/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;

public class PutFetchableMessage
extends FCPMessage {
    final String identifier;
    final boolean global;
    final FreenetURI uri;

    PutFetchableMessage(String ident, boolean global, FreenetURI uri) {
        this.identifier = ident;
        this.global = global;
        this.uri = uri;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        fs.put("Global", this.global);
        if (this.uri != null) {
            fs.putSingle("URI", this.uri.toString(false, false));
        }
        return fs;
    }

    @Override
    public String getName() {
        return "PutFetchable";
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "PutFetchable goes from server to client not the other way around", this.identifier, this.global);
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        container.activate((Object)this.uri, 5);
        this.uri.removeFrom(container);
        container.delete((Object)this);
    }
}

