/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.PluginRemovedMessage;
import freenet.node.fcp.ProtocolErrorMessage;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.support.SimpleFieldSet;

public class RemovePlugin
extends FCPMessage {
    static final String NAME = "RemovePlugin";
    private final String identifier;
    private final String plugname;
    private final int maxWaitTime;
    private final boolean purge;

    public RemovePlugin(SimpleFieldSet fs) throws MessageInvalidException {
        this.identifier = fs.get("Identifier");
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "Must contain an Identifier field", null, false);
        }
        this.plugname = fs.get("PluginName");
        if (this.plugname == null) {
            throw new MessageInvalidException(5, "Must contain a PluginName field", this.identifier, false);
        }
        this.maxWaitTime = fs.getInt("MaxWaitTime", 0);
        this.purge = fs.getBoolean("Purge", false);
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(final FCPConnectionHandler handler, final Node node) throws MessageInvalidException {
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "LoadPlugin requires full access", this.identifier, false);
        }
        node.executor.execute(new Runnable(){

            @Override
            public void run() {
                PluginInfoWrapper pi = node.pluginManager.getPluginInfo(RemovePlugin.this.plugname);
                if (pi == null) {
                    handler.outputHandler.queue(new ProtocolErrorMessage(32, false, "Plugin '" + RemovePlugin.this.plugname + "' does not exist or is not a FCP plugin", RemovePlugin.this.identifier, false));
                } else {
                    pi.stopPlugin(node.pluginManager, RemovePlugin.this.maxWaitTime, false);
                    if (RemovePlugin.this.purge) {
                        node.pluginManager.removeCachedCopy(pi.getFilename());
                    }
                    handler.outputHandler.queue(new PluginRemovedMessage(RemovePlugin.this.plugname, RemovePlugin.this.identifier));
                }
            }
        }, "Remove Plugin");
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

