/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import com.db4o.ObjectContainer;
import freenet.client.ClientMetadata;
import freenet.client.FetchException;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertBlock;
import freenet.client.InsertException;
import freenet.client.async.ClientContext;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.crypt.RandomSource;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.NodeStarter;
import freenet.node.Version;
import freenet.node.simulator.LongTermTest;
import freenet.node.simulator.TestUtil;
import freenet.support.Logger;
import freenet.support.PooledExecutor;
import freenet.support.api.Bucket;
import freenet.support.io.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class LongTermPushPullTest
extends LongTermTest {
    private static final int TEST_SIZE = 65536;
    private static final int EXIT_NO_SEEDNODES = 257;
    private static final int EXIT_FAILED_TARGET = 258;
    private static final int EXIT_THREW_SOMETHING = 261;
    private static final int DARKNET_PORT1 = 5010;
    private static final int OPENNET_PORT1 = 5011;
    private static final int DARKNET_PORT2 = 5012;
    private static final int OPENNET_PORT2 = 5013;
    private static final int MAX_N = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 0 || args.length > 2) {
            System.err.println("Usage: java freenet.node.simulator.LongTermPushPullTest <unique identifier>");
            System.exit(1);
        }
        String uid = args[0];
        if (args.length == 2 && (args[1].equalsIgnoreCase("--dump") || args[1].equalsIgnoreCase("-dump") || args[1].equalsIgnoreCase("dump"))) {
            try {
                LongTermPushPullTest.dumpStats(uid);
            }
            catch (IOException e) {
                System.err.println("IO ERROR: " + e);
                e.printStackTrace();
                System.exit(1);
            }
            catch (ParseException e) {
                System.err.println("PARSE ERROR: " + e);
                e.printStackTrace();
                System.exit(2);
            }
            System.exit(0);
        }
        ArrayList<String> csvLine = new ArrayList<String>(19);
        System.out.println("DATE:" + dateFormat.format(today.getTime()));
        csvLine.add(dateFormat.format(today.getTime()));
        System.out.println("Version:" + Version.buildNumber());
        csvLine.add(String.valueOf(Version.buildNumber()));
        int exitCode = 0;
        Node node = null;
        Node node2 = null;
        try {
            HighLevelSimpleClient client;
            File dir = new File("longterm-push-pull-test-" + uid);
            FileUtil.removeAll(dir);
            RandomSource random = NodeStarter.globalTestInit(dir.getPath(), false, Logger.LogLevel.ERROR, "", false);
            File seednodes = new File("seednodes.fref");
            if (!seednodes.exists() || seednodes.length() == 0L || !seednodes.canRead()) {
                System.err.println("Unable to read seednodes.fref, it doesn't exist, or is empty");
                System.exit(257);
            }
            File innerDir = new File(dir, Integer.toString(5010));
            innerDir.mkdir();
            FileInputStream fis = new FileInputStream(seednodes);
            FileUtil.writeTo(fis, new File(innerDir, "seednodes.fref"));
            fis.close();
            node = NodeStarter.createTestNode(5010, 5011, dir.getPath(), false, (short)18, 0, random, new PooledExecutor(), 1000, 0x400000L, true, true, true, true, true, true, true, 12288, true, true, false, false, null);
            Logger.getChain().setThreshold(Logger.LogLevel.ERROR);
            node.start(true);
            long t1 = System.currentTimeMillis();
            if (!TestUtil.waitForNodes(node)) {
                exitCode = 258;
                return;
            }
            long t2 = System.currentTimeMillis();
            System.out.println("SEED-TIME:" + (t2 - t1));
            csvLine.add(String.valueOf(t2 - t1));
            for (int i = 0; i <= 8; ++i) {
                Bucket data = LongTermPushPullTest.randomData(node);
                client = node.clientCore.makeClient((short)0, false, false);
                FreenetURI uri = new FreenetURI("KSK@" + uid + "-" + dateFormat.format(today.getTime()) + "-" + i);
                System.out.println("PUSHING " + uri);
                client.addEventHook(new ClientEventListener(){

                    @Override
                    public void onRemoveEventProducer(ObjectContainer container) {
                    }

                    @Override
                    public void receive(ClientEvent ce, ObjectContainer maybeContainer, ClientContext context) {
                        System.out.println(ce.getDescription());
                    }
                });
                try {
                    InsertBlock block = new InsertBlock(data, new ClientMetadata(), uri);
                    t1 = System.currentTimeMillis();
                    client.insert(block, false, null);
                    t2 = System.currentTimeMillis();
                    System.out.println("PUSH-TIME-" + i + ":" + (t2 - t1));
                    csvLine.add(String.valueOf(t2 - t1));
                }
                catch (InsertException e) {
                    e.printStackTrace();
                    csvLine.add("N/A");
                }
                data.free();
            }
            node.park();
            File innerDir2 = new File(dir, Integer.toString(5012));
            innerDir2.mkdir();
            fis = new FileInputStream(seednodes);
            FileUtil.writeTo(fis, new File(innerDir2, "seednodes.fref"));
            fis.close();
            node2 = NodeStarter.createTestNode(5012, 5013, dir.getPath(), false, (short)18, 0, random, new PooledExecutor(), 1000, 0x500000L, true, true, true, true, true, true, true, 12288, false, true, false, false, null);
            node2.start(true);
            t1 = System.currentTimeMillis();
            if (!TestUtil.waitForNodes(node2)) {
                exitCode = 258;
                return;
            }
            t2 = System.currentTimeMillis();
            System.out.println("SEED-TIME:" + (t2 - t1));
            csvLine.add(String.valueOf(t2 - t1));
            for (int i = 0; i <= 8; ++i) {
                client = node2.clientCore.makeClient((short)0, false, false);
                Calendar targetDate = (Calendar)today.clone();
                targetDate.add(5, -((1 << i) - 1));
                FreenetURI uri = new FreenetURI("KSK@" + uid + "-" + dateFormat.format(targetDate.getTime()) + "-" + i);
                System.out.println("PULLING " + uri);
                try {
                    t1 = System.currentTimeMillis();
                    client.fetch(uri);
                    t2 = System.currentTimeMillis();
                    System.out.println("PULL-TIME-" + i + ":" + (t2 - t1));
                    csvLine.add(String.valueOf(t2 - t1));
                    continue;
                }
                catch (FetchException e) {
                    if (e.getMode() != 28 && e.getMode() != 13) {
                        e.printStackTrace();
                    }
                    csvLine.add(FetchException.getShortMessage(e.getMode()));
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            exitCode = 261;
        }
        finally {
            try {
                if (node != null) {
                    node.park();
                }
            }
            catch (Throwable t1) {}
            try {
                if (node2 != null) {
                    node2.park();
                }
            }
            catch (Throwable t1) {}
            File file = new File(uid + ".csv");
            LongTermPushPullTest.writeToStatusLog(file, csvLine);
            System.exit(exitCode);
        }
    }

    private static void dumpStats(String uid) throws IOException, ParseException {
        File file = new File(uid + ".csv");
        FileInputStream fis = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
        String line = null;
        GregorianCalendar prevDate = null;
        TreeMap<GregorianCalendar, DumpElement> map = new TreeMap<GregorianCalendar, DumpElement>();
        while ((line = br.readLine()) != null) {
            DumpElement element;
            long prev;
            long now;
            long dist;
            String[] split = line.split(",");
            Date date = dateFormat.parse(split[0]);
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            calendar.setTime(date);
            System.out.println("Date: " + dateFormat.format(calendar.getTime()));
            if (prevDate != null && (dist = TimeUnit.DAYS.convert((now = calendar.getTimeInMillis()) - (prev = prevDate.getTimeInMillis()), TimeUnit.MILLISECONDS)) != 1L) {
                System.out.println("" + dist + " days since last report");
            }
            prevDate = calendar;
            int version = Integer.parseInt(split[1]);
            if (split.length > 2) {
                int[] pushTimes = new int[9];
                String[] pushFailures = new String[9];
                for (int i = 0; i <= 8; ++i) {
                    String s = split[3 + i];
                    try {
                        pushTimes[i] = Integer.parseInt(s);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        pushFailures[i] = s;
                    }
                }
                if (split.length > 12) {
                    int[] pullTimes = new int[9];
                    String[] pullFailures = new String[9];
                    for (int i = 0; i <= 8; ++i) {
                        String s = split[13 + i];
                        try {
                            pullTimes[i] = Integer.parseInt(s);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            pullFailures[i] = s;
                        }
                    }
                    element = new DumpElement(calendar, version, pushTimes, pushFailures, pullTimes, pullFailures);
                } else {
                    element = new DumpElement(calendar, version, pushTimes, pushFailures);
                }
            } else {
                element = new DumpElement(calendar, version);
            }
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            map.put(calendar, element);
        }
        fis.close();
        for (int i = 0; i <= 8; ++i) {
            int delta = (1 << i) - 1;
            System.out.println("Checking delta: " + delta + " days");
            int failures = 0;
            int successes = 0;
            long successTime = 0L;
            int noMatch = 0;
            int insertFailure = 0;
            HashMap<String, Integer> failureModes = new HashMap<String, Integer>();
            for (Map.Entry entry : map.entrySet()) {
                GregorianCalendar date = (GregorianCalendar)entry.getKey();
                DumpElement element = (DumpElement)entry.getValue();
                if (element.pullTimes == null) continue;
                date = (GregorianCalendar)date.clone();
                date.add(5, -delta);
                System.out.println("Checking " + date.getTime() + " for " + element.date.getTime() + " delta " + delta);
                DumpElement inserted = (DumpElement)map.get(date);
                if (inserted == null) {
                    System.out.println("No match");
                    ++noMatch;
                    continue;
                }
                if (inserted.pushTimes == null || inserted.pushTimes[i] == 0) {
                    System.out.println("Insert failure");
                    if (element.pullTimes[i] != 0) {
                        System.err.println("Fetched it anyway??!?!?: time " + element.pullTimes[i]);
                    }
                    ++insertFailure;
                }
                if (element.pullTimes[i] == 0) {
                    String failureMode = element.pullFailures[i];
                    Integer count = (Integer)failureModes.get(failureMode);
                    if (count == null) {
                        failureModes.put(failureMode, 1);
                    } else {
                        failureModes.put(failureMode, count + 1);
                    }
                    ++failures;
                    continue;
                }
                ++successes;
                successTime += (long)element.pullTimes[i];
            }
            System.out.println("Successes: " + successes);
            if (successes != 0) {
                System.out.println("Average success time " + successTime / (long)successes);
            }
            System.out.println("Failures: " + failures);
            for (Map.Entry entry : failureModes.entrySet()) {
                System.out.println((String)entry.getKey() + " : " + entry.getValue());
            }
            System.out.println("No match: " + noMatch);
            System.out.println("Insert failure: " + insertFailure);
            double psuccess = (double)successes * 1.0 / (1.0 * (double)(successes + failures));
            System.out.println("Success rate for " + delta + " days: " + psuccess + " (" + (successes + failures) + " samples)");
            if (delta != 0) {
                double halfLifeEstimate = -1.0 * Math.log(2.0) / (Math.log(psuccess) / (double)delta);
                System.out.println("Half-life estimate: " + halfLifeEstimate + " days");
            }
            System.out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bucket randomData(Node node) throws IOException {
        Bucket data = node.clientCore.tempBucketFactory.makeBucket(65536L);
        OutputStream os = data.getOutputStream();
        try {
            int toWrite;
            byte[] buf = new byte[4096];
            for (long written = 0L; written < 65536L; written += (long)toWrite) {
                node.fastWeakRandom.nextBytes(buf);
                toWrite = (int)Math.min(65536L - written, (long)buf.length);
                os.write(buf, 0, toWrite);
            }
        }
        finally {
            os.close();
        }
        return data;
    }

    static class DumpElement {
        final GregorianCalendar date;
        final int version;
        final long seedTime;
        final int[] pushTimes;
        final String[] pushFailures;
        final int[] pullTimes;
        final String[] pullFailures;

        public DumpElement(GregorianCalendar date, int version) {
            this.date = date;
            this.version = version;
            this.seedTime = -1L;
            this.pushTimes = null;
            this.pushFailures = null;
            this.pullTimes = null;
            this.pullFailures = null;
        }

        public DumpElement(GregorianCalendar date, int version, int[] pushTimes, String[] pushFailures) {
            this.date = date;
            this.version = version;
            this.seedTime = -1L;
            this.pushTimes = pushTimes;
            this.pushFailures = pushFailures;
            this.pullTimes = null;
            this.pullFailures = null;
        }

        public DumpElement(GregorianCalendar date, int version, int[] pushTimes, String[] pushFailures, int[] pullTimes, String[] pullFailures) {
            this.date = date;
            this.version = version;
            this.seedTime = -1L;
            this.pushTimes = pushTimes;
            this.pushFailures = pushFailures;
            this.pullTimes = pullTimes;
            this.pullFailures = pullFailures;
        }
    }
}

