/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.FetchWaiter;
import freenet.client.HighLevelSimpleClient;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetter;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.client.events.SplitfileProgressEvent;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.pluginmanager.PluginDownLoader;
import freenet.pluginmanager.PluginManager;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.support.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;

public class PluginDownLoaderFreenet
extends PluginDownLoader<FreenetURI> {
    final HighLevelSimpleClient hlsc;
    final boolean desperate;
    final Node node;
    private boolean fatalFailure;
    private ClientGetter get;

    PluginDownLoaderFreenet(HighLevelSimpleClient hlsc, Node node, boolean desperate) {
        this.hlsc = hlsc.clone();
        this.node = node;
        this.desperate = desperate;
    }

    @Override
    public FreenetURI checkSource(String source) throws PluginNotFoundException {
        try {
            return new FreenetURI(source);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "not a valid freenet key: " + source, (Throwable)e);
            throw new PluginNotFoundException("not a valid freenet key: " + source, e);
        }
    }

    @Override
    InputStream getInputStream(final PluginManager.PluginProgress progress) throws IOException, PluginNotFoundException {
        FreenetURI uri = (FreenetURI)this.getSource();
        System.out.println("Downloading plugin from Freenet: " + uri);
        while (true) {
            try {
                progress.setDownloading();
                this.hlsc.addEventHook(new ClientEventListener(){

                    @Override
                    public void onRemoveEventProducer(ObjectContainer container) {
                    }

                    @Override
                    public void receive(ClientEvent ce, ObjectContainer maybeContainer, ClientContext context) {
                        if (ce instanceof SplitfileProgressEvent) {
                            SplitfileProgressEvent split = (SplitfileProgressEvent)ce;
                            if (split.finalizedTotal) {
                                progress.setDownloadProgress(split.minSuccessfulBlocks, split.succeedBlocks, split.totalBlocks, split.failedBlocks, split.fatallyFailedBlocks, split.finalizedTotal);
                            }
                        }
                    }
                });
                FetchContext context = this.hlsc.getFetchContext();
                if (this.desperate) {
                    context.maxNonSplitfileRetries = -1;
                    context.maxSplitfileBlockRetries = -1;
                }
                FetchWaiter fw = new FetchWaiter();
                this.get = new ClientGetter(fw, uri, context, 1, this.node.nonPersistentClientBulk, null, null, null);
                try {
                    this.node.clientCore.clientContext.start(this.get);
                }
                catch (DatabaseDisabledException e) {
                    // empty catch block
                }
                FetchResult res = fw.waitForCompletion();
                return res.asBucket().getInputStream();
            }
            catch (FetchException e) {
                if (e.getMode() == 27 || e.getMode() == 11) {
                    uri = e.newURI;
                    continue;
                }
                if (e.isFatal()) {
                    this.fatalFailure = true;
                }
                Logger.error(this, "error while fetching plugin: " + this.getSource(), (Throwable)e);
                throw new PluginNotFoundException("error while fetching plugin: " + e.getMessage() + " for key " + this.getSource(), e);
            }
            break;
        }
    }

    @Override
    String getPluginName(String source) throws PluginNotFoundException {
        return source.substring(source.lastIndexOf(47) + 1);
    }

    @Override
    String getSHA1sum() throws PluginNotFoundException {
        return null;
    }

    @Override
    String getSHA256sum() throws PluginNotFoundException {
        return null;
    }

    public boolean fatalFailure() {
        return this.fatalFailure;
    }

    @Override
    void tryCancel() {
        if (this.get != null) {
            this.get.cancel(null, this.node.clientCore.clientContext);
        }
    }
}

