/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.pluginmanager.PluginDownLoaderURL;
import freenet.pluginmanager.PluginManager;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.support.io.ArrayBucket;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import freenet.support.io.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;

public class PluginDownLoaderOfficialHTTPS
extends PluginDownLoaderURL {
    private static final String certurlNew = "freenet/clients/http/staticfiles/globalsign.pem";
    private static final String[] certURLs = new String[]{"freenet/clients/http/staticfiles/globalsign.pem"};
    public static final String certfileOld = "startssl.pem";
    private static final String certfile = "sslcerts.pem";

    @Override
    public URL checkSource(String source) throws PluginNotFoundException {
        return super.checkSource("https://downloads.freenetproject.org/latest/" + source + ".jar");
    }

    @Override
    String getPluginName(String source) throws PluginNotFoundException {
        return source + ".jar";
    }

    @Override
    String getSHA1sum() throws PluginNotFoundException {
        try {
            int read;
            URL sha1url = new URL(((URL)this.getSource()).toString() + ".sha1");
            URLConnection urlConnection = sha1url.openConnection();
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            InputStream is = PluginDownLoaderOfficialHTTPS.openConnectionCheckRedirects(urlConnection);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((read = is.read(buffer)) != -1) {
                bos.write(buffer, 0, read);
            }
            return new String(bos.toByteArray(), "ISO-8859-1").split(" ")[0];
        }
        catch (MalformedURLException e) {
            throw new PluginNotFoundException("impossible: " + e, e);
        }
        catch (IOException e) {
            throw new PluginNotFoundException("Error while fetching sha1 for plugin: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream getInputStream(PluginManager.PluginProgress progress) throws IOException {
        File TMP_KEYSTORE = null;
        Closeable fis = null;
        InputStream is = null;
        try {
            TMP_KEYSTORE = File.createTempFile("keystore", ".tmp");
            TMP_KEYSTORE.deleteOnExit();
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(null, new char[0]);
            is = this.getCert();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> c = cf.generateCertificates(is);
            for (Certificate certificate : c) {
                ks.setCertificateEntry(certificate.getPublicKey().toString(), certificate);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(TMP_KEYSTORE);
            try {
                ks.store(fileOutputStream, new char[0]);
            }
            finally {
                Closer.close(fileOutputStream);
            }
            System.out.println("The CA has been imported into the trustStore");
        }
        catch (Exception e) {
            System.err.println("Error while handling the CA :" + e.getMessage());
            throw new IOException("Error while handling the CA : " + e);
        }
        finally {
            Closer.close(fis);
        }
        System.setProperty("javax.net.ssl.trustStore", TMP_KEYSTORE.toString());
        return super.getInputStream(progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getCert() throws IOException {
        File certFile = new File(certfile).getAbsoluteFile();
        if (certFile.exists()) {
            return new FileInputStream(certFile);
        }
        OutputStream os = null;
        try {
            FileBucket bucket;
            try {
                bucket = new FileBucket(certFile, false, false, false, false, false);
                os = bucket.getOutputStream();
                PluginDownLoaderOfficialHTTPS.writeCerts(os);
                os.close();
                os = null;
            }
            catch (Throwable throwable) {
                Closer.close(os);
                throw throwable;
            }
            Closer.close(os);
            return bucket.getInputStream();
        }
        catch (IOException e) {
            ArrayBucket bucket = new ArrayBucket();
            os = bucket.getOutputStream();
            PluginDownLoaderOfficialHTTPS.writeCerts(os);
            os.close();
            return bucket.getInputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCerts(OutputStream os) throws IOException {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        InputStream in = null;
        for (String certurl : certURLs) {
            try {
                in = loader.getResourceAsStream(certurl);
                if (in != null) {
                    FileUtil.copy(in, os, -1L);
                    continue;
                }
                throw new IOException("Could not find certificates in fred source nor find certificates file");
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    public static void writeCertsTo(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        PluginDownLoaderOfficialHTTPS.writeCerts(fos);
        fos.close();
    }

    @Override
    public boolean isOfficialPluginLoader() {
        return true;
    }
}

