/*
 * Decompiled with CFR 0.152.
 */
package freenet.store;

import freenet.keys.KeyVerifyException;
import freenet.node.stats.StoreAccessStats;
import freenet.node.useralerts.UserAlertManager;
import freenet.store.BlockMetadata;
import freenet.store.FreenetStore;
import freenet.store.KeyCollisionException;
import freenet.store.StorableBlock;
import freenet.store.StoreCallback;
import freenet.support.ByteArrayWrapper;
import freenet.support.LRUMap;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.api.Bucket;
import freenet.support.io.TempBucketFactory;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class SlashdotStore<T extends StorableBlock>
implements FreenetStore<T> {
    private static volatile boolean logDEBUG;
    private final TempBucketFactory bf;
    private long maxLifetime;
    private final long purgePeriod;
    private final Ticker ticker;
    private final LRUMap<ByteArrayWrapper, DiskBlock> blocksByRoutingKey;
    private final StoreCallback<T> callback;
    private int maxKeys;
    private long hits;
    private long misses;
    private long writes;
    private final int headerSize;
    private final int dataSize;
    private final int fullKeySize;

    public SlashdotStore(StoreCallback<T> callback, int maxKeys, long maxLifetime, long purgePeriod, Ticker ticker, TempBucketFactory tbf) {
        this.callback = callback;
        this.blocksByRoutingKey = LRUMap.createSafeMap(ByteArrayWrapper.FAST_COMPARATOR);
        this.maxKeys = maxKeys;
        this.bf = tbf;
        this.ticker = ticker;
        this.maxLifetime = maxLifetime;
        this.purgePeriod = purgePeriod;
        callback.setStore(this);
        this.headerSize = callback.headerLength();
        this.dataSize = callback.dataLength();
        this.fullKeySize = callback.fullKeyLength();
        Runnable purgeOldData = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SlashdotStore.this.purgeOldData();
                }
                finally {
                    SlashdotStore.this.ticker.queueTimedJob(this, SlashdotStore.this.purgePeriod);
                }
            }
        };
        ticker.queueTimedJob(purgeOldData, maxLifetime + purgePeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T fetch(byte[] routingKey, byte[] fullKey, boolean dontPromote, boolean canReadClientCache, boolean canReadSlashdotCache, boolean ignoreOldBlocks, BlockMetadata meta) throws IOException {
        long timeAccessed;
        DiskBlock block;
        ByteArrayWrapper key = new ByteArrayWrapper(routingKey);
        SlashdotStore slashdotStore = this;
        synchronized (slashdotStore) {
            block = this.blocksByRoutingKey.get(key);
            if (block == null) {
                ++this.misses;
                return null;
            }
            timeAccessed = block.lastAccessed;
        }
        InputStream in = block.data.getInputStream();
        DataInputStream dis = new DataInputStream(in);
        byte[] fk = new byte[this.fullKeySize];
        byte[] header = new byte[this.headerSize];
        byte[] data = new byte[this.dataSize];
        dis.readFully(fk);
        dis.readFully(header);
        dis.readFully(data);
        in.close();
        try {
            T ret = this.callback.construct(data, header, routingKey, fk, canReadClientCache, canReadSlashdotCache, null, null);
            SlashdotStore slashdotStore2 = this;
            synchronized (slashdotStore2) {
                ++this.hits;
                if (!dontPromote) {
                    block.lastAccessed = System.currentTimeMillis();
                    this.blocksByRoutingKey.push(key, block);
                }
            }
            if (logDEBUG) {
                Logger.debug(this, "Block was last accessed " + (System.currentTimeMillis() - timeAccessed) + "ms ago");
            }
            return ret;
        }
        catch (KeyVerifyException e) {
            block.data.free();
            SlashdotStore slashdotStore3 = this;
            synchronized (slashdotStore3) {
                this.blocksByRoutingKey.removeKey(key);
                ++this.misses;
            }
            return null;
        }
    }

    @Override
    public long getBloomFalsePositive() {
        return -1L;
    }

    @Override
    public long getMaxKeys() {
        return this.maxKeys;
    }

    @Override
    public long hits() {
        return this.hits;
    }

    @Override
    public long keyCount() {
        return this.blocksByRoutingKey.size();
    }

    @Override
    public long misses() {
        return this.misses;
    }

    @Override
    public boolean probablyInStore(byte[] routingKey) {
        ByteArrayWrapper key = new ByteArrayWrapper(routingKey);
        return this.blocksByRoutingKey.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T block, byte[] data, byte[] header, boolean overwrite, boolean isOldBlock) throws IOException, KeyCollisionException {
        byte[] routingkey = block.getRoutingKey();
        byte[] fullKey = block.getFullKey();
        Bucket bucket = this.bf.makeBucket(this.fullKeySize + this.dataSize + this.headerSize);
        OutputStream os = bucket.getOutputStream();
        try {
            os.write(fullKey);
            os.write(header);
            os.write(data);
        }
        finally {
            os.close();
        }
        DiskBlock stored = new DiskBlock();
        stored.data = bucket;
        this.purgeOldData(new ByteArrayWrapper(routingkey), stored);
    }

    @Override
    public void setMaxKeys(long maxStoreKeys, boolean shrinkNow) throws IOException {
        if (maxStoreKeys > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.maxKeys = (int)maxStoreKeys;
        if (shrinkNow) {
            this.purgeOldData();
        } else {
            this.ticker.queueTimedJob(new Runnable(){

                @Override
                public void run() {
                    SlashdotStore.this.purgeOldData();
                }
            }, 0L);
        }
    }

    @Override
    public long writes() {
        return this.writes;
    }

    protected void purgeOldData() {
        this.purgeOldData(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeOldData(ByteArrayWrapper key, DiskBlock addFirst) {
        if (logDEBUG) {
            Logger.minor(this, "Dumping old data from " + this + (addFirst == null ? "" : " and adding " + addFirst.data));
        }
        ArrayList<DiskBlock> blocks = null;
        SlashdotStore slashdotStore = this;
        synchronized (slashdotStore) {
            long now = System.currentTimeMillis();
            if (addFirst != null) {
                addFirst.lastAccessed = now;
                DiskBlock oldBlock = this.blocksByRoutingKey.push(key, addFirst);
                if (oldBlock != null) {
                    Logger.warning(this, "Replacing " + oldBlock + " with " + addFirst + " for " + key);
                    if (blocks == null) {
                        blocks = new ArrayList();
                    }
                    if (logDEBUG) {
                        Logger.minor(this, "Will dump " + oldBlock);
                    }
                    blocks.add(oldBlock);
                }
                ++this.writes;
            }
            while (!this.blocksByRoutingKey.isEmpty()) {
                DiskBlock block = this.blocksByRoutingKey.peekValue();
                if (now - block.lastAccessed < this.maxLifetime && this.blocksByRoutingKey.size() < this.maxKeys) break;
                if (blocks == null) {
                    blocks = new ArrayList<DiskBlock>();
                }
                if (logDEBUG) {
                    Logger.minor(this, "Will dump " + block);
                }
                blocks.add(block);
                this.blocksByRoutingKey.popValue();
            }
        }
        if (blocks == null) {
            return;
        }
        for (DiskBlock block : blocks) {
            block.data.free();
        }
    }

    public synchronized Long getLifetime() {
        return this.maxLifetime;
    }

    public synchronized void setLifetime(Long val) {
        this.maxLifetime = val;
    }

    @Override
    public StoreAccessStats getSessionAccessStats() {
        return new StoreAccessStats(){

            @Override
            public long hits() {
                return SlashdotStore.this.hits;
            }

            @Override
            public long misses() {
                return SlashdotStore.this.misses;
            }

            @Override
            public long falsePos() {
                return 0L;
            }

            @Override
            public long writes() {
                return SlashdotStore.this.writes;
            }
        };
    }

    @Override
    public StoreAccessStats getTotalAccessStats() {
        return null;
    }

    @Override
    public boolean start(Ticker ticker, boolean longStart) throws IOException {
        return false;
    }

    @Override
    public void setUserAlertManager(UserAlertManager userAlertManager) {
    }

    @Override
    public FreenetStore<T> getUnderlyingStore() {
        return this;
    }

    @Override
    public void close() {
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }

    private class DiskBlock {
        Bucket data;
        long lastAccessed;

        private DiskBlock() {
        }
    }
}

