/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import com.db4o.ObjectContainer;
import freenet.support.BinaryBloomFilter;
import freenet.support.CountingBloomFilter;
import freenet.support.NullBloomFilter;
import freenet.support.math.MersenneTwister;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class BloomFilter {
    protected ByteBuffer filter;
    protected final int k;
    protected final int length;
    protected transient ReadWriteLock lock = new ReentrantReadWriteLock();
    protected BloomFilter forkedFilter;
    protected boolean needRebuild;

    public void init(ObjectContainer container) {
        this.lock = new ReentrantReadWriteLock();
    }

    public static BloomFilter createFilter(int length, int k, boolean counting) {
        if (length == 0) {
            return new NullBloomFilter(length, k);
        }
        if (counting) {
            return new CountingBloomFilter(length, k);
        }
        return new BinaryBloomFilter(length, k);
    }

    public static BloomFilter createFilter(File file, int length, int k, boolean counting) throws IOException {
        if (length == 0) {
            return new NullBloomFilter(length, k);
        }
        if (counting) {
            return new CountingBloomFilter(file, length, k);
        }
        return new BinaryBloomFilter(file, length, k);
    }

    protected BloomFilter(int length, int k) {
        if (length % 8 != 0) {
            length -= length % 8;
        }
        this.length = length;
        this.k = k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKey(byte[] key) {
        Random hashes = this.getHashes(key);
        this.lock.writeLock().lock();
        try {
            for (int i = 0; i < this.k; ++i) {
                this.setBit(hashes.nextInt(this.length));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.forkedFilter != null) {
            this.forkedFilter.addKey(key);
        }
    }

    public void addKeyForked(byte[] key) {
        if (this.forkedFilter != null) {
            this.forkedFilter.addKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkFilter(byte[] key) {
        Random hashes = this.getHashes(key);
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < this.k; ++i) {
                if (this.getBit(hashes.nextInt(this.length))) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKey(byte[] key) {
        Random hashes = this.getHashes(key);
        this.lock.writeLock().lock();
        try {
            for (int i = 0; i < this.k; ++i) {
                this.unsetBit(hashes.nextInt(this.length));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.forkedFilter != null) {
            this.forkedFilter.removeKey(key);
        }
    }

    protected abstract boolean getBit(int var1);

    protected abstract void setBit(int var1);

    protected abstract void unsetBit(int var1);

    public void unsetAll() {
        int x = this.filter.limit();
        for (int i = 0; i < x; ++i) {
            this.filter.put(i, (byte)0);
        }
    }

    protected Random getHashes(byte[] key) {
        return new MersenneTwister(key);
    }

    public abstract void fork(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge() {
        this.lock.writeLock().lock();
        try {
            if (this.forkedFilter == null) {
                return;
            }
            Lock forkedLock = this.forkedFilter.lock.writeLock();
            forkedLock.lock();
            try {
                this.filter.position(0);
                this.forkedFilter.filter.position(0);
                this.filter.put(this.forkedFilter.filter);
                this.filter.position(0);
                this.forkedFilter.close();
                this.forkedFilter = null;
            }
            finally {
                forkedLock.unlock();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard() {
        this.lock.writeLock().lock();
        try {
            if (this.forkedFilter == null) {
                return;
            }
            this.forkedFilter.close();
            this.forkedFilter = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public static int optimialK(int filterLength, long maxKey) {
        long k = Math.round(Math.log(2.0) * (double)filterLength / (double)maxKey);
        if (k > 64L) {
            k = 64L;
        }
        if (k < 1L) {
            k = 1L;
        }
        return (int)k;
    }

    public int getK() {
        return this.k;
    }

    public boolean needRebuild() {
        boolean _needRebuild = this.needRebuild;
        this.needRebuild = false;
        return _needRebuild;
    }

    public void force() {
        if (this.filter instanceof MappedByteBuffer) {
            ((MappedByteBuffer)this.filter).force();
        }
    }

    public void close() {
        if (this.filter != null) {
            this.force();
        }
        this.filter = null;
        this.forkedFilter = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void storeTo(ObjectContainer container) {
        container.store((Object)this.filter);
        container.store((Object)this);
    }

    public int getSizeBytes() {
        return this.filter.capacity();
    }

    public int getLength() {
        return this.length;
    }

    public int getFilledCount() {
        int x = 0;
        for (int i = 0; i < this.length; ++i) {
            if (!this.getBit(i)) continue;
            ++x;
        }
        return x;
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this.filter);
        container.delete((Object)this);
    }
}

