/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.HasCooldownCacheItem;
import freenet.support.Logger;
import freenet.support.RandomGrabArrayItem;
import freenet.support.RandomGrabArrayItemExclusionList;
import freenet.support.RemoveRandom;
import freenet.support.RemoveRandomParent;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.tanukisoftware.wrapper.WrapperManager;

public class RandomGrabArray
implements RemoveRandom,
HasCooldownCacheItem {
    private static volatile boolean logMINOR;
    private Block[] blocks = new Block[]{new Block()};
    private int index;
    private static final int MIN_SIZE = 32;
    private static final int BLOCK_SIZE = 1024;
    protected final boolean persistent;
    private final int hashCode;
    private RemoveRandomParent parent;
    static final int MAX_EXCLUDED = 10;

    public RandomGrabArray(boolean persistent, ObjectContainer container, RemoveRandomParent parent) {
        this.blocks[0].reqs = new RandomGrabArrayItem[32];
        this.persistent = persistent;
        this.index = 0;
        this.hashCode = super.hashCode();
        this.parent = parent;
    }

    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RandomGrabArrayItem req, ObjectContainer container, ClientContext context) {
        if (req.persistent() != this.persistent) {
            throw new IllegalArgumentException("req.persistent()=" + req.persistent() + " but array.persistent=" + this.persistent + " item=" + req + " array=" + this);
        }
        if (context != null && req.getCooldownTime(container, context, System.currentTimeMillis()) < 0L) {
            if (logMINOR) {
                Logger.minor(this, "Is finished already: " + req);
            }
            return;
        }
        req.setParentGrabArray(this, container);
        RandomGrabArray randomGrabArray = this;
        synchronized (randomGrabArray) {
            int i;
            if (context != null) {
                context.cooldownTracker.clearCachedWakeup(req, this.persistent, container);
                context.cooldownTracker.clearCachedWakeup(this, this.persistent, container);
                if (this.parent != null) {
                    context.cooldownTracker.clearCachedWakeup(this.parent, this.persistent, container);
                }
            }
            int x = 0;
            if (this.blocks.length == 1 && this.index < 1024) {
                if (this.persistent) {
                    container.activate((Object)this.blocks[0], 1);
                }
                for (int i2 = 0; i2 < this.index; ++i2) {
                    if (this.blocks[0].reqs[i2] != req) continue;
                    if (this.persistent) {
                        container.deactivate((Object)this.blocks[0], 1);
                    }
                    return;
                }
                if (this.index >= this.blocks[0].reqs.length) {
                    this.blocks[0].reqs = Arrays.copyOf(this.blocks[0].reqs, Math.min(1024, this.blocks[0].reqs.length * 2));
                }
                this.blocks[0].reqs[this.index++] = req;
                if (logMINOR) {
                    Logger.minor(this, "Added " + req + " before index " + this.index);
                }
                if (this.persistent) {
                    container.store((Object)this.blocks[0]);
                    container.store((Object)this);
                    container.deactivate((Object)this.blocks[0], 1);
                }
                return;
            }
            int targetBlock = this.index / 1024;
            for (int i3 = 0; i3 < this.blocks.length; ++i3) {
                Block block = this.blocks[i3];
                if (this.persistent) {
                    container.activate((Object)block, 1);
                }
                if (i3 != this.blocks.length - 1 && block.reqs.length != 1024) {
                    Logger.error(this, "Block " + i3 + " of " + this.blocks.length + " is wrong size: " + block.reqs.length + " should be " + 1024);
                }
                for (int j = 0; j < block.reqs.length && x < this.index; ++x, ++j) {
                    if (block.reqs[j] == req) {
                        if (logMINOR) {
                            Logger.minor(this, "Already contains " + req + " : " + this + " size now " + this.index);
                        }
                        if (this.persistent) {
                            container.deactivate((Object)block, 1);
                        }
                        return;
                    }
                    if (block.reqs[j] != null) continue;
                    Logger.error(this, "reqs[" + i3 + "." + j + "] = null on " + this);
                }
                if (!this.persistent || i3 == targetBlock) continue;
                container.deactivate((Object)block, 1);
            }
            int oldBlockLen = this.blocks.length;
            if (this.blocks.length <= targetBlock) {
                if (logMINOR) {
                    Logger.minor(this, "Adding blocks on " + this);
                }
                Block[] newBlocks = Arrays.copyOf(this.blocks, targetBlock + 1);
                for (i = this.blocks.length; i < newBlocks.length; ++i) {
                    newBlocks[i] = new Block();
                    newBlocks[i].reqs = new RandomGrabArrayItem[1024];
                }
                this.blocks = newBlocks;
            } else if (this.persistent) {
                container.activate((Object)this.blocks[targetBlock], 1);
            }
            Block target = this.blocks[targetBlock];
            target.reqs[this.index++ % 1024] = req;
            if (this.persistent) {
                for (i = oldBlockLen; i < this.blocks.length; ++i) {
                    container.store((Object)this.blocks[i]);
                }
                container.store((Object)this);
                container.store((Object)target);
                for (i = oldBlockLen; i < this.blocks.length; ++i) {
                    container.deactivate((Object)this.blocks[i], 1);
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Added: " + req + " to " + this + " size now " + this.index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveRandom.RemoveRandomReturn removeRandom(RandomGrabArrayItemExclusionList excluding, ObjectContainer container, ClientContext context, long now) {
        if (logMINOR) {
            Logger.minor(this, "removeRandom() on " + this + " index=" + this.index);
        }
        RandomGrabArray randomGrabArray = this;
        synchronized (randomGrabArray) {
            if (this.index == 0) {
                if (logMINOR) {
                    Logger.minor(this, "All null on " + this);
                }
                return null;
            }
            if (this.index < 10) {
                return this.removeRandomExhaustiveSearch(excluding, container, context, now);
            }
            RandomGrabArrayItem ret = this.removeRandomLimited(excluding, container, context, now);
            if (ret != null) {
                return new RemoveRandom.RemoveRandomReturn(ret);
            }
            if (this.index == 0) {
                if (logMINOR) {
                    Logger.minor(this, "All null on " + this);
                }
                return null;
            }
            return this.removeRandomExhaustiveSearch(excluding, container, context, now);
        }
    }

    private RandomGrabArrayItem removeRandomLimited(RandomGrabArrayItemExclusionList excluding, ObjectContainer container, ClientContext context, long now) {
        int newBlockCount;
        RandomGrabArrayItem oret;
        RandomGrabArrayItem ret;
        int blockNo;
        int i;
        boolean changedMe;
        block32: {
            int excluded = 0;
            changedMe = false;
            int lastActiveBlock = -1;
            while (true) {
                i = context.fastWeakRandom.nextInt(this.index);
                blockNo = i / 1024;
                if (this.persistent && blockNo != lastActiveBlock) {
                    if (lastActiveBlock != -1) {
                        container.deactivate((Object)this.blocks[lastActiveBlock], 1);
                    }
                    lastActiveBlock = blockNo;
                    container.activate((Object)this.blocks[blockNo], 1);
                }
                if ((ret = this.blocks[blockNo].reqs[i % 1024]) == null) {
                    Logger.error(this, "reqs[" + i + "] = null");
                    this.remove(blockNo, i, container);
                    changedMe = true;
                    continue;
                }
                if (excluding.excludeSummarily(ret, this, container, this.persistent, now) > 0L) {
                    if (++excluded <= 10) continue;
                    if (this.persistent) {
                        if (changedMe) {
                            container.store((Object)this);
                        }
                        container.deactivate((Object)this.blocks[blockNo], 1);
                    }
                    return null;
                }
                if (this.persistent) {
                    container.activate((Object)ret, 1);
                }
                oret = ret;
                long itemWakeTime = -1L;
                boolean broken = false;
                boolean bl = broken = this.persistent && ret.isStorageBroken(container);
                if (broken) {
                    Logger.error(this, "Storage broken on " + ret);
                    try {
                        ret.removeFrom(container, context);
                    }
                    catch (Throwable t) {
                        container.delete((Object)ret);
                    }
                } else {
                    itemWakeTime = ret.getCooldownTime(container, context, now);
                }
                if (broken || itemWakeTime == -1L) {
                    if (logMINOR) {
                        Logger.minor(this, "Not returning because cancelled: " + ret);
                    }
                    ret = null;
                    oret.setParentGrabArray(null, container);
                }
                if (itemWakeTime == 0L) {
                    itemWakeTime = excluding.exclude(ret, container, context, now);
                }
                if (ret == null || itemWakeTime <= 0L) break block32;
                ++excluded;
                if (this.persistent) {
                    container.deactivate((Object)ret, 1);
                }
                if (excluded > 10) break;
            }
            if (this.persistent) {
                if (changedMe) {
                    container.store((Object)this);
                }
                container.deactivate((Object)this.blocks[blockNo], 1);
            }
            return null;
        }
        if (ret != null) {
            if (logMINOR) {
                Logger.minor(this, "Returning (cannot remove): " + ret + " of " + this.index);
            }
            if (this.persistent) {
                if (changedMe) {
                    container.store((Object)this);
                }
                container.deactivate((Object)this.blocks[blockNo], 1);
            }
            return ret;
        }
        do {
            changedMe = true;
            this.remove(blockNo, i, container);
            if (this.persistent && oret != null && ret == null) {
                container.deactivate((Object)oret, 1);
            }
            oret = this.blocks[blockNo].reqs[i % 1024];
        } while (this.index > i && oret == null);
        if (this.blocks.length == 1 && this.index < this.blocks[0].reqs.length / 4 && this.blocks[0].reqs.length > 32) {
            changedMe = true;
            this.blocks[0].reqs = Arrays.copyOf(this.blocks[0].reqs, Math.max(this.index * 2, 32));
            if (this.persistent) {
                container.store((Object)this);
                container.store((Object)this.blocks[0]);
                container.deactivate((Object)this.blocks[0], 1);
            }
        } else if (this.blocks.length > 1 && (newBlockCount = (this.index + 512) / 1024 + 1) < this.blocks.length) {
            if (logMINOR) {
                Logger.minor(this, "Shrinking blocks on " + this);
            }
            Block[] oldBlocks = this.blocks;
            this.blocks = Arrays.copyOf(this.blocks, newBlockCount);
            if (this.persistent) {
                container.store((Object)this);
                for (int x = this.blocks.length; x < oldBlocks.length; ++x) {
                    container.delete((Object)oldBlocks[x]);
                }
                container.deactivate((Object)oldBlocks[blockNo], 1);
            }
        }
        if (changedMe && this.persistent) {
            container.store((Object)this);
        }
        return ret;
    }

    private RemoveRandom.RemoveRandomReturn removeRandomExhaustiveSearch(RandomGrabArrayItemExclusionList excluding, ObjectContainer container, ClientContext context, long now) {
        if (logMINOR) {
            Logger.minor(this, "Doing exhaustive search and compaction on " + this);
        }
        boolean changedMe = false;
        long wakeupTime = Long.MAX_VALUE;
        RandomGrabArrayItem ret = null;
        int random = -1;
        while (true) {
            if (this.persistent) {
                container.activate((Object)this.blocks[0], 1);
            }
            RandomGrabArrayItem[] reqsReading = this.blocks[0].reqs;
            RandomGrabArrayItem[] reqsWriting = this.blocks[0].reqs;
            int blockNumReading = 0;
            int blockNumWriting = 0;
            int offset = -1;
            int writeOffset = -1;
            int exclude = 0;
            int valid = 0;
            int validIndex = -1;
            int target = 0;
            RandomGrabArrayItem chosenItem = null;
            RandomGrabArrayItem validItem = null;
            for (int i = 0; i < this.index; ++i) {
                RandomGrabArrayItem item;
                if (++offset == 1024) {
                    offset = 0;
                    if (this.persistent && changedMe) {
                        container.store((Object)this.blocks[blockNumReading]);
                    }
                    if (this.persistent && blockNumReading != blockNumWriting) {
                        container.deactivate((Object)this.blocks[blockNumReading], 1);
                    }
                    if (this.persistent && ++blockNumReading != blockNumWriting) {
                        container.activate((Object)this.blocks[blockNumReading], 1);
                    }
                    reqsReading = this.blocks[blockNumReading].reqs;
                }
                if ((item = reqsReading[offset]) == null) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Found null item at offset " + offset + " i=" + i + " block = " + blockNumReading + " on " + this);
                    continue;
                }
                boolean excludeItem = false;
                boolean activated = false;
                long excludeTime = excluding.excludeSummarily(item, this, container, this.persistent, now);
                if (excludeTime > 0L) {
                    excludeItem = true;
                    if (wakeupTime > excludeTime) {
                        wakeupTime = excludeTime;
                    }
                } else {
                    if (this.persistent) {
                        container.activate((Object)item, 1);
                    }
                    activated = true;
                    boolean broken = this.persistent && item.isStorageBroken(container);
                    long itemWakeTime = -1L;
                    if (broken) {
                        Logger.error(this, "Storage broken on " + item);
                        try {
                            item.removeFrom(container, context);
                        }
                        catch (Throwable t) {
                            container.delete((Object)item);
                        }
                    } else {
                        itemWakeTime = item.getCooldownTime(container, context, now);
                    }
                    if (itemWakeTime == -1L || broken) {
                        if (logMINOR) {
                            Logger.minor(this, "Removing " + item + " on " + this);
                        }
                        changedMe = true;
                        reqsReading[offset] = null;
                        item.setParentGrabArray(null, container);
                        if (!this.persistent) continue;
                        container.deactivate((Object)item, 1);
                        continue;
                    }
                    if (itemWakeTime > 0L) {
                        if (itemWakeTime < wakeupTime) {
                            wakeupTime = itemWakeTime;
                        }
                        excludeItem = true;
                    }
                    if (!excludeItem && (itemWakeTime = excluding.exclude(item, container, context, now)) > 0L) {
                        if (itemWakeTime < wakeupTime) {
                            wakeupTime = itemWakeTime;
                        }
                        excludeItem = true;
                    }
                }
                if (++writeOffset == 1024) {
                    writeOffset = 0;
                    if (this.persistent && changedMe) {
                        container.store((Object)this.blocks[blockNumWriting]);
                    }
                    if (this.persistent && blockNumReading != blockNumWriting) {
                        container.deactivate((Object)this.blocks[blockNumWriting], 1);
                    }
                    if (this.persistent && blockNumReading != ++blockNumWriting) {
                        container.activate((Object)this.blocks[blockNumWriting], 1);
                    }
                    reqsWriting = this.blocks[blockNumWriting].reqs;
                }
                if (i != target) {
                    changedMe = true;
                    reqsReading[offset] = null;
                    reqsWriting[writeOffset] = item;
                }
                ++target;
                if (excludeItem) {
                    ++exclude;
                } else {
                    if (valid == random) {
                        chosenItem = item;
                    }
                    if (validIndex == -1) {
                        validIndex = target - 1;
                        validItem = item;
                    }
                    ++valid;
                }
                if (!this.persistent || !activated || item == chosenItem || item == validItem) continue;
                if (logMINOR) {
                    Logger.minor(this, "Deactivating " + item);
                }
                container.deactivate((Object)item, 1);
            }
            if (this.index != target) {
                changedMe = true;
                this.index = target;
            }
            if (chosenItem != null) {
                if (this.persistent && validItem != null && validItem != chosenItem) {
                    container.deactivate(validItem, 1);
                }
                ret = chosenItem;
                if (logMINOR) {
                    Logger.minor(this, "Chosen random item " + ret + " out of " + valid + " total " + this.index);
                }
                if (this.persistent && changedMe) {
                    container.store((Object)this.blocks[blockNumReading]);
                    if (blockNumReading != blockNumWriting) {
                        container.store((Object)this.blocks[blockNumWriting]);
                    }
                    container.store((Object)this);
                    container.deactivate((Object)this.blocks[blockNumReading], 1);
                    if (blockNumReading != blockNumWriting) {
                        container.deactivate((Object)this.blocks[blockNumWriting], 1);
                    }
                }
                return new RemoveRandom.RemoveRandomReturn(ret);
            }
            if (valid == 0 && exclude == 0) {
                if (logMINOR) {
                    Logger.minor(this, "No valid or excluded items total " + this.index);
                }
                return null;
            }
            if (valid == 0) {
                if (this.persistent && changedMe) {
                    container.store((Object)this.blocks[blockNumReading]);
                    if (blockNumReading != blockNumWriting) {
                        container.store((Object)this.blocks[blockNumWriting]);
                    }
                    container.store((Object)this);
                    container.deactivate((Object)this.blocks[blockNumReading], 1);
                    if (blockNumReading != blockNumWriting) {
                        container.deactivate((Object)this.blocks[blockNumWriting], 1);
                    }
                }
                if (logMINOR) {
                    Logger.minor(this, "No valid items, " + exclude + " excluded items total " + this.index);
                }
                context.cooldownTracker.setCachedWakeup(wakeupTime, this, this.parent, this.persistent, container, context);
                return new RemoveRandom.RemoveRandomReturn(wakeupTime);
            }
            if (valid == 1) {
                ret = validItem;
                if (logMINOR) {
                    Logger.minor(this, "No valid or excluded items apart from " + ret + " total " + this.index);
                }
                if (this.persistent && changedMe) {
                    container.store((Object)this.blocks[blockNumReading]);
                    if (blockNumReading != blockNumWriting) {
                        container.store((Object)this.blocks[blockNumWriting]);
                    }
                    container.store((Object)this);
                    container.deactivate((Object)this.blocks[blockNumReading], 1);
                    if (blockNumReading != blockNumWriting) {
                        container.deactivate((Object)this.blocks[blockNumWriting], 1);
                    }
                }
                return new RemoveRandom.RemoveRandomReturn(ret);
            }
            random = context.fastWeakRandom.nextInt(valid);
            if (logMINOR) {
                Logger.minor(this, "Looping to choose valid item " + random + " of " + valid + " (excluded " + exclude + ")");
            }
            if (this.persistent && blockNumReading != 0) {
                if (changedMe) {
                    container.store((Object)this.blocks[blockNumReading]);
                }
                container.deactivate((Object)this.blocks[blockNumReading], 1);
            }
            if (!this.persistent || blockNumWriting == 0 || blockNumWriting == blockNumReading) continue;
            if (changedMe) {
                container.store((Object)this.blocks[blockNumWriting]);
            }
            container.deactivate((Object)this.blocks[blockNumWriting], 1);
        }
    }

    private void remove(int blockNo, int i, ObjectContainer container) {
        --this.index;
        int endBlock = this.index / 1024;
        if (this.blocks.length == 1 || blockNo == endBlock) {
            RandomGrabArrayItem[] items = this.blocks[blockNo].reqs;
            int idx = this.index % 1024;
            items[i % 1024] = items[idx];
            items[idx] = null;
            if (this.persistent) {
                container.store((Object)this.blocks[blockNo]);
            }
        } else {
            RandomGrabArrayItem[] toItems = this.blocks[blockNo].reqs;
            if (this.persistent) {
                container.activate((Object)this.blocks[endBlock], 1);
            }
            RandomGrabArrayItem[] endItems = this.blocks[endBlock].reqs;
            toItems[i % 1024] = endItems[this.index % 1024];
            endItems[this.index % 1024] = null;
            if (this.persistent) {
                container.store((Object)this.blocks[blockNo]);
                container.store((Object)this.blocks[endBlock]);
                container.deactivate((Object)this.blocks[endBlock], 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(RandomGrabArrayItem it, ObjectContainer container, ClientContext context) {
        context.cooldownTracker.removeCachedWakeup(it, this.persistent, container);
        if (logMINOR) {
            Logger.minor(this, "Removing " + it + " from " + this);
        }
        if (logMINOR && container != null) {
            boolean stored = container.ext().isStored((Object)this);
            boolean active = container.ext().isActive((Object)this);
            if (!this.persistent && (stored || active)) {
                Logger.error(this, "persistent=" + this.persistent + " stored=" + stored + " active=" + active, (Throwable)new Exception("error"));
            } else {
                Logger.minor(this, "persistent=" + this.persistent + " stored=" + stored + " active=" + active, (Throwable)new Exception("error"));
            }
        }
        boolean matched = false;
        boolean empty = false;
        RandomGrabArray randomGrabArray = this;
        synchronized (randomGrabArray) {
            if (this.blocks.length == 1) {
                Block block = this.blocks[0];
                if (this.persistent) {
                    container.activate((Object)block, 1);
                }
                for (int i = 0; i < this.index; ++i) {
                    if (block.reqs[i] != it) continue;
                    block.reqs[i] = block.reqs[--this.index];
                    block.reqs[this.index] = null;
                    matched = true;
                    if (!this.persistent) break;
                    container.store((Object)block);
                    break;
                }
                if (this.index == 0) {
                    empty = true;
                }
                if (this.persistent) {
                    container.deactivate((Object)block, 1);
                }
            } else {
                int x = 0;
                for (int i = 0; i < this.blocks.length; ++i) {
                    Block block = this.blocks[i];
                    if (this.persistent) {
                        container.activate((Object)block, 1);
                    }
                    for (int j = 0; j < block.reqs.length && x < this.index; ++x, ++j) {
                        if (block.reqs[j] != it) continue;
                        int pullFrom = --this.index;
                        int idx = pullFrom % 1024;
                        int endBlock = pullFrom / 1024;
                        if (i == endBlock) {
                            block.reqs[j] = block.reqs[idx];
                            block.reqs[idx] = null;
                        } else {
                            Block fromBlock = this.blocks[endBlock];
                            if (this.persistent) {
                                container.activate((Object)fromBlock, 1);
                            }
                            block.reqs[j] = fromBlock.reqs[idx];
                            fromBlock.reqs[idx] = null;
                            if (this.persistent) {
                                container.store((Object)fromBlock);
                                container.deactivate((Object)fromBlock, 1);
                            }
                        }
                        if (this.persistent) {
                            container.store((Object)block);
                        }
                        matched = true;
                        break;
                    }
                    if (!this.persistent) continue;
                    container.deactivate((Object)block, 1);
                }
                if (this.index == 0) {
                    empty = true;
                }
            }
        }
        RandomGrabArray oldArray = it.getParentGrabArray();
        if (oldArray == this) {
            it.setParentGrabArray(null, container);
        } else if (oldArray != null) {
            Logger.error(this, "Removing item " + it + " from " + this + " but RGA is " + it.getParentGrabArray(), (Throwable)new Exception("debug"));
        }
        if (!matched) {
            if (logMINOR) {
                Logger.minor(this, "Not found: " + it + " on " + this);
            }
            return;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (empty && this.parent != null) {
            boolean active = true;
            if (this.persistent) {
                active = container.ext().isActive((Object)this.parent);
            }
            if (!active) {
                container.activate((Object)this.parent, 1);
            }
            this.parent.maybeRemove(this, container, context);
            if (!active) {
                container.deactivate((Object)this.parent, 1);
            }
        }
    }

    public synchronized boolean isEmpty(ObjectContainer container) {
        if (container != null && !this.persistent) {
            boolean stored = container.ext().isStored((Object)this);
            boolean active = container.ext().isActive((Object)this);
            if (stored && !active) {
                Logger.error(this, "Not empty because not active on " + this);
                return false;
            }
            if (!stored) {
                Logger.error(this, "Not stored yet passed in container on " + this);
            } else if (stored) {
                throw new IllegalStateException("Stored but not persistent on " + this);
            }
        }
        return this.index == 0;
    }

    @Override
    public boolean persistent() {
        return this.persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RandomGrabArrayItem item, ObjectContainer container) {
        RandomGrabArray randomGrabArray = this;
        synchronized (randomGrabArray) {
            if (this.blocks.length == 1) {
                Block block = this.blocks[0];
                if (this.persistent) {
                    container.activate((Object)block, 1);
                }
                for (int i = 0; i < this.index; ++i) {
                    if (block.reqs[i] != item) continue;
                    if (this.persistent) {
                        container.deactivate((Object)block, 1);
                    }
                    return true;
                }
                if (this.persistent) {
                    container.deactivate((Object)block, 1);
                }
            } else {
                int x = 0;
                for (int i = 0; i < this.blocks.length; ++i) {
                    Block block = this.blocks[i];
                    if (this.persistent) {
                        container.activate((Object)block, 1);
                    }
                    for (int j = 0; j < block.reqs.length && x < this.index; ++x, ++j) {
                        if (block.reqs[i] != item) continue;
                        if (this.persistent) {
                            container.deactivate((Object)block, 1);
                        }
                        return true;
                    }
                    if (!this.persistent) continue;
                    container.deactivate((Object)block, 1);
                }
            }
        }
        return false;
    }

    public synchronized int size() {
        return this.index;
    }

    public synchronized RandomGrabArrayItem get(int idx, ObjectContainer container) {
        int blockNo = idx / 1024;
        if (this.persistent) {
            container.activate((Object)this.blocks[blockNo], 1);
        }
        RandomGrabArrayItem item = this.blocks[blockNo].reqs[idx % 1024];
        if (this.persistent) {
            container.deactivate((Object)this.blocks[blockNo], 1);
        }
        return item;
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        if (this.blocks != null) {
            int count = 0;
            for (Block block : this.blocks) {
                container.activate((Object)block, 1);
                for (RandomGrabArrayItem item : block.reqs) {
                    if (item != null) {
                        container.activate((Object)item, 1);
                        if (count >= this.index) {
                            Logger.error(this, "ITEM AT INDEX " + count + " : " + item + " EVEN THOUGH MAX INDEX IS " + this.index + " on " + this, (Throwable)new Exception("error"));
                        } else {
                            Logger.error(this, "VALID ITEM WHILE DELETING BLOCK: " + item + " on " + this + " at index " + count + " of " + this.index, (Throwable)new Exception("error"));
                        }
                    }
                    ++count;
                }
                container.delete((Object)block);
            }
        }
        container.delete((Object)this);
    }

    public void moveElementsTo(RandomGrabArray existingGrabber, ObjectContainer container, boolean canCommit) {
        WrapperManager.signalStarting((int)((int)TimeUnit.MINUTES.toMillis(5L)));
        for (Block block : this.blocks) {
            if (this.persistent) {
                container.activate((Object)block, 1);
            }
            for (int j = 0; j < block.reqs.length; ++j) {
                RandomGrabArrayItem item = block.reqs[j];
                if (item == null) continue;
                if (this.persistent) {
                    container.activate((Object)item, 1);
                }
                item.setParentGrabArray(null, container);
                existingGrabber.add(item, container, null);
                if (this.persistent) {
                    container.deactivate((Object)item, 1);
                }
                block.reqs[j] = null;
            }
            if (this.persistent) {
                container.store((Object)block);
                container.deactivate((Object)block, 1);
                if (canCommit) {
                    container.commit();
                }
            }
            System.out.println("Moved block in RGA " + this);
        }
    }

    @Override
    public void moveElementsTo(RemoveRandom existingGrabber, ObjectContainer container, boolean canCommit) {
        if (!(existingGrabber instanceof RandomGrabArray)) {
            throw new IllegalArgumentException("Expected RGA but got " + existingGrabber);
        }
        this.moveElementsTo((RandomGrabArray)existingGrabber, container, canCommit);
    }

    @Override
    public void setParent(RemoveRandomParent newParent, ObjectContainer container) {
        this.parent = newParent;
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    static {
        Logger.registerClass(RandomGrabArray.class);
    }

    private static class Block {
        RandomGrabArrayItem[] reqs;

        private Block() {
        }
    }
}

