/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import com.db4o.ObjectContainer;
import freenet.support.api.Bucket;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class SimpleReadOnlyArrayBucket
implements Bucket {
    final byte[] buf;
    final int offset;
    final int length;

    public SimpleReadOnlyArrayBucket(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.offset = offset;
        this.length = length;
    }

    public SimpleReadOnlyArrayBucket(byte[] buf) {
        this(buf, 0, buf.length);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Read only");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.buf, this.offset, this.length);
    }

    @Override
    public String getName() {
        return "SimpleReadOnlyArrayBucket: len=" + this.length + ' ' + super.toString();
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly() {
    }

    @Override
    public void free() {
    }

    @Override
    public void storeTo(ObjectContainer container) {
        container.store((Object)this);
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }

    @Override
    public Bucket createShadow() {
        if (this.buf.length < 262144) {
            return new SimpleReadOnlyArrayBucket(Arrays.copyOfRange(this.buf, this.offset, this.offset + this.length));
        }
        return null;
    }
}

