/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.TimeUtil;
import java.util.concurrent.TimeUnit;

public class TokenBucket {
    private static boolean logMINOR;
    protected long current;
    protected long max;
    protected long timeLastTick;
    protected long nanosPerTick;

    public TokenBucket(long max, long nanosPerTick, long initialValue) {
        this.max = max;
        this.current = initialValue;
        if (this.current > max) {
            Logger.error(this, "initial value (" + this.current + ") > max (" + max + ") in " + this, (Throwable)new Exception("error"));
            this.current = max;
        }
        this.nanosPerTick = nanosPerTick;
        long now = System.currentTimeMillis();
        this.timeLastTick = TimeUnit.NANOSECONDS.convert(now, TimeUnit.MILLISECONDS);
        if (nanosPerTick <= 0L) {
            throw new IllegalArgumentException();
        }
        if (max <= 0L) {
            throw new IllegalArgumentException();
        }
    }

    public synchronized boolean instantGrab(long tokens) {
        if (tokens < 0L) {
            throw new IllegalArgumentException("Can't grab negative tokens: " + tokens);
        }
        if (logMINOR) {
            Logger.minor(this, "instant grab: " + tokens + " current=" + this.current + " max=" + this.max);
        }
        this.addTokens();
        if (logMINOR) {
            Logger.minor(this, "instant grab: " + tokens + " current=" + this.current + " max=" + this.max);
        }
        if (this.current >= tokens) {
            this.current -= tokens;
            return true;
        }
        return false;
    }

    public synchronized long partialInstantGrab(long tokens) {
        if (tokens < 0L) {
            throw new IllegalArgumentException("Can't grab negative tokens: " + tokens);
        }
        if (logMINOR) {
            Logger.minor(this, "instant grab: " + tokens + " current=" + this.current + " max=" + this.max);
        }
        this.addTokens();
        if (logMINOR) {
            Logger.minor(this, "instant grab: " + tokens + " current=" + this.current + " max=" + this.max);
        }
        if (this.current >= tokens) {
            this.current -= tokens;
            return tokens;
        }
        tokens = this.current;
        this.current = 0L;
        return tokens;
    }

    public synchronized void forceGrab(long tokens) {
        if (tokens < 0L) {
            throw new IllegalArgumentException("Can't grab negative tokens: " + tokens);
        }
        if (logMINOR) {
            Logger.minor(this, "forceGrab(" + tokens + ")");
        }
        this.addTokens();
        this.current -= tokens;
        if (logMINOR) {
            Logger.minor(this, "Removed tokens, balance now " + this.current);
        }
    }

    public synchronized long count() {
        return this.current;
    }

    public synchronized long getCount() {
        this.addTokens();
        return this.current;
    }

    protected long offset() {
        return 0L;
    }

    public synchronized void blockingGrab(long tokens) {
        if (tokens < 0L) {
            throw new IllegalArgumentException("Can't grab negative tokens: " + tokens);
        }
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        if (logMINOR) {
            Logger.minor(this, "Blocking grab: " + tokens);
        }
        if (tokens < this.max) {
            this.innerBlockingGrab(tokens);
        } else {
            int i = 0;
            while ((long)i < tokens) {
                this.innerBlockingGrab(Math.min(tokens, this.max));
                i = (int)((long)i + this.max);
            }
        }
    }

    public synchronized void innerBlockingGrab(long tokens) {
        int delay;
        if (tokens < 0L) {
            throw new IllegalArgumentException("Can't grab negative tokens: " + tokens);
        }
        if (logMINOR) {
            Logger.minor(this, "Inner blocking grab: " + tokens);
        }
        this.addTokens();
        if (logMINOR) {
            Logger.minor(this, "current=" + this.current);
        }
        this.current -= tokens;
        if (this.current >= 0L) {
            if (logMINOR) {
                Logger.minor(this, "Got tokens instantly, current=" + this.current);
            }
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Blocking grab removed tokens, current=" + this.current + " - will have to wait because negative...");
        }
        long minDelayNS = this.nanosPerTick * -this.current;
        long minDelayMS = TimeUnit.MILLISECONDS.convert(minDelayNS + TimeUnit.MILLISECONDS.toNanos(1L) - 1L, TimeUnit.NANOSECONDS);
        long now = System.currentTimeMillis();
        long wakeAt = now + minDelayMS;
        if (logMINOR) {
            Logger.minor(this, "Waking in " + minDelayMS + " millis");
        }
        while ((delay = (int)Math.min(Integer.MAX_VALUE, wakeAt - (now = System.currentTimeMillis()))) > 0) {
            if (logMINOR) {
                Logger.minor(this, "Waiting " + delay + "ms");
            }
            try {
                this.wait(delay);
            }
            catch (InterruptedException e) {}
        }
        if (logMINOR) {
            Logger.minor(this, "Blocking grab finished: current=" + this.current);
        }
    }

    public synchronized void recycle(long tokens) {
        if (tokens < 0L) {
            throw new IllegalArgumentException("Can't recycle negative tokens: " + tokens);
        }
        this.current += tokens;
        if (this.current > this.max) {
            this.current = this.max;
        }
    }

    public synchronized void changeNanosPerTick(long nanosPerTick) {
        if (nanosPerTick <= 0L) {
            throw new IllegalArgumentException();
        }
        this.addTokens();
        this.nanosPerTick = nanosPerTick;
        if (nanosPerTick < this.nanosPerTick) {
            this.notifyAll();
        }
    }

    public synchronized void changeBucketSize(long newMax) {
        if (newMax <= 0L) {
            throw new IllegalArgumentException();
        }
        this.max = newMax;
        this.addTokens();
    }

    public synchronized void changeNanosAndBucketSize(long nanosPerTick, long newMax) {
        if (nanosPerTick <= 0L) {
            throw new IllegalArgumentException();
        }
        if (newMax <= 0L) {
            throw new IllegalArgumentException();
        }
        this.addTokensNoClip();
        if (nanosPerTick < this.nanosPerTick) {
            this.notifyAll();
        }
        this.nanosPerTick = nanosPerTick;
        this.max = newMax;
        if (this.current > this.max) {
            this.current = this.max;
        }
    }

    public synchronized void addTokens() {
        this.addTokensNoClip();
        if (this.current > this.max) {
            this.current = this.max;
        }
        if (logMINOR) {
            Logger.minor(this, "addTokens: Clipped, current=" + this.current);
        }
    }

    public synchronized void addTokensNoClip() {
        long add = this.tokensToAdd();
        this.current += add;
        this.timeLastTick += add * this.nanosPerTick;
        if (logMINOR) {
            Logger.minor(this, "addTokensNoClip: Added " + add + " tokens, current=" + this.current);
        }
    }

    synchronized long tokensToAdd() {
        long nowNS = TimeUnit.NANOSECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        if (this.timeLastTick > nowNS) {
            System.err.println("CLOCK SKEW DETECTED! CLOCK WENT BACKWARDS BY AT LEAST " + TimeUtil.formatTime(TimeUnit.MILLISECONDS.convert(this.timeLastTick - nowNS, TimeUnit.NANOSECONDS), 2, true));
            System.err.println("FREENET WILL BREAK SEVERELY IF THIS KEEPS HAPPENING!");
            Logger.error(this, "CLOCK SKEW DETECTED! CLOCK WENT BACKWARDS BY AT LEAST " + TimeUtil.formatTime(TimeUnit.MILLISECONDS.convert(this.timeLastTick - nowNS, TimeUnit.NANOSECONDS), 2, true));
            this.timeLastTick = nowNS;
            return 0L;
        }
        long nextTick = this.timeLastTick + this.nanosPerTick;
        if (nextTick > nowNS) {
            return 0L;
        }
        if (nextTick + this.nanosPerTick > nowNS) {
            return 1L;
        }
        return (nowNS - nextTick) / this.nanosPerTick;
    }

    public synchronized long getNanosPerTick() {
        return this.nanosPerTick;
    }

    static {
        LoggerHook.registerClass(TokenBucket.class);
    }
}

