/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.NullInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class BucketChainBucket
implements Bucket {
    private final Vector<Bucket> buckets;
    public final long bucketSize;
    private long size;
    private boolean freed;
    private boolean readOnly;
    private final BucketFactory bf;
    private final boolean cacheWholeBucket;

    public BucketChainBucket(long bucketSize, BucketFactory bf, boolean cacheWholeBucket) {
        this.bucketSize = bucketSize;
        this.buckets = new Vector();
        this.bf = bf;
        this.size = 0L;
        this.freed = false;
        this.readOnly = false;
        this.cacheWholeBucket = cacheWholeBucket;
    }

    private BucketChainBucket(Vector<Bucket> newBuckets, long bucketSize2, long size2, boolean readOnly, BucketFactory bf2, boolean cacheWholeBucket) {
        this.buckets = newBuckets;
        this.bucketSize = bucketSize2;
        this.size = size2;
        this.readOnly = readOnly;
        this.bf = bf2;
        this.cacheWholeBucket = cacheWholeBucket;
    }

    public static BucketChainBucket constructReadOnly(Bucket[] buckets) {
        Vector<Bucket> copy = new Vector<Bucket>(buckets.length);
        long totalSize = 0L;
        for (Bucket bucket : buckets) {
            totalSize += bucket.size();
            copy.add(bucket);
        }
        return new BucketChainBucket(copy, 0L, totalSize, true, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() {
        Bucket[] list;
        BucketChainBucket bucketChainBucket = this;
        synchronized (bucketChainBucket) {
            list = this.getBuckets();
            this.freed = true;
            this.buckets.clear();
        }
        for (Bucket l : list) {
            l.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        BucketChainBucket bucketChainBucket = this;
        synchronized (bucketChainBucket) {
            this.size = 0L;
            this.buckets.clear();
        }
    }

    public synchronized Bucket[] getBuckets() {
        return this.buckets.toArray(new Bucket[this.buckets.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        BucketChainBucket bucketChainBucket = this;
        synchronized (bucketChainBucket) {
            if (this.freed) {
                throw new IOException("Freed");
            }
            if (this.buckets.size() == 0) {
                return new NullInputStream();
            }
            return new InputStream(){
                private int bucketNo = 0;
                private InputStream curBucketStream = BucketChainBucket.this.getBucketInputStream(0);
                private long readBytes;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int read() throws IOException {
                    BucketChainBucket bucketChainBucket = BucketChainBucket.this;
                    synchronized (bucketChainBucket) {
                        if (BucketChainBucket.this.freed) {
                            this.curBucketStream.close();
                            this.curBucketStream = null;
                            throw new IOException("Freed");
                        }
                    }
                    while (true) {
                        if (this.curBucketStream == null) {
                            this.curBucketStream = BucketChainBucket.this.getBucketInputStream(0);
                            if (this.curBucketStream == null) {
                                return -1;
                            }
                        }
                        try {
                            int x = this.curBucketStream.read();
                            if (x >= 0) {
                                ++this.readBytes;
                                return x;
                            }
                        }
                        catch (EOFException eOFException) {
                            // empty catch block
                        }
                        bucketChainBucket = BucketChainBucket.this;
                        synchronized (bucketChainBucket) {
                            if (this.readBytes >= BucketChainBucket.this.size) {
                                return -1;
                            }
                        }
                        ++this.bucketNo;
                        this.curBucketStream.close();
                        this.curBucketStream = BucketChainBucket.this.getBucketInputStream(this.bucketNo++);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int read(byte[] buf) throws IOException {
                    BucketChainBucket bucketChainBucket = BucketChainBucket.this;
                    synchronized (bucketChainBucket) {
                        if (BucketChainBucket.this.freed) {
                            this.curBucketStream.close();
                            this.curBucketStream = null;
                            throw new IOException("Freed");
                        }
                    }
                    return this.read(buf, 0, buf.length);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int read(byte[] buf, int offset, int length) throws IOException {
                    BucketChainBucket bucketChainBucket = BucketChainBucket.this;
                    synchronized (bucketChainBucket) {
                        if (BucketChainBucket.this.freed) {
                            this.curBucketStream.close();
                            this.curBucketStream = null;
                            throw new IOException("Freed");
                        }
                    }
                    if (length == 0) {
                        return 0;
                    }
                    while (true) {
                        if (this.curBucketStream == null) {
                            this.curBucketStream = BucketChainBucket.this.getBucketInputStream(0);
                            if (this.curBucketStream == null) {
                                return -1;
                            }
                        }
                        try {
                            int x = this.curBucketStream.read(buf, offset, length);
                            if (x > 0) {
                                this.readBytes += (long)x;
                                return x;
                            }
                        }
                        catch (EOFException e) {
                            // empty catch block
                        }
                        bucketChainBucket = BucketChainBucket.this;
                        synchronized (bucketChainBucket) {
                            if (this.readBytes >= BucketChainBucket.this.size) {
                                return -1;
                            }
                        }
                        ++this.bucketNo;
                        this.curBucketStream.close();
                        this.curBucketStream = BucketChainBucket.this.getBucketInputStream(this.bucketNo++);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int available() throws IOException {
                    BucketChainBucket bucketChainBucket = BucketChainBucket.this;
                    synchronized (bucketChainBucket) {
                        if (BucketChainBucket.this.freed) {
                            this.curBucketStream.close();
                            this.curBucketStream = null;
                            throw new IOException("Freed");
                        }
                    }
                    return (int)Math.min(Integer.MAX_VALUE, BucketChainBucket.this.size() - this.readBytes);
                }

                @Override
                public void close() throws IOException {
                    if (this.curBucketStream != null) {
                        this.curBucketStream.close();
                    }
                }
            };
        }
    }

    protected synchronized InputStream getBucketInputStream(int i) throws IOException {
        Bucket bucket = this.buckets.get(i);
        if (bucket == null) {
            return null;
        }
        return bucket.getInputStream();
    }

    @Override
    public String getName() {
        return "BucketChainBucket";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        Bucket[] list;
        BucketChainBucket bucketChainBucket = this;
        synchronized (bucketChainBucket) {
            if (this.readOnly) {
                throw new IOException("Read-only");
            }
            if (this.freed) {
                throw new IOException("Freed");
            }
            this.size = 0L;
            list = this.getBuckets();
            this.buckets.clear();
        }
        for (Bucket l : list) {
            l.free();
        }
        return new OutputStream(){
            private int bucketNo = 0;
            private OutputStream curBucketStream;
            private long bucketLength = 0L;
            private ByteArrayOutputStream baos;
            {
                if (BucketChainBucket.this.cacheWholeBucket) {
                    this.baos = new ByteArrayOutputStream((int)BucketChainBucket.this.bucketSize);
                } else {
                    this.curBucketStream = BucketChainBucket.this.makeBucketOutputStream(0);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(int c) throws IOException {
                BucketChainBucket bucketChainBucket = BucketChainBucket.this;
                synchronized (bucketChainBucket) {
                    if (BucketChainBucket.this.freed) {
                        if (this.baos == null) {
                            this.curBucketStream.close();
                            this.curBucketStream = null;
                        }
                        throw new IOException("Freed");
                    }
                    if (BucketChainBucket.this.readOnly) {
                        if (this.baos == null) {
                            this.curBucketStream.close();
                            this.curBucketStream = null;
                        }
                        throw new IOException("Read-only");
                    }
                }
                if (this.bucketLength == BucketChainBucket.this.bucketSize) {
                    if (this.baos != null) {
                        OutputStream os = BucketChainBucket.this.makeBucketOutputStream(this.bucketNo);
                        ++this.bucketNo;
                        try {
                            os.write(this.baos.toByteArray());
                            this.baos.reset();
                        }
                        finally {
                            os.close();
                        }
                    } else {
                        this.curBucketStream.close();
                        this.curBucketStream = BucketChainBucket.this.makeBucketOutputStream(++this.bucketNo);
                    }
                    this.bucketLength = 0L;
                }
                if (this.baos != null) {
                    this.baos.write(c);
                } else {
                    this.curBucketStream.write(c);
                }
                ++this.bucketLength;
                bucketChainBucket = BucketChainBucket.this;
                synchronized (bucketChainBucket) {
                    BucketChainBucket.this.size++;
                }
            }

            @Override
            public void write(byte[] buf) throws IOException {
                this.write(buf, 0, buf.length);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(byte[] buf, int offset, int length) throws IOException {
                BucketChainBucket bucketChainBucket = BucketChainBucket.this;
                synchronized (bucketChainBucket) {
                    if (BucketChainBucket.this.freed) {
                        if (this.baos == null) {
                            this.curBucketStream.close();
                            this.curBucketStream = null;
                        }
                        throw new IOException("Freed");
                    }
                    if (BucketChainBucket.this.readOnly) {
                        if (this.baos == null) {
                            this.curBucketStream.close();
                            this.curBucketStream = null;
                        }
                        throw new IOException("Read-only");
                    }
                }
                if (length <= 0) {
                    return;
                }
                if (this.bucketLength == BucketChainBucket.this.bucketSize) {
                    if (this.baos != null) {
                        OutputStream os = BucketChainBucket.this.makeBucketOutputStream(this.bucketNo);
                        ++this.bucketNo;
                        try {
                            os.write(this.baos.toByteArray());
                            this.baos.reset();
                        }
                        finally {
                            os.close();
                        }
                    } else {
                        this.curBucketStream.close();
                        this.curBucketStream = BucketChainBucket.this.makeBucketOutputStream(++this.bucketNo);
                    }
                    this.bucketLength = 0L;
                }
                if (this.bucketLength + (long)length > BucketChainBucket.this.bucketSize) {
                    int split = (int)(BucketChainBucket.this.bucketSize - this.bucketLength);
                    this.write(buf, offset, split);
                    this.write(buf, offset + split, length - split);
                    return;
                }
                if (this.baos != null) {
                    this.baos.write(buf, offset, length);
                } else {
                    this.curBucketStream.write(buf, offset, length);
                }
                this.bucketLength += (long)length;
                bucketChainBucket = BucketChainBucket.this;
                synchronized (bucketChainBucket) {
                    BucketChainBucket.this.size += length;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.baos != null && this.baos.size() > 0) {
                    OutputStream os = BucketChainBucket.this.makeBucketOutputStream(this.bucketNo);
                    ++this.bucketNo;
                    try {
                        os.write(this.baos.toByteArray());
                        this.baos.reset();
                    }
                    finally {
                        os.close();
                    }
                } else if (this.curBucketStream != null) {
                    this.curBucketStream.close();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream makeBucketOutputStream(int i) throws IOException {
        Bucket bucket;
        BucketChainBucket bucketChainBucket = this;
        synchronized (bucketChainBucket) {
            bucket = this.bf.makeBucket(this.bucketSize);
            this.buckets.add(bucket);
            if (this.buckets.size() != i + 1) {
                throw new IllegalStateException("Added bucket, size should be " + (i + 1) + " but is " + this.buckets.size());
            }
            if (this.buckets.get(i) != bucket) {
                throw new IllegalStateException("Bucket got replaced. Race condition?");
            }
        }
        return bucket.getOutputStream();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void storeTo(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bucket createShadow() {
        Vector<Bucket> newBuckets = new Vector<Bucket>();
        for (int i = 0; i < this.buckets.size(); ++i) {
            Bucket data = this.buckets.get(i);
            Bucket shadow = data.createShadow();
            if (shadow == null) {
                for (Bucket bucket : newBuckets) {
                    bucket.free();
                }
                return null;
            }
            newBuckets.add(shadow);
        }
        return new BucketChainBucket(newBuckets, this.bucketSize, this.size, true, this.bf, this.cacheWholeBucket);
    }
}

