/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.support.ListUtils;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class MultiReaderBucket {
    private final Bucket bucket;
    private ArrayList<Bucket> readers;
    private boolean closed;
    private static volatile boolean logMINOR;

    public MultiReaderBucket(Bucket underlying) {
        this.bucket = underlying;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket getReaderBucket() {
        MultiReaderBucket multiReaderBucket = this;
        synchronized (multiReaderBucket) {
            if (this.closed) {
                return null;
            }
            ReaderBucket d = new ReaderBucket();
            if (this.readers == null) {
                this.readers = new ArrayList(1);
            }
            this.readers.add(d);
            if (logMINOR) {
                Logger.minor(this, "getReaderBucket() returning " + d + " for " + this + " for " + this.bucket);
            }
            return d;
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    class ReaderBucket
    implements Bucket {
        private boolean freed;

        ReaderBucket() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void free() {
            if (logMINOR) {
                Logger.minor(this, "ReaderBucket " + this + " for " + MultiReaderBucket.this + " free()ing for " + MultiReaderBucket.this.bucket);
            }
            MultiReaderBucket multiReaderBucket = MultiReaderBucket.this;
            synchronized (multiReaderBucket) {
                if (this.freed) {
                    return;
                }
                this.freed = true;
                ListUtils.removeBySwapLast(MultiReaderBucket.this.readers, this);
                if (!MultiReaderBucket.this.readers.isEmpty()) {
                    return;
                }
                MultiReaderBucket.this.readers = null;
                if (MultiReaderBucket.this.closed) {
                    return;
                }
                MultiReaderBucket.this.closed = true;
            }
            MultiReaderBucket.this.bucket.free();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream getInputStream() throws IOException {
            MultiReaderBucket multiReaderBucket = MultiReaderBucket.this;
            synchronized (multiReaderBucket) {
                if (this.freed || MultiReaderBucket.this.closed) {
                    throw new IOException("Already freed");
                }
            }
            return new ReaderBucketInputStream();
        }

        @Override
        public String getName() {
            return MultiReaderBucket.this.bucket.getName();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            throw new IOException("Read only");
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void setReadOnly() {
        }

        @Override
        public long size() {
            return MultiReaderBucket.this.bucket.size();
        }

        protected void finalize() throws Throwable {
            this.free();
            super.finalize();
        }

        @Override
        public void storeTo(ObjectContainer container) {
            container.store((Object)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeFrom(ObjectContainer container) {
            container.delete((Object)this);
            MultiReaderBucket multiReaderBucket = MultiReaderBucket.this;
            synchronized (multiReaderBucket) {
                if (!MultiReaderBucket.this.closed) {
                    return;
                }
            }
            MultiReaderBucket.this.bucket.removeFrom(container);
            container.delete((Object)MultiReaderBucket.this.readers);
            container.delete((Object)MultiReaderBucket.this);
        }

        @Override
        public Bucket createShadow() {
            return null;
        }

        private class ReaderBucketInputStream
        extends InputStream {
            InputStream is;

            ReaderBucketInputStream() throws IOException {
                this.is = MultiReaderBucket.this.bucket.getInputStream();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final int read() throws IOException {
                MultiReaderBucket multiReaderBucket = MultiReaderBucket.this;
                synchronized (multiReaderBucket) {
                    if (ReaderBucket.this.freed || MultiReaderBucket.this.closed) {
                        throw new IOException("Already closed");
                    }
                }
                return this.is.read();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final int read(byte[] data, int offset, int length) throws IOException {
                MultiReaderBucket multiReaderBucket = MultiReaderBucket.this;
                synchronized (multiReaderBucket) {
                    if (ReaderBucket.this.freed || MultiReaderBucket.this.closed) {
                        throw new IOException("Already closed");
                    }
                }
                return this.is.read(data, offset, length);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final int read(byte[] data) throws IOException {
                MultiReaderBucket multiReaderBucket = MultiReaderBucket.this;
                synchronized (multiReaderBucket) {
                    if (ReaderBucket.this.freed || MultiReaderBucket.this.closed) {
                        throw new IOException("Already closed");
                    }
                }
                return this.is.read(data);
            }

            @Override
            public final void close() throws IOException {
                this.is.close();
            }

            @Override
            public final int available() throws IOException {
                return this.is.available();
            }
        }
    }
}

