/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.TempFileBucket;

public class PersistentTempFileBucket
extends TempFileBucket {
    public PersistentTempFileBucket(long id, FilenameGenerator generator) {
        this(id, generator, true);
    }

    protected PersistentTempFileBucket(long id, FilenameGenerator generator, boolean deleteOnFree) {
        super(id, generator, deleteOnFree);
    }

    @Override
    protected boolean deleteOnFinalize() {
        return false;
    }

    @Override
    protected boolean deleteOnExit() {
        return false;
    }

    @Override
    public Bucket createShadow() {
        PersistentTempFileBucket ret = new PersistentTempFileBucket(this.filenameID, this.generator, false);
        ret.setReadOnly();
        if (!this.getFile().exists()) {
            Logger.error(this, "File does not exist when creating shadow: " + this.getFile());
        }
        return ret;
    }
}

