/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DBJobRunner;
import freenet.client.async.DatabaseDisabledException;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.BucketArrayWrapper;
import freenet.support.io.NativeThread;
import freenet.support.io.NotPersistentBucket;
import freenet.support.io.SegmentedBucketChainBucketKillJob;
import freenet.support.io.SegmentedChainBucketSegment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class SegmentedBucketChainBucket
implements NotPersistentBucket {
    private final ArrayList<SegmentedChainBucketSegment> segments;
    private boolean readOnly;
    public final long bucketSize;
    public final int segmentSize;
    private long size;
    private boolean freed;
    final BucketFactory bf;
    private transient DBJobRunner dbJobRunner;
    private final boolean cacheWholeBucket;
    private static volatile boolean logMINOR;
    private transient SegmentedBucketChainBucketKillJob killMe;
    private transient boolean runningSegStore;
    private boolean clearing;

    public SegmentedBucketChainBucket(int blockSize, BucketFactory factory, DBJobRunner runner, int segmentSize2, boolean cacheWholeBucket) {
        this.bucketSize = blockSize;
        this.bf = factory;
        this.dbJobRunner = runner;
        this.segmentSize = segmentSize2;
        this.segments = new ArrayList();
        this.cacheWholeBucket = cacheWholeBucket;
    }

    @Override
    public Bucket createShadow() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() {
        SegmentedBucketChainBucket segmentedBucketChainBucket = this;
        synchronized (segmentedBucketChainBucket) {
            this.freed = true;
            this.clearing = false;
        }
        DBJob freeJob = new DBJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ObjectContainer container, ClientContext context) {
                SegmentedChainBucketSegment segment = null;
                if (!container.ext().isStored((Object)SegmentedBucketChainBucket.this)) {
                    Logger.error(this, "Bucket not stored in freeJob, already deleted???");
                    container.delete((Object)this);
                    return true;
                }
                Object object = this;
                synchronized (object) {
                    if (!SegmentedBucketChainBucket.this.segments.isEmpty()) {
                        segment = (SegmentedChainBucketSegment)SegmentedBucketChainBucket.this.segments.remove(0);
                    }
                }
                if (segment != null) {
                    container.activate((Object)segment, 1);
                    if (logMINOR) {
                        Logger.minor(SegmentedBucketChainBucket.this, "Freeing segment " + segment);
                    }
                    segment.activateBuckets(container);
                    segment.free();
                    segment.removeFrom(container);
                    object = this;
                    synchronized (object) {
                        if (!SegmentedBucketChainBucket.this.segments.isEmpty()) {
                            try {
                                SegmentedBucketChainBucket.this.dbJobRunner.queue(this, NativeThread.HIGH_PRIORITY, true);
                                SegmentedBucketChainBucket.this.dbJobRunner.queueRestartJob(this, NativeThread.HIGH_PRIORITY, container, false);
                            }
                            catch (DatabaseDisabledException e) {
                                // empty catch block
                            }
                            container.store((Object)this);
                            return true;
                        }
                    }
                }
                container.delete((Object)SegmentedBucketChainBucket.this.segments);
                container.delete((Object)SegmentedBucketChainBucket.this);
                container.delete((Object)this);
                object = SegmentedBucketChainBucket.this;
                synchronized (object) {
                    if (SegmentedBucketChainBucket.this.killMe == null) {
                        return true;
                    }
                }
                try {
                    SegmentedBucketChainBucket.this.dbJobRunner.removeRestartJob(SegmentedBucketChainBucket.this.killMe, NativeThread.HIGH_PRIORITY, container);
                }
                catch (DatabaseDisabledException e) {
                    // empty catch block
                }
                container.delete((Object)SegmentedBucketChainBucket.this.killMe);
                return true;
            }
        };
        try {
            this.dbJobRunner.runBlocking(freeJob, NativeThread.HIGH_PRIORITY);
        }
        catch (DatabaseDisabledException e) {
            Logger.error(this, "Unable to free " + this + " because database is disabled!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        SegmentedBucketChainBucket segmentedBucketChainBucket = this;
        synchronized (segmentedBucketChainBucket) {
            if (this.freed || this.clearing) {
                throw new IOException("Freed");
            }
        }
        return new InputStream(){
            int segmentNo = -1;
            int bucketNo;
            SegmentedChainBucketSegment seg;
            Bucket[] buckets;
            InputStream is;
            private long bucketRead;
            private boolean closed;
            {
                this.bucketNo = SegmentedBucketChainBucket.this.segmentSize;
                this.seg = null;
                this.buckets = null;
                this.is = null;
                this.bucketRead = 0L;
            }

            @Override
            public int read() throws IOException {
                byte[] b = new byte[1];
                if (this.read(b, 0, 1) <= 0) {
                    return -1;
                }
                return b[0];
            }

            @Override
            public int read(byte[] buf) throws IOException {
                return this.read(buf, 0, buf.length);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(byte[] buf, int offset, int length) throws IOException {
                int r;
                if (this.closed) {
                    throw new IOException("Already closed");
                }
                if (this.bucketRead == SegmentedBucketChainBucket.this.bucketSize || this.is == null) {
                    if (this.is != null) {
                        this.is.close();
                    }
                    if (this.buckets != null) {
                        this.buckets[this.bucketNo] = null;
                    }
                    this.bucketRead = 0L;
                    ++this.bucketNo;
                    if (this.bucketNo == SegmentedBucketChainBucket.this.segmentSize || this.buckets == null) {
                        this.bucketNo = 0;
                        ++this.segmentNo;
                        this.seg = SegmentedBucketChainBucket.this.getSegment(this.segmentNo);
                        if (this.seg == null) {
                            return -1;
                        }
                        try {
                            this.buckets = SegmentedBucketChainBucket.this.getBuckets(this.seg);
                        }
                        catch (DatabaseDisabledException e) {
                            throw new IOException("Database disabled during read!");
                        }
                    }
                    if (this.bucketNo >= this.buckets.length) {
                        SegmentedBucketChainBucket e = SegmentedBucketChainBucket.this;
                        synchronized (e) {
                            if (this.segmentNo >= SegmentedBucketChainBucket.this.segments.size()) {
                                return -1;
                            }
                        }
                        try {
                            this.buckets = SegmentedBucketChainBucket.this.getBuckets(this.seg);
                        }
                        catch (DatabaseDisabledException e2) {
                            throw new IOException("Database disabled during read!");
                        }
                        if (this.bucketNo >= this.buckets.length) {
                            return -1;
                        }
                    }
                    this.is = this.buckets[this.bucketNo].getInputStream();
                }
                if ((r = this.is.read(buf, offset, length)) > 0) {
                    this.bucketRead += (long)r;
                }
                return r;
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                if (this.is != null) {
                    this.is.close();
                }
                this.closed = true;
                this.is = null;
                this.seg = null;
                this.buckets = null;
            }
        };
    }

    protected synchronized SegmentedChainBucketSegment getSegment(int i) {
        return this.segments.get(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bucket[] getBuckets(final SegmentedChainBucketSegment seg) throws DatabaseDisabledException {
        final BucketArrayWrapper baw = new BucketArrayWrapper();
        this.dbJobRunner.runBlocking(new DBJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ObjectContainer container, ClientContext context) {
                container.activate((Object)seg, 1);
                BucketArrayWrapper bucketArrayWrapper = baw;
                synchronized (bucketArrayWrapper) {
                    baw.buckets = seg.shallowCopyBuckets();
                }
                container.deactivate((Object)seg, 1);
                return false;
            }
        }, NativeThread.HIGH_PRIORITY);
        BucketArrayWrapper bucketArrayWrapper = baw;
        synchronized (bucketArrayWrapper) {
            return baw.buckets;
        }
    }

    @Override
    public String getName() {
        return "SegmentedBucketChainBucket";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        SegmentedChainBucketSegment[] segs;
        SegmentedBucketChainBucket segmentedBucketChainBucket = this;
        synchronized (segmentedBucketChainBucket) {
            if (this.readOnly) {
                throw new IOException("Read-only");
            }
            if (this.freed || this.clearing) {
                throw new IOException("Freed");
            }
            this.size = 0L;
            segs = this.segments.toArray(new SegmentedChainBucketSegment[this.segments.size()]);
            this.segments.clear();
        }
        for (SegmentedChainBucketSegment seg : segs) {
            seg.free();
        }
        if (segs.length > 0) {
            try {
                this.dbJobRunner.runBlocking(new DBJob(){

                    @Override
                    public boolean run(ObjectContainer container, ClientContext context) {
                        for (SegmentedChainBucketSegment seg : segs) {
                            seg.removeFrom(container);
                        }
                        return true;
                    }
                }, NativeThread.HIGH_PRIORITY);
            }
            catch (DatabaseDisabledException e) {
                throw new IOException("Database disabled");
            }
        }
        return new OutputStream(){
            int segmentNo = 0;
            int bucketNo = 0;
            SegmentedChainBucketSegment seg = SegmentedBucketChainBucket.this.makeSegment(this.segmentNo, null);
            OutputStream cur;
            private long bucketLength;
            private boolean closed;
            private ByteArrayOutputStream baos;
            {
                if (SegmentedBucketChainBucket.this.cacheWholeBucket) {
                    this.baos = new ByteArrayOutputStream((int)SegmentedBucketChainBucket.this.bucketSize);
                } else {
                    this.cur = this.seg.makeBucketStream(this.bucketNo, SegmentedBucketChainBucket.this);
                }
            }

            @Override
            public void write(int arg0) throws IOException {
                this.write(new byte[]{(byte)arg0});
            }

            @Override
            public void write(byte[] buf) throws IOException {
                this.write(buf, 0, buf.length);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void write(byte[] buf, int offset, int length) throws IOException {
                SegmentedBucketChainBucket segmentedBucketChainBucket = SegmentedBucketChainBucket.this;
                // MONITORENTER : segmentedBucketChainBucket
                boolean ro = SegmentedBucketChainBucket.this.readOnly;
                // MONITOREXIT : segmentedBucketChainBucket
                if (ro) {
                    if (this.closed) throw new IOException("Read-only");
                    this.close();
                    throw new IOException("Read-only");
                }
                if (this.closed) {
                    throw new IOException("Already closed");
                }
                while (length > 0) {
                    if (this.bucketLength == SegmentedBucketChainBucket.this.bucketSize) {
                        if (this.bucketNo == SegmentedBucketChainBucket.this.segmentSize) {
                            this.bucketNo = 0;
                            ++this.segmentNo;
                            this.seg = SegmentedBucketChainBucket.this.makeSegment(this.segmentNo, this.seg);
                        }
                        if (this.baos != null) {
                            OutputStream os = this.seg.makeBucketStream(this.bucketNo, SegmentedBucketChainBucket.this);
                            ++this.bucketNo;
                            try {
                                os.write(this.baos.toByteArray());
                                this.baos.reset();
                            }
                            finally {
                                os.close();
                            }
                        } else {
                            this.cur.close();
                            this.cur = this.seg.makeBucketStream(++this.bucketNo, SegmentedBucketChainBucket.this);
                        }
                        this.bucketLength = 0L;
                    }
                    int left = (int)Math.min(Integer.MAX_VALUE, SegmentedBucketChainBucket.this.bucketSize - this.bucketLength);
                    int write = Math.min(left, length);
                    if (this.baos != null) {
                        this.baos.write(buf, offset, write);
                    } else {
                        this.cur.write(buf, offset, write);
                    }
                    offset += write;
                    length -= write;
                    this.bucketLength += (long)write;
                    Class<SegmentedBucketChainBucket> clazz = SegmentedBucketChainBucket.class;
                    // MONITORENTER : freenet.support.io.SegmentedBucketChainBucket.class
                    SegmentedBucketChainBucket.this.size += write;
                    // MONITOREXIT : clazz
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "Closing " + this + " for " + SegmentedBucketChainBucket.this);
                }
                if (this.baos != null && this.baos.size() > 0) {
                    if (this.bucketNo == SegmentedBucketChainBucket.this.segmentSize) {
                        this.bucketNo = 0;
                        ++this.segmentNo;
                        this.seg = SegmentedBucketChainBucket.this.makeSegment(this.segmentNo, this.seg);
                    }
                    OutputStream os = this.seg.makeBucketStream(this.bucketNo, SegmentedBucketChainBucket.this);
                    ++this.bucketNo;
                    try {
                        os.write(this.baos.toByteArray());
                        this.baos.reset();
                    }
                    finally {
                        os.close();
                    }
                } else {
                    this.cur.close();
                }
                this.closed = true;
                this.cur = null;
                final SegmentedChainBucketSegment oldSeg = this.seg;
                this.seg = null;
                try {
                    SegmentedBucketChainBucket.this.dbJobRunner.runBlocking(new DBJob(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public boolean run(ObjectContainer container, ClientContext context) {
                            if (container.ext().isStored((Object)oldSeg) && !container.ext().isActive((Object)oldSeg)) {
                                Logger.error(this, "OLD SEGMENT STORED BUT NOT ACTIVE: " + oldSeg, (Throwable)new Exception("error"));
                                container.activate((Object)oldSeg, 1);
                            }
                            oldSeg.storeTo(container);
                            container.ext().store((Object)SegmentedBucketChainBucket.this.segments, 1);
                            container.ext().store((Object)SegmentedBucketChainBucket.this, 1);
                            container.deactivate((Object)oldSeg, 1);
                            SegmentedBucketChainBucket segmentedBucketChainBucket = SegmentedBucketChainBucket.this;
                            synchronized (segmentedBucketChainBucket) {
                                if (SegmentedBucketChainBucket.this.killMe != null) {
                                    return true;
                                }
                                SegmentedBucketChainBucket.this.killMe = new SegmentedBucketChainBucketKillJob(SegmentedBucketChainBucket.this);
                            }
                            try {
                                SegmentedBucketChainBucket.this.killMe.scheduleRestart(container, context);
                            }
                            catch (DatabaseDisabledException databaseDisabledException) {
                                // empty catch block
                            }
                            return true;
                        }
                    }, NativeThread.HIGH_PRIORITY);
                }
                catch (DatabaseDisabledException e) {
                    throw new IOException("Database disabled");
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SegmentedChainBucketSegment makeSegment(int index, final SegmentedChainBucketSegment oldSeg) {
        SegmentedBucketChainBucket segmentedBucketChainBucket;
        if (logMINOR) {
            Logger.minor(this, "Make a segment for " + this + " index " + index + "old " + oldSeg);
        }
        if (oldSeg != null) {
            segmentedBucketChainBucket = this;
            synchronized (segmentedBucketChainBucket) {
                while (this.runningSegStore) {
                    Logger.normal(this, "Waiting for last segment-store job to finish on " + this);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
                this.runningSegStore = true;
            }
            try {
                this.dbJobRunner.runBlocking(new DBJob(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean run(ObjectContainer container, ClientContext context) {
                        try {
                            oldSeg.storeTo(container);
                            container.ext().store((Object)SegmentedBucketChainBucket.this.segments, 1);
                            container.ext().store((Object)SegmentedBucketChainBucket.this, 1);
                            container.deactivate((Object)oldSeg, 1);
                            SegmentedBucketChainBucket segmentedBucketChainBucket = SegmentedBucketChainBucket.this;
                            synchronized (segmentedBucketChainBucket) {
                                block22: {
                                    if (SegmentedBucketChainBucket.this.killMe == null) break block22;
                                    boolean bl = true;
                                    return bl;
                                }
                                SegmentedBucketChainBucket.this.killMe = new SegmentedBucketChainBucketKillJob(SegmentedBucketChainBucket.this);
                            }
                            SegmentedBucketChainBucket.this.killMe.scheduleRestart(container, context);
                        }
                        catch (DatabaseDisabledException databaseDisabledException) {
                            SegmentedBucketChainBucket segmentedBucketChainBucket = SegmentedBucketChainBucket.this;
                            synchronized (segmentedBucketChainBucket) {
                                SegmentedBucketChainBucket.this.runningSegStore = false;
                                SegmentedBucketChainBucket.this.notifyAll();
                            }
                        }
                        finally {
                            SegmentedBucketChainBucket segmentedBucketChainBucket = SegmentedBucketChainBucket.this;
                            synchronized (segmentedBucketChainBucket) {
                                SegmentedBucketChainBucket.this.runningSegStore = false;
                                SegmentedBucketChainBucket.this.notifyAll();
                            }
                        }
                        return true;
                    }
                }, NativeThread.HIGH_PRIORITY - 1);
            }
            catch (Throwable t) {
                Logger.error(this, "Caught throwable: " + t, t);
                this.runningSegStore = false;
            }
        }
        segmentedBucketChainBucket = this;
        synchronized (segmentedBucketChainBucket) {
            SegmentedChainBucketSegment seg = new SegmentedChainBucketSegment(this);
            if (this.segments.size() != index) {
                throw new IllegalArgumentException("Asked to add segment " + index + " but segments length is " + this.segments.size());
            }
            this.segments.add(seg);
            return seg;
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void removeFrom(ObjectContainer container) {
    }

    @Override
    public void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    public synchronized long size() {
        return this.size;
    }

    @Override
    public void storeTo(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }

    public Bucket[] getBuckets() {
        final BucketArrayWrapper baw = new BucketArrayWrapper();
        try {
            this.dbJobRunner.runBlocking(new DBJob(){

                @Override
                public boolean run(ObjectContainer container, ClientContext context) {
                    baw.buckets = SegmentedBucketChainBucket.this.getBuckets(container);
                    return false;
                }
            }, NativeThread.HIGH_PRIORITY);
        }
        catch (DatabaseDisabledException e) {
            return null;
        }
        return baw.buckets;
    }

    protected synchronized Bucket[] getBuckets(ObjectContainer container) {
        int segs = this.segments.size();
        if (segs == 0) {
            return new Bucket[0];
        }
        SegmentedChainBucketSegment seg = this.segments.get(segs - 1);
        container.activate((Object)seg, 1);
        seg.activateBuckets(container);
        int size = (segs - 1) * this.segmentSize + seg.size();
        Bucket[] buckets = new Bucket[size];
        seg.shallowCopyBuckets(buckets, (segs - 1) * this.segmentSize);
        container.deactivate((Object)seg, 1);
        int pos = 0;
        for (int i = 0; i < segs - 1; ++i) {
            seg = this.segments.get(i);
            container.activate((Object)seg, 1);
            seg.activateBuckets(container);
            seg.shallowCopyBuckets(buckets, pos);
            container.deactivate((Object)seg, 1);
            pos += this.segmentSize;
        }
        return buckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        SegmentedBucketChainBucket segmentedBucketChainBucket = this;
        synchronized (segmentedBucketChainBucket) {
            this.clearing = true;
        }
        DBJob clearJob = new DBJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ObjectContainer container, ClientContext context) {
                if (!container.ext().isStored((Object)SegmentedBucketChainBucket.this)) {
                    Logger.error(this, "Bucket not stored in clearJob, already deleted???");
                    container.delete((Object)this);
                    return false;
                }
                SegmentedChainBucketSegment segment = null;
                Object object = this;
                synchronized (object) {
                    if (!SegmentedBucketChainBucket.this.segments.isEmpty()) {
                        segment = (SegmentedChainBucketSegment)SegmentedBucketChainBucket.this.segments.remove(0);
                    }
                }
                if (segment != null) {
                    container.activate((Object)segment, 1);
                    if (logMINOR) {
                        Logger.minor(SegmentedBucketChainBucket.this, "Clearing segment " + segment);
                    }
                    segment.clear(container);
                    object = this;
                    synchronized (object) {
                        if (!SegmentedBucketChainBucket.this.segments.isEmpty()) {
                            try {
                                SegmentedBucketChainBucket.this.dbJobRunner.queue(this, NativeThread.HIGH_PRIORITY - 1, true);
                                SegmentedBucketChainBucket.this.dbJobRunner.queueRestartJob(this, NativeThread.HIGH_PRIORITY - 1, container, false);
                            }
                            catch (DatabaseDisabledException e) {
                                // empty catch block
                            }
                            container.store((Object)SegmentedBucketChainBucket.this.segments);
                            container.store((Object)SegmentedBucketChainBucket.this);
                            return true;
                        }
                    }
                }
                container.delete((Object)SegmentedBucketChainBucket.this.segments);
                container.delete((Object)SegmentedBucketChainBucket.this);
                container.delete((Object)this);
                object = SegmentedBucketChainBucket.this;
                synchronized (object) {
                    if (SegmentedBucketChainBucket.this.killMe == null) {
                        return true;
                    }
                }
                try {
                    SegmentedBucketChainBucket.this.dbJobRunner.removeRestartJob(SegmentedBucketChainBucket.this.killMe, NativeThread.HIGH_PRIORITY, container);
                }
                catch (DatabaseDisabledException e) {
                    // empty catch block
                }
                container.delete((Object)SegmentedBucketChainBucket.this.killMe);
                return true;
            }
        };
        try {
            this.dbJobRunner.runBlocking(clearJob, NativeThread.HIGH_PRIORITY - 1);
        }
        catch (DatabaseDisabledException e) {
            Logger.error(this, "Unable to clear() on " + this + " because database is disabled");
        }
    }

    synchronized boolean removeContents(ObjectContainer container) {
        while (this.segments.size() > 0) {
            Logger.normal(this, "Freeing unfinished unstored bucket " + this + " segments left " + this.segments.size());
            SegmentedChainBucketSegment seg = this.segments.remove(0);
            if (seg == null) continue;
            container.activate((Object)seg, 1);
            if (logMINOR) {
                Logger.minor(this, "Removing segment " + seg + " size " + seg.size());
            }
            if (this.clearing) {
                seg.clear(container);
            } else {
                seg.activateBuckets(container);
                seg.free();
                seg.removeFrom(container);
            }
            if (this.segments.size() <= 0) break;
            container.store(this.segments);
            container.store((Object)this);
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "Removed segments for " + this);
        }
        container.delete(this.segments);
        container.delete((Object)this);
        if (logMINOR) {
            Logger.minor(this, "Removed " + this);
        }
        this.freed = true;
        return false;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

