/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.support.Logger;
import freenet.support.io.NativeThread;
import freenet.support.io.SegmentedBucketChainBucket;

public class SegmentedBucketChainBucketKillJob
implements DBJob {
    final SegmentedBucketChainBucket bcb;
    private final int RESTART_PRIO = NativeThread.HIGH_PRIORITY;

    public SegmentedBucketChainBucketKillJob(SegmentedBucketChainBucket bucket) {
        this.bcb = bucket;
    }

    @Override
    public boolean run(ObjectContainer container, ClientContext context) {
        container.activate((Object)this.bcb, 2);
        Logger.normal(this, "Freeing unfinished unstored bucket " + this);
        if (this.bcb.removeContents(container)) {
            try {
                this.scheduleRestart(container, context);
            }
            catch (DatabaseDisabledException e1) {
                return true;
            }
            context.persistentBucketFactory.addBlobFreeCallback(this);
            try {
                context.jobRunner.queue(this, NativeThread.NORM_PRIORITY, true);
            }
            catch (DatabaseDisabledException e) {}
        } else {
            try {
                context.jobRunner.removeRestartJob(this, this.RESTART_PRIO, container);
            }
            catch (DatabaseDisabledException databaseDisabledException) {
                // empty catch block
            }
            container.delete((Object)this);
            context.persistentBucketFactory.removeBlobFreeCallback(this);
        }
        return true;
    }

    public void scheduleRestart(ObjectContainer container, ClientContext context) throws DatabaseDisabledException {
        context.jobRunner.queueRestartJob(this, this.RESTART_PRIO, container, true);
    }
}

