/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BaseFileBucket;
import freenet.support.io.FilenameGenerator;
import java.io.File;

public class TempFileBucket
extends BaseFileBucket
implements Bucket {
    long filenameID;
    final FilenameGenerator generator;
    private boolean readOnly;
    private final boolean deleteOnFree;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;

    public TempFileBucket(long id, FilenameGenerator generator) {
        this(id, generator, true);
    }

    protected TempFileBucket(long id, FilenameGenerator generator, boolean deleteOnFree) {
        super(generator.getFilename(id), false);
        this.filenameID = id;
        this.generator = generator;
        this.deleteOnFree = deleteOnFree;
        if (logDEBUG) {
            Logger.debug(this, "Initializing TempFileBucket(" + this.getFile());
        }
    }

    @Override
    protected boolean deleteOnFinalize() {
        return this.deleteOnFree;
    }

    @Override
    protected boolean createFileOnly() {
        return false;
    }

    @Override
    protected boolean deleteOnFree() {
        return this.deleteOnFree;
    }

    @Override
    public File getFile() {
        return this.generator.getFilename(this.filenameID);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    protected boolean deleteOnExit() {
        return false;
    }

    @Override
    public void storeTo(ObjectContainer container) {
        container.store((Object)this.generator);
        container.store((Object)this);
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "Removing from database: " + this);
        }
        container.delete((Object)this);
    }

    @Override
    public Bucket createShadow() {
        TempFileBucket ret = new TempFileBucket(this.filenameID, this.generator, false);
        ret.setReadOnly();
        if (!this.getFile().exists()) {
            Logger.error(this, "File does not exist when creating shadow: " + this.getFile());
        }
        return ret;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }
}

