/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.support.api.Bucket;
import freenet.support.io.FileUtil;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TrivialPaddedBucket
implements Bucket {
    private final Bucket underlying;
    private long size;
    private boolean outputStreamOpen;
    private boolean readOnly;
    private static final long MIN_PADDED_SIZE = 1024L;

    public TrivialPaddedBucket(Bucket underlying) {
        this(underlying, 0L);
    }

    public TrivialPaddedBucket(Bucket underlying, long size) {
        this.underlying = underlying;
        this.size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStream os;
        TrivialPaddedBucket trivialPaddedBucket = this;
        synchronized (trivialPaddedBucket) {
            if (this.outputStreamOpen) {
                throw new IOException("Already have an OutputStream for " + this);
            }
            os = this.underlying.getOutputStream();
            this.outputStreamOpen = true;
            this.size = 0L;
        }
        return new MyOutputStream(os);
    }

    private long paddedLength(long size) {
        if (size < 1024L) {
            size = 1024L;
        }
        if (size == 1024L) {
            return size;
        }
        long min = 1024L;
        long max = 2048L;
        while (true) {
            if (max < 0L) {
                throw new Error("Impossible size: " + size + " - min=" + min + ", max=" + max);
            }
            if (size < min) {
                throw new IllegalStateException("???");
            }
            if (size >= min && size <= max) {
                return max;
            }
            min = max;
            max <<= 1;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new MyInputStream(this.underlying.getInputStream());
    }

    @Override
    public String getName() {
        return "Padded:" + this.underlying.getName();
    }

    @Override
    public synchronized long size() {
        return this.size;
    }

    @Override
    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public synchronized void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    public void free() {
        this.underlying.free();
    }

    @Override
    public void storeTo(ObjectContainer container) {
        this.underlying.storeTo(container);
        container.store((Object)this);
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        this.underlying.removeFrom(container);
        container.delete((Object)this);
    }

    @Override
    public Bucket createShadow() {
        Bucket shadow = this.underlying.createShadow();
        TrivialPaddedBucket ret = new TrivialPaddedBucket(shadow, this.size);
        ret.setReadOnly();
        return ret;
    }

    private class MyInputStream
    extends FilterInputStream {
        private long counter;

        public MyInputStream(InputStream is) {
            super(is);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            TrivialPaddedBucket trivialPaddedBucket = TrivialPaddedBucket.this;
            synchronized (trivialPaddedBucket) {
                if (this.counter >= TrivialPaddedBucket.this.size) {
                    return -1;
                }
            }
            int ret = this.in.read();
            TrivialPaddedBucket trivialPaddedBucket2 = TrivialPaddedBucket.this;
            synchronized (trivialPaddedBucket2) {
                ++this.counter;
            }
            return ret;
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            TrivialPaddedBucket trivialPaddedBucket = TrivialPaddedBucket.this;
            synchronized (trivialPaddedBucket) {
                if (length < 0) {
                    return -1;
                }
                if (length == 0) {
                    return 0;
                }
                if (this.counter >= TrivialPaddedBucket.this.size) {
                    return -1;
                }
                if (this.counter + (long)length >= TrivialPaddedBucket.this.size) {
                    length = (int)Math.min((long)length, TrivialPaddedBucket.this.size - this.counter);
                }
            }
            int ret = this.in.read(buf, offset, length);
            TrivialPaddedBucket trivialPaddedBucket2 = TrivialPaddedBucket.this;
            synchronized (trivialPaddedBucket2) {
                if (ret > 0) {
                    this.counter += (long)ret;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long length) throws IOException {
            TrivialPaddedBucket trivialPaddedBucket = TrivialPaddedBucket.this;
            synchronized (trivialPaddedBucket) {
                if (this.counter >= TrivialPaddedBucket.this.size) {
                    return -1L;
                }
                if (this.counter + length >= TrivialPaddedBucket.this.size) {
                    length = (int)Math.min(length, this.counter + length - TrivialPaddedBucket.this.size);
                }
            }
            long ret = this.in.skip(length);
            TrivialPaddedBucket trivialPaddedBucket2 = TrivialPaddedBucket.this;
            synchronized (trivialPaddedBucket2) {
                if (ret > 0L) {
                    this.counter += ret;
                }
            }
            return ret;
        }

        @Override
        public synchronized int available() throws IOException {
            int ret;
            long max = TrivialPaddedBucket.this.size - this.counter;
            if (max < (long)(ret = this.in.available())) {
                ret = (int)max;
            }
            if (ret < 0) {
                return 0;
            }
            return ret;
        }
    }

    private class MyOutputStream
    extends FilterOutputStream {
        MyOutputStream(OutputStream os) {
            super(os);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            TrivialPaddedBucket trivialPaddedBucket = TrivialPaddedBucket.this;
            synchronized (trivialPaddedBucket) {
                TrivialPaddedBucket.this.size++;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buf) throws IOException {
            this.out.write(buf);
            TrivialPaddedBucket trivialPaddedBucket = TrivialPaddedBucket.this;
            synchronized (trivialPaddedBucket) {
                TrivialPaddedBucket.this.size += buf.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buf, int offset, int length) throws IOException {
            this.out.write(buf, offset, length);
            TrivialPaddedBucket trivialPaddedBucket = TrivialPaddedBucket.this;
            synchronized (trivialPaddedBucket) {
                TrivialPaddedBucket.this.size += length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                long padding;
                TrivialPaddedBucket trivialPaddedBucket = TrivialPaddedBucket.this;
                synchronized (trivialPaddedBucket) {
                    long paddedLength = TrivialPaddedBucket.this.paddedLength(TrivialPaddedBucket.this.size);
                    padding = paddedLength - TrivialPaddedBucket.this.size;
                }
                FileUtil.fill(this.out, padding);
                this.out.close();
            }
            finally {
                TrivialPaddedBucket trivialPaddedBucket = TrivialPaddedBucket.this;
                synchronized (trivialPaddedBucket) {
                    TrivialPaddedBucket.this.outputStreamOpen = false;
                }
            }
        }

        public String toString() {
            return "TrivialPaddedBucketOutputStream:" + this.out + "(" + TrivialPaddedBucket.this + ")";
        }
    }
}

