/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveContext;
import freenet.client.ArchiveExtractCallback;
import freenet.client.ArchiveFailureException;
import freenet.client.ArchiveHandlerImpl;
import freenet.client.async.ClientContext;
import freenet.support.Logger;
import freenet.support.api.Bucket;

class ArchiveExtractTag {
    final ArchiveHandlerImpl handler;
    final Bucket data;
    final boolean freeBucket;
    final ArchiveContext actx;
    final String element;
    final ArchiveExtractCallback callback;
    final long nodeDBHandle;

    ArchiveExtractTag(ArchiveHandlerImpl handler, Bucket data, boolean freeBucket, ArchiveContext actx, String element, ArchiveExtractCallback callback, long nodeDBHandle) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
        this.data = data;
        this.freeBucket = freeBucket;
        this.actx = actx;
        this.element = element;
        this.callback = callback;
        this.nodeDBHandle = nodeDBHandle;
    }

    public void activateForExecution(ObjectContainer container) {
        container.activate((Object)this, 1);
        container.activate((Object)this.data, 5);
        this.handler.activateForExecution(container);
        container.activate((Object)this.actx, 5);
        container.activate((Object)this.callback, 1);
    }

    public boolean checkBroken(ObjectContainer container, ClientContext context) {
        container.activate((Object)this, 1);
        if (this.data == null || this.actx == null || this.callback == null || this.handler == null) {
            String error = "Archive extract tag is broken: data=" + this.data + " actx=" + this.actx + " callback=" + this.callback + " handler=" + this.handler;
            Logger.error(this, error);
            if (this.callback != null) {
                container.activate((Object)this.callback, 1);
                this.callback.onFailed(new ArchiveFailureException(error), container, context);
            }
            if (this.data != null && this.freeBucket) {
                container.activate((Object)this.data, 1);
                this.data.free();
                this.data.removeFrom(container);
            }
            return true;
        }
        return false;
    }
}

