/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.async.BlockSet;
import freenet.client.events.ClientEventProducer;
import freenet.client.events.SimpleEventProducer;
import freenet.client.filter.FoundURICallback;
import freenet.client.filter.TagReplacerCallback;
import freenet.node.RequestScheduler;
import freenet.support.api.BucketFactory;
import java.util.Set;

public class FetchContext
implements Cloneable {
    public static final int IDENTICAL_MASK = 0;
    public static final int SPLITFILE_DEFAULT_BLOCK_MASK = 1;
    public static final int SPLITFILE_DEFAULT_MASK = 2;
    public static final int SET_RETURN_ARCHIVES = 4;
    public long maxOutputLength;
    public long maxTempLength;
    public int maxRecursionLevel;
    public int maxArchiveRestarts;
    public int maxArchiveLevels;
    public boolean dontEnterImplicitArchives;
    public int maxSplitfileBlockRetries;
    public int maxNonSplitfileRetries;
    public final int maxUSKRetries;
    public boolean allowSplitfiles;
    public boolean followRedirects;
    public boolean localRequestOnly;
    public boolean ignoreStore;
    public final ClientEventProducer eventProducer;
    public int maxMetadataSize;
    public int maxDataBlocksPerSegment;
    public int maxCheckBlocksPerSegment;
    public boolean returnZIPManifests;
    public boolean filterData;
    public final boolean ignoreTooManyPathComponents;
    public final BlockSet blocks;
    public Set<String> allowedMIMETypes;
    public String charset;
    private final boolean hasOwnEventProducer;
    public boolean canWriteClientCache;
    public FoundURICallback prefetchHook;
    public TagReplacerCallback tagReplacer;
    public String overrideMIME;
    private int cooldownRetries;
    private long cooldownTime;
    public boolean ignoreUSKDatehints;

    public FetchContext(long curMaxLength, long curMaxTempLength, int maxMetadataSize, int maxRecursionLevel, int maxArchiveRestarts, int maxArchiveLevels, boolean dontEnterImplicitArchives, int maxSplitfileBlockRetries, int maxNonSplitfileRetries, int maxUSKRetries, boolean allowSplitfiles, boolean followRedirects, boolean localRequestOnly, boolean filterData, int maxDataBlocksPerSegment, int maxCheckBlocksPerSegment, BucketFactory bucketFactory, ClientEventProducer producer, boolean ignoreTooManyPathComponents, boolean canWriteClientCache, String charset, String overrideMIME) {
        this.blocks = null;
        this.maxOutputLength = curMaxLength;
        this.maxTempLength = curMaxTempLength;
        this.maxMetadataSize = maxMetadataSize;
        this.maxRecursionLevel = maxRecursionLevel;
        this.maxArchiveRestarts = maxArchiveRestarts;
        this.maxArchiveLevels = maxArchiveLevels;
        this.dontEnterImplicitArchives = dontEnterImplicitArchives;
        this.maxSplitfileBlockRetries = maxSplitfileBlockRetries;
        this.maxNonSplitfileRetries = maxNonSplitfileRetries;
        this.maxUSKRetries = maxUSKRetries;
        this.allowSplitfiles = allowSplitfiles;
        this.followRedirects = followRedirects;
        this.localRequestOnly = localRequestOnly;
        this.eventProducer = producer;
        this.maxDataBlocksPerSegment = maxDataBlocksPerSegment;
        this.maxCheckBlocksPerSegment = maxCheckBlocksPerSegment;
        this.filterData = filterData;
        this.ignoreTooManyPathComponents = ignoreTooManyPathComponents;
        this.canWriteClientCache = canWriteClientCache;
        this.charset = charset;
        this.overrideMIME = overrideMIME;
        this.cooldownRetries = 3;
        this.cooldownTime = RequestScheduler.COOLDOWN_PERIOD;
        this.ignoreUSKDatehints = false;
        this.hasOwnEventProducer = true;
    }

    public FetchContext(FetchContext ctx, int maskID, boolean keepProducer, BlockSet blocks) {
        this.eventProducer = keepProducer ? ctx.eventProducer : new SimpleEventProducer();
        this.hasOwnEventProducer = !keepProducer;
        this.ignoreTooManyPathComponents = ctx.ignoreTooManyPathComponents;
        this.blocks = blocks != null ? blocks : ctx.blocks;
        this.allowedMIMETypes = ctx.allowedMIMETypes;
        this.maxUSKRetries = ctx.maxUSKRetries;
        this.localRequestOnly = ctx.localRequestOnly;
        this.maxArchiveLevels = ctx.maxArchiveLevels;
        this.maxMetadataSize = ctx.maxMetadataSize;
        this.maxNonSplitfileRetries = ctx.maxNonSplitfileRetries;
        this.maxOutputLength = ctx.maxOutputLength;
        this.maxSplitfileBlockRetries = ctx.maxSplitfileBlockRetries;
        this.maxTempLength = ctx.maxTempLength;
        this.allowSplitfiles = ctx.allowSplitfiles;
        this.dontEnterImplicitArchives = ctx.dontEnterImplicitArchives;
        this.followRedirects = ctx.followRedirects;
        this.maxArchiveRestarts = ctx.maxArchiveRestarts;
        this.maxCheckBlocksPerSegment = ctx.maxCheckBlocksPerSegment;
        this.maxDataBlocksPerSegment = ctx.maxDataBlocksPerSegment;
        this.filterData = ctx.filterData;
        this.maxRecursionLevel = ctx.maxRecursionLevel;
        this.returnZIPManifests = ctx.returnZIPManifests;
        this.canWriteClientCache = ctx.canWriteClientCache;
        this.prefetchHook = ctx.prefetchHook;
        this.tagReplacer = ctx.tagReplacer;
        this.overrideMIME = ctx.overrideMIME;
        this.cooldownRetries = ctx.cooldownRetries;
        this.cooldownTime = ctx.cooldownTime;
        this.ignoreUSKDatehints = ctx.ignoreUSKDatehints;
        if (maskID != 0 && maskID != 2) {
            if (maskID == 1) {
                this.maxRecursionLevel = 1;
                this.maxArchiveRestarts = 0;
                this.dontEnterImplicitArchives = true;
                this.allowSplitfiles = false;
                this.followRedirects = false;
                this.maxDataBlocksPerSegment = 0;
                this.maxCheckBlocksPerSegment = 0;
                this.returnZIPManifests = false;
            } else if (maskID == 4) {
                this.returnZIPManifests = true;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public FetchContext clone() {
        try {
            return (FetchContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void removeFrom(ObjectContainer container) {
        if (this.hasOwnEventProducer) {
            container.activate((Object)this.eventProducer, 1);
            this.eventProducer.removeFrom(container);
        }
        container.delete((Object)this);
    }

    public void setCooldownRetries(int cooldownRetries) {
        if (cooldownRetries < 0) {
            throw new IllegalArgumentException("Bogus negative retries");
        }
        if (cooldownRetries > 3) {
            throw new IllegalArgumentException("Invalid COOLDOWN_RETRIES: Must be <= 3 since the network will not tolerate more than that");
        }
        this.cooldownRetries = cooldownRetries;
    }

    public void setCooldownTime(long cooldownTime) {
        if (cooldownTime < 0L) {
            throw new IllegalArgumentException("Bogus negative cooldown time");
        }
        if (cooldownTime < RequestScheduler.COOLDOWN_PERIOD) {
            throw new IllegalArgumentException("Invalid COOLDOWN_PERIOD: Must be >= " + RequestScheduler.COOLDOWN_PERIOD + " since ULPRs will ensure fast response at that level");
        }
        this.cooldownTime = cooldownTime;
    }

    public int getCooldownRetries() {
        return this.cooldownRetries;
    }

    public long getCooldownTime() {
        return this.cooldownTime;
    }
}

