/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequester;
import freenet.client.async.CooldownTrackerItem;
import freenet.client.async.HasCooldownTrackerItem;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.PersistentChosenBlock;
import freenet.client.async.PersistentChosenRequest;
import freenet.client.async.SingleKeyListener;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.KeyVerifyException;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelGetException;
import freenet.node.NullSendableRequestItem;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.node.SendableRequestItem;
import freenet.support.Logger;
import freenet.support.RandomGrabArray;
import freenet.support.TimeUtil;
import java.util.Collections;
import java.util.List;

public abstract class BaseSingleFileFetcher
extends SendableGet
implements HasKeyListener,
HasCooldownTrackerItem {
    final ClientKey key;
    protected boolean cancelled;
    protected boolean finished;
    final int maxRetries;
    private int retryCount;
    final FetchContext ctx;
    protected boolean deleteFetchContext;
    static final SendableRequestItem[] keys = new SendableRequestItem[]{NullSendableRequestItem.nullItem};
    private int cachedCooldownTries;
    private long cachedCooldownTime;
    private static volatile boolean logMINOR;

    protected BaseSingleFileFetcher(ClientKey key, int maxRetries, FetchContext ctx, ClientRequester parent, boolean deleteFetchContext, boolean realTimeFlag) {
        super(parent, realTimeFlag);
        this.deleteFetchContext = deleteFetchContext;
        if (logMINOR) {
            Logger.minor(this, "Creating BaseSingleFileFetcher for " + key);
        }
        this.retryCount = 0;
        this.maxRetries = maxRetries;
        this.key = key;
        this.ctx = ctx;
        if (ctx == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public long countAllKeys(ObjectContainer container, ClientContext context) {
        return 1L;
    }

    @Override
    public long countSendableKeys(ObjectContainer container, ClientContext context) {
        return 1L;
    }

    @Override
    public SendableRequestItem chooseKey(KeysFetchingLocally fetching, ObjectContainer container, ClientContext context) {
        Key k;
        if (this.persistent) {
            container.activate((Object)this.key, 5);
        }
        if (fetching.hasKey(k = this.key.getNodeKey(false), this, this.persistent, container)) {
            return null;
        }
        long l = fetching.checkRecentlyFailed(k, this.realTimeFlag);
        long now = System.currentTimeMillis();
        if (l > 0L && l > now) {
            if (this.maxRetries == -1 || this.maxRetries >= 3) {
                if (logMINOR) {
                    Logger.minor(this, "RecentlyFailed -> cooldown until " + TimeUtil.formatTime(l - now) + " on " + this);
                }
                MyCooldownTrackerItem tracker = this.makeCooldownTrackerItem(container, context);
                tracker.cooldownWakeupTime = Math.max(tracker.cooldownWakeupTime, l);
                return null;
            }
            this.onFailure(new LowLevelGetException(10), null, container, context);
            return null;
        }
        return keys[0];
    }

    @Override
    public ClientKey getKey(Object token, ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.key, 5);
        }
        return this.key;
    }

    @Override
    public FetchContext getContext(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.ctx, 1);
        }
        return this.ctx;
    }

    @Override
    public boolean isSSK() {
        return this.key instanceof ClientSSK;
    }

    protected boolean retry(ObjectContainer container, ClientContext context) {
        if (this.isEmpty(container)) {
            if (logMINOR) {
                Logger.minor(this, "Not retrying because empty");
            }
            return false;
        }
        MyCooldownTrackerItem tracker = this.makeCooldownTrackerItem(container, context);
        int r = this.maxRetries == -1 ? ++tracker.retryCount : ++this.retryCount;
        if (logMINOR) {
            Logger.minor(this, "Attempting to retry... (max " + this.maxRetries + ", current " + r + ") on " + this + " finished=" + this.finished + " cancelled=" + this.cancelled);
        }
        if (r <= this.maxRetries || this.maxRetries == -1) {
            if (this.persistent && this.maxRetries != -1) {
                container.store((Object)this);
            }
            this.checkCachedCooldownData(container);
            if (this.cachedCooldownTries == 0 || r % this.cachedCooldownTries == 0) {
                long now = System.currentTimeMillis();
                if (tracker.cooldownWakeupTime > now) {
                    Logger.error(this, "Already on the cooldown queue for " + this + " until " + TimeUtil.formatTime(tracker.cooldownWakeupTime - now), (Throwable)new Exception("error"));
                } else {
                    if (logMINOR) {
                        Logger.minor(this, "Adding to cooldown queue " + this);
                    }
                    if (this.persistent) {
                        container.activate((Object)this.key, 5);
                    }
                    tracker.cooldownWakeupTime = now + this.cachedCooldownTime;
                    context.cooldownTracker.setCachedWakeup(tracker.cooldownWakeupTime, this, this.getParentGrabArray(), this.persistent, container, context, true);
                    if (logMINOR) {
                        Logger.minor(this, "Added single file fetcher into cooldown until " + TimeUtil.formatTime(tracker.cooldownWakeupTime - now));
                    }
                    if (this.persistent) {
                        container.deactivate((Object)this.key, 5);
                    }
                }
                this.onEnterFiniteCooldown(context);
            } else {
                this.clearCooldown(container, context, true);
            }
            return true;
        }
        this.unregister(container, context, this.getPriorityClass(container));
        return false;
    }

    private void checkCachedCooldownData(ObjectContainer container) {
        if (this.cachedCooldownTime != 0L || this.cachedCooldownTries != 0) {
            return;
        }
        this.innerCheckCachedCooldownData(container);
    }

    private void innerCheckCachedCooldownData(ObjectContainer container) {
        boolean active = true;
        if (this.persistent) {
            active = container.ext().isActive((Object)this.ctx);
            container.activate((Object)this.ctx, 1);
        }
        this.cachedCooldownTries = this.ctx.getCooldownRetries();
        this.cachedCooldownTime = this.ctx.getCooldownTime();
        if (!active) {
            container.deactivate((Object)this.ctx, 1);
        }
    }

    protected void onEnterFiniteCooldown(ClientContext context) {
    }

    private MyCooldownTrackerItem makeCooldownTrackerItem(ObjectContainer container, ClientContext context) {
        return (MyCooldownTrackerItem)context.cooldownTracker.make(this, this.persistent, container);
    }

    @Override
    public CooldownTrackerItem makeCooldownTrackerItem() {
        return new MyCooldownTrackerItem();
    }

    @Override
    public ClientRequester getClientRequest() {
        return this.parent;
    }

    @Override
    public short getPriorityClass(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        short retval = this.parent.getPriorityClass();
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ObjectContainer container, ClientContext context) {
        BaseSingleFileFetcher baseSingleFileFetcher = this;
        synchronized (baseSingleFileFetcher) {
            this.cancelled = true;
        }
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.key, 5);
        }
        this.unregisterAll(container, context);
    }

    public void unregisterAll(ObjectContainer container, ClientContext context) {
        this.getScheduler(container, context).removePendingKeys(this, false);
        this.unregister(container, context, (short)-1);
    }

    @Override
    public void unregister(ObjectContainer container, ClientContext context, short oldPrio) {
        context.cooldownTracker.remove(this, this.persistent, container);
        super.unregister(container, context, oldPrio);
    }

    @Override
    public synchronized boolean isCancelled(ObjectContainer container) {
        return this.cancelled;
    }

    public synchronized boolean isEmpty(ObjectContainer container) {
        return this.cancelled || this.finished;
    }

    @Override
    public RequestClient getClient(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        return this.parent.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGotKey(Key key, KeyBlock block, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate((Object)key, 5);
            container.activate((Object)this.key, 5);
        }
        BaseSingleFileFetcher baseSingleFileFetcher = this;
        synchronized (baseSingleFileFetcher) {
            if (this.finished) {
                if (logMINOR) {
                    Logger.minor(this, "onGotKey() called twice on " + this, (Throwable)new Exception("debug"));
                }
                return;
            }
            this.finished = true;
            if (this.persistent) {
                container.store((Object)this);
            }
            if (this.isCancelled(container)) {
                return;
            }
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.key == null) {
                throw new NullPointerException("Key is null on " + this);
            }
            if (!key.equals(this.key.getNodeKey(false))) {
                Logger.normal(this, "Got sent key " + key + " but want " + this.key + " for " + this);
                return;
            }
        }
        this.unregister(container, context, this.getPriorityClass(container));
        this.onSuccess(block, false, null, container, context);
        if (this.persistent) {
            container.deactivate((Object)this, 1);
            container.deactivate((Object)this.key, 1);
        }
    }

    public void onSuccess(KeyBlock lowLevelBlock, boolean fromStore, Object token, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.key, Integer.MAX_VALUE);
        }
        try {
            ClientKeyBlock block = Key.createKeyBlock(this.key, lowLevelBlock);
            this.onSuccess(block, fromStore, token, container, context);
        }
        catch (KeyVerifyException e) {
            this.onBlockDecodeError(token, container, context);
        }
    }

    protected abstract void onBlockDecodeError(Object var1, ObjectContainer var2, ClientContext var3);

    public abstract void onSuccess(ClientKeyBlock var1, boolean var2, Object var3, ObjectContainer var4, ClientContext var5);

    @Override
    public long getCooldownWakeup(Object token, ObjectContainer container, ClientContext context) {
        MyCooldownTrackerItem tracker = this.makeCooldownTrackerItem(container, context);
        return tracker.cooldownWakeupTime;
    }

    @Override
    public long getCooldownWakeupByKey(Key key, ObjectContainer container, ClientContext context) {
        MyCooldownTrackerItem tracker = this.makeCooldownTrackerItem(container, context);
        return tracker.cooldownWakeupTime;
    }

    @Override
    public void requeueAfterCooldown(Key key, long time, ObjectContainer container, ClientContext context) {
        MyCooldownTrackerItem tracker = this.makeCooldownTrackerItem(container, context);
        if (tracker.cooldownWakeupTime > time) {
            if (logMINOR) {
                Logger.minor(this, "Not requeueing as deadline has not passed yet");
            }
            return;
        }
        if (this.isEmpty(container)) {
            if (logMINOR) {
                Logger.minor(this, "Not requeueing as cancelled or finished");
            }
            return;
        }
        if (this.persistent) {
            container.activate((Object)this.key, 5);
        }
        if (!key.equals(this.key.getNodeKey(false))) {
            Logger.error(this, "Got requeueAfterCooldown for wrong key: " + key + " but mine is " + this.key.getNodeKey(false) + " for " + this.key);
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Requeueing after cooldown " + key + " for " + this);
        }
        this.reschedule(container, context);
        if (this.persistent) {
            container.deactivate((Object)this.key, 5);
        }
    }

    public void schedule(ObjectContainer container, ClientContext context) {
        if (this.key == null) {
            throw new NullPointerException();
        }
        if (this.persistent) {
            container.activate((Object)this.ctx, 1);
            if (this.ctx.blocks != null) {
                container.activate((Object)this.ctx.blocks, 5);
            }
        }
        try {
            this.getScheduler(container, context).register(this, new SendableGet[]{this}, this.persistent, container, this.ctx.blocks, false);
        }
        catch (KeyListenerConstructionException e) {
            Logger.error(this, "Impossible: " + e + " on " + this, (Throwable)e);
        }
    }

    public void reschedule(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.ctx, 1);
            if (this.ctx.blocks != null) {
                container.activate((Object)this.ctx.blocks, 5);
            }
        }
        try {
            this.getScheduler(container, context).register(null, new SendableGet[]{this}, this.persistent, container, this.ctx.blocks, true);
        }
        catch (KeyListenerConstructionException e) {
            Logger.error(this, "Impossible: " + e + " on " + this, (Throwable)e);
        }
    }

    public SendableGet getRequest(Key key, ObjectContainer container) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key[] listKeys(ObjectContainer container) {
        if (container != null && !this.persistent) {
            Logger.error(this, "listKeys() on " + this + " but persistent=false, stored is " + container.ext().isStored((Object)this) + " active is " + container.ext().isActive((Object)this));
        }
        BaseSingleFileFetcher baseSingleFileFetcher = this;
        synchronized (baseSingleFileFetcher) {
            if (this.cancelled || this.finished) {
                return new Key[0];
            }
        }
        if (this.persistent) {
            container.activate((Object)this.key, 5);
        }
        return new Key[]{this.key.getNodeKey(true)};
    }

    @Override
    public List<PersistentChosenBlock> makeBlocks(PersistentChosenRequest request, RequestScheduler sched, KeysFetchingLocally keysFetching, ObjectContainer container, ClientContext context) {
        ClientKey ckey;
        Key k;
        if (this.persistent) {
            container.activate((Object)this.key, 5);
        }
        if (keysFetching.hasKey(k = (ckey = this.key.cloneKey()).getNodeKey(true), this, this.persistent, container)) {
            return null;
        }
        long l = keysFetching.checkRecentlyFailed(k, this.realTimeFlag);
        long now = System.currentTimeMillis();
        if (l > 0L && l > now) {
            if (this.maxRetries == -1 || this.maxRetries >= 3) {
                if (logMINOR) {
                    Logger.minor(this, "RecentlyFailed -> cooldown until " + TimeUtil.formatTime(l - now) + " on " + this);
                }
                MyCooldownTrackerItem tracker = this.makeCooldownTrackerItem(container, context);
                tracker.cooldownWakeupTime = Math.max(tracker.cooldownWakeupTime, l);
                return null;
            }
            this.onFailure(new LowLevelGetException(10), null, container, context);
            return null;
        }
        PersistentChosenBlock block = new PersistentChosenBlock(false, request, keys[0], k, ckey, sched);
        return Collections.singletonList(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyListener makeKeyListener(ObjectContainer container, ClientContext context, boolean onStartup) {
        if (this.persistent) {
            container.activate((Object)this.key, 5);
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.ctx, 1);
        }
        BaseSingleFileFetcher baseSingleFileFetcher = this;
        synchronized (baseSingleFileFetcher) {
            if (this.finished) {
                return null;
            }
            if (this.cancelled) {
                return null;
            }
        }
        if (this.key == null) {
            Logger.error(this, "Key is null - left over BSSF? on " + this + " in makeKeyListener()", (Throwable)new Exception("error"));
            if (this.persistent) {
                container.delete((Object)this);
            }
            return null;
        }
        Key newKey = this.key.getNodeKey(true);
        if (this.parent == null) {
            Logger.error(this, "Parent is null on " + this + " persistent=" + this.persistent + " key=" + this.key + " ctx=" + this.ctx);
            if (container != null) {
                Logger.error(this, "Stored = " + container.ext().isStored((Object)this) + " active = " + container.ext().isActive((Object)this));
            }
            return null;
        }
        short prio = this.parent.getPriorityClass();
        SingleKeyListener ret = new SingleKeyListener(newKey, this, prio, this.persistent, this.realTimeFlag);
        if (this.persistent) {
            container.deactivate((Object)this.key, 5);
            container.deactivate((Object)this.parent, 1);
            container.deactivate((Object)this.ctx, 1);
        }
        return ret;
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        super.removeFrom(container, context);
        if (this.deleteFetchContext) {
            container.activate((Object)this.ctx, 1);
            this.ctx.removeFrom(container);
        }
        container.activate((Object)this.key, 5);
        this.key.removeFrom(container);
    }

    protected abstract void notFoundInStore(ObjectContainer var1, ClientContext var2);

    @Override
    public boolean preRegister(ObjectContainer container, ClientContext context, boolean toNetwork) {
        if (!toNetwork) {
            return false;
        }
        boolean deactivate = false;
        if (this.persistent) {
            deactivate = !container.ext().isActive((Object)this.ctx);
            container.activate((Object)this.ctx, 1);
        }
        boolean localOnly = this.ctx.localRequestOnly;
        if (deactivate) {
            container.deactivate((Object)this.ctx, 1);
        }
        if (localOnly) {
            this.notFoundInStore(container, context);
            return true;
        }
        deactivate = false;
        if (this.persistent) {
            deactivate = !container.ext().isActive((Object)this.parent);
            container.activate((Object)this.parent, 1);
        }
        this.parent.toNetwork(container, context);
        if (deactivate) {
            container.deactivate((Object)this.parent, 1);
        }
        return false;
    }

    @Override
    public synchronized long getCooldownTime(ObjectContainer container, ClientContext context, long now) {
        if (this.cancelled || this.finished) {
            return -1L;
        }
        MyCooldownTrackerItem tracker = this.makeCooldownTrackerItem(container, context);
        long wakeTime = tracker.cooldownWakeupTime;
        if (wakeTime <= now) {
            wakeTime = 0L;
            tracker.cooldownWakeupTime = 0L;
        }
        KeysFetchingLocally fetching = this.getScheduler(container, context).fetchingKeys();
        if (wakeTime <= 0L && fetching.hasKey(this.getNodeKey(null, container), this, this.cancelled, container)) {
            wakeTime = Long.MAX_VALUE;
        }
        if (wakeTime == 0L) {
            return 0L;
        }
        RandomGrabArray parentRGA = this.getParentGrabArray();
        context.cooldownTracker.setCachedWakeup(wakeTime, this, parentRGA, this.persistent, container, context, true);
        return wakeTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangedFetchContext(ObjectContainer container, ClientContext context) {
        BaseSingleFileFetcher baseSingleFileFetcher = this;
        synchronized (baseSingleFileFetcher) {
            if (this.cancelled || this.finished) {
                return;
            }
        }
        this.innerCheckCachedCooldownData(container);
    }

    static {
        Logger.registerClass(BaseSingleFileFetcher.class);
    }

    public static class MyCooldownTrackerItem
    implements CooldownTrackerItem {
        public int retryCount;
        public long cooldownWakeupTime;
    }
}

