/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveManager;
import freenet.client.FECQueue;
import freenet.client.FetchException;
import freenet.client.InsertException;
import freenet.client.async.BackgroundBlockEncoder;
import freenet.client.async.BaseManifestPutter;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientPutter;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.CooldownTracker;
import freenet.client.async.DBJob;
import freenet.client.async.DBJobRunner;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.DatastoreChecker;
import freenet.client.async.DownloadCache;
import freenet.client.async.HealingQueue;
import freenet.client.async.SimpleManifestPutter;
import freenet.client.async.USKManager;
import freenet.client.filter.LinkFilterExceptionProvider;
import freenet.crypt.RandomSource;
import freenet.node.RequestScheduler;
import freenet.node.RequestStarterGroup;
import freenet.node.useralerts.UserAlert;
import freenet.node.useralerts.UserAlertManager;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.api.BucketFactory;
import freenet.support.compress.RealCompressor;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.NativeThread;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.PersistentTempBucketFactory;
import java.util.Random;

public class ClientContext {
    public transient FECQueue fecQueue;
    private transient ClientRequestScheduler sskFetchSchedulerBulk;
    private transient ClientRequestScheduler chkFetchSchedulerBulk;
    private transient ClientRequestScheduler sskInsertSchedulerBulk;
    private transient ClientRequestScheduler chkInsertSchedulerBulk;
    private transient ClientRequestScheduler sskFetchSchedulerRT;
    private transient ClientRequestScheduler chkFetchSchedulerRT;
    private transient ClientRequestScheduler sskInsertSchedulerRT;
    private transient ClientRequestScheduler chkInsertSchedulerRT;
    private transient UserAlertManager alerts;
    public final transient DBJobRunner jobRunner;
    public final transient Executor mainExecutor;
    public final transient long nodeDBHandle;
    public final transient BackgroundBlockEncoder backgroundBlockEncoder;
    public final transient RandomSource random;
    public final transient ArchiveManager archiveManager;
    public transient PersistentTempBucketFactory persistentBucketFactory;
    public transient PersistentFileTracker persistentFileTracker;
    public final transient BucketFactory tempBucketFactory;
    public final transient HealingQueue healingQueue;
    public final transient USKManager uskManager;
    public final transient Random fastWeakRandom;
    public final transient long bootID;
    public final transient Ticker ticker;
    public final transient FilenameGenerator fg;
    public transient FilenameGenerator persistentFG;
    public final transient RealCompressor rc;
    public final transient DatastoreChecker checker;
    public final transient CooldownTracker cooldownTracker;
    public transient DownloadCache downloadCache;
    public final transient LinkFilterExceptionProvider linkFilterExceptionProvider;

    public ClientContext(long bootID, long nodeDBHandle, DBJobRunner jobRunner, FECQueue fecQueue, Executor mainExecutor, BackgroundBlockEncoder blockEncoder, ArchiveManager archiveManager, PersistentTempBucketFactory ptbf, BucketFactory tbf, PersistentFileTracker tracker, HealingQueue hq, USKManager uskManager, RandomSource strongRandom, Random fastWeakRandom, Ticker ticker, FilenameGenerator fg, FilenameGenerator persistentFG, RealCompressor rc, DatastoreChecker checker, LinkFilterExceptionProvider linkFilterExceptionProvider) {
        this.bootID = bootID;
        this.fecQueue = fecQueue;
        this.jobRunner = jobRunner;
        this.mainExecutor = mainExecutor;
        this.nodeDBHandle = nodeDBHandle;
        this.backgroundBlockEncoder = blockEncoder;
        this.random = strongRandom;
        this.archiveManager = archiveManager;
        this.persistentBucketFactory = ptbf;
        this.tempBucketFactory = tbf;
        this.healingQueue = hq;
        this.uskManager = uskManager;
        this.fastWeakRandom = fastWeakRandom;
        this.ticker = ticker;
        this.fg = fg;
        this.persistentFG = persistentFG;
        this.rc = rc;
        this.checker = checker;
        this.linkFilterExceptionProvider = linkFilterExceptionProvider;
        this.cooldownTracker = new CooldownTracker();
    }

    public void init(RequestStarterGroup starters, UserAlertManager alerts) {
        this.sskFetchSchedulerBulk = starters.sskFetchSchedulerBulk;
        this.chkFetchSchedulerBulk = starters.chkFetchSchedulerBulk;
        this.sskInsertSchedulerBulk = starters.sskPutSchedulerBulk;
        this.chkInsertSchedulerBulk = starters.chkPutSchedulerBulk;
        this.sskFetchSchedulerRT = starters.sskFetchSchedulerRT;
        this.chkFetchSchedulerRT = starters.chkFetchSchedulerRT;
        this.sskInsertSchedulerRT = starters.sskPutSchedulerRT;
        this.chkInsertSchedulerRT = starters.chkPutSchedulerRT;
        this.alerts = alerts;
        this.cooldownTracker.startMaintenance(this.ticker);
    }

    public ClientRequestScheduler getSskFetchScheduler(boolean realTime) {
        return realTime ? this.sskFetchSchedulerRT : this.sskFetchSchedulerBulk;
    }

    public ClientRequestScheduler getChkFetchScheduler(boolean realTime) {
        return realTime ? this.chkFetchSchedulerRT : this.chkFetchSchedulerBulk;
    }

    public ClientRequestScheduler getSskInsertScheduler(boolean realTime) {
        return realTime ? this.sskInsertSchedulerRT : this.sskInsertSchedulerBulk;
    }

    public ClientRequestScheduler getChkInsertScheduler(boolean realTime) {
        return realTime ? this.chkInsertSchedulerRT : this.chkInsertSchedulerBulk;
    }

    public void start(final ClientPutter inserter, final boolean earlyEncode) throws InsertException, DatabaseDisabledException {
        if (inserter.persistent()) {
            this.jobRunner.queue(new DBJob(){

                @Override
                public boolean run(ObjectContainer container, ClientContext context) {
                    container.activate((Object)inserter, 1);
                    try {
                        inserter.start(earlyEncode, false, container, context);
                    }
                    catch (InsertException e) {
                        inserter.client.onFailure(e, inserter, container);
                    }
                    container.deactivate((Object)inserter, 1);
                    return true;
                }
            }, NativeThread.NORM_PRIORITY, false);
        } else {
            inserter.start(earlyEncode, false, null, this);
        }
    }

    public void start(final ClientGetter getter) throws FetchException, DatabaseDisabledException {
        if (getter.persistent()) {
            this.jobRunner.queue(new DBJob(){

                @Override
                public boolean run(ObjectContainer container, ClientContext context) {
                    container.activate((Object)getter, 1);
                    try {
                        getter.start(container, context);
                    }
                    catch (FetchException e) {
                        getter.clientCallback.onFailure(e, getter, container);
                    }
                    container.deactivate((Object)getter, 1);
                    return true;
                }
            }, NativeThread.NORM_PRIORITY, false);
        } else {
            getter.start(null, this);
        }
    }

    public void start(final SimpleManifestPutter inserter) throws InsertException, DatabaseDisabledException {
        if (inserter.persistent()) {
            this.jobRunner.queue(new DBJob(){

                @Override
                public boolean run(ObjectContainer container, ClientContext context) {
                    container.activate((Object)inserter, 1);
                    try {
                        inserter.start(container, context);
                    }
                    catch (InsertException e) {
                        inserter.cb.onFailure(e, inserter, container);
                    }
                    container.deactivate((Object)inserter, 1);
                    return true;
                }
            }, NativeThread.NORM_PRIORITY, false);
        } else {
            inserter.start(null, this);
        }
    }

    public void start(final BaseManifestPutter inserter) throws InsertException, DatabaseDisabledException {
        if (inserter.persistent()) {
            this.jobRunner.queue(new DBJob(){

                @Override
                public boolean run(ObjectContainer container, ClientContext context) {
                    container.activate((Object)inserter, 1);
                    try {
                        inserter.start(container, context);
                    }
                    catch (InsertException e) {
                        inserter.cb.onFailure(e, inserter, container);
                    }
                    container.deactivate((Object)inserter, 1);
                    return true;
                }
            }, NativeThread.NORM_PRIORITY, false);
        } else {
            inserter.start(null, this);
        }
    }

    public BucketFactory getBucketFactory(boolean persistent) {
        if (persistent) {
            return this.persistentBucketFactory;
        }
        return this.tempBucketFactory;
    }

    public RequestScheduler getFetchScheduler(boolean ssk, boolean realTime) {
        if (ssk) {
            return realTime ? this.sskFetchSchedulerRT : this.sskFetchSchedulerBulk;
        }
        return realTime ? this.chkFetchSchedulerRT : this.chkFetchSchedulerBulk;
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing ClientContext in database", (Throwable)new Exception("error"));
        return false;
    }

    public void setFECQueue(FECQueue fecQueue2) {
        this.fecQueue = fecQueue2;
    }

    public void setPersistentBucketFactory(PersistentTempBucketFactory persistentTempBucketFactory, FilenameGenerator persistentFilenameGenerator) {
        this.persistentBucketFactory = persistentTempBucketFactory;
        this.persistentFG = persistentFilenameGenerator;
    }

    public void postUserAlert(final UserAlert alert) {
        if (this.alerts == null) {
            this.ticker.queueTimedJob(new Runnable(){

                @Override
                public void run() {
                    ClientContext.this.alerts.register(alert);
                }
            }, "Post alert", 0L, false, false);
        } else {
            this.alerts.register(alert);
        }
    }

    public void setDownloadCache(DownloadCache cache) {
        this.downloadCache = cache;
    }
}

