/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequester;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.crypt.RandomSource;
import freenet.crypt.SHA256;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeSSK;
import freenet.node.BaseSendableGet;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.node.SendableInsert;
import freenet.node.SendableRequest;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.RandomGrabArray;
import freenet.support.SectoredRandomGrabArray;
import freenet.support.SectoredRandomGrabArrayWithObject;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;

abstract class ClientRequestSchedulerBase {
    private static volatile boolean logMINOR;
    private static final int MIN_RETRY_COUNT = 3;
    final boolean isInsertScheduler;
    final boolean isSSKScheduler;
    final boolean isRTScheduler;
    protected SectoredRandomGrabArray[] newPriorities;
    protected transient ClientRequestScheduler sched;
    protected transient ArrayList<KeyListener> keyListeners;
    public byte[] globalSalt;

    abstract boolean persistent();

    protected ClientRequestSchedulerBase(boolean forInserts, boolean forSSKs, boolean forRT, RandomSource random) {
        this.isInsertScheduler = forInserts;
        this.isSSKScheduler = forSSKs;
        this.isRTScheduler = forRT;
        this.keyListeners = new ArrayList();
        this.newPriorities = new SectoredRandomGrabArray[7];
        this.globalSalt = new byte[32];
        random.nextBytes(this.globalSalt);
    }

    void innerRegister(SendableRequest req, ObjectContainer container, ClientContext context, SendableRequest[] maybeActive) {
        if (this.isInsertScheduler && req instanceof BaseSendableGet) {
            throw new IllegalArgumentException("Adding a SendableGet to an insert scheduler!!");
        }
        if (!this.isInsertScheduler && req instanceof SendableInsert) {
            throw new IllegalArgumentException("Adding a SendableInsert to a request scheduler!!");
        }
        if (this.isInsertScheduler != req.isInsert()) {
            throw new IllegalArgumentException("Request isInsert=" + req.isInsert() + " but my isInsertScheduler=" + this.isInsertScheduler + "!!");
        }
        if (req.persistent() != this.persistent()) {
            throw new IllegalArgumentException("innerRegister for persistence=" + req.persistent() + " but our persistence is " + this.persistent());
        }
        short prio = req.getPriorityClass(container);
        if (logMINOR) {
            Logger.minor(this, "Still registering " + req + " at prio " + prio + " for " + req.getClientRequest() + " ssk=" + this.isSSKScheduler + " insert=" + this.isInsertScheduler);
        }
        this.addToRequestsByClientRequest(req.getClientRequest(), req, container);
        this.addToGrabArray(prio, req.getClient(container), req.getClientRequest(), req, container, context);
        if (logMINOR) {
            Logger.minor(this, "Registered " + req + " on prioclass=" + prio);
        }
        if (this.persistent()) {
            this.sched.maybeAddToStarterQueue(req, container, maybeActive);
        }
    }

    protected void addToRequestsByClientRequest(ClientRequester clientRequest, SendableRequest req, ObjectContainer container) {
        if (clientRequest != null || this.persistent()) {
            boolean deactivate = false;
            if (this.persistent()) {
                boolean bl = deactivate = !container.ext().isActive((Object)clientRequest);
                if (deactivate) {
                    container.activate((Object)clientRequest, 1);
                }
            }
            clientRequest.addToRequests(req, container);
            if (deactivate) {
                container.deactivate((Object)clientRequest, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToGrabArray(short priorityClass, RequestClient client, ClientRequester cr, SendableRequest req, ObjectContainer container, ClientContext context) {
        if (priorityClass > 6 || priorityClass < 0) {
            throw new IllegalStateException("Invalid priority: " + priorityClass + " - range is " + 0 + " (most important) to " + 6 + " (least important)");
        }
        ClientRequestSchedulerBase clientRequestSchedulerBase = this;
        synchronized (clientRequestSchedulerBase) {
            SectoredRandomGrabArray clientGrabber = this.newPriorities[priorityClass];
            if (this.persistent()) {
                container.activate((Object)clientGrabber, 1);
            }
            if (clientGrabber == null) {
                this.newPriorities[priorityClass] = clientGrabber = new SectoredRandomGrabArray(this.persistent(), container, null);
                if (this.persistent()) {
                    container.store((Object)this);
                }
                if (logMINOR) {
                    Logger.minor(this, "Registering client tracker for priority " + priorityClass + " : " + clientGrabber);
                }
            }
            SectoredRandomGrabArray sectoredRandomGrabArray = clientGrabber;
            synchronized (sectoredRandomGrabArray) {
                SectoredRandomGrabArrayWithObject requestGrabber = (SectoredRandomGrabArrayWithObject)clientGrabber.getGrabber(client);
                if (this.persistent()) {
                    container.activate((Object)requestGrabber, 1);
                }
                if (requestGrabber == null) {
                    requestGrabber = new SectoredRandomGrabArrayWithObject(client, this.persistent(), container, clientGrabber);
                    if (logMINOR) {
                        Logger.minor(this, "Creating new grabber: " + requestGrabber + " for " + client + " from " + clientGrabber + " : prio=" + priorityClass);
                    }
                    clientGrabber.addGrabber(client, requestGrabber, container, context);
                    context.cooldownTracker.clearCachedWakeup(clientGrabber, this.persistent(), container);
                }
                requestGrabber.add(cr, req, container, context);
            }
        }
        this.sched.wakeStarter();
    }

    protected static int fixRetryCount(int retryCount) {
        return Math.max(0, retryCount - 3);
    }

    protected SendableRequest[] getSendableRequests(ClientRequester request, ObjectContainer container) {
        if (request != null || this.persistent()) {
            return request.getSendableRequests(container);
        }
        return null;
    }

    void removeFromAllRequestsByClientRequest(SendableRequest req, ClientRequester cr, boolean dontComplain, ObjectContainer container) {
        if (cr != null || this.persistent()) {
            cr.removeFromRequests(req, container, dontComplain);
        }
    }

    public void reregisterAll(ClientRequester request, RequestScheduler lock, ObjectContainer container, ClientContext context, short oldPrio) {
        if (request.persistent() != this.persistent()) {
            return;
        }
        SendableRequest[] reqs = this.getSendableRequests(request, container);
        if (reqs == null) {
            return;
        }
        for (int i = 0; i < reqs.length; ++i) {
            boolean isInsert;
            SendableRequest req = reqs[i];
            if (req == null) {
                Logger.error(this, "Request " + i + " is null reregistering for " + request);
                continue;
            }
            if (this.persistent()) {
                container.activate((Object)req, 1);
            }
            if ((isInsert = req.isInsert()) != this.isInsertScheduler || req.isSSK() != this.isSSKScheduler) {
                if (!this.persistent()) continue;
                container.deactivate((Object)req, 1);
                continue;
            }
            if (this.persistent() && req.isStorageBroken(container)) {
                Logger.error(this, "Broken request while changing priority: " + req);
                continue;
            }
            if (req.persistent() != this.persistent()) {
                Logger.error(this, "Request persistence is " + req.persistent() + " but scheduler's is " + this.persistent() + " on " + this + " for " + req);
                continue;
            }
            req.unregister(container, context, oldPrio);
            if (this.persistent()) {
                this.sched.removeFromStarterQueue(req, container, true);
            }
            if (this.persistent()) {
                container.activate((Object)req, 1);
            }
            this.innerRegister(req, container, context, null);
            if (!this.persistent()) continue;
            container.deactivate((Object)req, 1);
        }
    }

    public void succeeded(BaseSendableGet succeeded, ObjectContainer container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingKeys(KeyListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ClientRequestSchedulerBase clientRequestSchedulerBase = this;
        synchronized (clientRequestSchedulerBase) {
            if (this.keyListeners.contains(listener)) {
                return;
            }
            this.keyListeners.add(listener);
        }
        if (logMINOR) {
            Logger.minor(this, "Added pending keys to " + this + " : size now " + this.keyListeners.size() + " : " + listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePendingKeys(KeyListener listener) {
        boolean ret;
        ClientRequestSchedulerBase clientRequestSchedulerBase = this;
        synchronized (clientRequestSchedulerBase) {
            ret = this.keyListeners.remove(listener);
            while (logMINOR && this.keyListeners.remove(listener)) {
                Logger.error(this, "Still in pending keys after removal, must be in twice or more: " + listener, (Throwable)new Exception("error"));
            }
            listener.onRemove();
        }
        if (logMINOR) {
            Logger.minor(this, "Removed pending keys from " + this + " : size now " + this.keyListeners.size() + " : " + listener, (Throwable)new Exception("debug"));
        }
        return ret;
    }

    public synchronized boolean removePendingKeys(HasKeyListener hasListener) {
        boolean found = false;
        Iterator<KeyListener> i = this.keyListeners.iterator();
        while (i.hasNext()) {
            KeyListener listener = i.next();
            if (listener == null) {
                i.remove();
                Logger.error(this, "Null KeyListener in removePendingKeys()");
                continue;
            }
            if (listener.getHasKeyListener() != hasListener) continue;
            found = true;
            i.remove();
            listener.onRemove();
            Logger.normal(this, "Removed pending keys from " + this + " : size now " + this.keyListeners.size() + " : " + listener);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getKeyPrio(Key key, short priority, ObjectContainer container, ClientContext context) {
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        ArrayList<KeyListener> matches = null;
        ClientRequestSchedulerBase clientRequestSchedulerBase = this;
        synchronized (clientRequestSchedulerBase) {
            for (KeyListener listener : this.keyListeners) {
                if (!listener.probablyWantKey(key, saltedKey)) continue;
                if (matches == null) {
                    matches = new ArrayList<KeyListener>();
                }
                matches.add(listener);
            }
        }
        if (matches == null) {
            return priority;
        }
        for (KeyListener listener : matches) {
            short prio = listener.definitelyWantKey(key, saltedKey, container, this.sched.clientContext);
            if (prio == -1 || prio >= priority) continue;
            priority = prio;
        }
        return priority;
    }

    public synchronized long countWaitingKeys(ObjectContainer container) {
        long count = 0L;
        for (KeyListener listener : this.keyListeners) {
            count += listener.countKeys();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anyWantKey(Key key, ObjectContainer container, ClientContext context) {
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        ArrayList<KeyListener> matches = null;
        ClientRequestSchedulerBase clientRequestSchedulerBase = this;
        synchronized (clientRequestSchedulerBase) {
            for (KeyListener listener : this.keyListeners) {
                if (!listener.probablyWantKey(key, saltedKey)) continue;
                if (matches == null) {
                    matches = new ArrayList<KeyListener>();
                }
                matches.add(listener);
            }
        }
        if (matches != null) {
            for (KeyListener listener : matches) {
                if (listener.definitelyWantKey(key, saltedKey, container, this.sched.clientContext) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean anyProbablyWantKey(Key key, ClientContext context) {
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        for (KeyListener listener : this.keyListeners) {
            if (!listener.probablyWantKey(key, saltedKey)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tripPendingKey(Key key, KeyBlock block, ObjectContainer container, ClientContext context) {
        if (key instanceof NodeSSK != this.isSSKScheduler) {
            Logger.error(this, "Key " + key + " on scheduler ssk=" + this.isSSKScheduler, (Throwable)new Exception("debug"));
            return false;
        }
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        ArrayList<KeyListener> matches = null;
        ClientRequestSchedulerBase clientRequestSchedulerBase = this;
        synchronized (clientRequestSchedulerBase) {
            for (KeyListener listener : this.keyListeners) {
                if (!listener.probablyWantKey(key, saltedKey)) continue;
                if (matches == null) {
                    matches = new ArrayList<KeyListener>();
                }
                if (matches.contains(listener)) {
                    Logger.error(this, "In matches twice, presumably in keyListeners twice?: " + listener);
                    continue;
                }
                matches.add(listener);
            }
        }
        boolean ret = false;
        if (matches != null) {
            for (KeyListener listener : matches) {
                try {
                    if (listener.handleBlock(key, saltedKey, block, container, context)) {
                        ret = true;
                    }
                }
                catch (Throwable t) {
                    Logger.error(this, String.format("Error in handleBlock callback for %s", listener), t);
                }
                if (!listener.isEmpty()) continue;
                ClientRequestSchedulerBase clientRequestSchedulerBase2 = this;
                synchronized (clientRequestSchedulerBase2) {
                    this.keyListeners.remove(listener);
                }
                listener.onRemove();
            }
        } else {
            return false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendableGet[] requestsForKey(Key key, ObjectContainer container, ClientContext context) {
        ArrayList<SendableGet> list = null;
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        ClientRequestSchedulerBase clientRequestSchedulerBase = this;
        synchronized (clientRequestSchedulerBase) {
            for (KeyListener listener : this.keyListeners) {
                SendableGet[] reqs;
                if (!listener.probablyWantKey(key, saltedKey) || (reqs = listener.getRequestsForKey(key, saltedKey, container, context)) == null) continue;
                if (list == null) {
                    list = new ArrayList<SendableGet>();
                }
                for (SendableGet req : reqs) {
                    list.add(req);
                }
            }
        }
        if (list == null) {
            return null;
        }
        return list.toArray(new SendableGet[list.size()]);
    }

    public void onStarted(ObjectContainer container, ClientContext context) {
        this.keyListeners = new ArrayList();
        if (this.newPriorities == null) {
            this.newPriorities = new SectoredRandomGrabArray[7];
            if (this.persistent()) {
                container.store((Object)this);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(':');
        if (this.isInsertScheduler) {
            sb.append("insert:");
        }
        if (this.isSSKScheduler) {
            sb.append("SSK");
        } else {
            sb.append("CHK");
        }
        return sb.toString();
    }

    public synchronized long countQueuedRequests(ObjectContainer container, ClientContext context) {
        long total = 0L;
        for (int i = 0; i < this.newPriorities.length; ++i) {
            SectoredRandomGrabArray prio = this.newPriorities[i];
            container.activate((Object)prio, 1);
            if (prio == null || prio.isEmpty(container)) {
                System.out.println("Priority " + i + " : empty");
                continue;
            }
            System.out.println("Priority " + i + " : " + prio.size());
            System.out.println("Clients: " + prio.size() + " for " + prio);
            for (int k = 0; k < prio.size(); ++k) {
                Object client = prio.getClient(k);
                container.activate(client, 1);
                System.out.println("Client " + k + " : " + client);
                container.deactivate(client, 1);
                SectoredRandomGrabArrayWithObject requestGrabber = (SectoredRandomGrabArrayWithObject)prio.getGrabber(client);
                container.activate((Object)requestGrabber, 1);
                System.out.println("SRGA for client: " + requestGrabber);
                for (int l = 0; l < requestGrabber.size(); ++l) {
                    client = requestGrabber.getClient(l);
                    container.activate(client, 1);
                    System.out.println("Request " + l + " : " + client);
                    container.deactivate(client, 1);
                    RandomGrabArray rga = (RandomGrabArray)((Object)requestGrabber.getGrabber(client));
                    container.activate((Object)rga, 1);
                    System.out.println("Queued SendableRequests: " + rga.size() + " on " + rga);
                    long sendable = 0L;
                    long all = 0L;
                    for (int m = 0; m < rga.size(); ++m) {
                        SendableRequest req = (SendableRequest)rga.get(m, container);
                        if (req == null) continue;
                        container.activate((Object)req, 1);
                        sendable += req.countSendableKeys(container, context);
                        all += req.countAllKeys(container, context);
                        container.deactivate((Object)req, 1);
                    }
                    System.out.println("Sendable keys: " + sendable + " all keys " + all + " diff " + (all - sendable));
                    total += all;
                    container.deactivate((Object)rga, 1);
                }
                container.deactivate((Object)requestGrabber, 1);
            }
            container.deactivate((Object)prio, 1);
        }
        return total;
    }

    public byte[] saltKey(Key key) {
        MessageDigest md = SHA256.getMessageDigest();
        md.update(key.getRoutingKey());
        md.update(this.globalSalt);
        byte[] ret = md.digest();
        SHA256.returnMessageDigest(md);
        return ret;
    }

    protected void hintGlobalSalt(byte[] globalSalt2) {
        if (this.globalSalt == null) {
            this.globalSalt = globalSalt2;
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

