/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequestSchedulerCore;
import freenet.client.async.ClientRequestSchedulerNonPersistent;
import freenet.client.async.CooldownTracker;
import freenet.client.async.OfferedKeysList;
import freenet.client.async.TransientChosenBlock;
import freenet.crypt.RandomSource;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.node.BaseSendableGet;
import freenet.node.KeysFetchingLocally;
import freenet.node.Node;
import freenet.node.RequestStarter;
import freenet.node.SendableGet;
import freenet.node.SendableInsert;
import freenet.node.SendableRequest;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestItemKey;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.RandomGrabArray;
import freenet.support.RandomGrabArrayItem;
import freenet.support.RemoveRandom;
import freenet.support.SectoredRandomGrabArray;
import freenet.support.SectoredRandomGrabArrayWithObject;
import freenet.support.TimeUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;

class ClientRequestSelector
implements KeysFetchingLocally {
    final boolean isInsertScheduler;
    final ClientRequestScheduler sched;
    private static volatile boolean logMINOR;
    private transient HashSet<Key> keysFetching;
    private transient HashMap<Key, Long[]> persistentRequestsWaitingForKeysFetching;
    private transient HashMap<Key, WeakReference<BaseSendableGet>[]> transientRequestsWaitingForKeysFetching;
    private final transient HashSet<RunningTransientInsert> runningTransientInserts;
    private final transient Deque<RandomGrabArray> recentSuccesses;
    private static final short[] tweakedPrioritySelector;
    private static final short[] prioritySelector;

    ClientRequestSelector(boolean isInsertScheduler, ClientRequestScheduler sched) {
        this.sched = sched;
        this.isInsertScheduler = isInsertScheduler;
        if (!isInsertScheduler) {
            this.keysFetching = new HashSet();
            this.persistentRequestsWaitingForKeysFetching = new HashMap();
            this.transientRequestsWaitingForKeysFetching = new HashMap();
            this.runningTransientInserts = null;
            this.recentSuccesses = new ArrayDeque<RandomGrabArray>();
        } else {
            this.keysFetching = null;
            this.runningTransientInserts = new HashSet();
            this.recentSuccesses = null;
        }
    }

    private long removeFirstAccordingToPriorities(int fuzz, RandomSource random, ClientRequestSchedulerCore schedCore, ClientRequestSchedulerNonPersistent schedTransient, boolean transientOnly, short maxPrio, ObjectContainer container, ClientContext context, long now) {
        SectoredRandomGrabArray result = null;
        long wakeupTime = Long.MAX_VALUE;
        int iteration = 0;
        while (true) {
            long cooldownTime;
            short priority;
            int n = iteration;
            iteration = (short)(iteration + 1);
            if (n >= 8) break;
            boolean persistent = false;
            short s = priority = fuzz < 0 ? tweakedPrioritySelector[random.nextInt(tweakedPrioritySelector.length)] : prioritySelector[Math.abs(fuzz % prioritySelector.length)];
            if (transientOnly || schedCore == null) {
                result = null;
            } else {
                result = schedCore.newPriorities[priority];
                if (result != null) {
                    cooldownTime = context.cooldownTracker.getCachedWakeup(result, true, container, now);
                    if (cooldownTime > 0L) {
                        if (cooldownTime < wakeupTime) {
                            wakeupTime = cooldownTime;
                        }
                        if (logMINOR) {
                            if (cooldownTime == Long.MAX_VALUE) {
                                Logger.minor(this, "Priority " + priority + " (persistent) is waiting until a request finishes or is empty");
                            } else {
                                Logger.minor(this, "Priority " + priority + " (persistent) is in cooldown for another " + (cooldownTime - now) + " " + TimeUtil.formatTime(cooldownTime - now));
                            }
                        }
                        result = null;
                    } else {
                        container.activate((Object)result, 1);
                        persistent = true;
                    }
                }
            }
            if (result == null && (result = schedTransient.newPriorities[priority]) != null && (cooldownTime = context.cooldownTracker.getCachedWakeup(result, false, container, now)) > 0L) {
                if (cooldownTime < wakeupTime) {
                    wakeupTime = cooldownTime;
                }
                if (logMINOR) {
                    if (cooldownTime == Long.MAX_VALUE) {
                        Logger.minor(this, "Priority " + priority + " (transient) is waiting until a request finishes or is empty");
                    } else {
                        Logger.minor(this, "Priority " + priority + " (transient) is in cooldown for another " + (cooldownTime - now) + " " + TimeUtil.formatTime(cooldownTime - now));
                    }
                }
                result = null;
            }
            if (priority > maxPrio) {
                ++fuzz;
                continue;
            }
            if (result != null && !result.isEmpty((ObjectContainer)(persistent ? container : null))) {
                if (logMINOR) {
                    Logger.minor(this, "using priority : " + priority);
                }
                return priority;
            }
            if (logMINOR) {
                Logger.minor(this, "Priority " + priority + " is null (fuzz = " + fuzz + ')');
            }
            ++fuzz;
        }
        return wakeupTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChosenBlock removeFirstTransient(int fuzz, RandomSource random, OfferedKeysList offeredKeys, RequestStarter starter, ClientRequestSchedulerNonPersistent schedTransient, short maxPrio, boolean realTime, ClientContext context, ObjectContainer container) {
        long now = System.currentTimeMillis();
        for (int i = 0; i < 5; ++i) {
            SelectorReturn r;
            ClientRequestScheduler clientRequestScheduler = this.sched;
            synchronized (clientRequestScheduler) {
                r = this.removeFirstInner(fuzz, random, offeredKeys, starter, null, schedTransient, true, false, maxPrio, realTime, context, container, now);
            }
            SendableRequest req = null;
            if (r != null && r.req != null) {
                req = r.req;
            }
            if (req == null) continue;
            if (this.isInsertScheduler && req instanceof SendableGet) {
                IllegalStateException e = new IllegalStateException("removeFirstInner returned a SendableGet on an insert scheduler!!");
                req.internalError(e, this.sched, container, context, req.persistent());
                throw e;
            }
            ChosenBlock block = this.maybeMakeChosenRequest(req, container, context, now);
            if (block == null) continue;
            return block;
        }
        return null;
    }

    public ChosenBlock maybeMakeChosenRequest(SendableRequest req, ObjectContainer container, ClientContext context, long now) {
        boolean forkOnCacheable;
        boolean realTimeFlag;
        boolean canWriteClientCache;
        boolean ignoreStore;
        boolean localRequestOnly;
        ClientKey ckey;
        Key key;
        if (req == null) {
            return null;
        }
        if (req.isCancelled(container)) {
            if (logMINOR) {
                Logger.minor(this, "Request is cancelled: " + req);
            }
            return null;
        }
        if (req.getCooldownTime(container, context, now) != 0L) {
            if (logMINOR) {
                Logger.minor(this, "Request is in cooldown: " + req);
            }
            return null;
        }
        SendableRequestItem token = req.chooseKey(this, (ObjectContainer)(req.persistent() ? container : null), context);
        if (token == null) {
            if (logMINOR) {
                Logger.minor(this, "Choose key returned null: " + req);
            }
            return null;
        }
        if (this.isInsertScheduler) {
            key = null;
            ckey = null;
        } else {
            key = ((BaseSendableGet)req).getNodeKey(token, null);
            ckey = req instanceof SendableGet ? ((SendableGet)req).getKey(token, null) : null;
        }
        assert (!req.persistent());
        if (key != null && key.getRoutingKey() == null) {
            throw new NullPointerException();
        }
        if (req instanceof SendableGet) {
            SendableGet sg = (SendableGet)req;
            FetchContext ctx = sg.getContext(container);
            localRequestOnly = ctx.localRequestOnly;
            ignoreStore = ctx.ignoreStore;
            canWriteClientCache = ctx.canWriteClientCache;
            realTimeFlag = sg.realTimeFlag();
            forkOnCacheable = false;
        } else {
            localRequestOnly = false;
            if (req instanceof SendableInsert) {
                canWriteClientCache = ((SendableInsert)req).canWriteClientCache(null);
                forkOnCacheable = ((SendableInsert)req).forkOnCacheable(null);
                localRequestOnly = ((SendableInsert)req).localRequestOnly(null);
                realTimeFlag = ((SendableInsert)req).realTimeFlag();
            } else {
                canWriteClientCache = false;
                forkOnCacheable = true;
                localRequestOnly = false;
                realTimeFlag = false;
            }
            ignoreStore = false;
        }
        TransientChosenBlock ret = new TransientChosenBlock(req, token, key, ckey, localRequestOnly, ignoreStore, canWriteClientCache, forkOnCacheable, realTimeFlag, this.sched);
        if (logMINOR) {
            Logger.minor(this, "Created " + ret + " for " + req);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SelectorReturn removeFirstInner(int fuzz, RandomSource random, OfferedKeysList offeredKeys, RequestStarter starter, ClientRequestSchedulerCore schedCore, ClientRequestSchedulerNonPersistent schedTransient, boolean transientOnly, boolean notTransient, short maxPrio, boolean realTime, ClientContext context, ObjectContainer container, long now) {
        boolean tryOfferedKeys;
        if (logMINOR) {
            Logger.minor(this, "removeFirst()");
        }
        if (schedCore == null) {
            transientOnly = true;
        }
        if (transientOnly && notTransient) {
            Logger.error(this, "Not transient but no core");
            return null;
        }
        boolean bl = tryOfferedKeys = offeredKeys != null && !notTransient && random.nextBoolean();
        if (tryOfferedKeys && offeredKeys.getCooldownTime(container, context, now) == 0L) {
            return new SelectorReturn(offeredKeys);
        }
        long l = this.removeFirstAccordingToPriorities(fuzz, random, schedCore, schedTransient, transientOnly, maxPrio, container, context, now);
        if (l > Integer.MAX_VALUE) {
            if (logMINOR) {
                Logger.minor(this, "No priority available for the next " + TimeUtil.formatTime(l - now));
            }
            return null;
        }
        int choosenPriorityClass = (int)l;
        if (choosenPriorityClass == -1) {
            if (!notTransient && !tryOfferedKeys && offeredKeys != null && offeredKeys.getCooldownTime(container, context, now) == 0L) {
                return new SelectorReturn(offeredKeys);
            }
            if (logMINOR) {
                Logger.minor(this, "Nothing to do");
            }
            return null;
        }
        long wakeupTime = Long.MAX_VALUE;
        if (maxPrio >= 6) {
            maxPrio = (short)6;
        }
        while (choosenPriorityClass <= maxPrio) {
            block91: {
                if (logMINOR) {
                    Logger.minor(this, "Using priority " + choosenPriorityClass);
                }
                SectoredRandomGrabArray perm = null;
                if (!transientOnly) {
                    perm = schedCore.newPriorities[choosenPriorityClass];
                }
                SectoredRandomGrabArray trans = null;
                if (!notTransient) {
                    trans = schedTransient.newPriorities[choosenPriorityClass];
                }
                if (perm == null && trans == null) {
                    if (logMINOR) {
                        Logger.minor(this, "No requests to run: chosen priority empty");
                    }
                } else {
                    Object object;
                    Object req;
                    RemoveRandom.RemoveRandomReturn val;
                    boolean triedPerm = false;
                    boolean triedTrans = false;
                    while (true) {
                        boolean persistent;
                        SectoredRandomGrabArray chosenTracker = null;
                        if (triedTrans) {
                            trans = null;
                        }
                        if (triedPerm) {
                            perm = null;
                        }
                        if (perm == null && trans == null) break block91;
                        if (perm == null && trans != null) {
                            chosenTracker = trans;
                            triedTrans = true;
                            long cooldownTime = context.cooldownTracker.getCachedWakeup(trans, false, container, now);
                            if (cooldownTime > 0L) {
                                if (cooldownTime < wakeupTime) {
                                    wakeupTime = cooldownTime;
                                }
                                Logger.normal(this, "Priority " + choosenPriorityClass + " (transient) is in cooldown for another " + (cooldownTime - now) + " " + TimeUtil.formatTime(cooldownTime - now));
                                break block91;
                            }
                            persistent = false;
                        } else if (perm != null && trans == null) {
                            chosenTracker = perm;
                            triedPerm = true;
                            long cooldownTime = context.cooldownTracker.getCachedWakeup(perm, true, container, now);
                            if (cooldownTime > 0L) {
                                if (cooldownTime < wakeupTime) {
                                    wakeupTime = cooldownTime;
                                }
                                Logger.normal(this, "Priority " + choosenPriorityClass + " (persistent) is in cooldown for another " + (cooldownTime - now) + " " + TimeUtil.formatTime(cooldownTime - now));
                                break block91;
                            }
                            container.activate((Object)perm, 1);
                            persistent = true;
                        } else {
                            boolean choosePerm;
                            container.activate((Object)perm, 1);
                            int permSize = perm.size();
                            int transSize = trans.size();
                            boolean bl2 = choosePerm = random.nextInt(permSize + transSize) < permSize;
                            if (choosePerm) {
                                chosenTracker = perm;
                                triedPerm = true;
                                persistent = true;
                            } else {
                                chosenTracker = trans;
                                triedTrans = true;
                                persistent = false;
                            }
                            long cooldownTime = context.cooldownTracker.getCachedWakeup(trans, choosePerm, container, now);
                            if (cooldownTime > 0L) {
                                if (cooldownTime < wakeupTime) {
                                    wakeupTime = cooldownTime;
                                }
                                Logger.normal(this, "Priority " + choosenPriorityClass + " (perm=" + choosePerm + ") is in cooldown for another " + (cooldownTime - now) + " " + TimeUtil.formatTime(cooldownTime - now));
                                break block91;
                            }
                        }
                        if (logMINOR) {
                            Logger.minor(this, "Got priority tracker " + chosenTracker);
                        }
                        if ((val = chosenTracker.removeRandom(starter, (ObjectContainer)(persistent ? container : null), context, now)) == null) {
                            Logger.normal(this, "Priority " + choosenPriorityClass + " returned null - nothing to schedule, should remove priority");
                            continue;
                        }
                        if (val.item == null) {
                            if (val.wakeupTime == -1L) {
                                Logger.normal(this, "Priority " + choosenPriorityClass + " returned cooldown time of -1 - nothing to schedule, should remove priority");
                                continue;
                            }
                            Logger.normal(this, "Priority " + choosenPriorityClass + " returned cooldown time of " + (val.wakeupTime - now) + " = " + TimeUtil.formatTime(val.wakeupTime - now));
                            if (val.wakeupTime <= 0L || val.wakeupTime >= wakeupTime) continue;
                            wakeupTime = val.wakeupTime;
                            continue;
                        }
                        req = (SendableRequest)val.item;
                        if (persistent) {
                            container.activate(req, 1);
                        }
                        if (chosenTracker.persistent() != persistent) {
                            Logger.error(this, "Tracker.persistent()=" + chosenTracker.persistent() + " but is in the queue for persistent=" + persistent + " for " + chosenTracker);
                        }
                        if (((SendableRequest)req).persistent() != persistent) {
                            Logger.error(this, "Request.persistent()=" + ((SendableRequest)req).persistent() + " but is in the queue for persistent=" + chosenTracker.persistent() + " for " + req);
                        }
                        if (((SendableRequest)req).getPriorityClass(container) == choosenPriorityClass) break;
                        Logger.normal(this, "In wrong priority class: " + req + " (req.prio=" + ((SendableRequest)req).getPriorityClass(container) + " but chosen=" + choosenPriorityClass + ')');
                        SectoredRandomGrabArrayWithObject clientGrabber = (SectoredRandomGrabArrayWithObject)chosenTracker.getGrabber(((SendableRequest)req).getClient(container));
                        if (clientGrabber != null) {
                            RandomGrabArray baseRGA;
                            if (chosenTracker.persistent()) {
                                container.activate((Object)clientGrabber, 1);
                            }
                            if ((baseRGA = (RandomGrabArray)((Object)clientGrabber.getGrabber(((SendableRequest)req).getClientRequest()))) != null) {
                                if (chosenTracker.persistent()) {
                                    container.activate((Object)baseRGA, 1);
                                }
                                object = this.sched;
                                synchronized (object) {
                                    baseRGA.remove((RandomGrabArrayItem)req, container, context);
                                }
                            }
                        } else {
                            Logger.error(this, "Could not find client grabber for client " + ((SendableRequest)req).getClient(container) + " from " + chosenTracker);
                        }
                        if (((SendableRequest)req).persistent()) {
                            schedCore.innerRegister((SendableRequest)req, container, context, null);
                            continue;
                        }
                        schedTransient.innerRegister((SendableRequest)req, container, context, null);
                    }
                    if (!((SendableRequest)req).persistent() && !this.isInsertScheduler) {
                        Deque<BaseSendableGet> recent = schedTransient.recentSuccesses;
                        BaseSendableGet altReq = null;
                        object = recent;
                        synchronized (object) {
                            if (!recent.isEmpty() && random.nextBoolean()) {
                                altReq = recent.poll();
                            }
                        }
                        if (altReq != null && altReq.isCancelled(container)) {
                            if (logMINOR) {
                                Logger.minor(this, "Ignoring cancelled recently succeeded item " + altReq);
                            }
                            altReq = null;
                        }
                        if (altReq != null && (l = altReq.getCooldownTime(container, context, now)) != 0L && logMINOR) {
                            Logger.minor(this, "Ignoring recently succeeded item, cooldown time = " + l + (l > 0L ? " (" + TimeUtil.formatTime(l - now) + ")" : ""));
                            altReq = null;
                        }
                        if (altReq != null && altReq != req) {
                            short prio = altReq.getPriorityClass(container);
                            if (prio <= choosenPriorityClass) {
                                if (logMINOR) {
                                    Logger.minor(this, "Recently succeeded (transient) req " + altReq + " (prio=" + altReq.getPriorityClass(container) + ") is better than " + req + " (prio=" + ((SendableRequest)req).getPriorityClass(container) + "), using that");
                                }
                                req = altReq;
                            } else {
                                if (logMINOR) {
                                    Logger.minor(this, "Chosen req " + req + " is better, reregistering recently succeeded " + altReq);
                                }
                                Deque<BaseSendableGet> deque = recent;
                                synchronized (deque) {
                                    recent.add(altReq);
                                }
                            }
                        }
                    } else if (!this.isInsertScheduler) {
                        RandomGrabArray altRGA = null;
                        Object altReq = this.recentSuccesses;
                        synchronized (altReq) {
                            if (!this.recentSuccesses.isEmpty() && !random.nextBoolean()) {
                                altRGA = this.recentSuccesses.removeLast();
                            }
                        }
                        if (altRGA != null) {
                            container.activate((Object)altRGA, 1);
                            altReq = null;
                            if (container.ext().isStored((Object)altRGA) && !altRGA.isEmpty(container)) {
                                if (logMINOR) {
                                    Logger.minor(this, "Maybe using recently succeeded item from " + altRGA);
                                }
                                if ((val = altRGA.removeRandom(starter, container, context, now)) != null) {
                                    if (val.item == null) {
                                        if (logMINOR) {
                                            Logger.minor(this, "Ignoring recently succeeded item, removeRandom returned cooldown time " + val.wakeupTime + (val.wakeupTime > 0L ? " (" + TimeUtil.formatTime(val.wakeupTime - now) + ")" : ""));
                                        }
                                    } else {
                                        altReq = (SendableRequest)val.item;
                                    }
                                }
                                if (altReq != null && altReq != req) {
                                    container.activate(altReq, 1);
                                    short prio = ((SendableRequest)altReq).getPriorityClass(container);
                                    boolean useRecent = false;
                                    if (prio <= choosenPriorityClass && altReq.getCooldownTime(container, context, now) != 0L) {
                                        useRecent = true;
                                    }
                                    if (useRecent) {
                                        if (logMINOR) {
                                            Logger.minor(this, "Recently succeeded (persistent) req " + altReq + " (prio=" + ((SendableRequest)altReq).getPriorityClass(container) + ") is better than " + req + " (prio=" + ((SendableRequest)req).getPriorityClass(container) + "), using that");
                                        }
                                        req = altReq;
                                    } else {
                                        if (logMINOR) {
                                            Logger.minor(this, "Chosen (persistent) req " + req + " is better, reregistering recently succeeded " + altRGA + " for " + altReq);
                                        }
                                        Deque<RandomGrabArray> deque = this.recentSuccesses;
                                        synchronized (deque) {
                                            this.recentSuccesses.add(altRGA);
                                        }
                                    }
                                }
                            } else {
                                container.deactivate((Object)altRGA, 1);
                            }
                        }
                    }
                    if (logMINOR) {
                        Logger.minor(this, "removeFirst() returning " + req + " (prio " + ((SendableRequest)req).getPriorityClass(container) + ", client " + ((SendableRequest)req).getClient(container) + ", client-req " + ((SendableRequest)req).getClientRequest() + ')');
                    }
                    if (logMINOR) {
                        Logger.minor(this, "removeFirst() returning " + req + " of " + ((SendableRequest)req).getClientRequest());
                    }
                    assert (((SendableRequest)req).realTimeFlag() == realTime);
                    return new SelectorReturn((SendableRequest)req);
                }
            }
            ++choosenPriorityClass;
        }
        if (logMINOR) {
            Logger.minor(this, "No requests to run");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToFetching(Key key) {
        HashSet<Key> hashSet = this.keysFetching;
        synchronized (hashSet) {
            boolean retval = this.keysFetching.add(key);
            if (!retval) {
                Logger.normal(this, "Already in keysFetching: " + key);
            } else if (logMINOR) {
                Logger.minor(this, "Added to keysFetching: " + key);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasKey(Key key, BaseSendableGet getterWaiting, boolean persistent, ObjectContainer container) {
        if (this.keysFetching == null) {
            throw new NullPointerException();
        }
        long pid = -1L;
        if (getterWaiting != null && persistent) {
            pid = container.ext().getID((Object)getterWaiting);
        }
        HashSet<Key> hashSet = this.keysFetching;
        synchronized (hashSet) {
            boolean ret = this.keysFetching.contains(key);
            if (!ret) {
                return ret;
            }
            if (getterWaiting != null) {
                if (persistent) {
                    Long[] waiting = this.persistentRequestsWaitingForKeysFetching.get(key);
                    if (waiting == null) {
                        this.persistentRequestsWaitingForKeysFetching.put(key, new Long[]{pid});
                    } else {
                        Long[] arr$ = waiting;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            long l = arr$[i$];
                            if (l != pid) continue;
                            return true;
                        }
                        Long[] newWaiting = Arrays.copyOf(waiting, waiting.length + 1);
                        newWaiting[waiting.length] = pid;
                        this.persistentRequestsWaitingForKeysFetching.put(key, newWaiting);
                    }
                } else {
                    WeakReference<BaseSendableGet>[] waiting = this.transientRequestsWaitingForKeysFetching.get(key);
                    if (waiting == null) {
                        this.transientRequestsWaitingForKeysFetching.put(key, new WeakReference[]{new WeakReference<BaseSendableGet>(getterWaiting)});
                    } else {
                        for (WeakReference<BaseSendableGet> ref : waiting) {
                            if (ref.get() != getterWaiting) continue;
                            return true;
                        }
                        WeakReference<BaseSendableGet>[] newWaiting = Arrays.copyOf(waiting, waiting.length + 1);
                        newWaiting[waiting.length] = new WeakReference<BaseSendableGet>(getterWaiting);
                        this.transientRequestsWaitingForKeysFetching.put(key, newWaiting);
                    }
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFetchingKey(Key key) {
        if (logMINOR) {
            Logger.minor(this, "Removing from keysFetching: " + key);
        }
        if (key != null) {
            WeakReference<BaseSendableGet>[] transientWaiting;
            Long[] persistentWaiting;
            HashSet<Key> hashSet = this.keysFetching;
            synchronized (hashSet) {
                this.keysFetching.remove(key);
                persistentWaiting = this.persistentRequestsWaitingForKeysFetching.remove(key);
                transientWaiting = this.transientRequestsWaitingForKeysFetching.remove(key);
            }
            if (persistentWaiting != null || transientWaiting != null) {
                CooldownTracker tracker = this.sched.clientContext.cooldownTracker;
                if (persistentWaiting != null) {
                    for (Long l : persistentWaiting) {
                        tracker.clearCachedWakeupPersistent(l);
                    }
                }
                if (transientWaiting != null) {
                    for (WeakReference<BaseSendableGet> ref : transientWaiting) {
                        BaseSendableGet get = (BaseSendableGet)ref.get();
                        if (get == null) continue;
                        ClientRequestScheduler clientRequestScheduler = this.sched;
                        synchronized (clientRequestScheduler) {
                            tracker.clearCachedWakeup(get, false, null);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTransientInsert(SendableInsert insert, SendableRequestItemKey token) {
        RunningTransientInsert tmp = new RunningTransientInsert(insert, token);
        HashSet<RunningTransientInsert> hashSet = this.runningTransientInserts;
        synchronized (hashSet) {
            return this.runningTransientInserts.contains(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTransientInsertFetching(SendableInsert insert, SendableRequestItemKey token) {
        RunningTransientInsert tmp = new RunningTransientInsert(insert, token);
        HashSet<RunningTransientInsert> hashSet = this.runningTransientInserts;
        synchronized (hashSet) {
            boolean retval = this.runningTransientInserts.add(tmp);
            if (!retval) {
                Logger.normal(this, "Already in runningTransientInserts: " + insert + " : " + token);
            } else if (logMINOR) {
                Logger.minor(this, "Added to runningTransientInserts: " + insert + " : " + token);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransientInsertFetching(SendableInsert insert, SendableRequestItemKey token) {
        RunningTransientInsert tmp = new RunningTransientInsert(insert, token);
        if (logMINOR) {
            Logger.minor(this, "Removing from runningTransientInserts: " + insert + " : " + token);
        }
        HashSet<RunningTransientInsert> hashSet = this.runningTransientInserts;
        synchronized (hashSet) {
            this.runningTransientInserts.remove(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void succeeded(BaseSendableGet succeeded, ObjectContainer container) {
        RandomGrabArray array = succeeded.getParentGrabArray();
        container.activate((Object)array, 1);
        if (array == null) {
            return;
        }
        Deque<RandomGrabArray> deque = this.recentSuccesses;
        synchronized (deque) {
            if (this.recentSuccesses.contains(array)) {
                return;
            }
            while (this.recentSuccesses.size() >= 8) {
                this.recentSuccesses.pollFirst();
            }
            this.recentSuccesses.add(array);
        }
    }

    @Override
    public long checkRecentlyFailed(Key key, boolean realTime) {
        Node node = this.sched.getNode();
        return node.clientCore.checkRecentlyFailed(key, realTime);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        tweakedPrioritySelector = new short[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 6};
        prioritySelector = new short[]{0, 1, 2, 3, 4, 5, 6};
    }

    public class SelectorReturn {
        public final SendableRequest req;
        public final long wakeupTime;

        SelectorReturn(SendableRequest req) {
            this.req = req;
            this.wakeupTime = -1L;
        }

        SelectorReturn(long wakeupTime) {
            this.wakeupTime = wakeupTime;
            this.req = null;
        }
    }

    private static class RunningTransientInsert {
        final SendableInsert insert;
        final SendableRequestItemKey token;

        RunningTransientInsert(SendableInsert i, SendableRequestItemKey t) {
            this.insert = i;
            this.token = t;
        }

        public int hashCode() {
            return this.insert.hashCode() ^ ((Object)this.token).hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof RunningTransientInsert)) {
                return false;
            }
            RunningTransientInsert r = (RunningTransientInsert)o;
            return r.insert == this.insert && (r.token == this.token || ((Object)r.token).equals(this.token));
        }
    }
}

