/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.PersistentSendableRequestSet;
import freenet.client.async.SendableRequestSet;
import freenet.client.async.TransientSendableRequestSet;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.node.SendableRequest;
import freenet.node.useralerts.SimpleUserAlert;
import freenet.node.useralerts.UserAlert;
import freenet.support.Logger;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import org.tanukisoftware.wrapper.WrapperManager;

public abstract class ClientRequester {
    private static volatile boolean logMINOR;
    protected short priorityClass;
    protected final boolean realTimeFlag;
    protected boolean cancelled;
    protected RequestClient client;
    protected final SendableRequestSet requests;
    private final int hashCode;
    protected int totalBlocks;
    protected int successfulBlocks;
    protected int failedBlocks;
    protected int fatallyFailedBlocks;
    protected int minSuccessBlocks;
    protected boolean blockSetFinalized;
    protected boolean sentToNetwork;
    static final transient UserAlert brokenClientAlert;
    private static WeakHashMap<ClientRequester, Object> allRequesters;
    private static Object dumbValue;
    public final long creationTime;

    public abstract void onTransition(ClientGetState var1, ClientGetState var2, ObjectContainer var3);

    public short getPriorityClass() {
        return this.priorityClass;
    }

    protected ClientRequester() {
        this.realTimeFlag = false;
        this.creationTime = 0L;
        this.hashCode = 0;
        this.requests = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientRequester(short priorityClass, RequestClient client) {
        this.priorityClass = priorityClass;
        this.client = client;
        this.realTimeFlag = client.realTimeFlag();
        if (client == null) {
            throw new NullPointerException();
        }
        this.hashCode = super.hashCode();
        this.requests = this.persistent() ? new PersistentSendableRequestSet() : new TransientSendableRequestSet();
        WeakHashMap<ClientRequester, Object> weakHashMap = allRequesters;
        synchronized (weakHashMap) {
            if (!this.persistent()) {
                allRequesters.put(this, dumbValue);
            }
        }
        this.creationTime = System.currentTimeMillis();
    }

    protected synchronized boolean cancel() {
        boolean ret = this.cancelled;
        this.cancelled = true;
        return ret;
    }

    public abstract void cancel(ObjectContainer var1, ClientContext var2);

    public boolean isCancelled() {
        return this.cancelled;
    }

    public abstract FreenetURI getURI();

    public abstract boolean isFinished();

    public int hashCode() {
        return this.hashCode;
    }

    protected synchronized void resetBlocks() {
        this.totalBlocks = 0;
        this.successfulBlocks = 0;
        this.failedBlocks = 0;
        this.fatallyFailedBlocks = 0;
        this.minSuccessBlocks = 0;
        this.blockSetFinalized = false;
        this.sentToNetwork = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockSetFinalized(ObjectContainer container, ClientContext context) {
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            if (this.blockSetFinalized) {
                return;
            }
            this.blockSetFinalized = true;
        }
        if (logMINOR) {
            Logger.minor(this, "Finalized set of blocks for " + this, (Throwable)new Exception("debug"));
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.notifyClients(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlock(ObjectContainer container) {
        boolean wasFinalized;
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            ++this.totalBlocks;
            wasFinalized = this.blockSetFinalized;
        }
        if (wasFinalized) {
            if (Logger.LogLevel.MINOR.matchesThreshold(Logger.globalGetThresholdNew())) {
                Logger.error(this, "addBlock() but set finalized! on " + this, (Throwable)new Exception("error"));
            } else {
                Logger.error(this, "addBlock() but set finalized! on " + this);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "addBlock(): total=" + this.totalBlocks + " successful=" + this.successfulBlocks + " failed=" + this.failedBlocks + " required=" + this.minSuccessBlocks);
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlocks(int num, ObjectContainer container) {
        boolean wasFinalized;
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            this.totalBlocks += num;
            wasFinalized = this.blockSetFinalized;
        }
        if (wasFinalized) {
            if (Logger.LogLevel.MINOR.matchesThreshold(Logger.globalGetThresholdNew())) {
                Logger.error(this, "addBlocks() but set finalized! on " + this, (Throwable)new Exception("error"));
            } else {
                Logger.error(this, "addBlocks() but set finalized! on " + this);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "addBlocks(" + num + "): total=" + this.totalBlocks + " successful=" + this.successfulBlocks + " failed=" + this.failedBlocks + " required=" + this.minSuccessBlocks);
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completedBlock(boolean dontNotify, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Completed block (" + dontNotify + "): total=" + this.totalBlocks + " success=" + this.successfulBlocks + " failed=" + this.failedBlocks + " fatally=" + this.fatallyFailedBlocks + " finalised=" + this.blockSetFinalized + " required=" + this.minSuccessBlocks + " on " + this);
        }
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            if (this.cancelled) {
                return;
            }
            ++this.successfulBlocks;
        }
        if (this.checkForBrokenClient(container, context)) {
            return;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        if (dontNotify) {
            return;
        }
        this.notifyClients(container, context);
    }

    public boolean checkForBrokenClient(ObjectContainer container, ClientContext context) {
        if (container != null && this.client == null) {
            if (container.ext().isStored((Object)this) && container.ext().isActive((Object)this)) {
                Logger.error(this, "Stored and active " + this + " but client is null!");
                if (!this.isFinished()) {
                    context.postUserAlert(brokenClientAlert);
                    System.err.println("Cancelling download/upload because of bug causing database corruption. The bug has been fixed but the download/upload will be cancelled. You can restart it.");
                }
                this.client = new RequestClient(){

                    @Override
                    public boolean persistent() {
                        return true;
                    }

                    @Override
                    public void removeFrom(ObjectContainer container) {
                        container.delete((Object)this);
                    }

                    @Override
                    public boolean realTimeFlag() {
                        return ClientRequester.this.realTimeFlag;
                    }
                };
                container.store((Object)this.client);
                container.store((Object)this);
                if (!this.isFinished()) {
                    this.cancel(container, context);
                }
                return true;
            }
            if (container.ext().isStored((Object)this) && !container.ext().isActive((Object)this)) {
                Logger.error(this, "Not active in completedBlock on " + this, (Throwable)new Exception("error"));
                return true;
            }
            throw new IllegalStateException("Client is null on persistent request " + this);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failedBlock(ObjectContainer container, ClientContext context) {
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            ++this.failedBlocks;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.notifyClients(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fatallyFailedBlock(ObjectContainer container, ClientContext context) {
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            ++this.fatallyFailedBlocks;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.notifyClients(container, context);
    }

    public synchronized void addMustSucceedBlocks(int blocks, ObjectContainer container) {
        this.totalBlocks += blocks;
        this.minSuccessBlocks += blocks;
        if (this.persistent()) {
            container.store((Object)this);
        }
        if (logMINOR) {
            Logger.minor(this, "addMustSucceedBlocks(" + blocks + "): total=" + this.totalBlocks + " successful=" + this.successfulBlocks + " failed=" + this.failedBlocks + " required=" + this.minSuccessBlocks);
        }
    }

    public synchronized void addRedundantBlocks(int blocks, ObjectContainer container) {
        this.totalBlocks += blocks;
        this.minSuccessBlocks += blocks;
        if (this.persistent()) {
            container.store((Object)this);
        }
        if (logMINOR) {
            Logger.minor(this, "addMustSucceedBlocks(" + blocks + "): total=" + this.totalBlocks + " successful=" + this.successfulBlocks + " failed=" + this.failedBlocks + " required=" + this.minSuccessBlocks);
        }
    }

    public abstract void notifyClients(ObjectContainer var1, ClientContext var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toNetwork(ObjectContainer container, ClientContext context) {
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            if (this.sentToNetwork) {
                return;
            }
            this.sentToNetwork = true;
            if (this.persistent()) {
                container.store((Object)this);
            }
        }
        this.innerToNetwork(container, context);
    }

    protected abstract void innerToNetwork(ObjectContainer var1, ClientContext var2);

    protected void clearCountersOnRestart() {
        this.blockSetFinalized = false;
        this.cancelled = false;
        this.failedBlocks = 0;
        this.fatallyFailedBlocks = 0;
        this.minSuccessBlocks = 0;
        this.sentToNetwork = false;
        this.successfulBlocks = 0;
        this.totalBlocks = 0;
    }

    public RequestClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriorityClass(short newPriorityClass, ClientContext ctx, ObjectContainer container) {
        short oldPrio;
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            oldPrio = this.priorityClass;
            this.priorityClass = newPriorityClass;
        }
        if (logMINOR) {
            Logger.minor(this, "Changing priority class of " + this + " from " + oldPrio + " to " + newPriorityClass);
        }
        ctx.getChkFetchScheduler(this.realTimeFlag).reregisterAll(this, container, oldPrio);
        ctx.getChkInsertScheduler(this.realTimeFlag).reregisterAll(this, container, oldPrio);
        ctx.getSskFetchScheduler(this.realTimeFlag).reregisterAll(this, container, oldPrio);
        ctx.getSskInsertScheduler(this.realTimeFlag).reregisterAll(this, container, oldPrio);
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    public boolean realTimeFlag() {
        return this.realTimeFlag;
    }

    public boolean persistent() {
        return this.client.persistent();
    }

    public void removeFrom(ObjectContainer container, ClientContext context) {
        container.activate((Object)this.requests, 1);
        this.requests.removeFrom(container);
        container.delete((Object)this);
    }

    public void objectOnActivate(ObjectContainer container) {
        container.activate((Object)this.client, 1);
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.client == null) {
            throw new NullPointerException();
        }
        return true;
    }

    public boolean objectCanUpdate(ObjectContainer container) {
        if (this.client == null) {
            throw new NullPointerException();
        }
        return true;
    }

    public void addToRequests(SendableRequest req, ObjectContainer container) {
        if (this.persistent()) {
            container.activate((Object)this.requests, 1);
        }
        this.requests.addRequest(req, container);
        if (this.persistent()) {
            container.deactivate((Object)this.requests, 1);
        }
    }

    public SendableRequest[] getSendableRequests(ObjectContainer container) {
        if (this.persistent()) {
            container.activate((Object)this.requests, 1);
        }
        SendableRequest[] reqs = this.requests.listRequests(container);
        if (this.persistent()) {
            container.deactivate((Object)this.requests, 1);
        }
        return reqs;
    }

    public void removeFromRequests(SendableRequest req, ObjectContainer container, boolean dontComplain) {
        if (this.persistent()) {
            container.activate((Object)this.requests, 1);
        }
        if (!this.requests.removeRequest(req, container) && !dontComplain) {
            Logger.error(this, "Not in request list for " + this + ": " + req);
        }
        if (this.persistent()) {
            container.deactivate((Object)this.requests, 1);
        }
    }

    public static void checkAll(ObjectContainer container, ClientContext clientContext) {
        ObjectSet requesters = container.query(ClientRequester.class);
        for (ClientRequester req : requesters) {
            try {
                if (logMINOR) {
                    Logger.minor(req, "Checking " + req);
                }
                if (req.isCancelled() || req.isFinished()) {
                    if (logMINOR) {
                        Logger.minor(req, "Cancelled or finished");
                    }
                } else {
                    if (logMINOR) {
                        Logger.minor(req, "Checking for broken client: " + req);
                    }
                    if (!req.checkForBrokenClient(container, clientContext)) {
                        if (logMINOR) {
                            Logger.minor(req, "Request is clean.");
                        } else {
                            WrapperManager.signalStarting((int)((int)TimeUnit.MINUTES.toMillis(5L)));
                            container.commit();
                        }
                    }
                }
            }
            catch (Throwable t) {
                Logger.error(ClientRequester.class, "Caught error while checking on startup", t);
            }
            container.deactivate((Object)req, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientRequester[] getAll() {
        WeakHashMap<ClientRequester, Object> weakHashMap = allRequesters;
        synchronized (weakHashMap) {
            return allRequesters.keySet().toArray(new ClientRequester[0]);
        }
    }

    static {
        Logger.registerClass(ClientRequester.class);
        brokenClientAlert = new SimpleUserAlert(true, "Some broken downloads/uploads were cancelled. Please restart them.", "Some downloads/uploads were broken due to a bug (some time before 1287) causing unrecoverable database corruption. They have been cancelled. Please restart them from the Downloads or Uploads page.", "Some downloads/uploads were broken due to a pre-1287 bug, please restart them.", 1);
        allRequesters = new WeakHashMap();
        dumbValue = new Object();
    }
}

