/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Query;
import freenet.client.async.BlockSet;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequester;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.DatastoreCheckerItem;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeSSK;
import freenet.node.LowLevelGetException;
import freenet.node.Node;
import freenet.node.PrioRunnable;
import freenet.node.SendableGet;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.NativeThread;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class DatastoreChecker
implements PrioRunnable {
    static final int KILL_BLOCKS = 0;
    static final int RESET_COUNTER = 100;
    private static volatile boolean logMINOR;
    static final int MAX_PERSISTENT_KEYS = 1024;
    private final ArrayDeque<PersistentItem>[] persistentQueue;
    private final ArrayDeque<TransientItem>[] transientQueue;
    private ClientContext context;
    private final Node node;
    private final DBJob loader = new DBJob(){

        @Override
        public boolean run(ObjectContainer container, ClientContext context) {
            DatastoreChecker.this.loadPersistentRequests(container, context);
            return false;
        }

        public String toString() {
            return "DatastoreCheckerPersistentRequestLoader";
        }
    };

    public synchronized void setContext(ClientContext context) {
        this.context = context;
    }

    public DatastoreChecker(Node node) {
        int i;
        this.node = node;
        int priorities = 7;
        this.persistentQueue = new ArrayDeque[priorities];
        for (i = 0; i < priorities; ++i) {
            this.persistentQueue[i] = new ArrayDeque();
        }
        this.transientQueue = new ArrayDeque[priorities];
        for (i = 0; i < priorities; ++i) {
            this.transientQueue[i] = new ArrayDeque();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPersistentRequests(ObjectContainer container, ClientContext context) {
        int totalSize = 0;
        DatastoreChecker datastoreChecker = this;
        synchronized (datastoreChecker) {
            for (ArrayDeque<PersistentItem> queue : this.persistentQueue) {
                for (PersistentItem item : queue) {
                    totalSize += item.keys.length;
                }
            }
            if (totalSize > 1024) {
                if (logMINOR) {
                    Logger.minor(this, "Persistent datastore checker queue already full");
                }
                return;
            }
        }
        for (short p = 0; p <= 6; p = (short)(p + 1)) {
            short prio = p;
            Query query = container.query();
            query.constrain(DatastoreCheckerItem.class);
            query.descend("nodeDBHandle").constrain((Object)context.nodeDBHandle).and(query.descend("prio").constrain((Object)prio));
            ObjectSet results = query.execute();
            for (DatastoreCheckerItem item : results) {
                if (item.chosenBy == context.bootID) continue;
                SendableGet getter = item.getter;
                if (getter == null || !container.ext().isStored((Object)getter)) {
                    if (logMINOR) {
                        Logger.minor(this, "Ignoring DatastoreCheckerItem because the SendableGet has already been deleted from the database");
                    }
                    container.delete((Object)item);
                    continue;
                }
                try {
                    BlockSet blocks = item.blocks;
                    container.activate((Object)getter, 1);
                    if (getter.isStorageBroken(container)) {
                        Logger.error(this, "Getter is broken as stored: " + getter);
                        container.delete((Object)getter);
                        container.delete((Object)item);
                        continue;
                    }
                    ClientRequestScheduler sched = getter.getScheduler(container, context);
                    PersistentItem persist = new PersistentItem(null, getter, sched, item, blocks);
                    Key[] keys = getter.listKeys(container);
                    item.chosenBy = context.bootID;
                    container.store((Object)item);
                    ArrayList<Key> finalKeysToCheck = new ArrayList<Key>(keys.length);
                    for (Key key : keys) {
                        key = key.cloneKey();
                        finalKeysToCheck.add(key);
                    }
                    Key[] finalKeys = finalKeysToCheck.toArray(new Key[finalKeysToCheck.size()]);
                    persist.keys = finalKeys;
                    DatastoreChecker datastoreChecker2 = this;
                    synchronized (datastoreChecker2) {
                        if (this.persistentQueue[prio].contains(persist)) {
                            continue;
                        }
                        this.persistentQueue[prio].add(persist);
                        if (totalSize == 0) {
                            this.notifyAll();
                        }
                        if ((totalSize += finalKeys.length) > 1024) {
                            boolean full = this.trimPersistentQueue(prio, container);
                            this.notifyAll();
                            if (full) {
                                return;
                            }
                        } else {
                            this.notifyAll();
                        }
                    }
                    container.deactivate((Object)getter, 1);
                }
                catch (NullPointerException e) {
                    Logger.error(this, "NPE for getter in DatastoreChecker: " + e + " - probably leftover data from an incomplete deletion", (Throwable)e);
                    try {
                        Logger.error(this, "Getter: " + getter);
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean trimPersistentQueue(short prio, ObjectContainer container) {
        DatastoreChecker datastoreChecker = this;
        synchronized (datastoreChecker) {
            int i;
            int i2;
            int preQueueSize = 0;
            for (i2 = 0; i2 < prio; ++i2) {
                for (PersistentItem item : this.persistentQueue[i2]) {
                    preQueueSize += item.keys.length;
                }
            }
            if (preQueueSize > 1024) {
                for (i2 = prio + 1; i2 < this.persistentQueue.length; ++i2) {
                    for (PersistentItem item : this.persistentQueue[i2]) {
                        item.checkerItem.chosenBy = 0L;
                        container.store((Object)item.checkerItem);
                    }
                    this.persistentQueue[i2].clear();
                }
                return true;
            }
            int postQueueSize = 0;
            for (i = prio + 1; i < this.persistentQueue.length; ++i) {
                for (PersistentItem item : this.persistentQueue[i]) {
                    postQueueSize += item.keys.length;
                }
            }
            if (postQueueSize + preQueueSize < 1024) {
                return false;
            }
            for (i = this.persistentQueue.length - 1; i > prio; --i) {
                PersistentItem item;
                while ((item = this.persistentQueue[i].pollLast()) != null) {
                    item.checkerItem.chosenBy = 0L;
                    container.store((Object)item.checkerItem);
                    if ((postQueueSize -= item.keys.length) + preQueueSize >= 1024) continue;
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueTransientRequest(SendableGet getter, BlockSet blocks) {
        Key[] checkKeys = getter.listKeys(null);
        short prio = getter.getPriorityClass(null);
        if (logMINOR) {
            Logger.minor(this, "Queueing transient request " + getter + " priority " + prio + " keys " + checkKeys.length);
        }
        ArrayList<Key> finalKeysToCheck = new ArrayList<Key>(checkKeys.length);
        ClientRequester requestor = getter.getClientRequest();
        requestor.addToRequests(getter, null);
        DatastoreChecker datastoreChecker = this;
        synchronized (datastoreChecker) {
            for (Key key : checkKeys) {
                finalKeysToCheck.add(key);
            }
            TransientItem queueItem = new TransientItem(finalKeysToCheck.toArray(new Key[finalKeysToCheck.size()]), getter, blocks);
            if (logMINOR && this.transientQueue[prio].contains(queueItem)) {
                Logger.error(this, "Transient request " + getter + " is already queued!");
                return;
            }
            this.transientQueue[prio].add(queueItem);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queuePersistentRequest(SendableGet getter, BlockSet blocks, ObjectContainer container, ClientContext context) {
        if (getter.isCancelled(container)) {
            if (logMINOR) {
                Logger.minor(this, "Request is empty, not checking store: " + getter);
            }
            return;
        }
        Key[] checkKeys = getter.listKeys(container);
        short prio = getter.getPriorityClass(container);
        ClientRequestScheduler sched = getter.getScheduler(container, context);
        DatastoreCheckerItem item = new DatastoreCheckerItem(getter, context.nodeDBHandle, prio, blocks);
        container.store((Object)item);
        container.activate((Object)blocks, 5);
        ClientRequester requestor = getter.getClientRequest();
        container.activate((Object)requestor, 1);
        requestor.addToRequests(getter, container);
        DatastoreChecker datastoreChecker = this;
        synchronized (datastoreChecker) {
            int queueSize = 0;
            for (short p = 0; p <= prio; p = (short)(p + 1)) {
                for (PersistentItem persist : this.persistentQueue[p]) {
                    queueSize += persist.keys.length;
                }
            }
            if (queueSize > 1024) {
                return;
            }
            item.chosenBy = context.bootID;
            container.store((Object)item);
            ArrayList<Key> finalKeysToCheck = new ArrayList<Key>(checkKeys.length);
            for (Key key : checkKeys) {
                finalKeysToCheck.add(key);
            }
            PersistentItem queueItem = new PersistentItem(finalKeysToCheck.toArray(new Key[finalKeysToCheck.size()]), getter, sched, item, blocks);
            if (logMINOR && this.persistentQueue[prio].contains(queueItem)) {
                Logger.error(this, "Persistent request " + getter + " is already queued!");
                return;
            }
            this.persistentQueue[prio].add(queueItem);
            this.trimPersistentQueue(prio, container);
            this.notifyAll();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.realRun();
                }
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t + " in datastore checker thread", t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        Random random = null;
        Key[] keys = null;
        SendableGet getter = null;
        boolean persistent = false;
        ClientRequestScheduler sched = null;
        DatastoreCheckerItem item = null;
        BlockSet blocks = null;
        int queueSize = this.context.jobRunner.getQueueSize(ClientRequestScheduler.TRIP_PENDING_PRIORITY);
        boolean notPersistent = queueSize > 100;
        boolean waited = false;
        DatastoreChecker datastoreChecker = this;
        synchronized (datastoreChecker) {
            while (true) {
                for (int prio = 0; prio < this.transientQueue.length; prio = (int)((short)(prio + 1))) {
                    PersistentItem persist;
                    TransientItem trans = this.transientQueue[prio].pollFirst();
                    if (trans != null) {
                        keys = trans.keys;
                        getter = trans.getter;
                        persistent = false;
                        item = null;
                        blocks = trans.blockSet;
                        if (!logMINOR) break;
                        Logger.minor(this, "Checking transient request " + getter + " prio " + prio + " of " + this.transientQueue[prio].size());
                        break;
                    }
                    if (notPersistent || (persist = this.persistentQueue[prio].pollFirst()) == null) continue;
                    keys = persist.keys;
                    getter = persist.getter;
                    persistent = true;
                    sched = persist.scheduler;
                    item = persist.checkerItem;
                    blocks = persist.blockSet;
                    if (!logMINOR) break;
                    Logger.minor(this, "Checking persistent request at prio " + prio);
                    break;
                }
                if (keys != null) break;
                if (!notPersistent) {
                    try {
                        this.context.jobRunner.queue(this.loader, NativeThread.HIGH_PRIORITY, true);
                    }
                    catch (DatabaseDisabledException e1) {
                        // empty catch block
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Waiting for more persistent or transient requests");
                    }
                } else if (logMINOR) {
                    Logger.minor(this, "Waiting for more transient requests");
                }
                if (waited && notPersistent) {
                    return;
                }
                waited = true;
                try {
                    this.wait(TimeUnit.SECONDS.toMillis(100L));
                }
                catch (InterruptedException e) {}
            }
        }
        if (!persistent) {
            sched = getter.getScheduler(null, this.context);
        }
        boolean anyValid = false;
        for (Key key : keys) {
            if (random != null && random.nextInt(100) < 0) {
                anyValid = true;
                continue;
            }
            KeyBlock block = blocks != null ? blocks.get(key) : this.node.fetch(key, true, true, false, false, null);
            if (block != null) {
                if (logMINOR) {
                    Logger.minor(this, "Found key");
                }
                if (key instanceof NodeSSK) {
                    sched.tripPendingKey(block);
                    continue;
                }
                sched.tripPendingKey(block);
                continue;
            }
            anyValid = true;
        }
        if (logMINOR) {
            Logger.minor(this, "Checked " + keys.length + " keys");
        }
        if (persistent) {
            try {
                this.context.jobRunner.queue(this.loader, NativeThread.HIGH_PRIORITY, true);
            }
            catch (DatabaseDisabledException e) {
                // empty catch block
            }
        }
        if (persistent) {
            final SendableGet get = getter;
            final ClientRequestScheduler scheduler = sched;
            final boolean valid = anyValid;
            final DatastoreCheckerItem it = item;
            try {
                this.context.jobRunner.queue(new DBJob(){

                    @Override
                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (container.ext().isActive((Object)get)) {
                            Logger.warning(this, "ALREADY ACTIVATED: " + get);
                        }
                        if (!container.ext().isStored((Object)get)) {
                            if (logMINOR) {
                                Logger.minor(this, "Already deleted from database");
                            }
                            container.delete((Object)it);
                            return false;
                        }
                        container.activate((Object)get, 1);
                        try {
                            scheduler.finishRegister(new SendableGet[]{get}, true, container, valid, it);
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Failed to register " + get + ": " + t, t);
                            try {
                                get.onFailure(new LowLevelGetException(3, "Internal error: " + t, t), null, container, context);
                            }
                            catch (Throwable t1) {
                                Logger.error(this, "Failed to fail: " + t, t);
                            }
                        }
                        container.deactivate((Object)get, 1);
                        DatastoreChecker.this.loader.run(container, context);
                        return false;
                    }

                    public String toString() {
                        return "DatastoreCheckerFinishRegister";
                    }
                }, NativeThread.NORM_PRIORITY, false);
            }
            catch (DatabaseDisabledException e) {}
        } else {
            sched.finishRegister(new SendableGet[]{getter}, false, null, anyValid, item);
        }
    }

    synchronized void wakeUp() {
        this.notifyAll();
    }

    public void start(Executor executor, String name) {
        try {
            this.context.jobRunner.queue(this.loader, NativeThread.HIGH_PRIORITY - 1, true);
        }
        catch (DatabaseDisabledException databaseDisabledException) {
            // empty catch block
        }
        executor.execute(this, name);
    }

    @Override
    public int getPriority() {
        return NativeThread.NORM_PRIORITY;
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing DatastoreChecker in database", (Throwable)new Exception("error"));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(SendableGet request, boolean persistent, ObjectContainer container, ClientContext context, short prio) {
        if (logMINOR) {
            Logger.minor(this, "Removing request prio=" + prio + " persistent=" + persistent);
        }
        QueueItem requestMatcher = new QueueItem(request);
        if (!persistent) {
            DatastoreChecker datastoreChecker = this;
            synchronized (datastoreChecker) {
                if (!this.transientQueue[prio].remove(requestMatcher)) {
                    return;
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Removed transient request");
            }
        } else {
            DatastoreChecker datastoreChecker = this;
            synchronized (datastoreChecker) {
                this.persistentQueue[prio].remove(requestMatcher);
            }
            Query query = container.query();
            query.constrain(DatastoreCheckerItem.class);
            query.descend("getter").constrain((Object)request).identity();
            ObjectSet results = query.execute();
            int deleted = 0;
            for (DatastoreCheckerItem item : results) {
                if (item.nodeDBHandle != context.nodeDBHandle) continue;
                if (deleted == 1) {
                    try {
                        Logger.error(this, "Multiple DatastoreCheckerItem's for " + request);
                    }
                    catch (Throwable e) {
                        Logger.error(this, "Multiple DatastoreCheckerItem's for request");
                    }
                }
                ++deleted;
                container.delete((Object)item);
            }
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    private static final class TransientItem
    extends QueueItem {
        Key[] keys;
        final BlockSet blockSet;

        TransientItem(Key[] keys, SendableGet getter, BlockSet blockSet) {
            super(getter);
            this.keys = keys;
            this.blockSet = blockSet;
        }
    }

    private static final class PersistentItem
    extends QueueItem {
        Key[] keys;
        final ClientRequestScheduler scheduler;
        final DatastoreCheckerItem checkerItem;
        final BlockSet blockSet;

        PersistentItem(Key[] keys, SendableGet getter, ClientRequestScheduler scheduler, DatastoreCheckerItem checkerItem, BlockSet blockSet) {
            super(getter);
            this.keys = keys;
            this.scheduler = scheduler;
            this.checkerItem = checkerItem;
            this.blockSet = blockSet;
        }
    }

    private static class QueueItem {
        final SendableGet getter;

        QueueItem(SendableGet getter) {
            this.getter = getter;
        }

        public boolean equals(Object o) {
            if (!(o instanceof QueueItem)) {
                return false;
            }
            return this.getter == ((QueueItem)o).getter;
        }
    }
}

