/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.InsertContext;
import freenet.client.async.BaseManifestPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutter;
import freenet.client.async.ManifestElement;
import freenet.client.async.TooManyFilesInsertException;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.support.ContainerSizeEstimator;
import freenet.support.Logger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DefaultManifestPutter
extends BaseManifestPutter {
    private static volatile boolean logMINOR;
    public static final long DEFAULT_MAX_CONTAINERSIZE = 0x200000L;
    public static final long DEFAULT_MAX_CONTAINERITEMSIZE = 0x100000L;
    public static final long DEFAULT_CONTAINERSIZE_SPARE = 200704L;

    public DefaultManifestPutter(ClientPutCallback clientCallback, HashMap<String, Object> manifestElements, short prioClass, FreenetURI target, String defaultName, InsertContext ctx, boolean getCHKOnly, RequestClient clientContext, boolean earlyEncode, boolean persistent, byte[] forceCryptoKey, ObjectContainer container, ClientContext context) throws TooManyFilesInsertException {
        super(clientCallback, manifestElements, prioClass, target, defaultName, ctx, getCHKOnly, clientContext, earlyEncode, ClientPutter.randomiseSplitfileKeys(target, ctx, persistent, container), forceCryptoKey, container, context);
    }

    @Override
    protected void makePutHandlers(HashMap<String, Object> manifestElements, String defaultName) throws TooManyFilesInsertException {
        this.verifyManifest(manifestElements);
        this.makePutHandlers(this.getRootContainer(), manifestElements, defaultName, "", 0x200000L, null);
    }

    private void verifyManifest(HashMap<String, Object> metadata) {
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            Object o = entry.getValue();
            if (o instanceof HashMap) {
                HashMap hm = (HashMap)o;
                this.verifyManifest(hm);
                continue;
            }
            if (o instanceof ManifestElement) continue;
            throw new IllegalArgumentException("FATAL: unknown manifest element: " + o);
        }
    }

    private long makePutHandlers(BaseManifestPutter.ContainerBuilder containerBuilder, HashMap<String, Object> manifestElements, String defaultName, String prefix, long maxSize, String parentName) throws TooManyFilesInsertException {
        HashMap hm;
        ManifestElement me;
        Object o;
        String name;
        ContainerSizeEstimator.ContainerSize wholeSize;
        if (logMINOR) {
            Logger.minor(this, "STAT: handling " + (parentName == null ? "<root>?" : parentName));
        }
        if (maxSize == 0x200000L) {
            maxSize = 1896448L;
        }
        if ((wholeSize = ContainerSizeEstimator.getSubTreeSize(manifestElements, 0x100000L, maxSize, Integer.MAX_VALUE)).getSizeTotalNoLimit() <= maxSize) {
            if (logMINOR) {
                Logger.minor(this, "PackStat2: the whole tree (unlimited) fits into container (no externals)");
            }
            this.makeEveryThingUnlimitedPutHandlers(containerBuilder, manifestElements, defaultName, prefix);
            return wholeSize.getSizeTotalNoLimit();
        }
        if (wholeSize.getSizeTotal() <= maxSize) {
            if (logMINOR) {
                Logger.minor(this, "PackStat2: the whole tree fits into container (with externals)");
            }
            this.makeEveryThingPutHandlers(containerBuilder, manifestElements, defaultName, prefix);
            return wholeSize.getSizeTotal();
        }
        long tmpSize = 0L;
        if (wholeSize.getSizeFiles() < maxSize || wholeSize.getSizeFilesNoLimit() < maxSize) {
            String name2;
            if (logMINOR) {
                Logger.minor(this, "PackStat2: the files in dir fits into container with spare, so it need to grab stuff from sub's to fill container up");
            }
            if (wholeSize.getSizeFilesNoLimit() < maxSize) {
                for (Map.Entry<String, Object> entry : manifestElements.entrySet()) {
                    String name22 = entry.getKey();
                    Object object = entry.getValue();
                    if (object instanceof ManifestElement) {
                        ManifestElement me2 = (ManifestElement)object;
                        containerBuilder.addItem(name22, prefix + name22, me2, name22.equals(defaultName));
                        continue;
                    }
                    tmpSize += 512L;
                }
                tmpSize += wholeSize.getSizeFilesNoLimit();
            } else {
                for (Map.Entry<String, Object> entry : manifestElements.entrySet()) {
                    name2 = entry.getKey();
                    Object object = entry.getValue();
                    if (object instanceof ManifestElement) {
                        ManifestElement me2 = (ManifestElement)object;
                        if (me2.getSize() > 0x100000L) {
                            containerBuilder.addExternal(name2, me2.getData(), me2.getMimeTypeOverride(), name2.equals(defaultName));
                            continue;
                        }
                        containerBuilder.addItem(name2, prefix + name2, me2, name2.equals(defaultName));
                        continue;
                    }
                    tmpSize += 512L;
                }
                tmpSize += wholeSize.getSizeFiles();
            }
            for (Map.Entry<String, Object> entry : manifestElements.entrySet()) {
                name2 = entry.getKey();
                Object object = entry.getValue();
                if (!(object instanceof HashMap)) continue;
                HashMap hm2 = (HashMap)object;
                if (tmpSize < maxSize - (long)(512 * hm2.size())) {
                    containerBuilder.pushCurrentDir();
                    containerBuilder.makeSubDirCD(name2);
                    tmpSize += this.makePutHandlers(containerBuilder, hm2, defaultName, "", maxSize - tmpSize, name2);
                    containerBuilder.popCurrentDir();
                    continue;
                }
                BaseManifestPutter.ContainerBuilder subC = containerBuilder.makeSubContainer(name2);
                this.makePutHandlers(subC, hm2, defaultName, "", 0x200000L, name2);
            }
            return tmpSize;
        }
        HashMap<String, Object> itemsLeft = new HashMap<String, Object>();
        int minUsageForFiles = 0;
        Iterator<Map.Entry<String, Object>> iter = manifestElements.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            name = entry.getKey();
            o = entry.getValue();
            if (!(o instanceof ManifestElement)) continue;
            me = (ManifestElement)o;
            if (me.getTargetURI() != null) {
                tmpSize += 512L;
                containerBuilder.addItem(name, prefix + name, me, name.equals(defaultName));
                iter.remove();
                continue;
            }
            minUsageForFiles += 512;
        }
        if (wholeSize.getSizeSubTrees() + tmpSize + (long)minUsageForFiles < maxSize || wholeSize.getSizeSubTreesNoLimit() + tmpSize + (long)minUsageForFiles < maxSize) {
            if (logMINOR) {
                Logger.minor(this, "PackStat2: the sub dirs fit into container with spare, so it need to grab files to fill container up");
            }
            if (wholeSize.getSizeSubTreesNoLimit() + tmpSize + (long)minUsageForFiles < maxSize) {
                if (logMINOR) {
                    Logger.minor(this, " (unlimited)");
                }
                for (Map.Entry<String, Object> entry : manifestElements.entrySet()) {
                    name = entry.getKey();
                    o = entry.getValue();
                    if (!(o instanceof HashMap)) continue;
                    hm = (HashMap)o;
                    containerBuilder.pushCurrentDir();
                    containerBuilder.makeSubDirCD(name);
                    this.makeEveryThingUnlimitedPutHandlers(containerBuilder, hm, defaultName, prefix);
                    containerBuilder.popCurrentDir();
                }
                tmpSize = wholeSize.getSizeSubTreesNoLimit();
            } else {
                if (logMINOR) {
                    Logger.minor(this, " (limited)");
                }
                for (Map.Entry<String, Object> entry : manifestElements.entrySet()) {
                    name = entry.getKey();
                    o = entry.getValue();
                    if (!(o instanceof HashMap)) continue;
                    hm = (HashMap)o;
                    containerBuilder.pushCurrentDir();
                    containerBuilder.makeSubDirCD(name);
                    this.makeEveryThingPutHandlers(containerBuilder, hm, defaultName, prefix);
                    containerBuilder.popCurrentDir();
                }
                tmpSize = wholeSize.getSizeSubTrees();
            }
        } else {
            if (logMINOR) {
                Logger.minor(this, "PackStat2: sub dirs does not fit into container, make each its own");
            }
            for (Map.Entry<String, Object> entry : manifestElements.entrySet()) {
                name = entry.getKey();
                o = entry.getValue();
                if (!(o instanceof HashMap)) continue;
                hm = (HashMap)o;
                BaseManifestPutter.ContainerBuilder subC = containerBuilder.makeSubContainer(name);
                this.makePutHandlers(subC, hm, defaultName, "", 0x200000L, name);
                tmpSize += 512L;
            }
        }
        for (Map.Entry<String, Object> entry : manifestElements.entrySet()) {
            name = entry.getKey();
            o = entry.getValue();
            if (!(o instanceof ManifestElement)) continue;
            me = (ManifestElement)o;
            long size = ContainerSizeEstimator.tarItemSize(me.getSize());
            if (me.getSize() <= 0x100000L && size < maxSize - (tmpSize + (long)minUsageForFiles - 512L)) {
                containerBuilder.addItem(name, prefix + name, me, name.equals(defaultName));
                tmpSize += size;
                minUsageForFiles -= 512;
                continue;
            }
            tmpSize += 512L;
            minUsageForFiles -= 512;
            itemsLeft.put(name, me);
        }
        assert (minUsageForFiles == 0);
        if (tmpSize > maxSize) {
            throw new TooManyFilesInsertException();
        }
        while (!itemsLeft.isEmpty()) {
            if (logMINOR) {
                Logger.minor(this, "ItemsLeft checker: " + itemsLeft.size());
            }
            if (itemsLeft.size() == 1) {
                for (Map.Entry entry : itemsLeft.entrySet()) {
                    String lname = (String)entry.getKey();
                    ManifestElement me3 = (ManifestElement)entry.getValue();
                    containerBuilder.addElement(lname, me3, lname.equals(defaultName));
                }
                itemsLeft.clear();
                continue;
            }
            long leftLimit = 1896448L;
            ContainerSizeEstimator.ContainerSize leftSize = ContainerSizeEstimator.getSubTreeSize(itemsLeft, 0x100000L, 1896448L, 0);
            if (leftSize.getSizeFiles() > 0L && leftSize.getSizeFilesNoLimit() <= 1896448L) {
                BaseManifestPutter.ContainerBuilder archive = this.makeArchive();
                for (Map.Entry<String, Object> entry : itemsLeft.entrySet()) {
                    String lname = entry.getKey();
                    ManifestElement me4 = (ManifestElement)entry.getValue();
                    containerBuilder.addArchiveItem(archive, lname, me4, lname.equals(defaultName));
                }
                itemsLeft.clear();
                continue;
            }
            if (leftSize.getSizeFiles() - (long)(512 * itemsLeft.size()) == 0L && leftSize.getSizeFilesNoLimit() > 0L) {
                for (Map.Entry<String, Object> entry : itemsLeft.entrySet()) {
                    String lname = entry.getKey();
                    ManifestElement me5 = (ManifestElement)entry.getValue();
                    containerBuilder.addElement(lname, me5, lname.equals(defaultName));
                }
                itemsLeft.clear();
                continue;
            }
            long archiveLimit = 200704L;
            BaseManifestPutter.ContainerBuilder archive = this.makeArchive();
            Iterator<Map.Entry<String, Object>> iter2 = itemsLeft.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry<String, Object> entry = iter2.next();
                String lname = entry.getKey();
                ManifestElement me6 = (ManifestElement)entry.getValue();
                if (me6.getSize() <= -1L || me6.getSize() > 0x100000L || me6.getSize() >= 0x200000L - archiveLimit) continue;
                containerBuilder.addArchiveItem(archive, lname, me6, lname.equals(defaultName));
                tmpSize += 512L;
                archiveLimit += ContainerSizeEstimator.tarItemSize(me6.getSize());
                iter2.remove();
            }
        }
        return tmpSize;
    }

    private void makeEveryThingUnlimitedPutHandlers(BaseManifestPutter.ContainerBuilder containerBuilder, HashMap<String, Object> manifestElements, String defaultName, String prefix) {
        for (Map.Entry<String, Object> entry : manifestElements.entrySet()) {
            String name = entry.getKey();
            Object o = entry.getValue();
            if (o instanceof ManifestElement) {
                ManifestElement element = (ManifestElement)o;
                containerBuilder.addItem(name, prefix + name, element, name.equals(defaultName));
                continue;
            }
            HashMap hm = (HashMap)o;
            containerBuilder.pushCurrentDir();
            containerBuilder.makeSubDirCD(name);
            this.makeEveryThingUnlimitedPutHandlers(containerBuilder, hm, defaultName, "");
            containerBuilder.popCurrentDir();
        }
    }

    private void makeEveryThingPutHandlers(BaseManifestPutter.ContainerBuilder containerBuilder, HashMap<String, Object> manifestElements, String defaultName, String prefix) {
        for (Map.Entry<String, Object> entry : manifestElements.entrySet()) {
            String name = entry.getKey();
            Object o = entry.getValue();
            if (o instanceof ManifestElement) {
                ManifestElement element = (ManifestElement)o;
                if (element.getSize() > 0x100000L) {
                    containerBuilder.addExternal(name, element.getData(), element.getMimeTypeOverride(), name.equals(defaultName));
                    continue;
                }
                containerBuilder.addItem(name, prefix + name, element, name.equals(defaultName));
                continue;
            }
            HashMap hm = (HashMap)o;
            containerBuilder.pushCurrentDir();
            containerBuilder.makeSubDirCD(name);
            this.makeEveryThingPutHandlers(containerBuilder, hm, defaultName, "");
            containerBuilder.popCurrentDir();
        }
    }

    static {
        Logger.registerClass(DefaultManifestPutter.class);
    }
}

