/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.PersistentChosenRequest;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.node.LowLevelGetException;
import freenet.node.LowLevelPutException;
import freenet.node.NodeClientCore;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;

public class PersistentChosenBlock
extends ChosenBlock {
    public final PersistentChosenRequest parent;
    public final boolean isInsert;
    private boolean finished;
    private LowLevelGetException failedGet;
    private boolean fetchSucceeded;
    private boolean insertSucceeded;
    private LowLevelPutException failedPut;
    private static volatile boolean logMINOR;

    public PersistentChosenBlock(boolean isInsert, PersistentChosenRequest parent, SendableRequestItem token, Key key, ClientKey ckey, RequestScheduler sched) {
        super(token, key, ckey, parent.localRequestOnly, parent.ignoreStore, parent.canWriteClientCache, parent.forkOnCacheable, parent.realTimeFlag, sched);
        this.isInsert = isInsert;
        this.parent = parent;
        if (logMINOR) {
            Logger.minor(this, "Created " + this + " for " + parent + " ckey=" + ckey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFetchSuccess(ClientContext context) {
        assert (!this.isInsert);
        PersistentChosenBlock persistentChosenBlock = this;
        synchronized (persistentChosenBlock) {
            if (this.finished) {
                Logger.error(this, "Already finished in onSuccess() on " + this, (Throwable)new Exception("debug"));
                return;
            }
            this.finished = true;
            this.fetchSucceeded = true;
        }
        this.parent.onFinished(this, context);
        this.parent.scheduler.succeeded((SendableGet)this.parent.request, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(LowLevelGetException e, ClientContext context) {
        assert (!this.isInsert);
        PersistentChosenBlock persistentChosenBlock = this;
        synchronized (persistentChosenBlock) {
            if (this.finished) {
                Logger.error(this, "Already finished in onFailure() on " + this, (Throwable)new Exception("debug"));
                return;
            }
            if (e == null) {
                throw new NullPointerException();
            }
            this.failedGet = e;
            this.finished = true;
        }
        this.parent.onFinished(this, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInsertSuccess(ClientContext context) {
        assert (this.isInsert);
        PersistentChosenBlock persistentChosenBlock = this;
        synchronized (persistentChosenBlock) {
            if (this.finished) {
                Logger.error(this, "Already finished in onSuccess() on " + this, (Throwable)new Exception("debug"));
                return;
            }
            this.insertSucceeded = true;
            this.finished = true;
            if (this.getGeneratedKey() == null) {
                Logger.error(this, "Insert completed but no generated key on " + this, (Throwable)new Exception("debug"));
            }
        }
        this.parent.onFinished(this, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(LowLevelPutException e, ClientContext context) {
        assert (this.isInsert);
        PersistentChosenBlock persistentChosenBlock = this;
        synchronized (persistentChosenBlock) {
            if (this.finished) {
                Logger.error(this, "Already finished in onFailure() on " + this, (Throwable)new Exception("debug"));
                return;
            }
            if (e == null) {
                throw new NullPointerException();
            }
            this.failedPut = e;
            this.finished = true;
        }
        this.parent.onFinished(this, context);
    }

    LowLevelGetException failedGet() {
        return this.failedGet;
    }

    boolean insertSucceeded() {
        return this.insertSucceeded;
    }

    boolean fetchSucceeded() {
        return this.fetchSucceeded;
    }

    LowLevelPutException failedPut() {
        return this.failedPut;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean send(NodeClientCore core, RequestScheduler sched) {
        return super.send(core, sched);
    }

    @Override
    public short getPriority() {
        return this.parent.prio;
    }

    @Override
    public SendableRequestSender getSender(ClientContext context) {
        return this.parent.sender;
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Trying to store a PersistentChosenRequest!", (Throwable)new Exception("error"));
        return false;
    }

    public boolean objectCanUpdate(ObjectContainer container) {
        Logger.error(this, "Trying to store a PersistentChosenRequest!", (Throwable)new Exception("error"));
        return false;
    }

    public boolean objectCanActivate(ObjectContainer container) {
        Logger.error(this, "Trying to store a PersistentChosenRequest!", (Throwable)new Exception("error"));
        return false;
    }

    public boolean objectCanDeactivate(ObjectContainer container) {
        Logger.error(this, "Trying to store a PersistentChosenRequest!", (Throwable)new Exception("error"));
        return false;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

