/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.PlainManifestPutter;
import freenet.client.async.SendableRequestSet;
import freenet.node.SendableRequest;
import freenet.support.ListUtils;
import freenet.support.Logger;
import java.util.ArrayList;

public class PersistentSendableRequestSet
implements SendableRequestSet {
    private static volatile boolean logMINOR;
    private final ArrayList<SendableRequest> list = new ArrayList();

    PersistentSendableRequestSet() {
    }

    @Override
    public synchronized boolean addRequest(SendableRequest req, ObjectContainer container) {
        container.activate(this.list, 1);
        int idx = this.find(req, container);
        if (idx == -1) {
            this.list.add(req);
            container.store((Object)req);
            container.ext().store(this.list, 1);
            return true;
        }
        return false;
    }

    private synchronized int find(SendableRequest req, ObjectContainer container) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get(i) != req) continue;
            return i;
        }
        if (container.ext().isStored((Object)req)) {
            long id = container.ext().getID((Object)req);
            for (int i = 0; i < this.list.size(); ++i) {
                if (container.ext().getID((Object)this.list.get(i)) != id) continue;
                Logger.warning(this, "db4o being wierd: found on second round");
                return i;
            }
        }
        return -1;
    }

    @Override
    public synchronized SendableRequest[] listRequests(ObjectContainer container) {
        container.activate(this.list, 1);
        return this.list.toArray(new SendableRequest[this.list.size()]);
    }

    @Override
    public synchronized boolean removeRequest(SendableRequest req, ObjectContainer container) {
        int idx;
        if (logMINOR) {
            Logger.minor(this, "Removing " + req + " from " + this);
        }
        container.activate(this.list, 1);
        boolean success = false;
        while ((idx = this.find(req, container)) != -1) {
            if (success) {
                Logger.error(this, "Request is in " + this + " twice or more : " + req);
            }
            success = true;
            ListUtils.removeBySwapLast(this.list, idx);
        }
        if (!success) {
            return false;
        }
        container.ext().store(this.list, 1);
        return success;
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        container.activate(this.list, 1);
        container.delete(this.list);
        container.delete((Object)this);
    }

    static {
        Logger.registerClass(PlainManifestPutter.class);
    }
}

