/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.async.BaseSingleFileFetcher;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.GetCompletionCallback;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.SingleFileStreamGenerator;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.KeyDecodeException;
import freenet.keys.TooBigException;
import freenet.node.LowLevelGetException;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import java.io.IOException;

public class SimpleSingleFileFetcher
extends BaseSingleFileFetcher
implements ClientGetState {
    final GetCompletionCallback rcb;
    final long token;
    private static volatile boolean logMINOR;

    SimpleSingleFileFetcher(ClientKey key, int maxRetries, FetchContext ctx, ClientRequester parent, GetCompletionCallback rcb, boolean isEssential, boolean dontAdd, long l, ObjectContainer container, ClientContext context, boolean deleteFetchContext, boolean realTimeFlag) {
        super(key, maxRetries, ctx, parent, deleteFetchContext, realTimeFlag);
        this.rcb = rcb;
        this.token = l;
        if (!dontAdd) {
            if (isEssential) {
                parent.addMustSucceedBlocks(1, container);
            } else {
                parent.addBlock(container);
            }
            parent.notifyClients(container, context);
        }
    }

    @Override
    public void onFailure(LowLevelGetException e, Object reqTokenIgnored, ObjectContainer container, ClientContext context) {
        switch (e.code) {
            case 4: {
                this.onFailure(new FetchException(13), false, container, context);
                return;
            }
            case 2: {
                this.onFailure(new FetchException(13), false, container, context);
                return;
            }
            case 10: {
                this.onFailure(new FetchException(30), false, container, context);
                return;
            }
            case 1: {
                this.onFailure(new FetchException(6), false, container, context);
                return;
            }
            case 3: {
                this.onFailure(new FetchException(17), false, container, context);
                return;
            }
            case 6: {
                this.onFailure(new FetchException(15), false, container, context);
                return;
            }
            case 5: {
                this.onFailure(new FetchException(14), false, container, context);
                return;
            }
            case 7: {
                this.onFailure(new FetchException(18), false, container, context);
                return;
            }
            case 8: {
                this.onFailure(new FetchException(6), false, container, context);
                return;
            }
            case 9: {
                this.onFailure(new FetchException(25), false, container, context);
                return;
            }
        }
        Logger.error(this, "Unknown LowLevelGetException code: " + e.code);
        this.onFailure(new FetchException(17), false, container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFailure(FetchException e, boolean forceFatal, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.rcb, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "onFailure( " + e + " , " + forceFatal + ")", (Throwable)e);
        }
        if (this.parent.isCancelled() || this.cancelled) {
            if (logMINOR) {
                Logger.minor(this, "Failing: cancelled");
            }
            e = new FetchException(25);
            forceFatal = true;
        }
        if (!e.isFatal() && !forceFatal && this.retry(container, context)) {
            if (logMINOR) {
                Logger.minor(this, "Retrying");
            }
            return;
        }
        this.unregisterAll(container, context);
        SimpleSingleFileFetcher simpleSingleFileFetcher = this;
        synchronized (simpleSingleFileFetcher) {
            this.finished = true;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (e.isFatal() || forceFatal) {
            this.parent.fatallyFailedBlock(container, context);
        } else {
            this.parent.failedBlock(container, context);
        }
        this.rcb.onFailure(e, this, container, context);
    }

    protected void onSuccess(FetchResult data, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.rcb, 1);
        }
        if (this.parent.isCancelled()) {
            data.asBucket().free();
            if (this.persistent) {
                data.asBucket().removeFrom(container);
            }
            this.onFailure(new FetchException(25), false, container, context);
            return;
        }
        this.rcb.onSuccess(new SingleFileStreamGenerator(data.asBucket(), this.persistent), data.getMetadata(), null, this, container, context);
    }

    @Override
    public void onSuccess(ClientKeyBlock block, boolean fromStore, Object reqTokenIgnored, ObjectContainer container, ClientContext context) {
        Bucket data;
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        if (this.parent instanceof ClientGetter) {
            ((ClientGetter)this.parent).addKeyToBinaryBlob(block, container, context);
        }
        if ((data = this.extract(block, container, context)) == null) {
            return;
        }
        context.uskManager.checkUSK(this.key.getURI(), fromStore, container, block.isMetadata());
        if (!block.isMetadata()) {
            this.onSuccess(new FetchResult(new ClientMetadata(null), data), container, context);
        } else {
            this.onFailure(new FetchException(4, "Metadata where expected data"), false, container, context);
        }
    }

    protected Bucket extract(ClientKeyBlock block, ObjectContainer container, ClientContext context) {
        Bucket data;
        try {
            data = block.decode(context.getBucketFactory(this.parent.persistent()), (int)Math.min(this.ctx.maxOutputLength, Integer.MAX_VALUE), false);
        }
        catch (KeyDecodeException e1) {
            if (logMINOR) {
                Logger.minor(this, "Decode failure: " + e1, (Throwable)e1);
            }
            this.onFailure(new FetchException(6, e1.getMessage()), false, container, context);
            return null;
        }
        catch (TooBigException e) {
            this.onFailure(new FetchException(21, (Throwable)e), false, container, context);
            return null;
        }
        catch (IOException e) {
            Logger.error(this, "Could not capture data - disk full?: " + e, (Throwable)e);
            this.onFailure(new FetchException(12, (Throwable)e), false, container, context);
            return null;
        }
        return data;
    }

    @Override
    public long getToken() {
        return this.token;
    }

    @Override
    public void onFailed(KeyListenerConstructionException e, ObjectContainer container, ClientContext context) {
        this.onFailure(e.getFetchException(), false, container, context);
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        super.removeFrom(container, context);
    }

    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        super.cancel(container, context);
        if (this.persistent) {
            container.activate((Object)this.rcb, 1);
        }
        this.rcb.onFailure(new FetchException(25), this, container, context);
    }

    @Override
    protected void notFoundInStore(ObjectContainer container, ClientContext context) {
        this.onFailure(new FetchException(13), true, container, context);
    }

    @Override
    protected void onBlockDecodeError(Object token, ObjectContainer container, ClientContext context) {
        this.onFailure(new FetchException(6, "Could not decode block with the URI given, probably invalid as inserted, possible the URI is wrong"), true, container, context);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

