/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveContext;
import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.InsertContext;
import freenet.client.Metadata;
import freenet.client.MetadataParseException;
import freenet.client.async.BlockSet;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientRequester;
import freenet.client.async.GetCompletionCallback;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.SplitFileFetcherCrossSegment;
import freenet.client.async.SplitFileFetcherKeyListener;
import freenet.client.async.SplitFileFetcherSegment;
import freenet.client.async.SplitFileSegmentKeys;
import freenet.client.async.SplitFileStreamGenerator;
import freenet.node.SendableGet;
import freenet.support.BinaryBloomFilter;
import freenet.support.BloomFilter;
import freenet.support.CountingBloomFilter;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.compress.Compressor;
import freenet.support.io.FileUtil;
import freenet.support.math.MersenneTwister;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SplitFileFetcher
implements ClientGetState,
HasKeyListener {
    private static volatile boolean logMINOR;
    final FetchContext fetchContext;
    final FetchContext blockFetchContext;
    final boolean deleteFetchContext;
    final ArchiveContext archiveContext;
    final List<? extends Compressor> decompressors;
    final ClientMetadata clientMetadata;
    final ClientRequester parent;
    final GetCompletionCallback cb;
    final int recursionLevel;
    final short splitfileType;
    final int blocksPerSegment;
    final int checkBlocksPerSegment;
    final int deductBlocksFromSegments;
    final int segmentCount;
    final SplitFileFetcherSegment[] segments;
    final long maxTempLength;
    private boolean allSegmentsFinished;
    private final long overrideLength;
    private boolean finished;
    private long token;
    final boolean persistent;
    private FetchException otherFailure;
    final boolean realTimeFlag;
    private final int hashCode;
    File mainBloomFile;
    File altBloomFile;
    CountingBloomFilter cachedMainBloomFilter;
    BinaryBloomFilter[] cachedSegmentBloomFilters;
    final int mainBloomFilterSizeBytes;
    static final int DEFAULT_MAIN_BLOOM_ELEMENTS_PER_KEY = 19;
    final int mainBloomK;
    static final double ACCEPTABLE_BLOOM_FALSE_POSITIVES_ALL_SEGMENTS = 0.01;
    final int perSegmentBloomFilterSizeBytes;
    final int perSegmentK;
    private int keyCount;
    private final byte[] localSalt;
    private transient SplitFileFetcherKeyListener tempListener;
    private final int crossCheckBlocks;
    private final SplitFileFetcherCrossSegment[] crossSegments;
    private boolean toRemove = false;
    private boolean removed = false;

    public int hashCode() {
        return this.hashCode;
    }

    public SplitFileFetcher(Metadata metadata, GetCompletionCallback rcb, ClientRequester parent2, FetchContext newCtx, boolean deleteFetchContext, boolean realTimeFlag, List<? extends Compressor> decompressors2, ClientMetadata clientMetadata, ArchiveContext actx, int recursionLevel, long token2, boolean topDontCompress, short topCompatibilityMode, ObjectContainer container, ClientContext context) throws FetchException, MetadataParseException {
        int hash;
        this.persistent = parent2.persistent();
        this.realTimeFlag = realTimeFlag;
        this.deleteFetchContext = deleteFetchContext;
        if (logMINOR) {
            Logger.minor(this, "Persistence = " + this.persistent + " from " + parent2, (Throwable)new Exception("debug"));
        }
        if ((hash = super.hashCode()) == 0) {
            hash = 1;
        }
        this.hashCode = hash;
        this.finished = false;
        this.fetchContext = newCtx;
        if (newCtx == null) {
            throw new NullPointerException();
        }
        this.archiveContext = actx;
        this.blockFetchContext = new FetchContext(this.fetchContext, 1, true, null);
        ArrayList arrayList = this.decompressors = this.persistent ? new ArrayList(decompressors2) : decompressors2;
        if (this.decompressors.size() > 1) {
            Logger.error(this, "Multiple decompressors: " + this.decompressors.size() + " - this is almost certainly a bug", (Throwable)new Exception("debug"));
        }
        this.clientMetadata = clientMetadata == null ? new ClientMetadata() : clientMetadata.clone();
        this.cb = rcb;
        this.recursionLevel = recursionLevel + 1;
        this.parent = parent2;
        this.localSalt = new byte[32];
        context.random.nextBytes(this.localSalt);
        if (parent2.isCancelled()) {
            throw new FetchException(25);
        }
        this.overrideLength = metadata.dataLength();
        this.splitfileType = metadata.getSplitfileType();
        SplitFileSegmentKeys[] segmentKeys = metadata.grabSegmentKeys(container);
        if (this.persistent) {
            metadata.clearSplitfileKeys();
            container.store((Object)metadata);
        }
        long eventualLength = Math.max(this.overrideLength, metadata.uncompressedDataLength());
        boolean wasActive = true;
        if (this.persistent && !(wasActive = container.ext().isActive((Object)this.cb))) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onExpectedSize(eventualLength, container, context);
        if (metadata.uncompressedDataLength() > 0L) {
            this.cb.onFinalizedMetadata(container);
        }
        if (!wasActive) {
            container.deactivate((Object)this.cb, 1);
        }
        if (eventualLength > 0L && newCtx.maxOutputLength > 0L && eventualLength > newCtx.maxOutputLength) {
            throw new FetchException(21, eventualLength, true, clientMetadata.getMIMEType());
        }
        this.token = token2;
        InsertContext.CompatibilityMode minCompatMode = metadata.getMinCompatMode();
        InsertContext.CompatibilityMode maxCompatMode = metadata.getMaxCompatMode();
        int crossCheckBlocks = metadata.getCrossCheckBlocks();
        this.blocksPerSegment = metadata.getDataBlocksPerSegment();
        this.checkBlocksPerSegment = metadata.getCheckBlocksPerSegment();
        int splitfileDataBlocks = 0;
        int splitfileCheckBlocks = 0;
        for (SplitFileSegmentKeys keys : segmentKeys) {
            splitfileDataBlocks += keys.getDataBlocks();
            splitfileCheckBlocks += keys.getCheckBlocks();
        }
        if (this.splitfileType == 0) {
            if (splitfileCheckBlocks > 0) {
                Logger.error(this, "Splitfile type is SPLITFILE_NONREDUNDANT yet " + splitfileCheckBlocks + " check blocks found!! : " + this);
                throw new FetchException(4, "Splitfile type is non-redundant yet have " + splitfileCheckBlocks + " check blocks");
            }
        } else if (this.splitfileType == 1) {
            boolean dontCompress = this.decompressors.isEmpty();
            if (topCompatibilityMode != 0) {
                if (minCompatMode == InsertContext.CompatibilityMode.COMPAT_UNKNOWN || minCompatMode.ordinal() <= topCompatibilityMode && maxCompatMode.ordinal() >= topCompatibilityMode) {
                    minCompatMode = maxCompatMode = InsertContext.CompatibilityMode.values()[topCompatibilityMode];
                    dontCompress = topDontCompress;
                } else {
                    throw new FetchException(4, "Top compatibility mode is incompatible with detected compatibility mode");
                }
            }
            this.cb.onSplitfileCompatibilityMode(minCompatMode, maxCompatMode, metadata.getCustomSplitfileKey(), dontCompress, true, topCompatibilityMode != 0, container, context);
            if (this.blocksPerSegment > this.fetchContext.maxDataBlocksPerSegment || this.checkBlocksPerSegment > this.fetchContext.maxCheckBlocksPerSegment) {
                throw new FetchException(23, "Too many blocks per segment: " + this.blocksPerSegment + " data, " + this.checkBlocksPerSegment + " check");
            }
        } else {
            throw new MetadataParseException("Unknown splitfile format: " + this.splitfileType);
        }
        this.segmentCount = metadata.getSegmentCount();
        this.maxTempLength = this.fetchContext.maxTempLength;
        if (logMINOR) {
            Logger.minor(this, "Algorithm: " + this.splitfileType + ", blocks per segment: " + this.blocksPerSegment + ", check blocks per segment: " + this.checkBlocksPerSegment + ", segments: " + this.segmentCount + ", data blocks: " + splitfileDataBlocks + ", check blocks: " + splitfileCheckBlocks);
        }
        this.segments = new SplitFileFetcherSegment[this.segmentCount];
        this.crossCheckBlocks = crossCheckBlocks;
        long finalLength = 1L * (long)(splitfileDataBlocks - this.segmentCount * crossCheckBlocks) * 32768L;
        if (finalLength > this.overrideLength) {
            if (finalLength - this.overrideLength > 32768L) {
                throw new FetchException(4, "Splitfile is " + finalLength + " but length is " + finalLength);
            }
            finalLength = this.overrideLength;
        }
        this.mainBloomFile = null;
        this.altBloomFile = null;
        int mainElementsPerKey = 19;
        int origSize = splitfileDataBlocks + splitfileCheckBlocks;
        this.mainBloomK = (int)((double)mainElementsPerKey * 0.7);
        long elementsLong = origSize * mainElementsPerKey;
        if (elementsLong > Integer.MAX_VALUE) {
            throw new FetchException(21, "Cannot fetch splitfiles with more than " + Integer.MAX_VALUE / mainElementsPerKey + " keys! (approx 3.3TB)");
        }
        int mainSizeBits = (int)elementsLong;
        mainSizeBits = mainSizeBits + 7 & 0xFFFFFFF8;
        this.mainBloomFilterSizeBytes = mainSizeBits / 8 * 2;
        double acceptableFalsePositives = 0.01 / (double)this.segments.length;
        int perSegmentBitsPerKey = (int)Math.ceil(Math.log(acceptableFalsePositives) / Math.log(0.6185));
        int segBlocks = this.blocksPerSegment + this.checkBlocksPerSegment;
        if (segBlocks > origSize) {
            segBlocks = origSize;
        }
        int perSegmentSize = perSegmentBitsPerKey * segBlocks;
        perSegmentSize = perSegmentSize + 7 & 0xFFFFFFF8;
        this.perSegmentBloomFilterSizeBytes = perSegmentSize / 8;
        this.perSegmentK = BloomFilter.optimialK(perSegmentSize, segBlocks);
        this.keyCount = origSize;
        if (logMINOR) {
            Logger.minor(this, "Creating block filter for " + this + ": keys=" + (splitfileDataBlocks + splitfileCheckBlocks) + " main bloom size " + this.mainBloomFilterSizeBytes + " bytes, K=" + this.mainBloomK + ", filename=" + this.mainBloomFile + " alt bloom filter: filename=" + this.altBloomFile + " segments: " + this.segments.length + " each is " + this.perSegmentBloomFilterSizeBytes + " bytes k=" + this.perSegmentK);
        }
        try {
            this.tempListener = new SplitFileFetcherKeyListener(this, this.keyCount, this.mainBloomFile, this.altBloomFile, this.mainBloomFilterSizeBytes, this.mainBloomK, this.localSalt, this.segments.length, this.perSegmentBloomFilterSizeBytes, this.perSegmentK, this.persistent, true, null, null, container, false, realTimeFlag);
        }
        catch (IOException e) {
            throw new FetchException(12, "Unable to write Bloom filters for splitfile");
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        boolean pre1254 = minCompatMode != InsertContext.CompatibilityMode.COMPAT_CURRENT && minCompatMode.ordinal() < InsertContext.CompatibilityMode.COMPAT_1255.ordinal();
        boolean pre1250 = minCompatMode == InsertContext.CompatibilityMode.COMPAT_UNKNOWN || minCompatMode == InsertContext.CompatibilityMode.COMPAT_1250_EXACT;
        int maxRetries = this.blockFetchContext.maxSplitfileBlockRetries;
        byte cryptoAlgorithm = metadata.getSplitfileCryptoAlgorithm();
        byte[] splitfileCryptoKey = metadata.getSplitfileCryptoKey();
        for (int i = 0; i < this.segments.length; ++i) {
            SplitFileSegmentKeys keys = segmentKeys[i];
            int dataBlocks = keys.getDataBlocks();
            int checkBlocks = keys.getCheckBlocks();
            if (dataBlocks > this.fetchContext.maxDataBlocksPerSegment || checkBlocks > this.fetchContext.maxCheckBlocksPerSegment) {
                throw new FetchException(23, "Too many blocks per segment: " + this.blocksPerSegment + " data, " + this.checkBlocksPerSegment + " check");
            }
            this.segments[i] = new SplitFileFetcherSegment(this.splitfileType, keys, this, this.archiveContext, this.blockFetchContext, this.maxTempLength, recursionLevel, this.parent, i, pre1250, pre1254, crossCheckBlocks, cryptoAlgorithm, splitfileCryptoKey, maxRetries, realTimeFlag);
            int data = keys.getDataBlocks();
            int check = keys.getCheckBlocks();
            for (int j = 0; j < data + check; ++j) {
                this.tempListener.addKey(keys.getKey(j, null, false).getNodeKey(false), i, context);
            }
            if (!this.persistent) continue;
            container.store((Object)this.segments[i]);
            this.segments[i].deactivateKeys(container);
        }
        int totalCrossCheckBlocks = this.segments.length * crossCheckBlocks;
        this.parent.addMustSucceedBlocks(splitfileDataBlocks - totalCrossCheckBlocks, container);
        this.parent.addBlocks(splitfileCheckBlocks + totalCrossCheckBlocks, container);
        this.parent.notifyClients(container, context);
        this.deductBlocksFromSegments = metadata.getDeductBlocksFromSegments();
        if (crossCheckBlocks != 0) {
            MersenneTwister random = new MersenneTwister(Metadata.getCrossSegmentSeed(metadata.getHashes(), metadata.getHashThisLayerOnly()));
            this.crossSegments = new SplitFileFetcherCrossSegment[this.segments.length];
            int segLen = this.blocksPerSegment;
            for (int i = 0; i < this.crossSegments.length; ++i) {
                int j;
                SplitFileFetcherCrossSegment seg;
                Logger.normal(this, "Allocating blocks (on fetch) for cross segment " + i);
                if (this.segments.length - i == this.deductBlocksFromSegments) {
                    --segLen;
                }
                this.crossSegments[i] = seg = new SplitFileFetcherCrossSegment(this.persistent, segLen, crossCheckBlocks, this.parent, this, metadata.getSplitfileType());
                for (j = 0; j < segLen; ++j) {
                    this.allocateCrossDataBlock(seg, (Random)((Object)random));
                }
                for (j = 0; j < crossCheckBlocks; ++j) {
                    this.allocateCrossCheckBlock(seg, (Random)((Object)random));
                }
                if (!this.persistent) continue;
                seg.storeTo(container);
            }
        } else {
            this.crossSegments = null;
        }
        if (this.persistent) {
            for (SplitFileFetcherSegment seg : this.segments) {
                if (crossCheckBlocks != 0) {
                    container.store((Object)seg);
                }
                container.deactivate((Object)seg, 1);
            }
        }
        try {
            this.tempListener.writeFilters(container, "construction");
        }
        catch (IOException e) {
            throw new FetchException(12, "Unable to write Bloom filters for splitfile");
        }
    }

    private void allocateCrossDataBlock(SplitFileFetcherCrossSegment segment, Random random) {
        int blockNum;
        SplitFileFetcherSegment seg;
        int i;
        int x = 0;
        for (i = 0; i < 10; ++i) {
            x = random.nextInt(this.segments.length);
            seg = this.segments[x];
            blockNum = seg.allocateCrossDataBlock(segment, random);
            if (blockNum < 0) continue;
            segment.addDataBlock(seg, blockNum);
            return;
        }
        for (i = 0; i < this.segments.length; ++i) {
            if (++x == this.segments.length) {
                x = 0;
            }
            if ((blockNum = (seg = this.segments[x]).allocateCrossDataBlock(segment, random)) < 0) continue;
            segment.addDataBlock(seg, blockNum);
            return;
        }
        throw new IllegalStateException("Unable to allocate cross data block!");
    }

    private void allocateCrossCheckBlock(SplitFileFetcherCrossSegment segment, Random random) {
        int blockNum;
        SplitFileFetcherSegment seg;
        int i;
        int x = 0;
        for (i = 0; i < 10; ++i) {
            x = random.nextInt(this.segments.length);
            seg = this.segments[x];
            blockNum = seg.allocateCrossCheckBlock(segment, random);
            if (blockNum < 0) continue;
            segment.addDataBlock(seg, blockNum);
            return;
        }
        for (i = 0; i < this.segments.length; ++i) {
            if (++x == this.segments.length) {
                x = 0;
            }
            if ((blockNum = (seg = this.segments[x]).allocateCrossCheckBlock(segment, random)) < 0) continue;
            segment.addDataBlock(seg, blockNum);
            return;
        }
        throw new IllegalStateException("Unable to allocate cross data block!");
    }

    private SplitFileStreamGenerator finalStatus(ObjectContainer container, ClientContext context) throws FetchException {
        long length = 0L;
        for (int i = 0; i < this.segments.length; ++i) {
            SplitFileFetcherSegment s = this.segments[i];
            if (this.persistent) {
                container.activate((Object)s, 1);
            }
            if (!s.succeeded()) {
                throw new IllegalStateException("Not all finished");
            }
            s.throwError(container);
            long sz = s.decodedLength(container);
            length += sz;
            if (!logMINOR) continue;
            Logger.minor(this, "Segment " + i + " decoded length " + sz + " total length now " + length + " for " + s.dataBuckets.length + " blocks which should be " + s.dataBuckets.length * 32768);
        }
        if (length > this.overrideLength) {
            if (length - this.overrideLength > 32768L) {
                throw new FetchException(4, "Splitfile is " + length + " but length is " + length);
            }
            length = this.overrideLength;
        }
        SplitFileStreamGenerator streamGenerator = new SplitFileStreamGenerator(this.segments, length, this.crossCheckBlocks);
        return streamGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void segmentFinished(SplitFileFetcherSegment segment, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Finished segment: " + segment);
        }
        boolean finish = false;
        SplitFileFetcher splitFileFetcher = this;
        synchronized (splitFileFetcher) {
            int i;
            boolean allDone = true;
            for (i = 0; i < this.segments.length; ++i) {
                if (this.persistent) {
                    container.activate((Object)this.segments[i], 1);
                }
                if (this.segments[i].succeeded()) continue;
                if (logMINOR) {
                    Logger.minor(this, "Segment " + this.segments[i] + " is not finished");
                }
                allDone = false;
            }
            if (allDone) {
                if (this.allSegmentsFinished) {
                    if (logMINOR) {
                        Logger.minor(this, "Was already finished! (segmentFinished(" + segment + ')', (Throwable)new Exception("debug"));
                    }
                } else {
                    this.allSegmentsFinished = true;
                    finish = true;
                }
            } else {
                for (i = 0; i < this.segments.length; ++i) {
                    if (this.segments[i] == segment || !this.persistent) continue;
                    container.deactivate((Object)this.segments[i], 1);
                }
            }
            this.notifyAll();
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (finish) {
            this.finish(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        context.getChkFetchScheduler(this.realTimeFlag).removePendingKeys(this, true);
        boolean cbWasActive = true;
        SplitFileStreamGenerator data = null;
        try {
            SplitFileFetcher splitFileFetcher = this;
            synchronized (splitFileFetcher) {
                block15: {
                    if (this.otherFailure != null) {
                        throw this.otherFailure;
                    }
                    if (!this.finished) break block15;
                    Logger.error(this, "Was already finished");
                    return;
                }
                this.finished = true;
            }
            context.jobRunner.setCommitThisTransaction();
            if (this.persistent) {
                container.store((Object)this);
            }
            data = this.finalStatus(container, context);
            this.cb.onSuccess(data, this.clientMetadata, this.decompressors, this, container, context);
        }
        catch (FetchException e) {
            this.cb.onFailure(e, this, container, context);
        }
        finally {
            if (!cbWasActive) {
                container.deactivate((Object)this.cb, 1);
            }
        }
        if (this.crossCheckBlocks != 0 && !this.persistent) {
            this.finishSegments(container, context);
        }
    }

    @Override
    public void schedule(ObjectContainer container, ClientContext context) throws KeyListenerConstructionException {
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Scheduling " + this);
        }
        SendableGet[] getters = new SendableGet[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            if (logMINOR) {
                Logger.minor(this, "Scheduling segment " + i + " : " + this.segments[i]);
            }
            if (this.persistent) {
                container.activate((Object)this.segments[i], 1);
            }
            getters[i] = this.segments[i].schedule(container, context);
            if (!this.persistent) continue;
            container.deactivate((Object)this.segments[i], 1);
        }
        BlockSet blocks = this.fetchContext.blocks;
        context.getChkFetchScheduler(this.realTimeFlag).register(this, getters, this.persistent, container, blocks, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        boolean persist = this.persistent;
        if (persist) {
            container.activate((Object)this, 1);
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (logMINOR) {
                Logger.minor(this, "Cancelling segment " + i);
            }
            if (this.segments == null && persist && !container.ext().isActive((Object)this)) {
                Logger.error(this, "Deactivated mid-cancel on " + this, (Throwable)new Exception("error"));
                container.activate((Object)this, 1);
            }
            if (this.segments[i] == null) {
                SplitFileFetcher splitFileFetcher = this;
                synchronized (splitFileFetcher) {
                    if (this.finished) {
                        if (logMINOR) {
                            Logger.minor(this, "Finished mid-cancel on " + this);
                        }
                        return;
                    }
                    Logger.error(this, "Segment " + i + " is null on " + this + " but not finished?!");
                    continue;
                }
            }
            if (persist) {
                container.activate((Object)this.segments[i], 1);
            }
            this.segments[i].cancel(container, context);
        }
    }

    public boolean realTimeFlag() {
        return this.realTimeFlag;
    }

    @Override
    public long getToken() {
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyListener makeKeyListener(ObjectContainer container, ClientContext context, boolean onStartup) throws KeyListenerConstructionException {
        SplitFileFetcher splitFileFetcher = this;
        synchronized (splitFileFetcher) {
            File alt;
            File main;
            if (this.finished) {
                return null;
            }
            if (this.tempListener != null) {
                return this.tempListener;
            }
            if (this.fetchContext == null) {
                Logger.error(this, "fetchContext deleted without splitfile being deleted!");
                return null;
            }
            if (this.persistent) {
                container.activate((Object)this.mainBloomFile, 5);
                container.activate((Object)this.altBloomFile, 5);
                if (this.mainBloomFile != null) {
                    main = new File(this.mainBloomFile.getPath());
                    container.delete((Object)this.mainBloomFile);
                    this.mainBloomFile = null;
                    if (this.persistent) {
                        container.store((Object)this);
                    }
                } else {
                    main = null;
                }
                if (this.altBloomFile != null) {
                    alt = new File(this.altBloomFile.getPath());
                    container.delete((Object)this.altBloomFile);
                    this.altBloomFile = null;
                    if (this.persistent) {
                        container.store((Object)this);
                    }
                } else {
                    alt = null;
                }
                container.deactivate((Object)this.mainBloomFile, 1);
                container.deactivate((Object)this.altBloomFile, 1);
            } else {
                main = null;
                alt = null;
            }
            try {
                if (logMINOR) {
                    Logger.minor(this, "Attempting to read Bloom filter for " + this + " main file=" + main + " alt file=" + alt);
                }
                this.tempListener = new SplitFileFetcherKeyListener(this, this.keyCount, main, alt, this.mainBloomFilterSizeBytes, this.mainBloomK, this.localSalt, this.segments.length, this.perSegmentBloomFilterSizeBytes, this.perSegmentK, this.persistent, false, this.cachedMainBloomFilter, this.cachedSegmentBloomFilters, container, onStartup, this.realTimeFlag);
                if (main != null) {
                    try {
                        FileUtil.secureDelete(main);
                    }
                    catch (IOException e) {
                        System.err.println("Failed to delete old bloom filter file: " + main + " - this may leak information about a download : " + e);
                        e.printStackTrace();
                    }
                }
                if (alt != null) {
                    try {
                        FileUtil.secureDelete(alt);
                    }
                    catch (IOException e) {
                        System.err.println("Failed to delete old segment filters file: " + alt + " - this may leak information about a download : " + e);
                    }
                }
            }
            catch (IOException e) {
                Logger.error(this, "Unable to read Bloom filter for " + this + " attempting to reconstruct...", (Throwable)e);
                try {
                    FileUtil.secureDelete(main);
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    FileUtil.secureDelete(alt);
                }
                catch (IOException e2) {
                    // empty catch block
                }
                this.mainBloomFile = null;
                this.altBloomFile = null;
                if (this.persistent) {
                    container.store((Object)this);
                }
                try {
                    this.tempListener = new SplitFileFetcherKeyListener(this, this.keyCount, this.mainBloomFile, this.altBloomFile, this.mainBloomFilterSizeBytes, this.mainBloomK, this.localSalt, this.segments.length, this.perSegmentBloomFilterSizeBytes, this.perSegmentK, this.persistent, true, this.cachedMainBloomFilter, this.cachedSegmentBloomFilters, container, onStartup, this.realTimeFlag);
                }
                catch (IOException e1) {
                    throw new KeyListenerConstructionException(new FetchException(12, "Unable to reconstruct Bloom filters: " + e1, e1));
                }
            }
            return this.tempListener;
        }
    }

    @Override
    public synchronized boolean isCancelled(ObjectContainer container) {
        return this.finished;
    }

    public SplitFileFetcherSegment getSegment(int i) {
        return this.segments[i];
    }

    public void removeMyPendingKeys(SplitFileFetcherSegment segment, ObjectContainer container, ClientContext context) {
        this.keyCount = this.tempListener.killSegment(segment, container, context);
    }

    void setKeyCount(int keyCount2, ObjectContainer container) {
        this.keyCount = keyCount2;
        if (this.persistent) {
            container.store((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailed(FetchException e, ObjectContainer container, ClientContext context) {
        SplitFileFetcher splitFileFetcher = this;
        synchronized (splitFileFetcher) {
            if (this.finished) {
                return;
            }
            this.otherFailure = e;
        }
        this.cancel(container, context);
    }

    @Override
    public void onFailed(KeyListenerConstructionException e, ObjectContainer container, ClientContext context) {
        this.onFailed(e.getFetchException(), container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        SplitFileFetcher splitFileFetcher = this;
        synchronized (splitFileFetcher) {
            this.toRemove = true;
            if (this.removed) {
                return;
            }
        }
        if (this.crossCheckBlocks > 0) {
            boolean allGone = true;
            for (int i = 0; i < this.crossSegments.length; ++i) {
                if (this.crossSegments[i] == null) continue;
                boolean active = true;
                if (this.persistent && !(active = container.ext().isActive((Object)this.crossSegments[i]))) {
                    container.activate((Object)this.crossSegments[i], 1);
                }
                this.crossSegments[i].preRemove(container, context);
                if (!this.crossSegments[i].isFinished()) {
                    allGone = false;
                    if (logMINOR) {
                        Logger.minor(this, "Waiting for " + this.crossSegments[i] + " in removeFrom()");
                    }
                }
                if (active) continue;
                container.deactivate((Object)this.crossSegments[i], 1);
            }
            if (!allGone) {
                container.store((Object)this);
                return;
            }
        }
        this.innerRemoveFrom(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void innerRemoveFrom(ObjectContainer container, ClientContext context) {
        SplitFileFetcher splitFileFetcher = this;
        synchronized (splitFileFetcher) {
            if (this.removed) {
                Logger.error(this, "innerRemoveFrom() called twice", (Throwable)new Exception("error"));
                return;
            }
            this.removed = true;
        }
        if (logMINOR) {
            Logger.minor(this, "removeFrom() on " + this, (Throwable)new Exception("debug"));
        }
        if (!container.ext().isStored((Object)this)) {
            return;
        }
        container.activate((Object)this.blockFetchContext, 1);
        this.blockFetchContext.removeFrom(container);
        if (this.deleteFetchContext) {
            container.activate((Object)this.fetchContext, 1);
            this.fetchContext.removeFrom(container);
        }
        container.activate((Object)this.clientMetadata, 1);
        this.clientMetadata.removeFrom(container);
        container.activate(this.decompressors, 1);
        container.delete(this.decompressors);
        this.finishSegments(container, context);
        if (this.crossCheckBlocks != 0) {
            for (int i = 0; i < this.crossSegments.length; ++i) {
                SplitFileFetcherCrossSegment segment = this.crossSegments[i];
                this.crossSegments[i] = null;
                container.activate((Object)segment, 1);
                segment.removeFrom(container, context);
            }
        }
        container.activate((Object)this.mainBloomFile, 5);
        container.activate((Object)this.altBloomFile, 5);
        if (this.mainBloomFile != null && !this.mainBloomFile.delete() && this.mainBloomFile.exists()) {
            Logger.error(this, "Unable to delete main bloom file: " + this.mainBloomFile + " for " + this);
        }
        if (this.altBloomFile != null && !this.altBloomFile.delete() && this.altBloomFile.exists()) {
            Logger.error(this, "Unable to delete alt bloom file: " + this.altBloomFile + " for " + this);
        }
        container.delete((Object)this.mainBloomFile);
        container.delete((Object)this.altBloomFile);
        container.activate((Object)this.cachedMainBloomFilter, Integer.MAX_VALUE);
        this.cachedMainBloomFilter.removeFrom(container);
        for (int i = 0; i < this.cachedSegmentBloomFilters.length; ++i) {
            container.activate((Object)this.cachedSegmentBloomFilters[i], Integer.MAX_VALUE);
            this.cachedSegmentBloomFilters[i].removeFrom(container);
        }
        container.delete((Object)this);
    }

    private void finishSegments(ObjectContainer container, ClientContext context) {
        for (int i = 0; i < this.segments.length; ++i) {
            SplitFileFetcherSegment segment = this.segments[i];
            this.segments[i] = null;
            if (this.persistent) {
                container.activate((Object)segment, 1);
            }
            if (segment == null) continue;
            segment.fetcherFinished(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean objectCanUpdate(ObjectContainer container) {
        if (this.hashCode == 0) {
            Logger.error(this, "Trying to update with hash 0 => already deleted! active=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), (Throwable)new Exception("error"));
            return false;
        }
        SplitFileFetcher splitFileFetcher = this;
        synchronized (splitFileFetcher) {
            if (this.removed) {
                Logger.error(this, "Trying to write but already removed", (Throwable)new Exception("error"));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean objectCanNew(ObjectContainer container) {
        if (this.hashCode == 0) {
            Logger.error(this, "Trying to write with hash 0 => already deleted! active=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), (Throwable)new Exception("error"));
            return false;
        }
        SplitFileFetcher splitFileFetcher = this;
        synchronized (splitFileFetcher) {
            if (this.removed) {
                Logger.error(this, "Trying to write but already removed", (Throwable)new Exception("error"));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onFinishedCrossSegment(ObjectContainer container, ClientContext context, SplitFileFetcherCrossSegment seg) {
        boolean allGone = true;
        for (int i = 0; i < this.crossSegments.length; ++i) {
            if (this.crossSegments[i] == null) continue;
            boolean active = true;
            if (this.persistent && !(active = container.ext().isActive((Object)this.crossSegments[i]))) {
                container.activate((Object)this.crossSegments[i], 1);
            }
            if (!this.crossSegments[i].isFinished()) {
                allGone = false;
                if (logMINOR) {
                    Logger.minor(this, "Waiting for " + this.crossSegments[i]);
                }
            }
            if (!active) {
                container.deactivate((Object)this.crossSegments[i], 1);
            }
            if (!allGone) break;
        }
        SplitFileFetcher splitFileFetcher = this;
        synchronized (splitFileFetcher) {
            if (this.persistent && !this.toRemove) {
                return false;
            }
        }
        if (allGone) {
            if (this.persistent) {
                this.innerRemoveFrom(container, context);
            } else {
                this.finishSegments(container, context);
            }
            return true;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        return false;
    }

    public void setCachedMainFilter(CountingBloomFilter filter) {
        this.cachedMainBloomFilter = filter;
    }

    public void setCachedSegFilters(BinaryBloomFilter[] segmentFilters) {
        this.cachedSegmentBloomFilters = segmentFilters;
    }

    public SplitFileFetcherKeyListener getListener() {
        return this.tempListener;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

