/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveContext;
import freenet.client.FECCallback;
import freenet.client.FECCodec;
import freenet.client.FECJob;
import freenet.client.FECQueue;
import freenet.client.FailureCodeTracker;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.MetadataParseException;
import freenet.client.SplitfileBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.CooldownTrackerItem;
import freenet.client.async.HasCooldownCacheItem;
import freenet.client.async.HasCooldownTrackerItem;
import freenet.client.async.MinimalSplitfileBlock;
import freenet.client.async.PersistentChosenBlock;
import freenet.client.async.PersistentChosenRequest;
import freenet.client.async.SplitFileFetcher;
import freenet.client.async.SplitFileFetcherCrossSegment;
import freenet.client.async.SplitFileFetcherKeyListener;
import freenet.client.async.SplitFileFetcherSegmentGet;
import freenet.client.async.SplitFileFetcherSegmentSendableRequestItem;
import freenet.client.async.SplitFileFetcherSubSegment;
import freenet.client.async.SplitFileSegmentKeys;
import freenet.keys.CHKBlock;
import freenet.keys.CHKEncodeException;
import freenet.keys.CHKVerifyException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKeyBlock;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.KeyDecodeException;
import freenet.keys.NodeCHK;
import freenet.keys.TooBigException;
import freenet.node.KeysFetchingLocally;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.TimeUtil;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import freenet.support.io.MultiReaderBucket;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class SplitFileFetcherSegment
implements FECCallback,
HasCooldownTrackerItem {
    private static volatile boolean logMINOR;
    private static final boolean FORCE_CHECK_FEC_KEYS = true;
    final short splitfileType;
    SplitFileSegmentKeys keys;
    boolean[] foundKeys;
    ClientCHK[] dataKeys;
    ClientCHK[] checkKeys;
    final MinimalSplitfileBlock[] dataBuckets;
    final MinimalSplitfileBlock[] checkBuckets;
    final int[] dataRetries;
    final int[] checkRetries;
    final Vector<SplitFileFetcherSubSegment> subSegments;
    private SplitFileFetcherSegmentGet getter;
    final int minFetched;
    final SplitFileFetcher parentFetcher;
    final ClientRequester parent;
    final ArchiveContext archiveContext;
    final long maxBlockLength;
    private volatile boolean finished;
    private boolean startedDecode;
    private Bucket decodedData;
    final FetchContext blockFetchContext;
    final int recursionLevel;
    private FetchException failureException;
    private final boolean ignoreLastDataBlock;
    private int fatallyFailedBlocks;
    private int failedBlocks;
    private int fetchedBlocks;
    private int fetchedDataBlocks;
    final FailureCodeTracker errors;
    private boolean finishing;
    private boolean scheduled;
    private final boolean persistent;
    final int segNum;
    final boolean pre1254;
    final byte[] forceCryptoKey;
    final byte cryptoAlgorithm;
    private int maxRetries;
    private final int hashCode;
    private boolean fetcherFinished = false;
    private boolean fetcherHalfFinished = false;
    private boolean encoderFinished = false;
    final int crossCheckBlocks;
    private final SplitFileFetcherCrossSegment[] crossSegmentsByBlock;
    private transient int crossDataBlocksAllocated;
    private transient int crossCheckBlocksAllocated;
    private final boolean realTimeFlag;
    private int cachedCooldownTries;
    private long cachedCooldownTime;
    private transient FECCodec codec;
    private static final short ON_SUCCESS_DONT_NOTIFY = 1;
    private static final short ON_SUCCESS_ALL_FAILED = 2;
    private static final short ON_SUCCESS_DECODE_NOW = 4;
    private boolean createdBeforeRestart;

    public int hashCode() {
        return this.hashCode;
    }

    public SplitFileFetcherSegment(short splitfileType, SplitFileSegmentKeys keys, SplitFileFetcher fetcher, ArchiveContext archiveContext, FetchContext blockFetchContext, long maxTempLength, int recursionLevel, ClientRequester requester, int segNum, boolean ignoreLastDataBlock, boolean pre1254, int crossCheckBlocks, byte cryptoAlgorithm, byte[] forceCryptoKey, int maxRetries, boolean realTimeFlag) throws MetadataParseException, FetchException {
        int i;
        this.crossCheckBlocks = crossCheckBlocks;
        this.keys = keys;
        this.realTimeFlag = realTimeFlag;
        int dataBlocks = keys.getDataBlocks();
        int checkBlocks = keys.getCheckBlocks();
        this.foundKeys = new boolean[dataBlocks + checkBlocks];
        this.crossSegmentsByBlock = new SplitFileFetcherCrossSegment[dataBlocks];
        this.segNum = segNum;
        this.hashCode = super.hashCode();
        this.persistent = fetcher.persistent;
        this.parentFetcher = fetcher;
        this.ignoreLastDataBlock = ignoreLastDataBlock;
        this.errors = new FailureCodeTracker(false);
        this.archiveContext = archiveContext;
        this.splitfileType = splitfileType;
        this.maxRetries = maxRetries;
        this.parent = requester;
        this.dataKeys = null;
        this.checkKeys = null;
        if (splitfileType == 0) {
            this.minFetched = dataBlocks;
        } else if (splitfileType == 1) {
            this.minFetched = dataBlocks;
        } else {
            throw new MetadataParseException("Unknown splitfile type" + splitfileType);
        }
        this.finished = false;
        this.decodedData = null;
        this.dataBuckets = new MinimalSplitfileBlock[dataBlocks];
        this.checkBuckets = new MinimalSplitfileBlock[checkBlocks];
        for (i = 0; i < this.dataBuckets.length; ++i) {
            this.dataBuckets[i] = new MinimalSplitfileBlock(i);
        }
        for (i = 0; i < this.checkBuckets.length; ++i) {
            this.checkBuckets[i] = new MinimalSplitfileBlock(i + this.dataBuckets.length);
        }
        if (maxRetries != -1) {
            this.dataRetries = new int[dataBlocks];
            this.checkRetries = new int[checkBlocks];
        } else {
            this.dataRetries = null;
            this.checkRetries = null;
        }
        this.subSegments = null;
        this.getter = new SplitFileFetcherSegmentGet(this.parent, this, realTimeFlag);
        this.maxBlockLength = maxTempLength;
        this.blockFetchContext = blockFetchContext;
        this.recursionLevel = 0;
        if (logMINOR) {
            Logger.minor(this, "Created " + this + " for " + this.parentFetcher + " : " + this.dataBuckets.length + " data blocks " + this.checkBuckets.length + " check blocks");
        }
        this.pre1254 = pre1254;
        this.cryptoAlgorithm = cryptoAlgorithm;
        this.forceCryptoKey = forceCryptoKey;
    }

    public synchronized boolean isFinished(ObjectContainer container) {
        if (this.finished) {
            return true;
        }
        boolean deactivateParent = false;
        if (this.persistent) {
            boolean bl = deactivateParent = !container.ext().isActive((Object)this.parent);
            if (deactivateParent) {
                container.activate((Object)this.parent, 1);
            }
        }
        boolean ret = this.parent.isCancelled();
        if (deactivateParent) {
            container.deactivate((Object)this.parent, 1);
        }
        return ret;
    }

    public synchronized boolean succeeded() {
        return this.finished;
    }

    public synchronized boolean isFinishing(ObjectContainer container) {
        return this.isFinished(container) || this.finishing;
    }

    public synchronized void throwError(ObjectContainer container) throws FetchException {
        if (this.failureException != null) {
            if (this.persistent) {
                container.activate((Object)this.failureException, 5);
            }
            if (this.persistent) {
                throw this.failureException.clone();
            }
            throw this.failureException;
        }
    }

    public long decodedLength(ObjectContainer container) {
        if (this.decodedData != null) {
            if (this.persistent) {
                container.activate((Object)this.decodedData, 1);
            }
            return this.decodedData.size();
        }
        return (this.dataBuckets.length - this.crossCheckBlocks) * 32768;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeDecodedDataTo(OutputStream os, long truncateLength, ObjectContainer container) throws IOException {
        if (logMINOR) {
            Logger.minor(this, "Writing decoded data on " + this);
        }
        if (this.decodedData != null) {
            if (this.persistent) {
                container.activate((Object)this.decodedData, Integer.MAX_VALUE);
            }
            long len = this.decodedData.size();
            if (truncateLength >= 0L && truncateLength < len) {
                len = truncateLength;
            }
            BucketTools.copyTo(this.decodedData, os, Math.min(truncateLength, this.decodedData.size()));
            return len;
        }
        long totalCopied = 0L;
        byte[] buf = new byte[32768];
        for (int i = 0; i < this.dataBuckets.length - this.crossCheckBlocks; ++i) {
            long copy;
            Bucket data;
            MinimalSplitfileBlock status;
            if (logMINOR) {
                Logger.minor(this, "Copying data from block " + i);
            }
            if ((status = this.dataBuckets[i]) == null) {
                throw new NullPointerException();
            }
            boolean blockActive = true;
            if (this.persistent && !(blockActive = container.ext().isActive((Object)status))) {
                container.activate((Object)status, Integer.MAX_VALUE);
            }
            if ((data = status.getData()) == null) {
                throw new NullPointerException("Data bucket " + i + " of " + this.dataBuckets.length + " is null in writeDecodedData on " + this + " status = " + status + " number " + status.getNumber() + " data " + status.getData() + " persistence = " + this.persistent + (this.persistent ? " (block active = " + container.ext().isActive((Object)status) + " block ID = " + container.ext().getID((Object)status) + " seg active=" + container.ext().isActive((Object)this) + ")" : ""));
            }
            if (this.persistent) {
                container.activate((Object)data, 1);
            }
            if ((copy = truncateLength < 0L ? Long.MAX_VALUE : truncateLength - totalCopied) < 32768L) {
                buf = new byte[(int)copy];
            }
            InputStream is = data.getInputStream();
            try {
                DataInputStream dis = new DataInputStream(is);
                dis.readFully(buf);
            }
            finally {
                is.close();
            }
            os.write(buf);
            totalCopied += (long)buf.length;
            if (blockActive) continue;
            container.deactivate((Object)status, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Copied data (" + totalCopied + ")");
        }
        return totalCopied;
    }

    public synchronized int failedBlocks() {
        return this.failedBlocks;
    }

    public synchronized int fetchedBlocks() {
        return this.fetchedBlocks;
    }

    public synchronized int fatallyFailedBlocks() {
        return this.fatallyFailedBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short onSuccessInner(Bucket data, int blockNo, ObjectContainer container, ClientContext context) {
        SplitFileFetcherCrossSegment crossSegment = null;
        short res = 0;
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            boolean dontNotify;
            boolean tooSmall;
            boolean allFailed = false;
            boolean decodeNow = false;
            boolean wasDataBlock = false;
            if (this.finished) {
                if (logMINOR) {
                    Logger.minor(this, "onSuccess() when already finished for " + this);
                }
                data.free();
                if (this.persistent) {
                    data.removeFrom(container);
                }
                return -1;
            }
            if (blockNo < this.dataBuckets.length) {
                Bucket existingBlock;
                wasDataBlock = true;
                if (this.haveFoundKey(blockNo, container)) {
                    if (!this.startedDecode && logMINOR) {
                        Logger.minor(this, "Block already finished: " + blockNo);
                    }
                    data.free();
                    if (this.persistent) {
                        data.removeFrom(container);
                    }
                    return -1;
                }
                if (this.persistent) {
                    container.activate((Object)this.dataBuckets[blockNo], 1);
                }
                if ((existingBlock = this.dataBuckets[blockNo].trySetData(data)) != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Already have data for data block " + blockNo);
                    }
                    if (existingBlock != data) {
                        data.free();
                        if (this.persistent) {
                            data.removeFrom(container);
                        }
                    }
                    return -1;
                }
                this.setFoundKey(blockNo, container, context);
                if (this.persistent) {
                    data.storeTo(container);
                    container.store((Object)this.dataBuckets[blockNo]);
                    container.store((Object)this);
                }
                if (this.crossCheckBlocks != 0) {
                    crossSegment = this.crossSegmentsByBlock[blockNo];
                }
            } else if (blockNo < this.checkBuckets.length + this.dataBuckets.length) {
                Bucket existingBlock;
                int checkNo = blockNo - this.dataBuckets.length;
                if (this.haveFoundKey(blockNo, container)) {
                    if (!this.startedDecode && logMINOR) {
                        Logger.minor(this, "Check block already finished: " + checkNo);
                    }
                    data.free();
                    if (this.persistent) {
                        data.removeFrom(container);
                    }
                    return -1;
                }
                if (this.persistent) {
                    container.activate((Object)this.checkBuckets[checkNo], 1);
                }
                if ((existingBlock = this.checkBuckets[checkNo].trySetData(data)) != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Already have data for check block " + checkNo);
                    }
                    if (existingBlock != data) {
                        data.free();
                        if (this.persistent) {
                            data.removeFrom(container);
                        }
                    }
                    return -1;
                }
                this.setFoundKey(blockNo, container, context);
                if (this.persistent) {
                    data.storeTo(container);
                    container.store((Object)this.checkBuckets[checkNo]);
                    container.store((Object)this);
                }
            } else {
                Logger.error(this, "Unrecognized block number: " + blockNo, (Throwable)new Exception("error"));
            }
            if (this.startedDecode) {
                return -1;
            }
            boolean bl = tooSmall = data.size() < 32768L;
            if (tooSmall && (!this.ignoreLastDataBlock || blockNo != this.dataBuckets.length - 1)) {
                this.fail(new FetchException(4, "Block too small in splitfile: block " + blockNo + " of " + this.dataBuckets.length + " data keys, " + this.checkBuckets.length + " check keys"), container, context, true);
                return -1;
            }
            if (!this.ignoreLastDataBlock || blockNo != this.dataBuckets.length - 1 || !tooSmall) {
                ++this.fetchedBlocks;
            } else {
                ++this.fatallyFailedBlocks;
            }
            if (wasDataBlock) {
                ++this.fetchedDataBlocks;
            }
            if (logMINOR) {
                Logger.minor(this, "Fetched " + this.fetchedBlocks + " blocks in onSuccess(" + blockNo + ")");
            }
            boolean haveDataBlocks = this.fetchedDataBlocks == this.dataBuckets.length;
            boolean bl2 = decodeNow = !this.startedDecode && (this.fetchedBlocks >= this.minFetched || haveDataBlocks);
            if (decodeNow) {
                decodeNow = this.checkAndDecodeNow(container, blockNo, tooSmall, haveDataBlocks);
            }
            if (!decodeNow) {
                allFailed = this.failedBlocks + this.fatallyFailedBlocks > this.dataBuckets.length + this.checkBuckets.length - this.minFetched;
            }
            boolean bl3 = dontNotify = !this.scheduled;
            if (dontNotify) {
                res = (short)(res | 1);
            }
            if (allFailed) {
                res = (short)(res | 2);
            }
            if (decodeNow) {
                res = (short)(res | 4);
            }
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (crossSegment != null) {
            boolean active = true;
            if (this.persistent && !(active = container.ext().isActive((Object)crossSegment))) {
                container.activate((Object)crossSegment, 1);
            }
            crossSegment.onFetched(this, blockNo, container, context);
            if (!active) {
                container.deactivate((Object)crossSegment, 1);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFoundKey(int blockNo, ObjectContainer container, ClientContext context) {
        SplitFileFetcherKeyListener listener;
        if (this.keys == null) {
            this.migrateToKeys(container);
        } else if (this.persistent) {
            container.activate((Object)this.keys, 1);
        }
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.foundKeys[blockNo]) {
                return;
            }
            this.foundKeys[blockNo] = true;
            if (this.startedDecode) {
                return;
            }
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if ((listener = this.parentFetcher.getListener()) == null) {
            Logger.error(this, "NO LISTENER FOR " + this, (Throwable)new Exception("error"));
        } else {
            listener.removeKey(this.keys.getNodeKey(blockNo, null, false), this, container, context);
        }
    }

    private boolean haveFoundKey(int blockNo, ObjectContainer container) {
        if (this.keys == null) {
            this.migrateToKeys(container);
        }
        return this.foundKeys[blockNo];
    }

    private synchronized void migrateToKeys(ObjectContainer container) {
        ClientCHK key;
        int i;
        if (logMINOR) {
            Logger.minor(this, "Migrating keys on " + this);
        }
        this.keys = new SplitFileSegmentKeys(this.dataKeys.length, this.checkBuckets.length, this.forceCryptoKey, this.getCryptoAlgorithm());
        this.foundKeys = new boolean[this.dataKeys.length + this.checkBuckets.length];
        for (i = 0; i < this.dataKeys.length; ++i) {
            key = this.dataKeys[i];
            if (key == null) {
                this.foundKeys[i] = true;
                continue;
            }
            if (this.persistent) {
                container.activate((Object)key, 5);
            }
            this.keys.setKey(i, key);
            key.removeFrom(container);
        }
        for (i = 0; i < this.checkBuckets.length; ++i) {
            key = this.checkKeys[i];
            if (key == null) {
                this.foundKeys[i + this.dataKeys.length] = true;
                continue;
            }
            if (this.persistent) {
                container.activate((Object)key, 5);
            }
            this.keys.setKey(i + this.dataKeys.length, key);
            key.removeFrom(container);
        }
        this.dataKeys = null;
        this.checkKeys = null;
        if (this.persistent) {
            container.store((Object)this.keys);
            container.store((Object)this);
        }
    }

    private synchronized boolean checkAndDecodeNow(ObjectContainer container, int blockNo, boolean tooSmall, boolean haveDataBlocks) {
        boolean active;
        int i;
        if (this.startedDecode) {
            return false;
        }
        boolean decodeNow = true;
        int count = 0;
        boolean lastBlockTruncated = false;
        for (i = 0; i < this.dataBuckets.length; ++i) {
            Bucket d;
            active = true;
            if (this.persistent && !(active = container.ext().isActive((Object)this.dataBuckets[i]))) {
                container.activate((Object)this.dataBuckets[i], 1);
            }
            if ((d = this.dataBuckets[i].getData()) != null) {
                ++count;
                if (i == this.dataBuckets.length - 1 && this.ignoreLastDataBlock) {
                    if (blockNo == this.dataBuckets.length && tooSmall) {
                        lastBlockTruncated = true;
                    } else if (blockNo != this.dataBuckets.length || tooSmall) {
                        boolean blockActive = true;
                        if (this.persistent && !(blockActive = container.ext().isActive((Object)d))) {
                            container.activate((Object)d, 1);
                        }
                        boolean bl = lastBlockTruncated = d.size() < 32768L;
                        if (!blockActive) {
                            container.deactivate((Object)d, 1);
                        }
                    }
                }
            }
            if (active) continue;
            container.deactivate((Object)this.dataBuckets[i], 1);
        }
        if (haveDataBlocks && count < this.dataBuckets.length) {
            Logger.error(this, "haveDataBlocks is wrong: count is " + count);
        } else if (haveDataBlocks && count >= this.dataBuckets.length) {
            this.startedDecode = true;
            return true;
        }
        if (lastBlockTruncated) {
            --count;
        }
        for (i = 0; i < this.checkBuckets.length; ++i) {
            active = true;
            if (this.persistent && !(active = container.ext().isActive((Object)this.checkBuckets[i]))) {
                container.activate((Object)this.checkBuckets[i], 1);
            }
            if (this.checkBuckets[i].getData() != null) {
                ++count;
            }
            if (active) continue;
            container.deactivate((Object)this.checkBuckets[i], 1);
        }
        if (count < this.dataBuckets.length) {
            Logger.error(this, "Attempting to decode but only " + count + " of " + this.dataBuckets.length + " blocks available!", (Throwable)new Exception("error"));
            decodeNow = false;
            this.fetchedDataBlocks = count;
        } else {
            this.startedDecode = true;
            this.finishing = true;
        }
        return decodeNow;
    }

    public boolean onSuccess(Bucket data, int blockNo, ClientCHKBlock block, ObjectContainer container, ClientContext context, SplitFileFetcherSubSegment sub) {
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        if (data == null) {
            throw new NullPointerException();
        }
        if (logMINOR) {
            Logger.minor(this, "Fetched block " + blockNo + " in " + this + " data=" + this.dataBuckets.length + " check=" + this.checkBuckets.length);
        }
        try {
            if (!(this.maybeAddToBinaryBlob(data, block, blockNo, container, context, block == null ? "CROSS-SEGMENT FEC" : "UNKNOWN") || this.ignoreLastDataBlock && blockNo == this.dataBuckets.length - 1 || this.ignoreLastDataBlock && this.fetchedDataBlocks == this.dataBuckets.length)) {
                if (block == null) {
                    Logger.error(this, "CROSS-SEGMENT DECODED/ENCODED BLOCK INVALID: " + blockNo, (Throwable)new Exception("error"));
                    this.onFatalFailure(new FetchException(17, "Invalid block from cross-segment decode"), blockNo, container, context);
                    data.free();
                    if (this.persistent) {
                        data.removeFrom(container);
                    }
                    return false;
                }
                Logger.error(this, "DATA BLOCK INVALID: " + blockNo, (Throwable)new Exception("error"));
                this.onFatalFailure(new FetchException(17, "Invalid block"), blockNo, container, context);
                data.free();
                if (this.persistent) {
                    data.removeFrom(container);
                }
                return false;
            }
        }
        catch (FetchException e) {
            this.fail(e, container, context, false);
            data.free();
            if (this.persistent) {
                data.removeFrom(container);
            }
            return false;
        }
        short result = this.onSuccessInner(data, blockNo, container, context);
        if (result == -1) {
            return false;
        }
        this.finishOnSuccess(result, container, context);
        return true;
    }

    private void finishOnSuccess(short result, ObjectContainer container, ClientContext context) {
        boolean decodeNow;
        boolean dontNotify = (result & 1) == 1;
        boolean allFailed = (result & 2) == 2;
        boolean bl = decodeNow = (result & 4) == 4;
        if (logMINOR) {
            Logger.minor(this, "finishOnSuccess: result = " + result + " dontNotify=" + dontNotify + " allFailed=" + allFailed + " decodeNow=" + decodeNow);
        }
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.parent, 1);
        }
        this.parent.completedBlock(dontNotify, container, context);
        if (decodeNow) {
            if (this.persistent) {
                container.activate((Object)this.parentFetcher, 1);
            }
            this.parentFetcher.removeMyPendingKeys(this, container, context);
            if (this.persistent) {
                container.deactivate((Object)this.parentFetcher, 1);
            }
            this.removeSubSegments(container, context, false);
            this.decode(container, context);
        } else if (allFailed) {
            this.fail(new FetchException(19, this.errors), container, context, true);
        }
        if (this.persistent) {
            container.deactivate((Object)this.parent, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ObjectContainer container, ClientContext context) {
        SplitFileFetcherSegmentGet oldGetter;
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Decoding " + this);
        }
        this.createdBeforeRestart = this.createdBeforeRestart(container);
        if (this.persistent) {
            container.store((Object)this);
        }
        if (this.persistent) {
            int i;
            for (i = 0; i < this.dataBuckets.length; ++i) {
                container.activate((Object)this.dataBuckets[i], 1);
            }
            for (i = 0; i < this.checkBuckets.length; ++i) {
                container.activate((Object)this.checkBuckets[i], 1);
            }
        }
        int data = 0;
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.finished || this.encoderFinished) {
                return;
            }
            for (int i = 0; i < this.dataBuckets.length; ++i) {
                if (this.dataBuckets[i].getData() != null) {
                    ++data;
                    continue;
                }
                this.dataBuckets[i].flag = true;
                if (!this.persistent) continue;
                this.dataBuckets[i].storeTo(container);
            }
            oldGetter = this.getter;
            this.getter = null;
        }
        if (oldGetter != null) {
            if (this.persistent) {
                container.activate((Object)oldGetter, 1);
            }
            oldGetter.unregister(container, context, this.getPriorityClass(container));
            if (this.persistent) {
                oldGetter.removeFrom(container);
            }
            oldGetter = null;
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        if (data == this.dataBuckets.length) {
            if (logMINOR) {
                Logger.minor(this, "Already decoded");
            }
            if (this.persistent) {
                for (int i = 0; i < this.dataBuckets.length; ++i) {
                    container.activate((Object)this.dataBuckets[i].getData(), 1);
                }
            }
            SplitFileFetcherSegment i = this;
            synchronized (i) {
                this.startedDecode = true;
            }
            this.onDecodedSegment(container, context, null, null, null, this.dataBuckets, this.checkBuckets);
            return;
        }
        if (this.splitfileType != 0) {
            MinimalSplitfileBlock block;
            Object d;
            FECQueue queue = context.fecQueue;
            int count = 0;
            SplitFileFetcherSegment splitFileFetcherSegment2 = this;
            synchronized (splitFileFetcherSegment2) {
                int i;
                if (this.finished || this.encoderFinished) {
                    return;
                }
                for (i = 0; i < this.dataBuckets.length; ++i) {
                    d = this.dataBuckets[i].getData();
                    if (d == null) continue;
                    boolean valid = false;
                    if (i == this.dataBuckets.length - 1) {
                        if (this.ignoreLastDataBlock) {
                            boolean blockActive = true;
                            if (this.persistent && !(blockActive = container.ext().isActive(d))) {
                                container.activate(d, 1);
                            }
                            if (d.size() >= 32768L) {
                                valid = true;
                            }
                            if (!blockActive) {
                                container.deactivate(d, 1);
                            }
                        } else {
                            valid = true;
                        }
                    } else {
                        valid = true;
                    }
                    if (!valid) continue;
                    ++count;
                }
                for (i = 0; i < this.checkBuckets.length; ++i) {
                    if (this.checkBuckets[i].getData() == null) continue;
                    ++count;
                }
            }
            if (count < this.dataBuckets.length) {
                Logger.error(this, "Attempting to decode but only " + count + " of " + this.dataBuckets.length + " blocks available!", (Throwable)new Exception("error"));
                this.fail(new FetchException(17, "Not enough blocks to decode but decoding anyway?!"), container, context, true);
                return;
            }
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            if ((block = this.dataBuckets[this.dataBuckets.length - 1]) == null) {
                SplitFileFetcherSegment i = this;
                synchronized (i) {
                    if (!this.finished || this.encoderFinished) {
                        Logger.error(this, "Last block wrapper is null yet not finished?!");
                    }
                    return;
                }
            }
            Bucket lastBlock = block.getData();
            if (lastBlock != null) {
                if (this.persistent) {
                    container.activate((Object)lastBlock, 1);
                }
                if (this.ignoreLastDataBlock && lastBlock.size() < 32768L) {
                    lastBlock.free();
                    if (this.persistent) {
                        lastBlock.removeFrom(container);
                    }
                    this.dataBuckets[this.dataBuckets.length - 1].clearData();
                    if (this.persistent) {
                        container.store((Object)this.dataBuckets[this.dataBuckets.length - 1]);
                    }
                } else if (lastBlock.size() != 32768L) {
                    this.fail(new FetchException(4, "Last data block is not the standard size"), container, context, true);
                }
            }
            d = this;
            synchronized (d) {
                if (this.finished || this.encoderFinished) {
                    return;
                }
            }
            if (this.codec == null) {
                this.codec = FECCodec.getCodec(this.splitfileType, this.dataBuckets.length, this.checkBuckets.length);
            }
            FECJob job = new FECJob(this.codec, queue, this.dataBuckets, this.checkBuckets, 32768, context.getBucketFactory(this.persistent), (FECCallback)this, true, this.parent.getPriorityClass(), this.persistent);
            this.codec.addToQueue(job, queue, container);
            if (logMINOR) {
                Logger.minor(this, "Queued FEC job: " + job);
            }
            if (this.persistent) {
                container.deactivate((Object)this.parent, 1);
            }
        } else {
            Logger.error(this, "SPLITFILE_NONREDUNDANT !!");
            splitFileFetcherSegment = this;
            synchronized (splitFileFetcherSegment) {
                this.startedDecode = true;
            }
            this.onDecodedSegment(container, context, null, null, null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDecodedSegment(ObjectContainer container, ClientContext context, FECJob job, Bucket[] dataBuckets2, Bucket[] checkBuckets2, SplitfileBlock[] dataBlockStatus, SplitfileBlock[] checkBlockStatus) {
        block70: {
            boolean finishNow;
            Object data;
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
                container.activate((Object)context, 1);
                container.activate((Object)this.blockFetchContext, 1);
            }
            SplitFileFetcherSegment splitFileFetcherSegment = this;
            synchronized (splitFileFetcherSegment) {
                if (this.encoderFinished) {
                    Logger.error(this, "Decoded segment after encoder finished");
                }
            }
            if (this.codec == null) {
                this.codec = FECCodec.getCodec(this.splitfileType, this.dataBuckets.length, this.checkBuckets.length);
            }
            if (this.persistent) {
                for (int i = 0; i < this.dataBuckets.length; ++i) {
                    long ourID;
                    long theirID;
                    if (dataBlockStatus[i] != this.dataBuckets[i] && (theirID = container.ext().getID((Object)dataBlockStatus[i])) == (ourID = container.ext().getID((Object)this.dataBuckets[i]))) {
                        Logger.error(this, "DB4O BUG DETECTED IN DECODED SEGMENT!: our block: " + this.dataBuckets[i] + " block from decode " + dataBlockStatus[i] + " both have ID " + ourID + " = " + theirID);
                        this.dataBuckets[i] = (MinimalSplitfileBlock)dataBlockStatus[i];
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Data block " + i + " is " + this.dataBuckets[i]);
                    }
                    if (!container.ext().isStored((Object)this.dataBuckets[i])) {
                        Logger.error(this, "Data block " + i + " is not stored!");
                    } else if (!container.ext().isActive((Object)this.dataBuckets[i])) {
                        Logger.error(this, "Data block " + i + " is inactive! : " + this.dataBuckets[i]);
                    }
                    if (this.dataBuckets[i] == null) {
                        Logger.error(this, "Data block " + i + " is null!");
                    } else if (this.dataBuckets[i].getData() == null) {
                        Logger.error(this, "Data block " + i + " has null data!");
                    } else {
                        this.dataBuckets[i].getData().storeTo(container);
                    }
                    container.store((Object)this.dataBuckets[i]);
                }
            }
            if (this.crossCheckBlocks != 0) {
                for (int i = 0; i < this.dataBuckets.length; ++i) {
                    if (this.persistent) {
                        container.activate((Object)this.dataBuckets[i], 1);
                    }
                    if (!this.dataBuckets[i].flag) continue;
                    boolean active = true;
                    if (this.persistent && !(active = container.ext().isActive((Object)this.crossSegmentsByBlock[i]))) {
                        container.activate((Object)this.crossSegmentsByBlock[i], 1);
                    }
                    this.crossSegmentsByBlock[i].onFetched(this, i, container, context);
                    if (active) continue;
                    container.deactivate((Object)this.crossSegmentsByBlock[i], 1);
                }
            }
            int[] dataRetries = this.dataRetries;
            MyCooldownTrackerItem tracker = this.makeCooldownTrackerItem(container, context);
            if (this.getMaxRetries(container) == -1) {
                dataRetries = tracker.dataRetries;
            }
            boolean allDecodedCorrectly = true;
            boolean allFromStore = !this.parent.sentToNetwork;
            for (int i = 0; i < this.dataBuckets.length; ++i) {
                Bucket wrapper;
                if (this.persistent && this.crossCheckBlocks != 0) {
                    container.activate((Object)this.dataBuckets[i], 1);
                }
                if ((data = dataBlockStatus[i].getData()) == null) {
                    throw new NullPointerException("Data bucket " + i + " of " + this.dataBuckets.length + " is null in onDecodedSegment");
                }
                boolean heal = this.dataBuckets[i].flag;
                if (allFromStore) {
                    heal = false;
                }
                try {
                    if (this.persistent && this.crossCheckBlocks != 0) {
                        container.activate(data, Integer.MAX_VALUE);
                    }
                    if (!this.maybeAddToBinaryBlob((Bucket)data, null, i, container, context, "FEC DECODE")) {
                        if (!this.ignoreLastDataBlock || i != this.dataBuckets.length - 1) {
                            Logger.error(this, "Data block " + i + " FAILED TO DECODE CORRECTLY");
                            this.fail(new FetchException(35), container, context, false);
                            return;
                        }
                        Logger.normal(this, "Last block padding issue on decode on " + this);
                        heal = false;
                        allDecodedCorrectly = false;
                    }
                }
                catch (FetchException e) {
                    this.fail(e, container, context, false);
                    return;
                }
                if (heal && dataRetries[i] == 0) {
                    int odds;
                    int n = odds = this.createdBeforeRestart ? 10 : 20;
                    if (context.fastWeakRandom.nextInt(odds) != 0) {
                        heal = false;
                    }
                }
                if (!heal || (wrapper = this.queueHeal((Bucket)data, container, context)) == data) continue;
                assert (!this.persistent);
                this.dataBuckets[i].replaceData(wrapper);
            }
            if (allDecodedCorrectly && logMINOR) {
                Logger.minor(this, "All decoded correctly on " + this);
            }
            if (this.persistent) {
                container.store((Object)this);
            }
            if (this.persistent) {
                boolean fin;
                data = this;
                synchronized (data) {
                    fin = this.fetcherFinished;
                }
                if (fin) {
                    this.encoderFinished(container, context);
                    return;
                }
            }
            boolean bl = finishNow = this.splitfileType == 0 || !this.isCollectingBinaryBlob();
            if (finishNow) {
                data = this;
                synchronized (data) {
                    this.finished = true;
                }
                if (this.persistent) {
                    container.store((Object)this);
                }
                if (this.persistent) {
                    container.activate((Object)this.parentFetcher, 1);
                }
                this.parentFetcher.segmentFinished(this, container, context);
                if (this.persistent) {
                    container.deactivate((Object)this.parentFetcher, 1);
                }
            }
            if (this.splitfileType == 0) {
                if (this.persistent) {
                    container.deactivate((Object)this.parent, 1);
                    container.deactivate((Object)context, 1);
                }
                if (this.persistent) {
                    this.encoderFinished(container, context);
                }
                return;
            }
            Bucket lastBlock = this.dataBuckets[this.dataBuckets.length - 1].getData();
            if (lastBlock != null) {
                if (this.persistent) {
                    container.activate((Object)lastBlock, 1);
                }
                if (this.ignoreLastDataBlock && lastBlock.size() != 32768L) {
                    if (!finishNow) {
                        SplitFileFetcherSegment heal = this;
                        synchronized (heal) {
                            this.finished = true;
                        }
                        if (this.persistent) {
                            container.store((Object)this);
                        }
                        if (this.persistent) {
                            container.activate((Object)this.parentFetcher, 1);
                        }
                        this.parentFetcher.segmentFinished(this, container, context);
                        if (this.persistent) {
                            container.deactivate((Object)this.parentFetcher, 1);
                        }
                    }
                    if (this.persistent) {
                        container.deactivate((Object)this.parent, 1);
                        container.deactivate((Object)context, 1);
                        this.encoderFinished(container, context);
                    }
                    return;
                }
            }
            for (int i = 0; i < this.checkBuckets.length; ++i) {
                if (this.checkBuckets[i].getData() != null) continue;
                this.checkBuckets[i].flag = true;
                if (!this.persistent) continue;
                this.checkBuckets[i].storeTo(container);
            }
            try {
                SplitFileFetcherSegment i = this;
                synchronized (i) {
                    if (this.encoderFinished) {
                        Logger.error(this, "Encoder finished in onDecodedSegment at end??? on " + this);
                        return;
                    }
                }
                this.codec.addToQueue(new FECJob(this.codec, context.fecQueue, this.dataBuckets, this.checkBuckets, 32768, context.getBucketFactory(this.persistent), (FECCallback)this, false, this.parent.getPriorityClass(), this.persistent), context.fecQueue, container);
                if (this.persistent) {
                    container.deactivate((Object)this.parent, 1);
                    container.deactivate((Object)context, 1);
                }
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
                this.onFailed(t, container, context);
                if (!this.persistent) break block70;
                this.encoderFinished(container, context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onEncodedSegment(ObjectContainer container, ClientContext context, FECJob job, Bucket[] dataBuckets2, Bucket[] checkBuckets2, SplitfileBlock[] dataBlockStatus, SplitfileBlock[] checkBlockStatus) {
        try {
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            if (logMINOR) {
                Logger.minor(this, "Encoded " + this);
            }
            SplitFileFetcherSegment splitFileFetcherSegment = this;
            // MONITORENTER : splitFileFetcherSegment
            if (this.encoderFinished) {
                Logger.error(this, "Decoded segment after encoder finished");
            }
            for (int i = 0; i < this.dataBuckets.length; ++i) {
                Bucket data;
                if (this.dataBuckets[i] == null) {
                    Logger.error(this, "Data bucket " + i + " is null in onEncodedSegment on " + this);
                    continue;
                }
                if (this.dataBuckets[i] != dataBlockStatus[i]) {
                    Logger.error(this, "Data block " + i + " : ours is " + this.dataBuckets[i] + " codec's is " + dataBlockStatus[i]);
                    if (this.persistent) {
                        if (container.ext().getID((Object)this.dataBuckets[i]) == container.ext().getID((Object)dataBlockStatus[i])) {
                            Logger.error(this, "DB4O BUG DETECTED: SAME UID FOR TWO OBJECTS: " + this.dataBuckets[i] + "=" + container.ext().getID((Object)this.dataBuckets[i]) + " and " + dataBlockStatus[i] + "=" + container.ext().getID((Object)dataBlockStatus[i]) + " ... attempting workaround ...");
                        }
                        Logger.error(this, "Ours is " + (container.ext().isStored((Object)this.dataBuckets[i]) ? "stored " : "") + (container.ext().isActive((Object)this.dataBuckets[i]) ? "active " : "") + " UUID " + container.ext().getID((Object)this.dataBuckets[i]));
                        Logger.error(this, "Theirs is " + (container.ext().isStored((Object)dataBlockStatus[i]) ? "stored " : "") + (container.ext().isActive((Object)dataBlockStatus[i]) ? "active " : "") + " UUID " + container.ext().getID((Object)dataBlockStatus[i]));
                    }
                    this.dataBuckets[i] = (MinimalSplitfileBlock)dataBlockStatus[i];
                }
                if ((data = this.dataBuckets[i].getData()) != null) continue;
                Logger.error(this, "Data bucket " + i + " has null contents in onEncodedSegment on " + this + " for block " + this.dataBuckets[i]);
                if (!this.persistent) continue;
                if (!container.ext().isStored((Object)this.dataBuckets[i])) {
                    Logger.error(this, "Splitfile block appears not to be stored");
                    continue;
                }
                if (container.ext().isActive((Object)this.dataBuckets[i])) continue;
                Logger.error(this, "Splitfile block appears not to be active");
            }
            int[] checkRetries = this.checkRetries;
            MyCooldownTrackerItem tracker = this.makeCooldownTrackerItem(container, context);
            if (this.getMaxRetries(container) == -1) {
                checkRetries = tracker.checkRetries;
            }
            boolean allEncodedCorrectly = true;
            boolean allFromStore = false;
            SplitFileFetcherSegment splitFileFetcherSegment2 = this;
            // MONITORENTER : splitFileFetcherSegment2
            if (this.parent == null) {
                allFromStore = false;
                if (!this.fetcherFinished) {
                    Logger.error(this, "Parent is null on " + this + " but fetcher is not finished");
                } else {
                    allFromStore = false;
                }
            } else {
                allFromStore = !this.parent.sentToNetwork;
            }
            // MONITOREXIT : splitFileFetcherSegment2
            for (int i = 0; i < this.checkBuckets.length; ++i) {
                Bucket data;
                boolean heal = false;
                if (this.checkBuckets[i] == null) {
                    Logger.error(this, "Check bucket " + i + " is null in onEncodedSegment on " + this);
                    allEncodedCorrectly = false;
                    continue;
                }
                if (this.checkBuckets[i] != checkBlockStatus[i]) {
                    Logger.error(this, "Check block " + i + " : ours is " + this.checkBuckets[i] + " codec's is " + checkBlockStatus[i]);
                    if (this.persistent) {
                        if (container.ext().getID((Object)this.checkBuckets[i]) == container.ext().getID((Object)checkBlockStatus[i])) {
                            Logger.error(this, "DB4O BUG DETECTED: SAME UID FOR TWO OBJECTS: " + this.checkBuckets[i] + "=" + container.ext().getID((Object)this.checkBuckets[i]) + " and " + checkBlockStatus[i] + "=" + container.ext().getID((Object)checkBlockStatus[i]) + " ... attempting workaround ...");
                        }
                        Logger.error(this, "Ours is " + (container.ext().isStored((Object)this.checkBuckets[i]) ? "stored " : "") + (container.ext().isActive((Object)this.checkBuckets[i]) ? "active " : "") + " UUID " + container.ext().getID((Object)this.checkBuckets[i]));
                        Logger.error(this, "Theirs is " + (container.ext().isStored((Object)checkBlockStatus[i]) ? "stored " : "") + (container.ext().isActive((Object)checkBlockStatus[i]) ? "active " : "") + " UUID " + container.ext().getID((Object)checkBlockStatus[i]));
                    }
                    this.checkBuckets[i] = (MinimalSplitfileBlock)checkBlockStatus[i];
                }
                if ((data = this.checkBuckets[i].getData()) == null) {
                    Logger.error(this, "Check bucket " + i + " has null contents in onEncodedSegment on " + this + " for block " + this.checkBuckets[i]);
                    if (!this.persistent) continue;
                    if (!container.ext().isStored((Object)this.dataBuckets[i])) {
                        Logger.error(this, "Splitfile block appears not to be stored");
                        continue;
                    }
                    if (container.ext().isActive((Object)this.dataBuckets[i])) continue;
                    Logger.error(this, "Splitfile block appears not to be active");
                    continue;
                }
                heal = this.checkBuckets[i].flag;
                if (allFromStore) {
                    heal = false;
                }
                try {
                    if (!this.maybeAddToBinaryBlob(data, null, i + this.dataBuckets.length, container, context, "FEC ENCODE")) {
                        heal = false;
                        if (!this.ignoreLastDataBlock || this.fetchedDataBlocks != this.dataBuckets.length) {
                            Logger.error(this, "FAILED TO ENCODE CORRECTLY so not healing check block " + i);
                        }
                        allEncodedCorrectly = false;
                    }
                }
                catch (FetchException e) {
                    this.fail(e, container, context, false);
                    // MONITOREXIT : splitFileFetcherSegment
                    if (!this.persistent) return;
                    this.encoderFinished(container, context);
                    return;
                }
                if (heal && checkRetries[i] == 0) {
                    int odds;
                    int n = odds = this.createdBeforeRestart ? 10 : 20;
                    if (context.fastWeakRandom.nextInt(odds) != 0) {
                        heal = false;
                    }
                }
                if (heal) {
                    Bucket wrapper = this.queueHeal(data, container, context);
                    if (wrapper != data) {
                        assert (!this.persistent);
                        wrapper.free();
                    } else {
                        data.free();
                    }
                    if (this.persistent) {
                        data.removeFrom(container);
                    }
                    this.checkBuckets[i].clearData();
                } else {
                    data.free();
                }
                if (this.persistent) {
                    this.checkBuckets[i].removeFrom(container);
                }
                this.checkBuckets[i] = null;
                this.setFoundKey(i + this.dataBuckets.length, container, context);
            }
            if (logMINOR) {
                if (allEncodedCorrectly) {
                    Logger.minor(this, "All encoded correctly on " + this);
                } else {
                    Logger.minor(this, "Not encoded correctly on " + this);
                }
            }
            this.finished = true;
            if (this.persistent && !this.fetcherFinished) {
                container.store((Object)this);
            }
            // MONITOREXIT : splitFileFetcherSegment
            if (logMINOR) {
                Logger.minor(this, "Checked blocks.");
            }
            if (this.splitfileType == 0) return;
            if (!this.isCollectingBinaryBlob()) return;
            if (this.persistent) {
                container.activate((Object)this.parentFetcher, 1);
            }
            this.parentFetcher.segmentFinished(this, container, context);
            if (!this.persistent) return;
            container.deactivate((Object)this.parentFetcher, 1);
            return;
        }
        finally {
            if (this.persistent) {
                this.encoderFinished(container, context);
            }
        }
    }

    private boolean createdBeforeRestart(ObjectContainer container) {
        SplitFileFetcher f = this.parentFetcher;
        if (f == null) {
            Logger.error(this, "Created before restart returning false because parent fetcher already gone");
            return false;
        }
        boolean active = true;
        if (this.persistent && !(active = container.ext().isActive((Object)this.parentFetcher))) {
            container.activate((Object)f, 1);
        }
        SplitFileFetcherKeyListener listener = f.getListener();
        if (!active) {
            container.deactivate((Object)f, 1);
        }
        if (listener == null) {
            Logger.error(this, "Created before restart return false because no listener");
            return false;
        }
        return listener.loadedOnStartup;
    }

    boolean isCollectingBinaryBlob() {
        if (this.parent instanceof ClientGetter) {
            ClientGetter getter = (ClientGetter)this.parent;
            return getter.collectingBinaryBlob();
        }
        return false;
    }

    private boolean maybeAddToBinaryBlob(Bucket data, ClientCHKBlock block, int blockNo, ObjectContainer container, ClientContext context, String dataSource) throws FetchException {
        try {
            ClientCHK key;
            byte[] buf = BucketTools.toByteArray(data);
            if (buf.length != 32768) {
                if (!this.ignoreLastDataBlock || blockNo != this.dataBuckets.length - 1) {
                    Logger.error(this, "Block is too small: " + buf.length);
                }
                return false;
            }
            if (block == null) {
                block = ClientCHKBlock.encodeSplitfileBlock(buf, this.forceCryptoKey, this.getCryptoAlgorithm());
            }
            if ((key = this.getBlockKey(blockNo, container)) != null) {
                if (!key.equals(block.getClientKey())) {
                    if (this.ignoreLastDataBlock && blockNo == this.dataBuckets.length - 1 && dataSource.equals("FEC DECODE")) {
                        if (logMINOR) {
                            Logger.minor(this, "Last block wrong key, ignored because expected due to padding issues");
                        }
                    } else if (this.ignoreLastDataBlock && this.fetchedDataBlocks == this.dataBuckets.length && dataSource.equals("FEC ENCODE")) {
                        if (logMINOR) {
                            Logger.minor(this, "Wrong key, might be due to padding issues");
                        }
                    } else {
                        Logger.error(this, "INVALID KEY FROM " + dataSource + ": Block " + blockNo + " (data " + this.dataBuckets.length + " check " + this.checkBuckets.length + " ignore last block=" + this.ignoreLastDataBlock + ") : key " + block.getClientKey().getURI() + " should be " + key.getURI(), (Throwable)new Exception("error"));
                    }
                    return false;
                }
                if (logMINOR) {
                    Logger.minor(this, "Verified key for block " + blockNo + " from " + dataSource);
                }
            } else if ((dataSource.equals("FEC ENCODE") || dataSource.equals("FEC DECODE") || dataSource.equals("CROSS-SEGMENT FEC")) && this.haveBlock(blockNo, container)) {
                if (logMINOR) {
                    Logger.minor(this, "Key is null for block " + blockNo + " when checking key / adding to binary blob, key source is " + dataSource, (Throwable)new Exception("error"));
                }
            } else {
                Logger.error(this, "Key is null for block " + blockNo + " when checking key / adding to binary blob, key source is " + dataSource, (Throwable)new Exception("error"));
            }
            if (this.parent instanceof ClientGetter) {
                ((ClientGetter)this.parent).addKeyToBinaryBlob(block, container, context);
            }
            return true;
        }
        catch (CHKEncodeException e) {
            Logger.error(this, "Failed to encode (collecting binary blob) block " + blockNo + ": " + e, (Throwable)e);
            throw new FetchException(17, "Failed to encode for binary blob: " + e);
        }
        catch (IOException e) {
            throw new FetchException(12, "Failed to encode for binary blob: " + e);
        }
    }

    private byte getCryptoAlgorithm() {
        if (this.cryptoAlgorithm == 0) {
            return 2;
        }
        return this.cryptoAlgorithm;
    }

    private Bucket queueHeal(Bucket data, ObjectContainer container, ClientContext context) {
        Bucket copy;
        if (this.persistent) {
            try {
                copy = context.tempBucketFactory.makeBucket(data.size());
                BucketTools.copy(data, copy);
            }
            catch (IOException e) {
                Logger.normal(this, "Failed to copy data for healing: " + e, (Throwable)e);
                return data;
            }
        } else {
            MultiReaderBucket wrapper = new MultiReaderBucket(data);
            copy = wrapper.getReaderBucket();
            data = wrapper.getReaderBucket();
        }
        if (logMINOR) {
            Logger.minor(this, "Queueing healing insert for " + data + " on " + this);
        }
        context.healingQueue.queue(copy, this.forceCryptoKey, this.getCryptoAlgorithm(), context);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFatalFailure(FetchException e, int blockNo, ObjectContainer container, ClientContext context) {
        boolean allFailed;
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Permanently failed block: " + blockNo + " on " + this + " : " + e, (Throwable)e);
        }
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.isFinishing(container)) {
                return;
            }
            if (this.haveFoundKey(blockNo, container)) {
                Logger.error(this, "Block already finished: " + blockNo);
                return;
            }
            this.setFoundKey(blockNo, container, context);
            boolean deactivateParent = false;
            if (this.persistent) {
                boolean bl = deactivateParent = !container.ext().isActive((Object)this.parent);
                if (deactivateParent) {
                    container.activate((Object)this.parent, 1);
                }
            }
            if (e.isFatal()) {
                ++this.fatallyFailedBlocks;
                this.parent.fatallyFailedBlock(container, context);
            } else {
                ++this.failedBlocks;
                this.parent.failedBlock(container, context);
            }
            if (deactivateParent) {
                container.deactivate((Object)this.parent, 1);
            }
            allFailed = this.failedBlocks + this.fatallyFailedBlocks > this.dataBuckets.length + this.checkBuckets.length - this.minFetched;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (allFailed) {
            if (this.persistent) {
                container.activate((Object)this.errors, Integer.MAX_VALUE);
            }
            this.fail(new FetchException(19, this.errors), container, context, false);
        }
    }

    public void onNonFatalFailure(FetchException e, int blockNo, ObjectContainer container, ClientContext context) {
        this.onNonFatalFailure(e, blockNo, container, context, true);
    }

    private void onNonFatalFailure(FetchException e, int blockNo, ObjectContainer container, ClientContext context, boolean callStore) {
        if (this.persistent) {
            container.activate((Object)this.blockFetchContext, 1);
        }
        int maxTries = this.blockFetchContext.maxNonSplitfileRetries;
        RequestScheduler sched = context.getFetchScheduler(false, this.realTimeFlag);
        if (this.onNonFatalFailure(e, blockNo, container, context, sched, maxTries, callStore)) {
            this.makeGetter(container, context);
            if (this.getter != null) {
                this.rescheduleGetter(container, context);
            }
        }
    }

    SplitFileFetcherSegmentGet rescheduleGetter(ObjectContainer container, ClientContext context) {
        SplitFileFetcherSegmentGet getter = this.makeGetter(container, context);
        if (getter == null) {
            return null;
        }
        boolean getterActive = true;
        if (this.persistent && !(getterActive = container.ext().isActive((Object)getter))) {
            container.activate((Object)getter, 1);
        }
        getter.reschedule(container, context);
        getter.clearCooldown(container, context, true);
        if (!getterActive) {
            container.deactivate((Object)getter, 1);
        }
        return getter;
    }

    public void onNonFatalFailure(FetchException[] failures, int[] blockNos, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.blockFetchContext, 1);
        }
        int maxTries = this.blockFetchContext.maxNonSplitfileRetries;
        RequestScheduler sched = context.getFetchScheduler(false, this.realTimeFlag);
        boolean reschedule = false;
        for (int i = 0; i < failures.length; ++i) {
            if (!this.onNonFatalFailure(failures[i], blockNos[i], container, context, sched, maxTries, false)) continue;
            reschedule = true;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (reschedule) {
            this.makeGetter(container, context);
            if (this.getter != null) {
                this.rescheduleGetter(container, context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onNonFatalFailure(FetchException e, int blockNo, ObjectContainer container, ClientContext context, RequestScheduler sched, int maxTries, boolean callStore) {
        int tries;
        ClientCHK key;
        if (logMINOR) {
            Logger.minor(this, "Calling onNonFatalFailure for block " + blockNo + " on " + this);
        }
        boolean failed = false;
        boolean cooldown = false;
        int[] dataRetries = this.dataRetries;
        int[] checkRetries = this.checkRetries;
        MyCooldownTrackerItem tracker = this.makeCooldownTrackerItem(container, context);
        long[] dataCooldownTimes = tracker.dataCooldownTimes;
        long[] checkCooldownTimes = tracker.checkCooldownTimes;
        if (maxTries == -1) {
            dataRetries = tracker.dataRetries;
            checkRetries = tracker.checkRetries;
            callStore = false;
        }
        this.checkCachedCooldownData(container);
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.isFinished(container)) {
                return false;
            }
            if (blockNo < this.dataBuckets.length) {
                key = this.getBlockKey(blockNo, container);
                int n = blockNo;
                dataRetries[n] = dataRetries[n] + 1;
                tries = dataRetries[n];
                if (tries > maxTries && maxTries >= 0) {
                    failed = true;
                } else if (this.cachedCooldownTries == 0 || tries % this.cachedCooldownTries == 0) {
                    long now = System.currentTimeMillis();
                    if (dataCooldownTimes[blockNo] > now) {
                        Logger.error(this, "Already on the cooldown queue! for " + this + " data block no " + blockNo, (Throwable)new Exception("error"));
                    } else {
                        SplitFileFetcherSegmentGet getter = this.makeGetter(container, context);
                        if (getter != null) {
                            dataCooldownTimes[blockNo] = now + this.cachedCooldownTime;
                            if (logMINOR) {
                                Logger.minor(this, "Putting data block " + blockNo + " into cooldown until " + (dataCooldownTimes[blockNo] - now));
                            }
                        }
                    }
                    cooldown = true;
                }
            } else {
                int checkNo = blockNo - this.dataBuckets.length;
                key = this.getBlockKey(blockNo, container);
                if (this.persistent) {
                    container.activate((Object)key, 5);
                }
                int n = checkNo;
                checkRetries[n] = checkRetries[n] + 1;
                tries = checkRetries[n];
                if (tries > maxTries && maxTries >= 0) {
                    failed = true;
                } else if (this.cachedCooldownTries == 0 || tries % this.cachedCooldownTries == 0) {
                    long now = System.currentTimeMillis();
                    if (checkCooldownTimes[checkNo] > now) {
                        Logger.error(this, "Already on the cooldown queue! for " + this + " check block no " + blockNo, (Throwable)new Exception("error"));
                    } else {
                        SplitFileFetcherSegmentGet getter = this.makeGetter(container, context);
                        if (getter != null) {
                            checkCooldownTimes[checkNo] = now + this.cachedCooldownTime;
                            if (logMINOR) {
                                Logger.minor(this, "Putting check block " + blockNo + " into cooldown until " + (checkCooldownTimes[checkNo] - now));
                            }
                        }
                    }
                    cooldown = true;
                }
            }
        }
        if (failed) {
            this.onFatalFailure(e, blockNo, container, context);
            if (logMINOR) {
                Logger.minor(this, "Not retrying block " + blockNo + " on " + this + " : tries=" + tries + "/" + maxTries);
            }
            return false;
        }
        boolean mustSchedule = false;
        if (cooldown) {
            if (logMINOR) {
                Logger.minor(this, "Added to cooldown queue: " + key + " for " + this);
            }
        } else {
            mustSchedule = true;
            if (logMINOR) {
                Logger.minor(this, "Retrying block " + blockNo + " on " + this + " : tries=" + tries + "/" + maxTries);
            }
        }
        if (this.persistent) {
            if (callStore) {
                container.store((Object)this);
            }
            container.deactivate((Object)key, 5);
        }
        return mustSchedule;
    }

    private void checkCachedCooldownData(ObjectContainer container) {
        if (this.cachedCooldownTime != 0L || this.cachedCooldownTries != 0) {
            return;
        }
        this.innerCheckCachedCooldownData(container);
    }

    private void innerCheckCachedCooldownData(ObjectContainer container) {
        boolean active = true;
        if (this.persistent) {
            active = container.ext().isActive((Object)this.blockFetchContext);
            container.activate((Object)this.blockFetchContext, 1);
        }
        this.cachedCooldownTries = this.blockFetchContext.getCooldownRetries();
        this.cachedCooldownTime = this.blockFetchContext.getCooldownTime();
        if (!active) {
            container.deactivate((Object)this.blockFetchContext, 1);
        }
    }

    private MyCooldownTrackerItem makeCooldownTrackerItem(ObjectContainer container, ClientContext context) {
        return (MyCooldownTrackerItem)context.cooldownTracker.make(this, this.persistent, container);
    }

    void failCheckingDatastore(ObjectContainer container, ClientContext context) {
        this.fail(null, container, context, false, true);
    }

    void fail(FetchException e, ObjectContainer container, ClientContext context, boolean dontDeactivateParent) {
        this.fail(e, container, context, dontDeactivateParent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(FetchException e, ObjectContainer container, ClientContext context, boolean dontDeactivateParent, boolean checkingStoreOnly) {
        if (logMINOR) {
            Logger.minor(this, "Failing segment " + this, (Throwable)e);
        }
        boolean alreadyDecoding = false;
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.finished) {
                return;
            }
            if (this.startedDecode && checkingStoreOnly) {
                return;
            }
            if (checkingStoreOnly) {
                e = new FetchException(13);
            }
            this.finished = true;
            alreadyDecoding = this.startedDecode;
            this.failureException = e;
            for (int i = 0; i < this.checkBuckets.length; ++i) {
                Bucket d;
                MinimalSplitfileBlock b = this.checkBuckets[i];
                if (this.persistent) {
                    container.activate((Object)b, 2);
                }
                if (b != null && (d = b.getData()) != null) {
                    d.free();
                }
                if (this.persistent) {
                    b.removeFrom(container);
                }
                this.checkBuckets[i] = null;
            }
        }
        if (this.getter != null) {
            if (this.persistent) {
                container.activate((Object)this.getter, 1);
            }
            this.getter.unregister(container, context, this.getPriorityClass(container));
            if (this.persistent) {
                this.getter.removeFrom(container);
            }
            this.getter = null;
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        this.encoderFinished(container, context);
        this.removeSubSegments(container, context, false);
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.parentFetcher, 1);
        }
        if (!alreadyDecoding) {
            this.parentFetcher.removeMyPendingKeys(this, container, context);
        }
        this.parentFetcher.segmentFinished(this, container, context);
        if (this.persistent && !dontDeactivateParent) {
            container.deactivate((Object)this.parentFetcher, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendableGet schedule(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        SplitFileFetcherSegmentGet get = this.makeGetter(container, context);
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            this.scheduled = true;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (this.persistent) {
            container.activate((Object)get, 1);
        }
        return get;
    }

    public void cancel(ObjectContainer container, ClientContext context) {
        this.fail(new FetchException(25), container, context, true);
    }

    public void onBlockSetFinished(ClientGetState state) {
    }

    public void onTransition(ClientGetState oldState, ClientGetState newState) {
    }

    public synchronized ClientCHK getBlockKey(int blockNum, ObjectContainer container) {
        if (this.keys == null) {
            this.migrateToKeys(container);
        } else if (this.persistent) {
            container.activate((Object)this.keys, 1);
        }
        return this.keys.getKey(blockNum, this.foundKeys, this.persistent);
    }

    public NodeCHK getBlockNodeKey(int blockNum, ObjectContainer container) {
        ClientCHK key = this.getBlockKey(blockNum, container);
        if (key != null) {
            return key.getNodeCHK();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubSegments(ObjectContainer container, ClientContext context, boolean finishing) {
        SplitFileFetcherSubSegment[] deadSegs;
        if (this.subSegments == null) {
            return;
        }
        if (this.persistent) {
            container.activate(this.subSegments, 1);
        }
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            deadSegs = this.subSegments.toArray(new SplitFileFetcherSubSegment[this.subSegments.size()]);
            this.subSegments.clear();
        }
        if (this.persistent && deadSegs.length > 0) {
            container.store((Object)this);
        }
        for (int i = 0; i < deadSegs.length; ++i) {
            if (deadSegs[i] == null) {
                Logger.error(this, "Subsegment " + i + " of " + deadSegs.length + " on " + this + " is null!");
                continue;
            }
            if (this.persistent) {
                container.activate((Object)deadSegs[i], 1);
            }
            deadSegs[i].kill(container, context, true, false);
            context.getChkFetchScheduler(this.realTimeFlag).removeFromStarterQueue(deadSegs[i], container, true);
            if (!this.persistent) continue;
            container.deactivate((Object)deadSegs[i], 1);
        }
        if (this.persistent && !finishing) {
            container.store((Object)this);
            container.store(this.subSegments);
        }
    }

    public synchronized long getCooldownWakeup(int blockNum, int maxTries, ObjectContainer container, ClientContext context) {
        MyCooldownTrackerItem tracker = this.makeCooldownTrackerItem(container, context);
        long[] dataCooldownTimes = tracker.dataCooldownTimes;
        long[] checkCooldownTimes = tracker.checkCooldownTimes;
        if (blockNum < this.dataBuckets.length) {
            return dataCooldownTimes[blockNum];
        }
        return checkCooldownTimes[blockNum - this.dataBuckets.length];
    }

    synchronized void setMaxCooldownWakeup(long until, int blockNum, int maxTries, ObjectContainer container, ClientContext context) {
        MyCooldownTrackerItem tracker = this.makeCooldownTrackerItem(container, context);
        long[] dataCooldownTimes = tracker.dataCooldownTimes;
        long[] checkCooldownTimes = tracker.checkCooldownTimes;
        if (blockNum < this.dataBuckets.length) {
            dataCooldownTimes[blockNum] = Math.max(dataCooldownTimes[blockNum], until);
        } else {
            checkCooldownTimes[blockNum - this.dataBuckets.length] = Math.max(checkCooldownTimes[blockNum - this.dataBuckets.length], until);
        }
    }

    private int getRetries(int blockNum, ObjectContainer container, ClientContext context) {
        return this.getRetries(blockNum, this.getMaxRetries(container), container, context);
    }

    private int getRetries(int blockNum, int maxTries, ObjectContainer container, ClientContext context) {
        int[] dataRetries = this.dataRetries;
        int[] checkRetries = this.checkRetries;
        if (maxTries == -1) {
            MyCooldownTrackerItem tracker = this.makeCooldownTrackerItem(container, context);
            dataRetries = tracker.dataRetries;
            checkRetries = tracker.checkRetries;
        }
        if (blockNum < this.dataBuckets.length) {
            return dataRetries[blockNum];
        }
        return checkRetries[blockNum - this.dataBuckets.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requeueAfterCooldown(Key key, long time, ObjectContainer container, ClientContext context, SplitFileFetcherSubSegment dontDeactivate) {
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        boolean notFound = true;
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            int[] matches;
            if (this.isFinishing(container)) {
                return false;
            }
            if (this.persistent) {
                container.activate((Object)this.blockFetchContext, 1);
            }
            int maxTries = this.blockFetchContext.maxNonSplitfileRetries;
            if (this.keys == null) {
                this.migrateToKeys(container);
            } else if (this.persistent) {
                container.activate((Object)this.keys, 1);
            }
            for (int i : matches = this.keys.getBlockNumbers((NodeCHK)key, this.foundKeys)) {
                ClientCHK k = this.keys.getKey(i, this.foundKeys, this.persistent);
                if (k.getNodeKey(false).equals(key)) {
                    if (this.getCooldownWakeup(i, maxTries, container, context) > time) {
                        if (logMINOR) {
                            Logger.minor(this, "Not retrying after cooldown for data block " + i + " as deadline has not passed yet on " + this + " remaining time: " + (this.getCooldownWakeup(i, maxTries, container, context) - time) + "ms");
                        }
                        return false;
                    }
                    if (this.foundKeys[i]) continue;
                    if (logMINOR) {
                        Logger.minor(this, "Retrying after cooldown on " + this + ": block " + i + " on " + this + " : tries=" + this.getRetries(i, container, context) + "/" + maxTries);
                    }
                    notFound = false;
                    continue;
                }
                if (!this.persistent) continue;
                container.deactivate((Object)k, 5);
            }
        }
        if (notFound) {
            Logger.error(this, "requeueAfterCooldown: Key not found!: " + key + " on " + this);
        } else {
            this.rescheduleGetter(container, context);
        }
        return true;
    }

    public synchronized long getCooldownWakeupByKey(Key key, ObjectContainer container, ClientContext context) {
        if (this.keys == null) {
            this.migrateToKeys(container);
        } else if (this.persistent) {
            container.activate((Object)this.keys, 1);
        }
        int blockNo = this.keys.getBlockNumber((NodeCHK)key, this.foundKeys);
        if (blockNo == -1) {
            return -1L;
        }
        return this.getCooldownWakeup(blockNo, this.getMaxRetries(container), container, context);
    }

    public synchronized int getBlockNumber(Key key, ObjectContainer container) {
        if (this.keys == null) {
            this.migrateToKeys(container);
        } else if (this.persistent) {
            container.activate((Object)this.keys, 1);
        }
        return this.keys.getBlockNumber((NodeCHK)key, this.foundKeys);
    }

    public synchronized Integer[] getKeyNumbersAtRetryLevel(int retryCount, ObjectContainer container, ClientContext context) {
        int i;
        ArrayList<Integer> v = new ArrayList<Integer>();
        if (this.keys == null) {
            this.migrateToKeys(container);
        } else if (this.persistent) {
            container.activate((Object)this.keys, 1);
        }
        int maxTries = this.getMaxRetries(container);
        int[] dataRetries = this.dataRetries;
        int[] checkRetries = this.checkRetries;
        if (maxTries == -1) {
            MyCooldownTrackerItem tracker = this.makeCooldownTrackerItem(container, context);
            dataRetries = tracker.dataRetries;
            checkRetries = tracker.checkRetries;
        }
        for (i = 0; i < dataRetries.length; ++i) {
            if (this.foundKeys[i] || dataRetries[i] != retryCount) continue;
            v.add(i);
        }
        for (i = 0; i < checkRetries.length; ++i) {
            if (this.foundKeys[i + this.dataBuckets.length] || checkRetries[i] != retryCount) continue;
            v.add(i + this.dataBuckets.length);
        }
        return v.toArray(new Integer[v.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailed(Throwable t, ObjectContainer container, ClientContext context) {
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.finished) {
                Logger.error(this, "FEC decode or encode failed but already finished: " + t, t);
                return;
            }
            this.finished = true;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        this.fail(new FetchException(17, "FEC failure: " + t, t), container, context, false);
    }

    public synchronized boolean haveBlock(int blockNo, ObjectContainer container) {
        if (blockNo < this.dataBuckets.length) {
            boolean wasActive = false;
            if (this.dataBuckets[blockNo] == null) {
                return false;
            }
            if (this.persistent && !(wasActive = container.ext().isActive((Object)this.dataBuckets[blockNo]))) {
                container.activate((Object)this.dataBuckets[blockNo], 1);
            }
            boolean retval = this.dataBuckets[blockNo].hasData();
            if (this.persistent && !wasActive) {
                container.deactivate((Object)this.dataBuckets[blockNo], 1);
            }
            return retval;
        }
        boolean wasActive = false;
        if (this.checkBuckets[blockNo -= this.dataBuckets.length] == null) {
            return false;
        }
        if (this.persistent && !(wasActive = container.ext().isActive((Object)this.checkBuckets[blockNo]))) {
            container.activate((Object)this.checkBuckets[blockNo], 1);
        }
        boolean retval = this.checkBuckets[blockNo].hasData();
        if (this.persistent && !wasActive) {
            container.deactivate((Object)this.checkBuckets[blockNo], 1);
        }
        return retval;
    }

    public short getPriorityClass(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        return this.parent.priorityClass;
    }

    public boolean isCancelled(ObjectContainer container) {
        return this.isFinishing(container);
    }

    public Key[] listKeys(ObjectContainer container) {
        if (this.keys == null) {
            this.migrateToKeys(container);
        } else if (this.persistent) {
            container.activate((Object)this.keys, 1);
        }
        return this.keys.listNodeKeys(this.foundKeys, this.persistent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onGotKey(Key key, KeyBlock block, ObjectContainer container, ClientContext context) {
        int blockNum;
        ClientCHKBlock cb = null;
        Bucket data = null;
        short onSuccessResult = -1;
        FetchException fatal = null;
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            blockNum = this.getBlockNumber(key, container);
            if (blockNum < 0) {
                if (logMINOR) {
                    Logger.minor(this, "Rejecting block because not found");
                }
                return false;
            }
            if (this.finished || this.startedDecode || this.fetcherFinished) {
                if (logMINOR) {
                    Logger.minor(this, "Rejecting block because " + (this.finished ? "finished " : "") + (this.startedDecode ? "started decode " : "") + (this.fetcherFinished ? "fetcher finished " : ""));
                }
                return false;
            }
            if (logMINOR) {
                Logger.minor(this, "Found key for block " + blockNum + " on " + this + " in onGotKey() for " + key);
            }
            ClientCHK ckey = this.getBlockKey(blockNum, container);
            try {
                cb = new ClientCHKBlock((CHKBlock)block, ckey);
            }
            catch (CHKVerifyException e) {
                fatal = new FetchException(6, (Throwable)e);
            }
            if (cb != null) {
                data = this.extract(cb, blockNum, container, context);
                if (data == null) {
                    if (logMINOR) {
                        Logger.minor(this, "Extract failed");
                    }
                    return false;
                }
                if (this.parent instanceof ClientGetter) {
                    ((ClientGetter)this.parent).addKeyToBinaryBlob(cb, container, context);
                }
                if (!cb.isMetadata()) {
                    onSuccessResult = this.onSuccessInner(data, blockNum, container, context);
                }
            }
        }
        if (fatal != null) {
            if (this.persistent) {
                container.activate((Object)this.errors, 1);
            }
            this.errors.inc(fatal.mode);
            if (this.persistent) {
                this.errors.storeTo(container);
            }
            this.onFatalFailure(fatal, blockNum, container, context);
            return false;
        }
        if (data == null) {
            return false;
        }
        if (!cb.isMetadata()) {
            if (onSuccessResult != -1) {
                this.finishOnSuccess(onSuccessResult, container, context);
            }
            return true;
        }
        this.onFatalFailure(new FetchException(4, "Metadata where expected data"), blockNum, container, context);
        return true;
    }

    private synchronized MinimalSplitfileBlock getBlock(int blockNum) {
        if (blockNum < this.dataBuckets.length) {
            return this.dataBuckets[blockNum];
        }
        return this.checkBuckets[blockNum -= this.dataBuckets.length];
    }

    public Bucket getBlockBucket(int blockNum, ObjectContainer container) {
        MinimalSplitfileBlock block = this.getBlock(blockNum);
        boolean active = true;
        if (block != null && this.persistent && !(active = container.ext().isActive((Object)block))) {
            container.activate((Object)block, 1);
        }
        if (block == null) {
            Logger.error(this, "Block is null: " + blockNum + " on " + this + " activated = " + container.ext().isActive((Object)this) + " finished = " + this.finished + " encoder finished = " + this.encoderFinished + " fetcher finished = " + this.fetcherFinished);
            return null;
        }
        Bucket ret = block.getData();
        if (ret == null && logMINOR) {
            Logger.minor(this, "Bucket is null: " + blockNum + " on " + this + " for " + block);
        }
        if (!active) {
            container.deactivate((Object)block, 1);
        }
        return ret;
    }

    public boolean hasBlockWrapper(int i) {
        return this.getBlock(i) != null;
    }

    protected Bucket extract(ClientKeyBlock block, int blockNum, ObjectContainer container, ClientContext context) {
        Bucket data;
        try {
            data = block.decode(context.getBucketFactory(this.persistent), (int)Math.min(this.blockFetchContext.maxOutputLength, Integer.MAX_VALUE), false);
        }
        catch (KeyDecodeException e1) {
            if (logMINOR) {
                Logger.minor(this, "Decode failure: " + e1, (Throwable)e1);
            }
            if (this.persistent) {
                container.activate((Object)this.errors, 1);
            }
            this.errors.inc(6);
            if (this.persistent) {
                this.errors.storeTo(container);
            }
            this.onFatalFailure(new FetchException(6, e1.getMessage()), blockNum, container, context);
            return null;
        }
        catch (TooBigException e) {
            if (this.persistent) {
                container.activate((Object)this.errors, 1);
            }
            this.errors.inc(21);
            if (this.persistent) {
                this.errors.storeTo(container);
            }
            this.onFatalFailure(new FetchException(21, e.getMessage()), blockNum, container, context);
            return null;
        }
        catch (IOException e) {
            Logger.error(this, "Could not capture data - disk full?: " + e, (Throwable)e);
            if (this.persistent) {
                container.activate((Object)this.errors, 1);
            }
            this.errors.inc(12);
            if (this.persistent) {
                this.errors.storeTo(container);
            }
            this.onFatalFailure(new FetchException(12, (Throwable)e), blockNum, container, context);
            return null;
        }
        if (logMINOR) {
            Logger.minor(this, data == null ? "Could not decode: null" : "Decoded " + data.size() + " bytes");
        }
        return data;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public void deactivateKeys(ObjectContainer container) {
        container.deactivate((Object)this.keys, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeDecodedData(ObjectContainer container, boolean noStore) {
        Bucket data;
        MinimalSplitfileBlock block;
        int i;
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (!this.encoderFinished) {
                return;
            }
            if (!this.fetcherHalfFinished) {
                return;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Freeing decoded data on segment " + this);
        }
        if (this.decodedData != null) {
            if (this.persistent) {
                container.activate((Object)this.decodedData, 1);
            }
            this.decodedData.free();
            if (this.persistent) {
                this.decodedData.removeFrom(container);
            }
            this.decodedData = null;
        }
        for (i = 0; i < this.dataBuckets.length; ++i) {
            block = this.dataBuckets[i];
            if (block == null) continue;
            if (this.persistent) {
                container.activate((Object)block, 1);
            }
            if ((data = block.getData()) != null) {
                if (this.persistent) {
                    container.activate((Object)data, 1);
                }
                data.free();
            }
            if (this.persistent) {
                block.removeFrom(container);
            }
            this.dataBuckets[i] = null;
        }
        for (i = 0; i < this.checkBuckets.length; ++i) {
            block = this.checkBuckets[i];
            if (block == null) continue;
            if (this.persistent) {
                container.activate((Object)block, 1);
            }
            if ((data = block.getData()) != null) {
                if (this.persistent) {
                    container.activate((Object)data, 1);
                }
                data.free();
            }
            if (this.persistent) {
                block.removeFrom(container);
            }
            this.checkBuckets[i] = null;
        }
        if (this.persistent && !noStore) {
            container.store((Object)this);
        }
    }

    public void removeFrom(ObjectContainer container, ClientContext context) {
        int i;
        if (!this.finished) {
            Logger.error(this, "Removing " + this + " but not finished, fetcher finished " + this.fetcherFinished + " fetcher half finished " + this.fetcherHalfFinished + " encoder finished " + this.encoderFinished);
        }
        if (logMINOR) {
            Logger.minor(this, "removing " + this);
        }
        context.cooldownTracker.remove(this, true, container);
        this.freeDecodedData(container, true);
        this.removeSubSegments(container, context, true);
        if (this.subSegments != null) {
            container.delete(this.subSegments);
        }
        if (this.dataKeys != null) {
            for (i = 0; i < this.dataKeys.length; ++i) {
                if (this.dataKeys[i] != null) {
                    this.dataKeys[i].removeFrom(container);
                }
                this.dataKeys[i] = null;
            }
        }
        if (this.checkKeys != null) {
            for (i = 0; i < this.checkKeys.length; ++i) {
                if (this.checkKeys[i] != null) {
                    this.checkKeys[i].removeFrom(container);
                }
                this.checkKeys[i] = null;
            }
        }
        container.activate((Object)this.errors, 1);
        this.errors.removeFrom(container);
        if (this.failureException != null) {
            container.activate((Object)this.failureException, 5);
            this.failureException.removeFrom(container);
        }
        if (this.keys != null) {
            container.activate((Object)this.keys, 1);
            this.keys.removeFrom(container);
        }
        if (this.getter != null) {
            container.activate((Object)this.getter, 1);
            Logger.error(this, "Getter still exists: " + this.getter + " for " + this);
            this.getter.removeFrom(container);
        }
        container.delete((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetcherHalfFinished(ObjectContainer container) {
        boolean finish = false;
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.fetcherHalfFinished) {
                return;
            }
            this.fetcherHalfFinished = true;
            finish = this.encoderFinished;
        }
        if (finish) {
            if (this.crossCheckBlocks == 0) {
                this.freeDecodedData(container, false);
            }
        } else if (logMINOR) {
            Logger.minor(this, "Fetcher half-finished but fetcher not finished on " + this);
        }
        if (this.persistent) {
            container.store((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetcherFinished(ObjectContainer container, ClientContext context) {
        context.cooldownTracker.remove(this, this.persistent, container);
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.fetcherFinished) {
                return;
            }
            this.fetcherFinished = true;
            this.fetcherHalfFinished = true;
            if (!this.encoderFinished) {
                if (!this.startedDecode) {
                    if (logMINOR) {
                        Logger.minor(this, "Never started decode, completing immediately on " + this);
                    }
                    this.encoderFinished = true;
                    if (this.persistent) {
                        container.store((Object)this);
                    }
                } else {
                    if (this.persistent) {
                        container.store((Object)this);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Fetcher finished but encoder not finished on " + this);
                    }
                    return;
                }
            }
        }
        if (this.persistent) {
            this.removeFrom(container, context);
        } else {
            this.freeDecodedData(container, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encoderFinished(ObjectContainer container, ClientContext context) {
        context.cooldownTracker.remove(this, this.persistent, container);
        boolean finish = false;
        boolean half = false;
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            this.encoderFinished = true;
            finish = this.fetcherFinished;
            half = this.fetcherHalfFinished;
        }
        if (finish) {
            if (this.persistent) {
                this.removeFrom(container, context);
            }
        } else if (half) {
            if (this.crossCheckBlocks == 0) {
                this.freeDecodedData(container, false);
            }
            if (this.persistent) {
                container.store((Object)this);
            }
            if (logMINOR) {
                Logger.minor(this, "Encoder finished but fetcher not finished on " + this);
            }
        } else if (this.persistent) {
            container.store((Object)this);
        }
    }

    public int allocateCrossDataBlock(SplitFileFetcherCrossSegment seg, Random random) {
        int i;
        int size = this.realDataBlocks();
        if (this.crossDataBlocksAllocated == size) {
            return -1;
        }
        int x = 0;
        for (i = 0; i < 10; ++i) {
            x = random.nextInt(size);
            if (this.crossSegmentsByBlock[x] != null) continue;
            this.crossSegmentsByBlock[x] = seg;
            ++this.crossDataBlocksAllocated;
            return x;
        }
        for (i = 0; i < size; ++i) {
            if (++x == size) {
                x = 0;
            }
            if (this.crossSegmentsByBlock[x] != null) continue;
            this.crossSegmentsByBlock[x] = seg;
            ++this.crossDataBlocksAllocated;
            return x;
        }
        throw new IllegalStateException("Unable to allocate cross data block even though have not used all slots up???");
    }

    public int allocateCrossCheckBlock(SplitFileFetcherCrossSegment seg, Random random) {
        if (this.crossCheckBlocksAllocated == this.crossCheckBlocks) {
            return -1;
        }
        int x = this.dataBuckets.length - (1 + random.nextInt(this.crossCheckBlocks));
        for (int i = 0; i < this.crossCheckBlocks; ++i) {
            if (++x == this.dataBuckets.length) {
                x = this.dataBuckets.length - this.crossCheckBlocks;
            }
            if (this.crossSegmentsByBlock[x] != null) continue;
            this.crossSegmentsByBlock[x] = seg;
            ++this.crossCheckBlocksAllocated;
            return x;
        }
        throw new IllegalStateException("Unable to allocate cross check block even though have not used all slots up???");
    }

    public final int realDataBlocks() {
        return this.dataBuckets.length - this.crossCheckBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Integer> validBlockNumbers(KeysFetchingLocally fetching, boolean onlyLowestTries, ObjectContainer container, ClientContext context) {
        long now = System.currentTimeMillis();
        if (this.keys == null) {
            this.migrateToKeys(container);
        } else if (this.persistent) {
            container.activate((Object)this.keys, 1);
        }
        int maxTries = this.getMaxRetries(container);
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            int minRetries = Integer.MAX_VALUE;
            ArrayList<Integer> list = null;
            if (this.startedDecode || this.isFinishing(container)) {
                return null;
            }
            for (int i = 0; i < this.dataBuckets.length + this.checkBuckets.length; ++i) {
                NodeCHK key;
                if (this.foundKeys[i] || this.getCooldownWakeup(i, maxTries, container, context) > now || this.getBlockBucket(i, container) != null || fetching.hasKey(key = this.keys.getNodeKey(i, null, true), this.getter, this.persistent, container)) continue;
                if (onlyLowestTries) {
                    int retryCount = this.getRetries(i, container, context);
                    if (retryCount > minRetries) continue;
                    if (retryCount < minRetries && list != null) {
                        list.clear();
                    }
                }
                if (list == null) {
                    list = new ArrayList<Integer>();
                }
                list.add(i);
            }
            return list;
        }
    }

    public boolean checkRecentlyFailed(int blockNum, ObjectContainer container, ClientContext context, KeysFetchingLocally fetching, long now) {
        if (this.keys == null) {
            this.migrateToKeys(container);
        } else if (this.persistent) {
            container.activate((Object)this.keys, 1);
        }
        NodeCHK key = this.keys.getNodeKey(blockNum, null, true);
        long timeout = fetching.checkRecentlyFailed(key, this.realTimeFlag);
        if (timeout <= now) {
            return false;
        }
        int maxRetries = this.getMaxRetries(container);
        if (maxRetries == -1 || maxRetries >= 3) {
            if (logMINOR) {
                Logger.minor(this, "RecentlyFailed -> cooldown until " + TimeUtil.formatTime(timeout - now) + " on " + this);
            }
            this.setMaxCooldownWakeup(timeout, blockNum, this.getMaxRetries(container), container, context);
        } else {
            FetchException e = new FetchException(30);
            this.incErrors(e, container);
            this.onNonFatalFailure(e, blockNum, container, context);
        }
        return true;
    }

    private void incErrors(FetchException e, ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.errors, 1);
        }
        this.errors.inc(e.getMode());
        if (this.persistent) {
            this.errors.storeTo(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersistentChosenBlock> makeBlocks(PersistentChosenRequest request, RequestScheduler sched, KeysFetchingLocally fetching, SplitFileFetcherSegmentGet getter, ObjectContainer container, ClientContext context) {
        long now = System.currentTimeMillis();
        ArrayList<PersistentChosenBlock> list = null;
        if (this.keys == null) {
            this.migrateToKeys(container);
        } else if (this.persistent) {
            container.activate((Object)this.keys, 1);
        }
        int maxTries = this.getMaxRetries(container);
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.startedDecode || this.isFinishing(container)) {
                return null;
            }
            for (int i = 0; i < this.dataBuckets.length + this.checkBuckets.length; ++i) {
                NodeCHK key;
                if (this.foundKeys[i] || this.getCooldownWakeup(i, maxTries, container, context) > now || this.getBlockBucket(i, container) != null || fetching.hasKey(key = this.keys.getNodeKey(i, null, true), getter, this.persistent, container)) continue;
                if (list == null) {
                    list = new ArrayList<PersistentChosenBlock>();
                }
                ClientCHK ckey = this.keys.getKey(i, null, true);
                list.add(new PersistentChosenBlock(false, request, new SplitFileFetcherSegmentSendableRequestItem(i), key, ckey, sched));
            }
        }
        if (list == null) {
            return null;
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            PersistentChosenBlock block = (PersistentChosenBlock)i.next();
            long l = fetching.checkRecentlyFailed(block.key, this.realTimeFlag);
            if (l < now) continue;
            i.remove();
            if (maxTries == -1 || maxTries >= 3) {
                if (logMINOR) {
                    Logger.minor(this, "RecentlyFailed -> cooldown until " + TimeUtil.formatTime(l - now) + " on " + this);
                }
                this.setMaxCooldownWakeup(l, ((SplitFileFetcherSegmentSendableRequestItem)block.token).blockNum, maxTries, container, context);
                continue;
            }
            FetchException e = new FetchException(30);
            this.incErrors(e, container);
            this.onNonFatalFailure(e, ((SplitFileFetcherSegmentSendableRequestItem)block.token).blockNum, container, context);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCooldownTime(ObjectContainer container, ClientContext context, HasCooldownCacheItem parentRGA, long now) {
        if (this.keys == null) {
            this.migrateToKeys(container);
        } else if (this.persistent) {
            container.activate((Object)this.keys, 1);
        }
        int maxTries = this.getMaxRetries(container);
        KeysFetchingLocally fetching = context.getChkFetchScheduler(this.realTimeFlag).fetchingKeys();
        long cooldownWakeup = Long.MAX_VALUE;
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.startedDecode || this.isFinishing(container)) {
                return -1L;
            }
            for (int i = 0; i < this.dataBuckets.length + this.checkBuckets.length; ++i) {
                if (this.foundKeys[i] || this.getBlockBucket(i, container) != null) continue;
                long wakeup = this.getCooldownWakeup(i, maxTries, container, context);
                if (wakeup > now) {
                    if (wakeup >= cooldownWakeup) continue;
                    cooldownWakeup = wakeup;
                    continue;
                }
                NodeCHK key = this.keys.getNodeKey(i, null, true);
                if (fetching.hasKey(key, this.getter, this.persistent, container)) continue;
                return 0L;
            }
        }
        return cooldownWakeup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countAllKeys(ObjectContainer container, ClientContext context) {
        int count = 0;
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.startedDecode || this.isFinishing(container)) {
                return 0L;
            }
            for (int i = 0; i < this.dataBuckets.length + this.checkBuckets.length; ++i) {
                if (this.foundKeys[i] || this.getBlockBucket(i, container) != null) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countSendableKeys(ObjectContainer container, ClientContext context) {
        int count = 0;
        long now = System.currentTimeMillis();
        int maxTries = this.getMaxRetries(container);
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.startedDecode || this.isFinishing(container)) {
                return 0L;
            }
            for (int i = 0; i < this.dataBuckets.length + this.checkBuckets.length; ++i) {
                if (this.foundKeys[i] || this.getCooldownWakeup(i, maxTries, container, context) > now || this.getBlockBucket(i, container) != null) continue;
                ++count;
            }
            return count;
        }
    }

    public synchronized SplitFileFetcherSegmentGet makeGetter(ObjectContainer container, ClientContext context) {
        if (this.finishing || this.startedDecode || this.finished) {
            return null;
        }
        if (this.getter == null) {
            boolean parentActive = true;
            if (this.persistent && !(parentActive = container.ext().isActive((Object)this.parent))) {
                container.activate((Object)this.parent, 1);
            }
            this.getter = new SplitFileFetcherSegmentGet(this.parent, this, this.realTimeFlag);
            if (!parentActive) {
                container.deactivate((Object)this.parent, 1);
            }
            System.out.println("Auto-migrated from subsegments to SegmentGet on " + this + " : " + this.getter);
            this.getter.storeTo(container);
            container.store((Object)this);
            this.removeSubSegments(container, context, false);
            return this.getter;
        }
        return this.getter;
    }

    @Override
    public CooldownTrackerItem makeCooldownTrackerItem() {
        return new MyCooldownTrackerItem(this.dataBuckets.length, this.checkBuckets.length);
    }

    public synchronized int getMaxRetries(ObjectContainer container) {
        if (this.maxRetries != 0) {
            return this.maxRetries;
        }
        return this.innerGetMaxRetries(container);
    }

    private synchronized int innerGetMaxRetries(ObjectContainer container) {
        boolean contextActive = true;
        if (this.persistent && !(contextActive = container.ext().isActive((Object)this.blockFetchContext))) {
            container.activate((Object)this.blockFetchContext, 1);
        }
        this.maxRetries = this.blockFetchContext.maxSplitfileBlockRetries;
        if (this.persistent) {
            container.store((Object)this);
            if (!contextActive) {
                container.deactivate((Object)this.blockFetchContext, 1);
            }
        }
        return this.maxRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangedFetchContext(ObjectContainer container, ClientContext context) {
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.finished) {
                return;
            }
        }
        this.innerCheckCachedCooldownData(container);
        this.innerGetMaxRetries(container);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    static class MyCooldownTrackerItem
    implements CooldownTrackerItem {
        final int[] dataRetries;
        final int[] checkRetries;
        final long[] dataCooldownTimes;
        final long[] checkCooldownTimes;

        MyCooldownTrackerItem(int data, int check) {
            this.dataRetries = new int[data];
            this.checkRetries = new int[check];
            this.dataCooldownTimes = new long[data];
            this.checkCooldownTimes = new long[check];
        }
    }
}

