/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.async.BlockSet;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequester;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.PersistentChosenBlock;
import freenet.client.async.PersistentChosenRequest;
import freenet.client.async.SplitFileFetcherSegment;
import freenet.client.async.SplitFileFetcherSegmentSendableRequestItem;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.node.BulkCallFailureItem;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelGetException;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.node.SendableRequestItem;
import freenet.node.SupportsBulkCallFailure;
import freenet.support.ListUtils;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.RandomGrabArray;
import java.util.ArrayList;
import java.util.List;

public class SplitFileFetcherSegmentGet
extends SendableGet
implements SupportsBulkCallFailure {
    public final SplitFileFetcherSegment segment;
    private static volatile boolean logMINOR;

    public SplitFileFetcherSegmentGet(ClientRequester parent, SplitFileFetcherSegment segment, boolean realTimeFlag) {
        super(parent, realTimeFlag);
        this.segment = segment;
    }

    public boolean isEmpty(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
        }
        return this.segment.isFinishing(container);
    }

    @Override
    public ClientKey getKey(Object token, ObjectContainer container) {
        SplitFileFetcherSegmentSendableRequestItem req = (SplitFileFetcherSegmentSendableRequestItem)token;
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
        }
        return this.segment.getBlockKey(req.blockNum, container);
    }

    @Override
    public Key[] listKeys(ObjectContainer container) {
        boolean activated = false;
        if (this.persistent && !(activated = container.ext().isActive((Object)this.segment))) {
            container.activate((Object)this.segment, 1);
        }
        Key[] keys = this.segment.listKeys(container);
        if (this.persistent && !activated) {
            container.deactivate((Object)this.segment, 1);
        }
        return keys;
    }

    @Override
    public FetchContext getContext(ObjectContainer container) {
        boolean segmentActive = true;
        if (this.persistent && !(segmentActive = container.ext().isActive((Object)this.segment))) {
            container.activate((Object)this.segment, 1);
        }
        FetchContext ctx = this.segment.blockFetchContext;
        if (!segmentActive) {
            container.deactivate((Object)this.segment, 1);
        }
        if (this.persistent) {
            container.activate((Object)ctx, 1);
        }
        return ctx;
    }

    private boolean localRequestOnly(ObjectContainer container, ClientContext context) {
        boolean localOnly = false;
        boolean segmentActive = true;
        boolean ctxActive = true;
        if (this.persistent && !(segmentActive = container.ext().isActive((Object)this.segment))) {
            container.activate((Object)this.segment, 1);
        }
        FetchContext ctx = this.segment.blockFetchContext;
        if (!segmentActive) {
            container.deactivate((Object)this.segment, 1);
        }
        if (this.persistent) {
            ctxActive = container.ext().isActive((Object)ctx);
            container.activate((Object)ctx, 1);
        }
        localOnly = ctx.localRequestOnly;
        if (!ctxActive) {
            container.deactivate((Object)ctx, 1);
        }
        return localOnly;
    }

    private FetchException translateException(LowLevelGetException e) {
        switch (e.code) {
            case 2: 
            case 4: {
                return new FetchException(13);
            }
            case 10: {
                return new FetchException(30);
            }
            case 1: {
                return new FetchException(6);
            }
            case 3: {
                return new FetchException(17);
            }
            case 6: {
                return new FetchException(15);
            }
            case 5: {
                return new FetchException(14);
            }
            case 7: {
                return new FetchException(18);
            }
            case 8: {
                return new FetchException(6);
            }
            case 9: {
                return new FetchException(25);
            }
        }
        Logger.error(this, "Unknown LowLevelGetException code: " + e.code);
        return new FetchException(17, "Unknown error code: " + e.code);
    }

    @Override
    public void onFailure(LowLevelGetException e, Object token, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "onFailure(" + e + " , " + token + " on " + this);
        }
        this.onFailure(this.translateException(e), token, container, context);
    }

    public void onFailure(FetchException e, Object token, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.segment.errors, 1);
        }
        boolean forceFatal = false;
        if (this.parent.isCancelled()) {
            if (logMINOR) {
                Logger.minor(this, "Failing: cancelled");
            }
            e = new FetchException(25);
            forceFatal = true;
        }
        this.segment.errors.inc(e.getMode());
        if (this.persistent) {
            this.segment.errors.storeTo(container);
        }
        if (e.isFatal() && token == null) {
            this.segment.fail(e, container, context, false);
        } else if (e.isFatal() || forceFatal) {
            this.segment.onFatalFailure(e, ((SplitFileFetcherSegmentSendableRequestItem)token).blockNum, container, context);
        } else {
            this.segment.onNonFatalFailure(e, ((SplitFileFetcherSegmentSendableRequestItem)token).blockNum, container, context);
        }
        if (this.persistent) {
            container.deactivate((Object)this.segment, 1);
            container.deactivate((Object)this.parent, 1);
            container.deactivate((Object)this.segment.errors, 1);
        }
    }

    @Override
    public long getCooldownWakeup(Object token, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
        }
        return this.segment.getCooldownWakeup(((SplitFileFetcherSegmentSendableRequestItem)token).blockNum, this.segment.getMaxRetries(container), container, context);
    }

    @Override
    public long getCooldownWakeupByKey(Key key, ObjectContainer container, ClientContext context) {
        boolean activated = false;
        if (this.persistent && !(activated = container.ext().isActive((Object)this.segment))) {
            container.activate((Object)this.segment, 1);
        }
        long ret = this.segment.getCooldownWakeupByKey(key, container, context);
        if (this.persistent && !activated) {
            container.deactivate((Object)this.segment, 1);
        }
        return ret;
    }

    @Override
    public void requeueAfterCooldown(Key key, long time, ObjectContainer container, ClientContext context) {
        int blockNum;
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
        }
        if ((blockNum = this.segment.getBlockNumber(key, container)) == -1) {
            return;
        }
        this.reschedule(container, context);
    }

    void reschedule(ObjectContainer container, ClientContext context) {
        if (this.getParentGrabArray() != null) {
            if (logMINOR) {
                Logger.minor(this, "Not rescheduling as already scheduled on " + this.getParentGrabArray());
            }
            return;
        }
        if (this.isCancelled(container)) {
            return;
        }
        try {
            this.getScheduler(container, context).register(null, new SendableGet[]{this}, this.persistent, container, this.getContextBlocks(container), true);
        }
        catch (KeyListenerConstructionException e) {
            Logger.error(this, "Impossible: " + e + " on " + this, (Throwable)e);
        }
    }

    private BlockSet getContextBlocks(ObjectContainer container) {
        FetchContext context = this.getContext(container);
        BlockSet blocks = context.blocks;
        if (blocks != null) {
            if (this.persistent) {
                container.activate((Object)blocks, 1);
            }
            return blocks;
        }
        return null;
    }

    @Override
    public boolean preRegister(ObjectContainer container, ClientContext context, boolean toNetwork) {
        if (!toNetwork) {
            return false;
        }
        if (this.localRequestOnly(container, context)) {
            if (this.persistent) {
                container.activate((Object)this.segment, 1);
            }
            this.segment.failCheckingDatastore(container, context);
            return true;
        }
        boolean deactivate = false;
        if (this.persistent) {
            deactivate = !container.ext().isActive((Object)this.parent);
            container.activate((Object)this.parent, 1);
        }
        this.parent.toNetwork(container, context);
        if (deactivate) {
            container.deactivate((Object)this.parent, 1);
        }
        return false;
    }

    @Override
    public short getPriorityClass(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        return this.parent.priorityClass;
    }

    @Override
    public SendableRequestItem chooseKey(KeysFetchingLocally fetching, ObjectContainer container, ClientContext context) {
        Integer x;
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
        }
        ArrayList<Integer> possibles = this.segment.validBlockNumbers(fetching, true, container, context);
        do {
            if (possibles != null && !possibles.isEmpty()) continue;
            return null;
        } while (this.segment.checkRecentlyFailed(x = ListUtils.removeRandomBySwapLastSimple(context.random, possibles), container, context, fetching, System.currentTimeMillis()));
        return new SplitFileFetcherSegmentSendableRequestItem(x);
    }

    @Override
    public long countAllKeys(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
        }
        return this.segment.countAllKeys(container, context);
    }

    @Override
    public long countSendableKeys(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
        }
        return this.segment.countSendableKeys(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.segment, 1);
        }
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            return this.parent.cancelled;
        }
    }

    @Override
    public RequestClient getClient(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        return this.parent.getClient();
    }

    @Override
    public ClientRequester getClientRequest() {
        return this.parent;
    }

    @Override
    public boolean isSSK() {
        return false;
    }

    @Override
    public List<PersistentChosenBlock> makeBlocks(PersistentChosenRequest request, RequestScheduler sched, KeysFetchingLocally keys, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
        }
        List<PersistentChosenBlock> blocks = this.segment.makeBlocks(request, sched, keys, this, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.segment, 1);
        }
        return blocks;
    }

    public void storeTo(ObjectContainer container) {
        container.store((Object)this);
    }

    @Override
    public long getCooldownTime(ObjectContainer container, ClientContext context, long now) {
        RandomGrabArray parentRGA;
        long wakeTime;
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
        }
        if ((wakeTime = this.segment.getCooldownTime(container, context, parentRGA = this.getParentGrabArray(), now)) > 0L) {
            context.cooldownTracker.setCachedWakeup(wakeTime, this, parentRGA, this.persistent, container, context, true);
        }
        return wakeTime;
    }

    @Override
    public void onFailure(BulkCallFailureItem[] items, ObjectContainer container, ClientContext context) {
        int i;
        FetchException[] fetchExceptions = new FetchException[items.length];
        int countFatal = 0;
        for (i = 0; i < items.length; ++i) {
            fetchExceptions[i] = this.translateException(items[i].e);
            if (!fetchExceptions[i].isFatal()) continue;
            ++countFatal;
        }
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.segment.errors, 1);
        }
        if (this.parent.isCancelled()) {
            if (logMINOR) {
                Logger.minor(this, "Failing: cancelled");
            }
            this.segment.fail(new FetchException(25), container, context, false);
            return;
        }
        for (i = 0; i < fetchExceptions.length; ++i) {
            this.segment.errors.inc(fetchExceptions[i].getMode());
        }
        if (this.persistent) {
            this.segment.errors.storeTo(container);
        }
        int nonFatalExceptions = items.length - countFatal;
        int[] blockNumbers = new int[nonFatalExceptions];
        if (countFatal > 0) {
            FetchException[] newFetchExceptions = new FetchException[items.length - countFatal];
            int x = 0;
            for (int i2 = 0; i2 < items.length; ++i2) {
                int blockNum = ((SplitFileFetcherSegmentSendableRequestItem)items[i2].token).blockNum;
                if (fetchExceptions[i2].isFatal()) {
                    this.segment.onFatalFailure(fetchExceptions[i2], blockNum, container, context);
                    continue;
                }
                blockNumbers[x] = blockNum;
                newFetchExceptions[x] = fetchExceptions[i2];
                ++x;
            }
            fetchExceptions = newFetchExceptions;
        } else {
            for (int i3 = 0; i3 < blockNumbers.length; ++i3) {
                blockNumbers[i3] = ((SplitFileFetcherSegmentSendableRequestItem)items[i3].token).blockNum;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Calling segment.onNonFatalFailure with " + blockNumbers.length + " failed fetches");
        }
        this.segment.onNonFatalFailure(fetchExceptions, blockNumbers, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.segment, 1);
            container.deactivate((Object)this.parent, 1);
            container.deactivate((Object)this.segment.errors, 1);
        }
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

