/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequester;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.PersistentChosenBlock;
import freenet.client.async.PersistentChosenRequest;
import freenet.client.async.SplitFileFetcherSegment;
import freenet.client.async.SplitFileFetcherSegmentGet;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.node.BulkCallFailureItem;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelGetException;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.node.SendableRequestItem;
import freenet.node.SupportsBulkCallFailure;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.NativeThread;
import java.util.List;
import java.util.Vector;

public class SplitFileFetcherSubSegment
extends SendableGet
implements SupportsBulkCallFailure {
    final int retryCount;
    final SplitFileFetcherSegment segment;
    final Vector<Integer> blockNums;
    final FetchContext ctx;
    private static boolean logMINOR;
    private boolean cancelled;

    @Override
    public boolean isStorageBroken(ObjectContainer container) {
        if (!container.ext().isActive((Object)this)) {
            throw new IllegalStateException("Must be activated first!");
        }
        if (this.segment == null) {
            Logger.error(this, "No segment");
            return true;
        }
        if (this.ctx == null) {
            Logger.error(this, "No fetch context");
            return true;
        }
        if (this.blockNums == null) {
            Logger.error(this, "No block nums");
            return true;
        }
        return false;
    }

    SplitFileFetcherSubSegment(SplitFileFetcherSegment segment, ClientRequester parent, int retryCount) {
        super(parent, false);
        this.segment = segment;
        this.retryCount = retryCount;
        if (parent == null) {
            throw new NullPointerException();
        }
        this.ctx = segment.blockFetchContext;
        this.blockNums = new Vector();
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
    }

    @Override
    public FetchContext getContext(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.ctx, 1);
        }
        return this.ctx;
    }

    @Override
    public SendableRequestItem chooseKey(KeysFetchingLocally keys, ObjectContainer container, ClientContext context) {
        return null;
    }

    @Override
    public ClientKey getKey(Object token, ObjectContainer container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long countAllKeys(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate((Object)this.segment, 1);
        }
        return this.segment.getKeyNumbersAtRetryLevel(this.retryCount, container, context).length;
    }

    @Override
    public long countSendableKeys(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate(this.blockNums, 1);
        }
        this.cleanBlockNums(container);
        return this.blockNums.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanBlockNums(ObjectContainer container) {
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            int initSize = this.blockNums.size();
            Integer prev = null;
            for (int i = 0; i < this.blockNums.size(); ++i) {
                Integer x = this.blockNums.get(i);
                if (x == prev || x.equals(prev)) {
                    this.blockNums.remove(i);
                    if (logMINOR) {
                        Logger.minor(this, "Removing " + x + " (index " + i + ") in cleanBlockNums on " + this);
                    }
                    --i;
                    if (!this.persistent) continue;
                    container.delete((Object)x);
                    continue;
                }
                prev = x;
            }
            if (this.blockNums.size() < initSize) {
                Logger.error(this, "Cleaned block number list duplicates: was " + initSize + " now " + this.blockNums.size());
            }
        }
    }

    @Override
    public void onFailure(BulkCallFailureItem[] items, ObjectContainer container, ClientContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onFailure(LowLevelGetException e, Object token, ObjectContainer container, ClientContext context) {
        throw new UnsupportedOperationException();
    }

    protected void onFailure(FetchException e, Object token, ObjectContainer container, ClientContext context) {
        throw new UnsupportedOperationException();
    }

    protected void onSuccess(Bucket data, boolean fromStore, Integer token, int blockNo, ClientCHKBlock block, ObjectContainer container, ClientContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestClient getClient(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        return this.parent.getClient();
    }

    @Override
    public ClientRequester getClientRequest() {
        return this.parent;
    }

    @Override
    public short getPriorityClass(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        return this.parent.priorityClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.segment, 1);
        }
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            return this.parent.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate(this.blockNums, 1);
        }
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            if (this.blockNums.isEmpty() && !this.cancelled && logMINOR) {
                Logger.minor(this, "Subsegment is empty, removing: " + this);
            }
            return this.cancelled || this.blockNums.isEmpty();
        }
    }

    @Override
    public boolean isSSK() {
        return false;
    }

    public void onGotKey(Key key, KeyBlock block, ObjectContainer container, ClientContext context) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(ObjectContainer container, ClientContext context, boolean dontDeactivateSeg, boolean cancelledAlready) {
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
            container.activate(this.blockNums, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Killing " + this);
        }
        this.unregister(container, context, this.getPriorityClass(container));
        Integer[] oldNums = null;
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            if (cancelledAlready) {
                if (!this.cancelled) {
                    this.cancelled = true;
                }
            } else {
                if (this.cancelled) {
                    return;
                }
                this.cancelled = true;
            }
            if (this.persistent) {
                oldNums = this.blockNums.toArray(new Integer[this.blockNums.size()]);
            }
            this.blockNums.clear();
        }
        if (this.persistent && oldNums != null && oldNums.length > 0) {
            for (Integer i : oldNums) {
                container.delete((Object)i);
            }
        }
        if (this.persistent) {
            this.removeFrom(container, context, dontDeactivateSeg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrom(ObjectContainer container, ClientContext context, boolean dontDeactivateSeg) {
        container.activate((Object)this.segment, 1);
        container.activate(this.blockNums, 1);
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            if (!this.cancelled) {
                Logger.error(this, "Removing when not cancelled! on " + this, (Throwable)new Exception("error"));
                this.cancelled = true;
            }
            if (!this.blockNums.isEmpty()) {
                Logger.error(this, "Removing when blockNums not empty! on " + this, (Throwable)new Exception("error"));
                for (Integer i : this.blockNums) {
                    container.delete((Object)i);
                }
                this.blockNums.clear();
            }
        }
        container.delete(this.blockNums);
        container.delete((Object)this);
        if (!dontDeactivateSeg) {
            container.deactivate((Object)this.segment, 1);
        }
    }

    @Override
    public long getCooldownWakeup(Object token, ObjectContainer container, ClientContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void requeueAfterCooldown(Key key, long time, ObjectContainer container, ClientContext context) {
        this.migrateToSegmentFetcher(container, context);
    }

    @Override
    public long getCooldownWakeupByKey(Key key, ObjectContainer container, ClientContext context) {
        boolean activated = false;
        if (this.persistent && !(activated = container.ext().isActive((Object)this.segment))) {
            container.activate((Object)this.segment, 1);
        }
        long ret = this.segment.getCooldownWakeupByKey(key, container, context);
        if (this.persistent && !activated) {
            container.deactivate((Object)this.segment, 1);
        }
        return ret;
    }

    public void reschedule(ObjectContainer container, ClientContext context) {
        this.migrateToSegmentFetcher(container, context);
    }

    @Override
    public List<PersistentChosenBlock> makeBlocks(PersistentChosenRequest request, RequestScheduler sched, KeysFetchingLocally keys, ObjectContainer container, ClientContext context) {
        this.queueMigrateToSegmentFetcher(container, context);
        return null;
    }

    private void queueMigrateToSegmentFetcher(ObjectContainer container, ClientContext context) {
        assert (container != null);
        assert (this.persistent);
        if (!container.ext().isStored((Object)this)) {
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Queueing migrate to segment fetcher for " + this);
        }
        try {
            context.jobRunner.queue(new DBJob(){

                @Override
                public boolean run(ObjectContainer container, ClientContext context) {
                    if (!container.ext().isStored((Object)SplitFileFetcherSubSegment.this)) {
                        return false;
                    }
                    container.activate((Object)SplitFileFetcherSubSegment.this, 1);
                    SplitFileFetcherSubSegment.this.migrateToSegmentFetcher(container, context);
                    return false;
                }
            }, NativeThread.NORM_PRIORITY, false);
        }
        catch (DatabaseDisabledException databaseDisabledException) {
            // empty catch block
        }
    }

    private void migrateToSegmentFetcher(ObjectContainer container, ClientContext context) {
        boolean cancelled;
        if (this.segment == null) {
            Logger.error(this, "Migrating to segment fetcher on " + this + " but segment is null!");
            if (container.ext().isStored((Object)this)) {
                Logger.error(this, "... and this is stored!");
            }
            if (container.ext().isActive((Object)this)) {
                Logger.error(this, "... and activated!");
            }
            return;
        }
        boolean segmentActive = true;
        if (this.persistent && !(segmentActive = container.ext().isActive((Object)this.segment))) {
            container.activate((Object)this.segment, 1);
        }
        boolean bl = cancelled = this.isCancelled(container) || this.isEmpty(container) || this.segment.isFinishing(container);
        if (!cancelled) {
            SplitFileFetcherSegmentGet getter = this.segment.makeGetter(container, context);
            if (this.persistent) {
                container.activate((Object)getter, 1);
            }
            getter.reschedule(container, context);
            if (this.persistent) {
                container.deactivate((Object)getter, 1);
            }
        } else {
            this.kill(container, context, true, false);
        }
        if (!segmentActive) {
            container.deactivate((Object)this.segment, 1);
        }
    }

    @Override
    public Key[] listKeys(ObjectContainer container) {
        boolean activated = false;
        if (this.persistent && !(activated = container.ext().isActive((Object)this.segment))) {
            container.activate((Object)this.segment, 1);
        }
        Key[] keys = this.segment.listKeys(container);
        if (this.persistent && !activated) {
            container.deactivate((Object)this.segment, 1);
        }
        return keys;
    }

    public int objectHash() {
        return super.hashCode();
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.blockNums == null) {
            throw new NullPointerException("Storing " + this + " but blockNums == null!");
        }
        if (this.segment == null) {
            throw new NullPointerException("Storing " + this + " but segment == null!");
        }
        return true;
    }

    public boolean objectCanUpdate(ObjectContainer container) {
        if (this.blockNums == null) {
            if (!container.ext().isActive((Object)this)) {
                Logger.error(this, "Not active and blockNums == null but trying to store", (Throwable)new Exception("error"));
                return false;
            }
            throw new NullPointerException("Storing " + this + " but blockNums == null!");
        }
        if (this.segment == null) {
            throw new NullPointerException("Storing " + this + " but segment == null!");
        }
        return true;
    }

    @Override
    public boolean preRegister(ObjectContainer container, ClientContext context, boolean toNetwork) {
        if (!toNetwork) {
            return false;
        }
        boolean deactivate = false;
        if (this.persistent) {
            deactivate = !container.ext().isActive((Object)this.parent);
            container.activate((Object)this.parent, 1);
        }
        this.parent.toNetwork(container, context);
        if (deactivate) {
            container.deactivate((Object)this.parent, 1);
        }
        return false;
    }

    @Override
    public long getCooldownTime(ObjectContainer container, ClientContext context, long now) {
        this.queueMigrateToSegmentFetcher(container, context);
        return Long.MAX_VALUE;
    }
}

