/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveContext;
import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.InsertContext;
import freenet.client.async.BaseClientGetter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientGetWorkerThread;
import freenet.client.async.SingleFileFetcher;
import freenet.client.async.StreamGenerator;
import freenet.client.async.USKCallback;
import freenet.client.async.USKFetcher;
import freenet.client.async.USKManager;
import freenet.client.async.USKRetrieverCallback;
import freenet.crypt.HashResult;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.node.PrioRunnable;
import freenet.node.RequestClient;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.compress.Compressor;
import freenet.support.compress.DecompressorThreadManager;
import freenet.support.io.Closer;
import freenet.support.io.NativeThread;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.util.List;

public class USKRetriever
extends BaseClientGetter
implements USKCallback {
    final FetchContext ctx;
    final USKRetrieverCallback cb;
    final USK origUSK;
    private USKCallback proxy;
    private USKFetcher fetcher;
    private static volatile boolean logMINOR;

    public USKRetriever(FetchContext fctx, short prio, RequestClient client, USKRetrieverCallback cb, USK origUSK) {
        super(prio, client);
        if (client.persistent()) {
            throw new UnsupportedOperationException("USKRetriever cannot be persistent");
        }
        this.ctx = fctx;
        this.cb = cb;
        this.origUSK = origUSK;
        this.proxy = this;
    }

    @Override
    public void onFoundEdition(long l, USK key, ObjectContainer container, ClientContext context, boolean metadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
        if (l < 0L) {
            Logger.error(this, "Found negative edition: " + l + " for " + key + " !!!");
            return;
        }
        if (l < this.origUSK.suggestedEdition) {
            Logger.warning(this, "Found edition prior to that specified by the client: " + l + " < " + this.origUSK.suggestedEdition, (Throwable)new Exception("error"));
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Found edition " + l + " for " + this + " - fetching...");
        }
        FreenetURI uri = key.getSSK(l).getURI();
        try {
            SingleFileFetcher getter = (SingleFileFetcher)SingleFileFetcher.create(this, this, uri, this.ctx, new ArchiveContext(this.ctx.maxTempLength, this.ctx.maxArchiveLevels), this.ctx.maxNonSplitfileRetries, 0, true, l, true, false, null, context, this.realTimeFlag, false);
            getter.schedule(null, context);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Impossible: " + e, (Throwable)e);
        }
        catch (FetchException e) {
            Logger.error(this, "Could not start fetcher for " + uri + " : " + e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void onSuccess(StreamGenerator streamGenerator, ClientMetadata clientMetadata, List<? extends Compressor> decompressors, final ClientGetState state, ObjectContainer container, ClientContext context) {
        PipedOutputStream pipeOut;
        Bucket finalResult;
        OutputStream output;
        block13: {
            if (logMINOR) {
                Logger.minor(this, "Success on " + this + " from " + state + " : length " + streamGenerator.size() + "mime type " + clientMetadata.getMIMEType());
            }
            DecompressorThreadManager decompressorManager = null;
            output = null;
            finalResult = null;
            long maxLen = Math.max(this.ctx.maxTempLength, this.ctx.maxOutputLength);
            try {
                finalResult = context.getBucketFactory(this.persistent()).makeBucket(maxLen);
            }
            catch (IOException e) {
                Logger.error(this, "Caught " + e, (Throwable)e);
                this.onFailure(new FetchException(12, (Throwable)e), state, container, context);
                return;
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
                this.onFailure(new FetchException(17, t), state, container, context);
                return;
            }
            PipedInputStream pipeIn = null;
            pipeOut = null;
            try {
                output = finalResult.getOutputStream();
                if (decompressors != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Decompressing...");
                    }
                    if (this.persistent()) {
                        container.activate(decompressors, 5);
                        container.activate((Object)this.ctx, 1);
                    }
                    pipeIn = new PipedInputStream();
                    pipeOut = new PipedOutputStream(pipeIn);
                    decompressorManager = new DecompressorThreadManager(pipeIn, decompressors, maxLen);
                    pipeIn = decompressorManager.execute();
                    ClientGetWorkerThread worker = new ClientGetWorkerThread(pipeIn, output, null, null, null, false, null, null, null, context.linkFilterExceptionProvider);
                    worker.start();
                    streamGenerator.writeTo(pipeOut, container, context);
                    worker.waitFinished();
                    pipeOut.close();
                    pipeOut = null;
                    break block13;
                }
                streamGenerator.writeTo(output, container, context);
                output.close();
                output = null;
            }
            catch (IOException e) {
                Logger.error(this, "Caught " + e, (Throwable)e);
                this.onFailure(new FetchException(17, (Throwable)e), state, container, context);
                Closer.close(output);
                Closer.close(pipeOut);
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
                this.onFailure(new FetchException(17, t), state, container, context);
                {
                    catch (Throwable throwable) {
                        Closer.close(output);
                        Closer.close(pipeOut);
                        throw throwable;
                    }
                }
                Closer.close(output);
                Closer.close(pipeOut);
                return;
            }
        }
        Closer.close(output);
        Closer.close(pipeOut);
        final FetchResult result = new FetchResult(clientMetadata, finalResult);
        context.uskManager.updateKnownGood(this.origUSK, state.getToken(), context);
        context.mainExecutor.execute(new PrioRunnable(){

            @Override
            public void run() {
                USKRetriever.this.cb.onFound(USKRetriever.this.origUSK, state.getToken(), result);
            }

            @Override
            public int getPriority() {
                return NativeThread.NORM_PRIORITY;
            }
        });
    }

    @Override
    public void onFailure(FetchException e, ClientGetState state, ObjectContainer container, ClientContext context) {
        switch (e.mode) {
            case 24: 
            case 27: {
                context.uskManager.updateKnownGood(this.origUSK, state.getToken(), context);
                return;
            }
        }
        Logger.warning(this, "Found edition " + state.getToken() + " but failed to fetch edition: " + e, (Throwable)e);
    }

    @Override
    public void onBlockSetFinished(ClientGetState state, ObjectContainer container, ClientContext context) {
    }

    public USK getOriginalUSK() {
        return this.origUSK;
    }

    @Override
    public FreenetURI getURI() {
        return this.origUSK.getURI();
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public void notifyClients(ObjectContainer container, ClientContext context) {
    }

    @Override
    public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
    }

    @Override
    public void onExpectedMIME(ClientMetadata meta, ObjectContainer container, ClientContext context) {
    }

    @Override
    public void onExpectedSize(long size, ObjectContainer container, ClientContext context) {
    }

    @Override
    public void onFinalizedMetadata(ObjectContainer container) {
    }

    @Override
    public short getPollingPriorityNormal() {
        return this.cb.getPollingPriorityNormal();
    }

    @Override
    public short getPollingPriorityProgress() {
        return this.cb.getPollingPriorityProgress();
    }

    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        super.cancel();
    }

    @Override
    protected void innerToNetwork(ObjectContainer container, ClientContext context) {
    }

    @Override
    public void onExpectedTopSize(long size, long compressed, int blocksReq, int blocksTotal, ObjectContainer container, ClientContext context) {
    }

    @Override
    public void onSplitfileCompatibilityMode(InsertContext.CompatibilityMode min, InsertContext.CompatibilityMode max, byte[] splitfileKey, boolean compressed, boolean bottomLayer, boolean definitiveAnyway, ObjectContainer container, ClientContext context) {
    }

    @Override
    public void onHashes(HashResult[] hashes, ObjectContainer container, ClientContext context) {
    }

    synchronized void setProxy(USKCallback cb) {
        this.proxy = cb;
    }

    synchronized USKCallback getProxy() {
        return this.proxy;
    }

    synchronized void setFetcher(USKFetcher f) {
        this.fetcher = f;
    }

    synchronized USKFetcher getFetcher() {
        return this.fetcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(USKManager manager) {
        USKCallback p;
        USKFetcher f;
        USKRetriever uSKRetriever = this;
        synchronized (uSKRetriever) {
            f = this.fetcher;
            p = this.proxy;
        }
        if (f != null) {
            f.cancel(null, manager.getContext());
        }
        if (p != null) {
            manager.unsubscribe(this.origUSK, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeUSKPollParameters(long time, int tries, ClientContext context) {
        USKFetcher f;
        USKRetriever uSKRetriever = this;
        synchronized (uSKRetriever) {
            f = this.fetcher;
        }
        if (f == null) {
            throw new IllegalStateException();
        }
        f.changeUSKPollParameters(time, tries, context);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

