/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.wizardsteps;

import freenet.clients.http.FirstTimeWizardToadlet;
import freenet.clients.http.wizardsteps.PageHelper;
import freenet.clients.http.wizardsteps.Step;
import freenet.clients.http.wizardsteps.WizardL10n;
import freenet.config.Config;
import freenet.config.ConfigException;
import freenet.config.Option;
import freenet.l10n.NodeL10n;
import freenet.node.NodeClientCore;
import freenet.node.NodeStarter;
import freenet.support.Fields;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.SizeUtil;
import freenet.support.api.HTTPRequest;
import freenet.support.io.FileUtil;

public class DATASTORE_SIZE
implements Step {
    private final NodeClientCore core;
    private final Config config;

    public DATASTORE_SIZE(NodeClientCore core, Config config) {
        this.config = config;
        this.core = core;
    }

    @Override
    public void getStep(HTTPRequest request, PageHelper helper) {
        Option<?> sizeOption;
        HTMLNode contentNode = helper.getPageContent(WizardL10n.l10n("step4Title"));
        HTMLNode bandwidthInfoboxContent = helper.getInfobox("infobox-header", WizardL10n.l10n("datastoreSize"), contentNode, null, false);
        bandwidthInfoboxContent.addChild("#", WizardL10n.l10n("datastoreSizeLong"));
        HTMLNode bandwidthForm = helper.addFormChild(bandwidthInfoboxContent, ".", "dsForm");
        HTMLNode result = bandwidthForm.addChild("select", "name", "ds");
        long maxSize = this.maxDatastoreSize();
        long autodetectedSize = this.canAutoconfigureDatastoreSize();
        if (maxSize < autodetectedSize) {
            autodetectedSize = maxSize;
        }
        if (!(sizeOption = this.config.get("node").getOption("storeSize")).isDefault()) {
            long current = (Long)sizeOption.getValue();
            result.addChild("option", new String[]{"value", "selected"}, new String[]{SizeUtil.formatSize(current), "on"}, WizardL10n.l10n("currentPrefix") + " " + SizeUtil.formatSize(current));
        } else if (autodetectedSize != -1L) {
            result.addChild("option", new String[]{"value", "selected"}, new String[]{SizeUtil.formatSize(autodetectedSize), "on"}, SizeUtil.formatSize(autodetectedSize));
        }
        if (autodetectedSize != 0x20000000L) {
            result.addChild("option", "value", "512M", "512 MiB");
        }
        result.addChild("option", "value", "1G", "1 GiB");
        if (maxSize >= 0x80000000L) {
            if (autodetectedSize != -1L || !sizeOption.isDefault()) {
                result.addChild("option", "value", "2G", "2 GiB");
            } else {
                result.addChild("option", new String[]{"value", "selected"}, new String[]{"2G", "on"}, "2GiB");
            }
        }
        if (maxSize >= 0xC0000000L) {
            result.addChild("option", "value", "3G", "3 GiB");
        }
        if (maxSize >= 0x140000000L) {
            result.addChild("option", "value", "5G", "5 GiB");
        }
        if (maxSize >= 0x280000000L) {
            result.addChild("option", "value", "10G", "10 GiB");
        }
        if (maxSize >= 0x500000000L) {
            result.addChild("option", "value", "20G", "20 GiB");
        }
        if (maxSize >= 0x780000000L) {
            result.addChild("option", "value", "30G", "30 GiB");
        }
        if (maxSize >= 0xC80000000L) {
            result.addChild("option", "value", "50G", "50 GiB");
        }
        if (maxSize >= 0x1900000000L) {
            result.addChild("option", "value", "100G", "100 GiB");
        }
        if (maxSize >= 0x3200000000L) {
            result.addChild("option", "value", "200G", "200GiB");
        }
        if (maxSize >= 0x4B00000000L) {
            result.addChild("option", "value", "300G", "300GiB");
        }
        if (maxSize >= 0x7D00000000L) {
            result.addChild("option", "value", "500G", "500GiB");
        }
        HTMLNode below = bandwidthForm.addChild("div");
        below.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "back", NodeL10n.getBase().getString("Toadlet.back")});
        below.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "next", NodeL10n.getBase().getString("Toadlet.next")});
    }

    @Override
    public String postStep(HTTPRequest request) {
        this._setDatastoreSize(request.getPartAsStringFailsafe("ds", 20));
        return FirstTimeWizardToadlet.WIZARD_STEP.BANDWIDTH.name();
    }

    private void _setDatastoreSize(String selectedStoreSize) {
        try {
            long size = Fields.parseLong(selectedStoreSize);
            long clientCacheSize = Math.min(size / 10L, 0xC800000L);
            int upstreamLimit = this.config.get("node").getInt("outputBandwidthLimit");
            int downstreamLimit = this.config.get("node").getInt("inputBandwidthLimit");
            int limit = downstreamLimit <= 0 ? upstreamLimit : Math.min(downstreamLimit, upstreamLimit);
            long lifetime = this.config.get("node").getLong("slashdotCacheLifetime");
            long maxSlashdotCacheSize = lifetime / 1000L * (long)limit;
            long slashdotCacheSize = Math.min(size / 10L, maxSlashdotCacheSize);
            long storeSize = size - (clientCacheSize + slashdotCacheSize);
            System.out.println("Setting datastore size to " + Fields.longToString(storeSize, true));
            this.config.get("node").set("storeSize", Fields.longToString(storeSize, true));
            if (this.config.get("node").getString("storeType").equals("ram")) {
                this.config.get("node").set("storeType", "salt-hash");
            }
            System.out.println("Setting client cache size to " + Fields.longToString(clientCacheSize, true));
            this.config.get("node").set("clientCacheSize", Fields.longToString(clientCacheSize, true));
            if (this.config.get("node").getString("clientCacheType").equals("ram")) {
                this.config.get("node").set("clientCacheType", "salt-hash");
            }
            System.out.println("Setting slashdot/ULPR/recent requests cache size to " + Fields.longToString(slashdotCacheSize, true));
            this.config.get("node").set("slashdotCacheSize", Fields.longToString(slashdotCacheSize, true));
            Logger.normal(this, "The storeSize has been set to " + selectedStoreSize);
        }
        catch (ConfigException e) {
            Logger.error(this, "Should not happen, please report!" + e, (Throwable)e);
        }
    }

    private long maxDatastoreSize() {
        long maxMemory = NodeStarter.getMemoryLimitBytes();
        if (maxMemory == Long.MAX_VALUE) {
            return 0x40000000L;
        }
        if (maxMemory < 0x8000000L) {
            return 0x40000000L;
        }
        long available = maxMemory - 0x6400000L;
        long slots = (available /= 2L) / 4L;
        return (slots /= 3L) * 34988L;
    }

    private long canAutoconfigureDatastoreSize() {
        if (!this.config.get("node").getOption("storeSize").isDefault()) {
            return -1L;
        }
        long freeSpace = FileUtil.getFreeSpace(this.core.node.getStoreDir());
        if (freeSpace <= 0L) {
            return -1L;
        }
        long shortSize = freeSpace / 20L > 0x40000000L ? Math.min(freeSpace / 20L, 0x4000000000L) : (freeSpace / 10L > 0x40000000L ? freeSpace / 10L : (freeSpace / 5L > 0x40000000L ? 0x20000000L : 0x10000000L));
        return shortSize;
    }
}

