/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptoKey;
import freenet.crypt.Util;
import freenet.support.HexUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.StringTokenizer;
import net.i2p.util.NativeBigInteger;

public class DHGroup
extends CryptoKey {
    private static final long serialVersionUID = -1L;
    public final BigInteger p;
    public final BigInteger g;

    public DHGroup(BigInteger p, BigInteger g) {
        this.p = p;
        this.g = g;
    }

    @Override
    public String toLongString() {
        String pStr = HexUtil.biToHex(this.p);
        String gStr = HexUtil.biToHex(this.g);
        StringBuilder b = new StringBuilder(pStr.length() + gStr.length() + 1);
        b.append(pStr).append(',').append(gStr);
        return b.toString();
    }

    public static CryptoKey readFromField(String field) {
        StringTokenizer str = new StringTokenizer(field, ",");
        NativeBigInteger p = new NativeBigInteger(1, HexUtil.hexToBytes(str.nextToken()));
        NativeBigInteger g = new NativeBigInteger(1, HexUtil.hexToBytes(str.nextToken()));
        return new DHGroup(p, g);
    }

    public static CryptoKey read(DataInputStream i) throws IOException {
        BigInteger p = Util.readMPI(i);
        BigInteger g = Util.readMPI(i);
        return new DHGroup(p, g);
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    @Override
    public String keyType() {
        return "DHG-" + this.p.bitLength();
    }

    @Override
    public byte[] fingerprint() {
        return this.fingerprint(new BigInteger[]{this.p, this.g});
    }

    @Override
    public byte[] asBytes() {
        byte[] pb = Util.MPIbytes(this.p);
        byte[] gb = Util.MPIbytes(this.g);
        byte[] tb = new byte[pb.length + gb.length];
        System.arraycopy(pb, 0, tb, 0, pb.length);
        System.arraycopy(gb, 0, tb, pb.length, gb.length);
        return tb;
    }
}

