/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.BlockCipher;
import freenet.crypt.RandomSource;
import freenet.crypt.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PCFBMode {
    protected final BlockCipher c;
    protected final byte[] feedback_register;
    protected int registerPointer;

    @Deprecated
    public static PCFBMode create(BlockCipher c) {
        return new PCFBMode(c);
    }

    public static PCFBMode create(BlockCipher c, byte[] iv) {
        return PCFBMode.create(c, iv, 0);
    }

    public static PCFBMode create(BlockCipher c, byte[] iv, int offset) {
        return new PCFBMode(c, iv, offset);
    }

    protected PCFBMode(BlockCipher c) {
        this.c = c;
        this.feedback_register = new byte[c.getBlockSize() >> 3];
        this.registerPointer = this.feedback_register.length;
    }

    protected PCFBMode(BlockCipher c, byte[] iv, int offset) {
        this(c);
        System.arraycopy(iv, offset, this.feedback_register, 0, this.feedback_register.length);
    }

    public final void reset(byte[] iv) {
        System.arraycopy(iv, 0, this.feedback_register, 0, this.feedback_register.length);
        this.registerPointer = this.feedback_register.length;
    }

    public final void reset(byte[] iv, int offset) {
        System.arraycopy(iv, offset, this.feedback_register, 0, this.feedback_register.length);
        this.registerPointer = this.feedback_register.length;
    }

    public void writeIV(RandomSource rs, OutputStream out) throws IOException {
        rs.nextBytes(this.feedback_register);
        out.write(this.feedback_register);
    }

    public void readIV(InputStream in) throws IOException {
        Util.readFully(in, this.feedback_register);
    }

    public int lengthIV() {
        return this.feedback_register.length;
    }

    public static int lengthIV(BlockCipher c) {
        return c.getBlockSize() >> 3;
    }

    public int decipher(int b) {
        if (this.registerPointer == this.feedback_register.length) {
            this.refillBuffer();
        }
        int rv = (this.feedback_register[this.registerPointer] ^ (byte)b) & 0xFF;
        this.feedback_register[this.registerPointer++] = (byte)b;
        return rv;
    }

    public byte[] blockDecipher(byte[] buf, int off, int len) {
        byte b;
        int feedback_length = this.feedback_register.length;
        if (this.registerPointer != 0) {
            int l = Math.min(feedback_length - this.registerPointer, len);
            len -= l;
            while (l-- > 0) {
                byte b2 = buf[off];
                int n = off++;
                buf[n] = (byte)(buf[n] ^ this.feedback_register[this.registerPointer]);
                this.feedback_register[this.registerPointer++] = b2;
            }
            if (len == 0) {
                return buf;
            }
            this.refillBuffer();
        }
        while (len > feedback_length) {
            len -= feedback_length;
            while (this.registerPointer < feedback_length) {
                b = buf[off];
                int n = off++;
                buf[n] = (byte)(buf[n] ^ this.feedback_register[this.registerPointer]);
                this.feedback_register[this.registerPointer++] = b;
            }
            this.refillBuffer();
        }
        while (len-- > 0) {
            b = buf[off];
            int n = off++;
            buf[n] = (byte)(buf[n] ^ this.feedback_register[this.registerPointer]);
            this.feedback_register[this.registerPointer++] = b;
        }
        return buf;
    }

    public int encipher(int b) {
        if (this.registerPointer == this.feedback_register.length) {
            this.refillBuffer();
        }
        int n = this.registerPointer;
        this.feedback_register[n] = (byte)(this.feedback_register[n] ^ (byte)b);
        return this.feedback_register[this.registerPointer++] & 0xFF;
    }

    public byte[] blockEncipher(byte[] buf, int off, int len) {
        int feedback_length = this.feedback_register.length;
        if (this.registerPointer != 0) {
            int l = Math.min(feedback_length - this.registerPointer, len);
            len -= l;
            while (l-- > 0) {
                int n = this.registerPointer++;
                byte by = (byte)(this.feedback_register[n] ^ buf[off]);
                this.feedback_register[n] = by;
                buf[off] = by;
                ++off;
            }
            if (len == 0) {
                return buf;
            }
            this.refillBuffer();
        }
        while (len > feedback_length) {
            len -= feedback_length;
            while (this.registerPointer < feedback_length) {
                int n = this.registerPointer++;
                byte by = (byte)(this.feedback_register[n] ^ buf[off]);
                this.feedback_register[n] = by;
                buf[off] = by;
                ++off;
            }
            this.refillBuffer();
        }
        while (len-- > 0) {
            int n = this.registerPointer++;
            byte by = (byte)(this.feedback_register[n] ^ buf[off]);
            this.feedback_register[n] = by;
            buf[off] = by;
            ++off;
        }
        return buf;
    }

    protected void refillBuffer() {
        this.c.encipher(this.feedback_register, this.feedback_register);
        this.registerPointer = 0;
    }
}

