/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import com.db4o.ObjectContainer;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequester;
import freenet.client.async.PersistentChosenBlock;
import freenet.client.async.PersistentChosenRequest;
import freenet.keys.CHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.KeyBlock;
import freenet.keys.SSKBlock;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelPutException;
import freenet.node.NodeClientCore;
import freenet.node.NullSendableRequestItem;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableInsert;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.List;

public class SimpleSendableInsert
extends SendableInsert {
    public final KeyBlock block;
    public final short prioClass;
    private boolean finished;
    public final RequestClient client;
    public final ClientRequestScheduler scheduler;
    private static volatile boolean logMINOR;

    public SimpleSendableInsert(NodeClientCore core, KeyBlock block, short prioClass) {
        super(false, false);
        this.block = block;
        this.prioClass = prioClass;
        this.client = core.node.nonPersistentClientBulk;
        if (block instanceof CHKBlock) {
            this.scheduler = core.requestStarters.chkPutSchedulerBulk;
        } else if (block instanceof SSKBlock) {
            this.scheduler = core.requestStarters.sskPutSchedulerBulk;
        } else {
            throw new IllegalArgumentException("Don't know what to do with " + block);
        }
        if (!this.scheduler.isInsertScheduler()) {
            throw new IllegalStateException("Scheduler " + this.scheduler + " is not an insert scheduler!");
        }
    }

    public SimpleSendableInsert(KeyBlock block, short prioClass, RequestClient client, ClientRequestScheduler scheduler) {
        super(false, false);
        this.block = block;
        this.prioClass = prioClass;
        this.client = client;
        this.scheduler = scheduler;
    }

    @Override
    public void onSuccess(Object keyNum, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Finished insert of " + this.block);
        }
    }

    @Override
    public void onFailure(LowLevelPutException e, Object keyNum, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Failed insert of " + this.block + ": " + e);
        }
    }

    @Override
    public short getPriorityClass(ObjectContainer container) {
        return this.prioClass;
    }

    @Override
    public SendableRequestSender getSender(ObjectContainer container, ClientContext context) {
        return new SendableRequestSender(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean send(NodeClientCore core, RequestScheduler sched, ClientContext context, ChosenBlock req) {
                try {
                    if (logMINOR) {
                        Logger.minor(this, "Starting request: " + this);
                    }
                    core.realPut(SimpleSendableInsert.this.block, req.canWriteClientCache, true, false, false, false);
                }
                catch (LowLevelPutException e) {
                    SimpleSendableInsert.this.onFailure(e, req.token, null, context);
                    if (logMINOR) {
                        Logger.minor(this, "Request failed: " + this + " for " + e);
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    SimpleSendableInsert.this.finished = true;
                }
                if (logMINOR) {
                    Logger.minor(this, "Request succeeded: " + this);
                }
                SimpleSendableInsert.this.onSuccess(req.token, null, context);
                return true;
            }

            @Override
            public boolean sendIsBlocking() {
                return true;
            }
        };
    }

    @Override
    public RequestClient getClient(ObjectContainer container) {
        return this.client;
    }

    @Override
    public ClientRequester getClientRequest() {
        return null;
    }

    @Override
    public boolean isCancelled(ObjectContainer container) {
        return this.finished;
    }

    @Override
    public boolean isEmpty(ObjectContainer container) {
        return this.finished;
    }

    public void schedule() {
        this.finished = false;
        this.scheduler.registerInsert(this, false, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ObjectContainer container, ClientContext context) {
        SimpleSendableInsert simpleSendableInsert = this;
        synchronized (simpleSendableInsert) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        super.unregister(container, context, this.prioClass);
    }

    @Override
    public synchronized long countAllKeys(ObjectContainer container, ClientContext context) {
        if (this.finished) {
            return 0L;
        }
        return 1L;
    }

    @Override
    public synchronized long countSendableKeys(ObjectContainer container, ClientContext context) {
        if (this.finished) {
            return 0L;
        }
        return 1L;
    }

    @Override
    public synchronized SendableRequestItem chooseKey(KeysFetchingLocally keys, ObjectContainer container, ClientContext context) {
        if (keys.hasTransientInsert(this, NullSendableRequestItem.nullItem)) {
            return null;
        }
        if (this.finished) {
            return null;
        }
        return NullSendableRequestItem.nullItem;
    }

    @Override
    public boolean isSSK() {
        return this.block instanceof SSKBlock;
    }

    @Override
    public List<PersistentChosenBlock> makeBlocks(PersistentChosenRequest request, RequestScheduler sched, KeysFetchingLocally keys, ObjectContainer container, ClientContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canWriteClientCache(ObjectContainer container) {
        return false;
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean forkOnCacheable(ObjectContainer container) {
        return true;
    }

    @Override
    public void onEncode(SendableRequestItem token, ClientKey key, ObjectContainer container, ClientContext context) {
    }

    @Override
    public boolean localRequestOnly(ObjectContainer container) {
        return false;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

