/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequester;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.keys.FreenetURI;
import freenet.node.PrioRunnable;
import freenet.node.RequestClient;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPConnectionOutputHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.IdentifierCollisionException;
import freenet.node.fcp.PersistentRequestModifiedMessage;
import freenet.node.fcp.RequestStatus;
import freenet.node.fcp.RequestStatusCache;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.NativeThread;

public abstract class ClientRequest {
    protected FreenetURI uri;
    protected final String identifier;
    protected final int verbosity;
    protected final transient FCPConnectionHandler origHandler;
    protected final FCPClient client;
    protected short priorityClass;
    protected final short persistenceType;
    protected final String charset;
    protected boolean finished;
    protected String clientToken;
    protected final boolean global;
    protected final long startupTime;
    protected long completionTime;
    protected long lastActivity;
    protected final RequestClient lowLevelClient;
    private final int hashCode;
    private static volatile boolean logMINOR;
    public static final short PERSIST_CONNECTION = 0;
    public static final short PERSIST_REBOOT = 1;
    public static final short PERSIST_FOREVER = 2;
    protected boolean started;

    public int hashCode() {
        return this.hashCode;
    }

    protected ClientRequest() {
        this.verbosity = 0;
        this.startupTime = 0L;
        this.persistenceType = 0;
        this.origHandler = null;
        this.lowLevelClient = null;
        this.charset = null;
        this.client = null;
        this.global = false;
        this.hashCode = 0;
        this.identifier = null;
    }

    public ClientRequest(FreenetURI uri2, String identifier2, int verbosity2, String charset, FCPConnectionHandler handler, FCPClient client, short priorityClass2, short persistenceType2, boolean realTime, String clientToken2, boolean global, ObjectContainer container) {
        int hash = super.hashCode();
        if (hash == 0) {
            hash = 1;
        }
        this.hashCode = hash;
        this.uri = uri2;
        this.identifier = identifier2;
        this.verbosity = global ? Integer.MAX_VALUE : verbosity2;
        this.finished = false;
        this.priorityClass = priorityClass2;
        this.persistenceType = persistenceType2;
        this.charset = charset;
        this.clientToken = clientToken2;
        this.global = global;
        if (this.persistenceType == 0) {
            this.origHandler = handler;
            this.lowLevelClient = this.origHandler.connectionRequestClient(realTime);
            this.client = null;
        } else {
            this.origHandler = null;
            if (this.persistenceType == 2) {
                container.activate((Object)client, 1);
                client.init(container);
            }
            this.client = client;
            assert (client != null);
            assert (client.persistenceType == this.persistenceType);
            this.lowLevelClient = client.lowLevelClient(realTime);
        }
        assert (this.lowLevelClient != null);
        this.startupTime = System.currentTimeMillis();
    }

    public ClientRequest(FreenetURI uri2, String identifier2, int verbosity2, String charset, FCPConnectionHandler handler, short priorityClass2, short persistenceType2, final boolean realTime, String clientToken2, boolean global, ObjectContainer container) {
        int hash = super.hashCode();
        if (hash == 0) {
            hash = 1;
        }
        this.hashCode = hash;
        this.uri = uri2;
        this.identifier = identifier2;
        this.verbosity = global ? Integer.MAX_VALUE : verbosity2;
        this.finished = false;
        this.priorityClass = priorityClass2;
        this.persistenceType = persistenceType2;
        this.clientToken = clientToken2;
        this.charset = charset;
        this.global = global;
        if (this.persistenceType == 0) {
            this.origHandler = handler;
            this.client = null;
            this.lowLevelClient = new RequestClient(){

                @Override
                public boolean persistent() {
                    return false;
                }

                @Override
                public void removeFrom(ObjectContainer container) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean realTimeFlag() {
                    return realTime;
                }
            };
        } else {
            this.origHandler = null;
            if (global) {
                this.client = this.persistenceType == 2 ? handler.server.globalForeverClient : handler.server.globalRebootClient;
            } else {
                FCPClient fCPClient = this.client = this.persistenceType == 2 ? handler.getForeverClient(container) : handler.getRebootClient();
            }
            if (this.persistenceType == 2) {
                container.activate((Object)this.client, 1);
                this.client.init(container);
            }
            this.lowLevelClient = this.client.lowLevelClient(realTime);
            if (this.lowLevelClient == null) {
                throw new NullPointerException("No lowLevelClient from client: " + this.client + " global = " + global + " persistence = " + this.persistenceType);
            }
        }
        if (this.lowLevelClient.persistent() != (this.persistenceType == 2)) {
            throw new IllegalStateException("Low level client.persistent=" + this.lowLevelClient.persistent() + " but persistence type = " + this.persistenceType);
        }
        if (this.client != null) assert (this.client.persistenceType == this.persistenceType);
        this.startupTime = System.currentTimeMillis();
    }

    public abstract void onLostConnection(ObjectContainer var1, ClientContext var2);

    public abstract void sendPendingMessages(FCPConnectionOutputHandler var1, boolean var2, boolean var3, boolean var4, ObjectContainer var5);

    public static String persistenceTypeString(short type) {
        switch (type) {
            case 0: {
                return "connection";
            }
            case 1: {
                return "reboot";
            }
            case 2: {
                return "forever";
            }
        }
        return Short.toString(type);
    }

    public static short parsePersistence(String string) {
        if (string == null || string.equalsIgnoreCase("connection")) {
            return 0;
        }
        if (string.equalsIgnoreCase("reboot")) {
            return 1;
        }
        if (string.equalsIgnoreCase("forever")) {
            return 2;
        }
        return Short.parseShort(string);
    }

    abstract void register(ObjectContainer var1, boolean var2) throws IdentifierCollisionException;

    public void cancel(ObjectContainer container, ClientContext context) {
        ClientRequester cr = this.getClientRequest();
        if (this.persistenceType == 2) {
            container.activate((Object)cr, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Cancelling " + cr + " for " + this + " persistenceType = " + this.persistenceType);
        }
        if (cr != null) {
            cr.cancel(container, context);
        }
        this.freeData(container);
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
    }

    public boolean isPersistentForever() {
        return this.persistenceType == 2;
    }

    public boolean isPersistent() {
        return this.persistenceType != 0;
    }

    public boolean hasFinished() {
        return this.finished;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    protected abstract ClientRequester getClientRequest();

    public void dropped(ObjectContainer container, ClientContext context) {
        this.cancel(container, context);
        this.freeData(container);
    }

    public short getPriority() {
        return this.priorityClass;
    }

    protected abstract void freeData(ObjectContainer var1);

    protected void finish(ObjectContainer container) {
        if (this.persistenceType == 0) {
            this.origHandler.finishedClientRequest(this);
        } else {
            this.client.finishedClientRequest(this, container);
        }
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
    }

    public abstract double getSuccessFraction(ObjectContainer var1);

    public abstract double getTotalBlocks(ObjectContainer var1);

    public abstract double getMinBlocks(ObjectContainer var1);

    public abstract double getFetchedBlocks(ObjectContainer var1);

    public abstract double getFailedBlocks(ObjectContainer var1);

    public abstract double getFatalyFailedBlocks(ObjectContainer var1);

    public abstract String getFailureReason(boolean var1, ObjectContainer var2);

    public abstract boolean isTotalFinalized(ObjectContainer var1);

    public void onMajorProgress(ObjectContainer container) {
    }

    public abstract void start(ObjectContainer var1, ClientContext var2);

    public boolean isStarted() {
        return this.started;
    }

    public abstract boolean hasSucceeded();

    public long getLastActivity() {
        return this.lastActivity;
    }

    public abstract boolean canRestart();

    public abstract boolean restart(ObjectContainer var1, ClientContext var2, boolean var3) throws DatabaseDisabledException;

    protected abstract FCPMessage persistentTagMessage(ObjectContainer var1);

    public void modifyRequest(String newClientToken, short newPriorityClass, FCPServer server, ObjectContainer container) {
        PersistentRequestModifiedMessage modifiedMsg;
        boolean clientTokenChanged = false;
        boolean priorityClassChanged = false;
        if (newClientToken != null) {
            if (this.clientToken != null) {
                if (!newClientToken.equals(this.clientToken)) {
                    this.clientToken = newClientToken;
                    clientTokenChanged = true;
                }
            } else {
                this.clientToken = newClientToken;
                clientTokenChanged = true;
            }
        }
        if (newPriorityClass >= 0 && newPriorityClass != this.priorityClass) {
            RequestStatusCache cache;
            this.priorityClass = newPriorityClass;
            ClientRequester r = this.getClientRequest();
            if (this.persistenceType == 2) {
                container.activate((Object)r, 1);
            }
            if (r.checkForBrokenClient(container, server.node.clientCore.clientContext)) {
                return;
            }
            r.setPriorityClass(this.priorityClass, server.core.clientContext, container);
            if (this.persistenceType == 2) {
                container.deactivate((Object)r, 1);
            }
            priorityClassChanged = true;
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                cache.setPriority(this.identifier, newPriorityClass);
            }
        }
        if (!clientTokenChanged && !priorityClassChanged) {
            return;
        }
        if (this.persistenceType == 2) {
            container.store((Object)this);
            container.commit();
            if (logMINOR) {
                Logger.minor(this, "COMMITTED");
            }
        }
        if (clientTokenChanged && priorityClassChanged) {
            modifiedMsg = new PersistentRequestModifiedMessage(this.identifier, this.global, this.priorityClass, this.clientToken);
        } else if (priorityClassChanged) {
            modifiedMsg = new PersistentRequestModifiedMessage(this.identifier, this.global, this.priorityClass);
        } else if (clientTokenChanged) {
            modifiedMsg = new PersistentRequestModifiedMessage(this.identifier, this.global, this.clientToken);
        } else {
            return;
        }
        this.client.queueClientRequestMessage(modifiedMsg, 0, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartAsync(final FCPServer server, final boolean disableFilterData) throws DatabaseDisabledException {
        RequestStatusCache cache;
        ClientRequest clientRequest = this;
        synchronized (clientRequest) {
            this.started = false;
        }
        if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
            cache.updateStarted(this.identifier, false);
        }
        if (this.persistenceType == 2) {
            server.core.clientContext.jobRunner.queue(new DBJob(){

                @Override
                public boolean run(ObjectContainer container, ClientContext context) {
                    container.activate((Object)ClientRequest.this, 1);
                    try {
                        ClientRequest.this.restart(container, context, disableFilterData);
                    }
                    catch (DatabaseDisabledException databaseDisabledException) {
                        // empty catch block
                    }
                    container.deactivate((Object)ClientRequest.this, 1);
                    return true;
                }
            }, NativeThread.HIGH_PRIORITY, false);
        } else {
            server.core.getExecutor().execute(new PrioRunnable(){

                @Override
                public int getPriority() {
                    return NativeThread.NORM_PRIORITY;
                }

                @Override
                public void run() {
                    try {
                        ClientRequest.this.restart(null, server.core.clientContext, disableFilterData);
                    }
                    catch (DatabaseDisabledException databaseDisabledException) {
                        // empty catch block
                    }
                }
            }, "Restart request");
        }
    }

    public void requestWasRemoved(ObjectContainer container, ClientContext context) {
        if (this.persistenceType != 2) {
            return;
        }
        if (this.uri != null) {
            this.uri.removeFrom(container);
        }
        container.delete((Object)this);
    }

    protected boolean isGlobalQueue() {
        if (this.client == null) {
            return false;
        }
        return this.client.isGlobalQueue;
    }

    public boolean objectCanUpdate(ObjectContainer container) {
        if (this.hashCode == 0) {
            Logger.error(this, "Trying to update with hash 0 => already deleted!", (Throwable)new Exception("error"));
            return false;
        }
        return true;
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.persistenceType != 2) {
            Logger.error(this, "Not storing non-persistent request in database", (Throwable)new Exception("error"));
            return false;
        }
        if (this.hashCode == 0) {
            Logger.error(this, "Trying to write with hash 0 => already deleted!", (Throwable)new Exception("error"));
            return false;
        }
        return true;
    }

    public void storeTo(ObjectContainer container) {
        container.store((Object)this);
    }

    public FCPClient getClient() {
        return this.client;
    }

    abstract RequestStatus getStatus(ObjectContainer var1);

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

