/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.events.ExpectedHashesEvent;
import freenet.crypt.HashResult;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;

public class ExpectedHashes
extends FCPMessage {
    final HashResult[] hashes;
    final String identifier;
    final boolean global;

    public ExpectedHashes(ExpectedHashesEvent event, String identifier, boolean global) {
        this.identifier = identifier;
        this.global = global;
        this.hashes = event.hashes;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        if (this.hashes == null) {
            Logger.error(this, "Hashes == null, possibly persistence issue caused prior to build 1411 on " + this);
            return null;
        }
        SimpleFieldSet fs = new SimpleFieldSet(false);
        SimpleFieldSet values = new SimpleFieldSet(false);
        for (HashResult hash : this.hashes) {
            if (hash == null) {
                Logger.error(this, "Hash == null, possibly persistence issue caused prior to build 1411 on " + this);
                return null;
            }
            values.putOverwrite(hash.type.name(), hash.hashAsHex());
        }
        fs.put("Hashes", values);
        fs.putOverwrite("Identifier", this.identifier);
        fs.put("Global", this.global);
        return fs;
    }

    @Override
    public String getName() {
        return "ExpectedHashes";
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        if (this.hashes != null) {
            for (HashResult res : this.hashes) {
                if (res == null) continue;
                container.activate((Object)res, Integer.MAX_VALUE);
                res.removeFrom(container);
            }
        }
        container.delete((Object)this);
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new UnsupportedOperationException();
    }
}

