/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Query;
import freenet.client.async.ClientContext;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.node.fcp.ClientGet;
import freenet.node.fcp.ClientPutBase;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.DownloadRequestStatus;
import freenet.node.fcp.FCPClientRequestClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPConnectionOutputHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.FCPPersistentRoot;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.GetFailedMessage;
import freenet.node.fcp.IdentifierCollisionException;
import freenet.node.fcp.ListPersistentRequestsMessage;
import freenet.node.fcp.PutFailedMessage;
import freenet.node.fcp.RequestCompletionCallback;
import freenet.node.fcp.RequestStatus;
import freenet.node.fcp.RequestStatusCache;
import freenet.node.fcp.UploadRequestStatus;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.NullObject;
import freenet.support.api.Bucket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FCPClient {
    final FCPPersistentRoot root;
    final String name;
    private transient FCPConnectionHandler currentConnection;
    private final List<ClientRequest> runningPersistentRequests;
    private final List<ClientRequest> completedUnackedRequests;
    private final Map<String, ClientRequest> clientRequestsByIdentifier;
    public final boolean isGlobalQueue;
    boolean watchGlobal;
    int watchGlobalVerbosityMask;
    private transient LinkedList<FCPClient> clientsWatching;
    private final NullObject clientsWatchingLock = new NullObject();
    private RequestClient lowLevelClient;
    private RequestClient lowLevelClientRT;
    private transient List<RequestCompletionCallback> completionCallbacks;
    private transient RequestStatusCache statusCache;
    final short persistenceType;
    private static volatile boolean logMINOR;

    public FCPClient(String name2, FCPConnectionHandler handler, boolean isGlobalQueue, RequestCompletionCallback cb, short persistenceType, FCPPersistentRoot root, ObjectContainer container) {
        this.name = name2;
        if (this.name == null) {
            throw new NullPointerException();
        }
        this.currentConnection = handler;
        boolean forever = persistenceType == 2;
        this.runningPersistentRequests = new ArrayList<ClientRequest>();
        this.completedUnackedRequests = new ArrayList<ClientRequest>();
        this.clientRequestsByIdentifier = new HashMap<String, ClientRequest>();
        this.isGlobalQueue = isGlobalQueue;
        this.persistenceType = persistenceType;
        assert (persistenceType == 2 || persistenceType == 1);
        this.watchGlobalVerbosityMask = Integer.MAX_VALUE;
        this.lowLevelClient = new FCPClientRequestClient(this, forever, false);
        this.lowLevelClientRT = new FCPClientRequestClient(this, forever, true);
        this.completionCallbacks = new ArrayList<RequestCompletionCallback>();
        if (cb != null) {
            this.completionCallbacks.add(cb);
        }
        if (persistenceType == 2) {
            assert (root != null);
            this.root = root;
        } else {
            this.root = null;
        }
    }

    public synchronized FCPConnectionHandler getConnection() {
        return this.currentConnection;
    }

    public synchronized void setConnection(FCPConnectionHandler handler) {
        this.currentConnection = handler;
    }

    public synchronized void onLostConnection(FCPConnectionHandler handler) {
        handler.freeDDAJobs();
        if (this.currentConnection == handler) {
            this.currentConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishedClientRequest(ClientRequest get, ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "Finished client request", (Throwable)new Exception("debug"));
        }
        assert (this.persistenceType == 2 == (container != null));
        assert (get.persistenceType == this.persistenceType);
        if (container != null) {
            container.activate(this.runningPersistentRequests, 2);
            container.activate(this.completedUnackedRequests, 2);
        }
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            if (this.runningPersistentRequests.remove(get)) {
                this.completedUnackedRequests.add(get);
                if (container != null) {
                    container.store((Object)get);
                    container.ext().store(this.runningPersistentRequests, 2);
                    container.ext().store(this.completedUnackedRequests, 2);
                }
            }
        }
        if (this.statusCache != null) {
            if (get instanceof ClientGet) {
                Bucket shadow;
                ClientGet download = (ClientGet)get;
                GetFailedMessage msg = download.getFailureMessage(container);
                int failureCode = -1;
                String shortFailMessage = null;
                String longFailMessage = null;
                if (msg != null) {
                    failureCode = msg.code;
                    shortFailMessage = msg.getShortFailedMessage();
                    longFailMessage = msg.getLongFailedMessage();
                }
                if (this.persistenceType == 2) {
                    container.deactivate((Object)msg, 1);
                }
                if ((shadow = ((ClientGet)get).getFinalBucket(container)) != null) {
                    shadow = shadow.createShadow();
                }
                this.statusCache.finishedDownload(get.identifier, get.hasSucceeded(), ((ClientGet)get).getDataSize(container), ((ClientGet)get).getMIMEType(container), failureCode, longFailMessage, shortFailMessage, shadow, download.filterData(container));
            } else if (get instanceof ClientPutBase) {
                ClientPutBase upload = (ClientPutBase)get;
                PutFailedMessage msg = upload.getFailureMessage(container);
                int failureCode = -1;
                String shortFailMessage = null;
                String longFailMessage = null;
                if (msg != null) {
                    failureCode = msg.code;
                    shortFailMessage = msg.getShortFailedMessage();
                    longFailMessage = msg.getLongFailedMessage();
                }
                if (this.persistenceType == 2) {
                    container.deactivate((Object)msg, 1);
                }
                this.statusCache.finishedUpload(upload.getIdentifier(), upload.hasSucceeded(), upload.getGeneratedURI(container), failureCode, shortFailMessage, longFailMessage);
            } else assert (false);
        }
    }

    public void queuePendingMessagesOnConnectionRestartAsync(FCPConnectionOutputHandler outputHandler, ObjectContainer container, ClientContext context) {
        if (this.persistenceType == 2) {
            ListPersistentRequestsMessage.PersistentListJob job = new ListPersistentRequestsMessage.PersistentListJob(this, outputHandler, context){

                @Override
                void complete(ObjectContainer container, ClientContext context) {
                }
            };
            job.run(container, context);
        } else {
            ListPersistentRequestsMessage.TransientListJob job = new ListPersistentRequestsMessage.TransientListJob(this, outputHandler, context){

                @Override
                void complete(ObjectContainer container, ClientContext context) {
                }
            };
            job.run(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queuePendingMessagesOnConnectionRestart(FCPConnectionOutputHandler outputHandler, ObjectContainer container, int offset, int max) {
        Object[] reqs;
        assert (this.persistenceType == 2 == (container != null));
        if (container != null) {
            container.activate(this.completedUnackedRequests, 2);
        }
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            reqs = this.completedUnackedRequests.toArray();
        }
        int i = 0;
        for (i = offset; i < Math.min(reqs.length, offset + max); ++i) {
            ClientRequest req = (ClientRequest)reqs[i];
            if (this.persistenceType == 2) {
                container.activate((Object)req, 1);
            }
            ((ClientRequest)reqs[i]).sendPendingMessages(outputHandler, true, false, false, container);
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queuePendingMessagesFromRunningRequests(FCPConnectionOutputHandler outputHandler, ObjectContainer container, int offset, int max) {
        Object[] reqs;
        assert (this.persistenceType == 2 == (container != null));
        if (container != null) {
            container.activate(this.runningPersistentRequests, 2);
        }
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            reqs = this.runningPersistentRequests.toArray();
        }
        int i = 0;
        for (i = offset; i < Math.min(reqs.length, offset + max); ++i) {
            ClientRequest req = (ClientRequest)reqs[i];
            if (this.persistenceType == 2) {
                container.activate((Object)req, 1);
            }
            req.sendPendingMessages(outputHandler, true, false, false, container);
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ClientRequest cg, ObjectContainer container) throws IdentifierCollisionException {
        assert (cg.persistenceType == this.persistenceType);
        assert (this.persistenceType == 2 == (container != null));
        if (logMINOR) {
            Logger.minor(this, "Registering " + cg.getIdentifier());
        }
        if (container != null) {
            container.activate(this.completedUnackedRequests, 2);
            container.activate(this.runningPersistentRequests, 2);
            container.activate(this.clientRequestsByIdentifier, 2);
        }
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            String ident = cg.getIdentifier();
            ClientRequest old = this.clientRequestsByIdentifier.get(ident);
            if (old != null && old != cg) {
                throw new IdentifierCollisionException();
            }
            if (cg.hasFinished()) {
                this.completedUnackedRequests.add(cg);
                if (container != null) {
                    container.store((Object)cg);
                    container.ext().store(this.completedUnackedRequests, 2);
                }
            } else {
                this.runningPersistentRequests.add(cg);
                if (container != null) {
                    cg.storeTo(container);
                    container.ext().store(this.runningPersistentRequests, 2);
                }
            }
            this.clientRequestsByIdentifier.put(ident, cg);
            if (container != null) {
                container.ext().store(this.clientRequestsByIdentifier, 2);
            }
        }
        if (this.statusCache != null) {
            if (cg instanceof ClientGet) {
                this.statusCache.addDownload((DownloadRequestStatus)cg.getStatus(container));
            } else if (cg instanceof ClientPutBase) {
                this.statusCache.addUpload((UploadRequestStatus)cg.getStatus(container));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeByIdentifier(String identifier, boolean kill, FCPServer server, ObjectContainer container, ClientContext context) {
        ClientRequest req;
        assert (this.persistenceType == 2 == (container != null));
        if (logMINOR) {
            Logger.minor(this, "removeByIdentifier(" + identifier + ',' + kill + ')');
        }
        if (container != null) {
            container.activate(this.completedUnackedRequests, 2);
            container.activate(this.runningPersistentRequests, 2);
            container.activate(this.clientRequestsByIdentifier, 2);
        }
        if (this.statusCache != null) {
            this.statusCache.removeByIdentifier(identifier);
        }
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            req = this.clientRequestsByIdentifier.get(identifier);
            boolean removedFromRunning = false;
            if (req == null) {
                for (ClientRequest r : this.completedUnackedRequests) {
                    if (this.persistenceType == 2) {
                        container.activate((Object)r, 1);
                    }
                    if (r.getIdentifier().equals(identifier)) {
                        req = r;
                        this.completedUnackedRequests.remove(r);
                        Logger.error(this, "Found completed unacked request " + r + " for identifier " + r.getIdentifier() + " but not in clientRequestsByIdentifier!!");
                        break;
                    }
                    if (this.persistenceType != 2) continue;
                    container.deactivate((Object)r, 1);
                }
                if (req == null) {
                    for (ClientRequest r : this.runningPersistentRequests) {
                        if (this.persistenceType == 2) {
                            container.activate((Object)r, 1);
                        }
                        if (r.getIdentifier().equals(identifier)) {
                            req = r;
                            this.runningPersistentRequests.remove(r);
                            removedFromRunning = true;
                            Logger.error(this, "Found running request " + r + " for identifier " + r.getIdentifier() + " but not in clientRequestsByIdentifier!!");
                            break;
                        }
                        if (this.persistenceType != 2) continue;
                        container.deactivate((Object)r, 1);
                    }
                }
                if (req == null) {
                    return false;
                }
            } else {
                removedFromRunning = this.runningPersistentRequests.remove(req);
                if (!removedFromRunning && !this.completedUnackedRequests.remove(req)) {
                    Logger.error(this, "Removing " + identifier + ": in clientRequestsByIdentifier but not in running/completed maps!");
                    return false;
                }
            }
            this.clientRequestsByIdentifier.remove(identifier);
            if (container != null) {
                if (removedFromRunning) {
                    container.ext().store(this.runningPersistentRequests, 2);
                } else {
                    container.ext().store(this.completedUnackedRequests, 2);
                }
                container.ext().store(this.clientRequestsByIdentifier, 2);
            }
        }
        if (container != null) {
            container.activate((Object)req, 1);
        }
        if (kill) {
            if (logMINOR) {
                Logger.minor(this, "Killing request " + req);
            }
            req.cancel(container, context);
        }
        req.requestWasRemoved(container, context);
        RequestCompletionCallback[] callbacks = null;
        FCPClient removedFromRunning = this;
        synchronized (removedFromRunning) {
            if (this.completionCallbacks != null) {
                callbacks = this.completionCallbacks.toArray(new RequestCompletionCallback[this.completionCallbacks.size()]);
            }
        }
        if (callbacks != null) {
            for (RequestCompletionCallback cb : callbacks) {
                cb.onRemove(req, container);
            }
        }
        return true;
    }

    public boolean hasPersistentRequests(ObjectContainer container) {
        assert (this.persistenceType == 2 == (container != null));
        if (this.runningPersistentRequests == null) {
            if (!container.ext().isActive((Object)this)) {
                Logger.error(this, "FCPCLIENT NOT ACTIVE!!!");
            }
            throw new NullPointerException();
        }
        if (this.completedUnackedRequests == null) {
            if (!container.ext().isActive((Object)this)) {
                Logger.error(this, "FCPCLIENT NOT ACTIVE!!!");
            }
            throw new NullPointerException();
        }
        if (container != null) {
            container.activate(this.completedUnackedRequests, 2);
            container.activate(this.runningPersistentRequests, 2);
        }
        return !this.runningPersistentRequests.isEmpty() || !this.completedUnackedRequests.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPersistentRequests(List<ClientRequest> v, boolean onlyForever, ObjectContainer container) {
        assert (this.persistenceType == 2 == (container != null));
        if (container != null) {
            container.activate(this.completedUnackedRequests, 2);
            container.activate(this.runningPersistentRequests, 2);
            container.activate(this.clientRequestsByIdentifier, 2);
        }
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            for (ClientRequest req : this.runningPersistentRequests) {
                if (container != null) {
                    container.activate((Object)req, 1);
                }
                if (req == null) {
                    Logger.error(this, "Request is null on runningPersistentRequests for " + this + " - database corruption??");
                    continue;
                }
                if (!req.isPersistentForever() && onlyForever) continue;
                v.add(req);
            }
            if (container != null) {
                for (ClientRequest req : this.completedUnackedRequests) {
                    container.activate((Object)req, 1);
                }
            }
            v.addAll(this.completedUnackedRequests);
        }
    }

    private void addPersistentRequestStatus(List<RequestStatus> status, boolean onlyForever, ObjectContainer container) {
        ArrayList<ClientRequest> reqs = new ArrayList<ClientRequest>();
        this.addPersistentRequests(reqs, onlyForever, container);
        for (ClientRequest req : reqs) {
            try {
                status.add(req.getStatus(container));
            }
            catch (Throwable t) {
                Logger.error(this, "BROKEN REQUEST LOADING PERSISTENT REQUEST STATUS: " + t, t);
            }
        }
    }

    public void addPersistentRequestStatus(List<RequestStatus> status) {
        this.statusCache.addTo(status);
    }

    public boolean setWatchGlobal(boolean enabled, int verbosityMask, FCPServer server, ObjectContainer container) {
        assert (this.persistenceType == 2 == (container != null));
        if (this.isGlobalQueue) {
            Logger.error(this, "Set watch global on global queue!: " + this, (Throwable)new Exception("debug"));
            return false;
        }
        if (server.globalForeverClient == null) {
            return false;
        }
        if (this.watchGlobal && !enabled) {
            server.globalRebootClient.unwatch(this);
            server.globalForeverClient.unwatch(this);
            this.watchGlobal = false;
        } else if (enabled && !this.watchGlobal) {
            server.globalRebootClient.watch(this);
            server.globalForeverClient.watch(this);
            FCPConnectionHandler connHandler = this.getConnection();
            if (connHandler != null) {
                if (this.persistenceType == 1) {
                    server.globalRebootClient.queuePendingMessagesOnConnectionRestartAsync(connHandler.outputHandler, container, server.core.clientContext);
                } else {
                    server.globalForeverClient.queuePendingMessagesOnConnectionRestartAsync(connHandler.outputHandler, container, server.core.clientContext);
                }
            }
            this.watchGlobal = true;
        }
        this.watchGlobalVerbosityMask = verbosityMask;
        return true;
    }

    public void queueClientRequestMessage(FCPMessage msg, int verbosityLevel, ObjectContainer container) {
        this.queueClientRequestMessage(msg, verbosityLevel, false, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueClientRequestMessage(FCPMessage msg, int verbosityLevel, boolean useGlobalMask, ObjectContainer container) {
        if (useGlobalMask && (verbosityLevel & this.watchGlobalVerbosityMask) != verbosityLevel) {
            return;
        }
        FCPConnectionHandler conn = this.getConnection();
        if (conn != null) {
            conn.outputHandler.queue(msg);
        }
        if (this.isGlobalQueue) {
            FCPClient[] clients;
            NullObject nullObject = this.clientsWatchingLock;
            synchronized (nullObject) {
                clients = this.clientsWatching != null ? this.clientsWatching.toArray(new FCPClient[this.clientsWatching.size()]) : null;
            }
            if (clients != null) {
                for (FCPClient client : clients) {
                    if (this.persistenceType == 2) {
                        container.activate((Object)client, 1);
                    }
                    if (client.persistenceType != this.persistenceType) continue;
                    client.queueClientRequestMessage(msg, verbosityLevel, true, container);
                    if (this.persistenceType != 2) continue;
                    container.deactivate((Object)client, 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unwatch(FCPClient client) {
        if (!this.isGlobalQueue) {
            return;
        }
        NullObject nullObject = this.clientsWatchingLock;
        synchronized (nullObject) {
            if (this.clientsWatching != null) {
                this.clientsWatching.remove(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watch(FCPClient client) {
        if (!this.isGlobalQueue) {
            return;
        }
        NullObject nullObject = this.clientsWatchingLock;
        synchronized (nullObject) {
            if (this.clientsWatching == null) {
                this.clientsWatching = new LinkedList();
            }
            this.clientsWatching.add(client);
        }
    }

    public synchronized ClientRequest getRequest(String identifier, ObjectContainer container) {
        assert (this.persistenceType == 2 == (container != null));
        if (container != null) {
            container.activate(this.clientRequestsByIdentifier, 2);
        }
        ClientRequest req = this.clientRequestsByIdentifier.get(identifier);
        if (this.persistenceType == 2) {
            container.activate((Object)req, 1);
        }
        return req;
    }

    public String toString() {
        return super.toString() + ':' + this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySuccess(ClientRequest req, ObjectContainer container) {
        assert (req.persistenceType == this.persistenceType);
        RequestCompletionCallback[] callbacks = null;
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            if (this.completionCallbacks != null) {
                callbacks = this.completionCallbacks.toArray(new RequestCompletionCallback[this.completionCallbacks.size()]);
            }
        }
        if (callbacks != null) {
            for (RequestCompletionCallback cb : callbacks) {
                cb.notifySuccess(req, container);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFailure(ClientRequest req, ObjectContainer container) {
        assert (req.persistenceType == this.persistenceType);
        RequestCompletionCallback[] callbacks = null;
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            if (this.completionCallbacks != null) {
                callbacks = this.completionCallbacks.toArray(new RequestCompletionCallback[this.completionCallbacks.size()]);
            }
        }
        if (callbacks != null) {
            for (RequestCompletionCallback cb : callbacks) {
                cb.notifyFailure(req, container);
            }
        }
    }

    public synchronized void addRequestCompletionCallback(RequestCompletionCallback cb) {
        if (this.completionCallbacks == null) {
            this.completionCallbacks = new ArrayList<RequestCompletionCallback>();
        }
        this.completionCallbacks.add(cb);
    }

    public synchronized void removeRequestCompletionCallback(RequestCompletionCallback cb) {
        if (this.completionCallbacks != null) {
            this.completionCallbacks.remove(cb);
        }
    }

    public void removeFromDatabase(ObjectContainer container) {
        container.activate(this.runningPersistentRequests, 2);
        container.delete(this.runningPersistentRequests);
        container.activate(this.completedUnackedRequests, 2);
        container.delete(this.completedUnackedRequests);
        container.activate(this.clientRequestsByIdentifier, 2);
        container.delete(this.clientRequestsByIdentifier);
        container.activate((Object)this.lowLevelClient, 2);
        this.lowLevelClient.removeFrom(container);
        container.delete((Object)this);
        container.delete((Object)this.clientsWatchingLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(ObjectContainer container, ClientContext context) {
        HashSet<ClientRequest> toKill = new HashSet<ClientRequest>();
        if (container != null) {
            container.activate(this.completedUnackedRequests, 2);
            container.activate(this.runningPersistentRequests, 2);
            container.activate(this.clientRequestsByIdentifier, 2);
        }
        if (this.statusCache != null) {
            this.statusCache.clear();
        }
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            for (ClientRequest req : this.runningPersistentRequests) {
                toKill.add(req);
            }
            this.runningPersistentRequests.clear();
            for (ClientRequest req : this.completedUnackedRequests) {
                if (this.persistenceType == 2) {
                    container.activate((Object)req, 1);
                }
                toKill.add(req);
            }
            this.completedUnackedRequests.clear();
            for (ClientRequest req : this.clientRequestsByIdentifier.values()) {
                if (this.persistenceType == 2) {
                    container.activate((Object)req, 1);
                }
                toKill.add(req);
            }
            this.clientRequestsByIdentifier.clear();
            if (this.persistenceType == 2) {
                container.ext().store(this.clientRequestsByIdentifier, 2);
            }
        }
    }

    public ClientGet getCompletedRequest(FreenetURI key, ObjectContainer container) {
        if (container != null) {
            container.activate(this.completedUnackedRequests, 2);
        }
        for (int i = 0; i < this.completedUnackedRequests.size(); ++i) {
            ClientRequest req = this.completedUnackedRequests.get(i);
            if (!(req instanceof ClientGet)) continue;
            ClientGet getter = (ClientGet)req;
            if (this.persistenceType == 2) {
                container.activate((Object)getter, 1);
            }
            if (getter.getURI(container).equals(key)) {
                return getter;
            }
            if (this.persistenceType != 2) continue;
            container.deactivate((Object)getter, 1);
        }
        return null;
    }

    public void init(ObjectContainer container) {
        if (!container.ext().isActive((Object)this)) {
            throw new IllegalStateException("Initialising but not activated");
        }
        container.activate(this.runningPersistentRequests, 2);
        container.activate(this.completedUnackedRequests, 2);
        container.activate(this.clientRequestsByIdentifier, 2);
        container.activate((Object)this.lowLevelClient, 2);
        assert (this.runningPersistentRequests != null);
        assert (this.completedUnackedRequests != null);
        assert (this.clientRequestsByIdentifier != null);
        if (this.lowLevelClient == null) {
            System.err.println("No lowLevelClient for " + this + " but other fields exist.");
            System.err.println("This means your database has been corrupted slightly, probably by a bug in Freenet.");
            System.err.println("We are trying to recover ...");
            Query q = container.query();
            q.constrain(FCPClientRequestClient.class);
            q.descend("client").constrain((Object)this);
            ObjectSet results = q.execute();
            for (FCPClientRequestClient c : results) {
                if (c.client != this) continue;
                System.err.println("Found the old request client, eh???");
                this.lowLevelClient = c;
                break;
            }
            if (this.lowLevelClient == null) {
                this.lowLevelClient = new FCPClientRequestClient(this, this.persistenceType == 2, false);
            }
            container.store((Object)this.lowLevelClient);
            container.store((Object)this);
        }
        if (this.lowLevelClientRT == null) {
            this.lowLevelClientRT = new FCPClientRequestClient(this, this.persistenceType == 2, true);
        }
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.persistenceType != 2) {
            Logger.error(this, "Not storing non-persistent request in database", (Throwable)new Exception("error"));
            return false;
        }
        if (this.lowLevelClient == null) {
            throw new NullPointerException();
        }
        return true;
    }

    public void objectCanUpdate(ObjectContainer container) {
        if (this.lowLevelClient == null) {
            throw new NullPointerException();
        }
    }

    public RequestStatusCache getRequestStatusCache() {
        return this.statusCache;
    }

    public void setRequestStatusCache(RequestStatusCache cache, ObjectContainer container) {
        this.statusCache = cache;
        if (this.persistenceType == 2) {
            System.out.println("Loading cache of request statuses...");
            ArrayList<RequestStatus> statuses = new ArrayList<RequestStatus>();
            this.addPersistentRequestStatus(statuses, true, container);
            for (RequestStatus status : statuses) {
                if (status instanceof DownloadRequestStatus) {
                    cache.addDownload((DownloadRequestStatus)status);
                    continue;
                }
                cache.addUpload((UploadRequestStatus)status);
            }
        }
    }

    public RequestClient lowLevelClient(boolean realTime) {
        if (realTime) {
            return this.lowLevelClientRT;
        }
        return this.lowLevelClient;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

