/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.events.FinishedCompressionEvent;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;
import freenet.support.compress.Compressor;

public class FinishedCompressionMessage
extends FCPMessage {
    final String identifier;
    final boolean global;
    final int codec;
    final long origSize;
    final long compressedSize;

    private FinishedCompressionMessage() {
        this.origSize = 0L;
        this.identifier = null;
        this.global = false;
        this.compressedSize = 0L;
        this.codec = 0;
    }

    public FinishedCompressionMessage(String identifier, boolean global, FinishedCompressionEvent event) {
        this.identifier = identifier;
        this.codec = event.codec;
        this.compressedSize = event.compressedSize;
        this.origSize = event.originalSize;
        this.global = global;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        fs.put("Codec", this.codec);
        if (this.codec != -1) {
            fs.putSingle("Codec.Name", Compressor.COMPRESSOR_TYPE.getCompressorByMetadataID((short)this.codec).name());
        } else {
            fs.putSingle("Codec.Name", "NONE");
        }
        fs.put("OriginalSize", this.origSize);
        fs.put("CompressedSize", this.compressedSize);
        fs.put("Global", this.global);
        return fs;
    }

    @Override
    public String getName() {
        return "FinishedCompression";
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "FinishedCompression goes from server to client not the other way around", this.identifier, this.global);
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

