/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.Base64;
import freenet.support.SimpleFieldSet;

public class PeerNote
extends FCPMessage {
    static final String name = "PeerNote";
    final String noteText;
    final int peerNoteType;
    final String nodeIdentifier;
    final String identifier;

    public PeerNote(String nodeIdentifier, String noteText, int peerNoteType, String identifier) {
        this.nodeIdentifier = nodeIdentifier;
        this.noteText = noteText;
        this.peerNoteType = peerNoteType;
        this.identifier = identifier;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("NodeIdentifier", this.nodeIdentifier);
        fs.put("PeerNoteType", this.peerNoteType);
        fs.putSingle("NoteText", Base64.encodeUTF8(this.noteText, true));
        if (this.identifier != null) {
            fs.putSingle("Identifier", this.identifier);
        }
        return fs;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "PeerNote goes from server to client not the other way around", this.identifier, false);
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

