/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ManifestElement;
import freenet.keys.FreenetURI;
import freenet.node.fcp.DirPutFile;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import java.net.MalformedURLException;

public class RedirectDirPutFile
extends DirPutFile {
    final FreenetURI targetURI;
    private static volatile boolean logMINOR;

    public static RedirectDirPutFile create(String name, String contentTypeOverride, SimpleFieldSet subset, String identifier, boolean global) throws MessageInvalidException {
        FreenetURI targetURI;
        String target = subset.get("TargetURI");
        if (target == null) {
            throw new MessageInvalidException(5, "TargetURI missing but UploadFrom=redirect", identifier, global);
        }
        try {
            targetURI = new FreenetURI(target);
        }
        catch (MalformedURLException e) {
            throw new MessageInvalidException(8, "Invalid TargetURI: " + e, identifier, global);
        }
        if (logMINOR) {
            Logger.minor(RedirectDirPutFile.class, "targetURI = " + targetURI);
        }
        String mimeType = contentTypeOverride != null ? contentTypeOverride : RedirectDirPutFile.guessMIME(name);
        return new RedirectDirPutFile(name, mimeType, targetURI);
    }

    public RedirectDirPutFile(String name, String mimeType, FreenetURI targetURI) {
        super(name, mimeType);
        this.targetURI = targetURI;
    }

    @Override
    public Bucket getData() {
        return null;
    }

    @Override
    public ManifestElement getElement() {
        return new ManifestElement(this.name, this.targetURI, this.getMIMEType());
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        container.activate((Object)this.targetURI, 5);
        this.targetURI.removeFrom(container);
        container.delete((Object)this);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

