/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import freenet.client.ClientMetadata;
import freenet.client.InsertContext;
import freenet.client.async.CacheFetchResult;
import freenet.client.events.SplitfileProgressEvent;
import freenet.keys.FreenetURI;
import freenet.node.fcp.ClientPut;
import freenet.node.fcp.DownloadRequestStatus;
import freenet.node.fcp.RequestStatus;
import freenet.node.fcp.UploadFileRequestStatus;
import freenet.node.fcp.UploadRequestStatus;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.api.Bucket;
import freenet.support.io.NoFreeBucket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RequestStatusCache {
    private static volatile boolean logMINOR;
    private final ArrayList<RequestStatus> downloads = new ArrayList();
    private final ArrayList<RequestStatus> uploads = new ArrayList();
    private final HashMap<String, RequestStatus> requestsByIdentifier = new HashMap();
    private final MultiValueTable<FreenetURI, RequestStatus> downloadsByURI = new MultiValueTable();
    private final MultiValueTable<FreenetURI, RequestStatus> uploadsByFinalURI = new MultiValueTable();

    RequestStatusCache() {
    }

    synchronized void addDownload(DownloadRequestStatus status) {
        RequestStatus old = this.requestsByIdentifier.put(status.getIdentifier(), status);
        if (logMINOR) {
            Logger.minor(this, "Starting download " + status.getIdentifier());
        }
        if (old == status) {
            return;
        }
        assert (old == null);
        this.downloads.add(status);
        this.downloadsByURI.put(status.getURI(), status);
    }

    synchronized void addUpload(UploadRequestStatus status) {
        RequestStatus old = this.requestsByIdentifier.put(status.getIdentifier(), status);
        if (old == status) {
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Starting upload " + status.getIdentifier());
        }
        assert (old == null);
        this.uploads.add(status);
        FreenetURI uri = status.getURI();
        if (uri != null) {
            this.uploadsByFinalURI.put(uri, status);
        }
    }

    synchronized void finishedDownload(String identifier, boolean success, long dataSize, String mimeType, int failureCode, String failureReasonLong, String failureReasonShort, Bucket dataShadow, boolean filtered) {
        DownloadRequestStatus status = (DownloadRequestStatus)this.requestsByIdentifier.get(identifier);
        if (status == null) {
            return;
        }
        status.setFinished(success, dataSize, mimeType, failureCode, failureReasonLong, failureReasonShort, dataShadow, filtered);
    }

    synchronized void gotFinalURI(String identifier, FreenetURI finalURI) {
        UploadRequestStatus status = (UploadRequestStatus)this.requestsByIdentifier.get(identifier);
        if (status == null) {
            return;
        }
        if (status.getFinalURI() == null) {
            this.uploadsByFinalURI.put(finalURI, status);
        }
        status.setFinalURI(finalURI);
    }

    synchronized void finishedUpload(String identifier, boolean success, FreenetURI finalURI, int failureCode, String failureReasonShort, String failureReasonLong) {
        UploadRequestStatus status = (UploadRequestStatus)this.requestsByIdentifier.get(identifier);
        if (status == null) {
            return;
        }
        if (status.getFinalURI() == null && finalURI != null) {
            this.uploadsByFinalURI.put(finalURI, status);
        }
        status.setFinished(success, finalURI, failureCode, failureReasonShort, failureReasonLong);
    }

    synchronized void updateStatus(String identifier, SplitfileProgressEvent event) {
        RequestStatus status = this.requestsByIdentifier.get(identifier);
        if (status == null) {
            return;
        }
        status.updateStatus(event);
    }

    synchronized void updateDetectedCompatModes(String identifier, InsertContext.CompatibilityMode[] compatModes, byte[] splitfileKey, boolean dontCompress) {
        DownloadRequestStatus status = (DownloadRequestStatus)this.requestsByIdentifier.get(identifier);
        if (status == null) {
            return;
        }
        status.updateDetectedCompatModes(compatModes, dontCompress);
        status.updateDetectedSplitfileKey(splitfileKey);
    }

    synchronized void removeByIdentifier(String identifier) {
        RequestStatus status = this.requestsByIdentifier.remove(identifier);
        if (status == null) {
            return;
        }
        if (status instanceof DownloadRequestStatus) {
            this.downloads.remove(status);
            FreenetURI uri = status.getURI();
            assert (uri != null);
            this.downloadsByURI.removeElement(uri, status);
        } else if (status instanceof UploadRequestStatus) {
            this.uploads.remove(status);
            FreenetURI uri = ((UploadRequestStatus)status).getFinalURI();
            if (uri != null) {
                this.uploadsByFinalURI.removeElement(uri, status);
            }
        }
    }

    synchronized void clear() {
        this.downloads.clear();
        this.uploads.clear();
        this.requestsByIdentifier.clear();
        this.downloadsByURI.clear();
        this.uploadsByFinalURI.clear();
    }

    public void updateCompressionStatus(String identifier, ClientPut.COMPRESS_STATE compressing) {
        UploadFileRequestStatus status = (UploadFileRequestStatus)this.requestsByIdentifier.get(identifier);
        if (status == null) {
            return;
        }
        status.updateCompressionStatus(compressing);
    }

    public synchronized void addTo(List<RequestStatus> status) {
        for (RequestStatus req : this.requestsByIdentifier.values()) {
            status.add(req.clone());
        }
    }

    public synchronized void updateExpectedMIME(String identifier, String foundDataMimeType) {
        DownloadRequestStatus status = (DownloadRequestStatus)this.requestsByIdentifier.get(identifier);
        if (status == null) {
            return;
        }
        status.updateExpectedMIME(foundDataMimeType);
    }

    public synchronized void updateExpectedDataLength(String identifier, long expectedDataLength) {
        DownloadRequestStatus status = (DownloadRequestStatus)this.requestsByIdentifier.get(identifier);
        if (status == null) {
            return;
        }
        status.updateExpectedDataLength(expectedDataLength);
    }

    public void setPriority(String identifier, short newPriorityClass) {
        RequestStatus status = this.requestsByIdentifier.get(identifier);
        if (status == null) {
            return;
        }
        status.setPriority(newPriorityClass);
    }

    public synchronized void updateStarted(String identifier, boolean started) {
        RequestStatus status = this.requestsByIdentifier.get(identifier);
        if (status == null) {
            return;
        }
        if (!started) {
            status.restart(false);
        } else {
            status.setStarted(started);
        }
    }

    public synchronized void updateStarted(String identifier, FreenetURI redirect) {
        DownloadRequestStatus status = (DownloadRequestStatus)this.requestsByIdentifier.get(identifier);
        if (status == null) {
            return;
        }
        status.restart(false);
        if (redirect != null) {
            this.downloadsByURI.remove(status.getURI());
            status.redirect(redirect);
            this.downloadsByURI.put(redirect, status);
        }
    }

    public synchronized CacheFetchResult getShadowBucket(FreenetURI key, boolean noFilter) {
        Object[] downloads = this.downloadsByURI.getArray(key);
        if (downloads == null) {
            return null;
        }
        for (Object o : downloads) {
            DownloadRequestStatus download = (DownloadRequestStatus)o;
            Bucket data = download.getDataShadow();
            if (data == null || data.size() == 0L || noFilter && download.filterData || download.overriddenDataType) continue;
            return new CacheFetchResult(new ClientMetadata(download.getMIMEType()), new NoFreeBucket(data), download.filterData);
        }
        return null;
    }

    static {
        Logger.registerClass(RequestStatusCache.class);
    }
}

