/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import freenet.keys.FreenetURI;
import freenet.node.fcp.ClientPut;
import freenet.node.fcp.UploadRequestStatus;
import java.io.File;

public class UploadFileRequestStatus
extends UploadRequestStatus {
    private final long dataSize;
    private final String mimeType;
    private final File origFilename;
    private ClientPut.COMPRESS_STATE compressing;

    UploadFileRequestStatus(String identifier, short persistence, boolean started, boolean finished, boolean success, int total, int min, int fetched, int fatal, int failed, boolean totalFinalized, long last, short prio, FreenetURI finalURI, FreenetURI targetURI, int failureCode, String failureReasonShort, String failureReasonLong, long dataSize, String mimeType, File origFilename, ClientPut.COMPRESS_STATE compressing) {
        super(identifier, persistence, started, finished, success, total, min, fetched, fatal, failed, totalFinalized, last, prio, finalURI, targetURI, failureCode, failureReasonShort, failureReasonLong);
        this.dataSize = dataSize;
        this.mimeType = mimeType;
        this.origFilename = origFilename;
        this.compressing = compressing;
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    public File getOrigFilename() {
        return this.origFilename;
    }

    public ClientPut.COMPRESS_STATE isCompressing() {
        return this.compressing;
    }

    synchronized void updateCompressionStatus(ClientPut.COMPRESS_STATE status) {
        this.compressing = status;
    }

    @Override
    public String getPreferredFilename() {
        String s = super.getPreferredFilename();
        if (s == null && this.origFilename != null) {
            return this.origFilename.getName();
        }
        return s;
    }
}

