/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.node.Node;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.ProtocolErrorMessage;
import freenet.support.SimpleFieldSet;
import freenet.support.io.NativeThread;

public class WatchGlobal
extends FCPMessage {
    final boolean enabled;
    final int verbosityMask;
    static final String NAME = "WatchGlobal";

    public WatchGlobal(SimpleFieldSet fs) throws MessageInvalidException {
        this.enabled = fs.getBoolean("Enabled", true);
        String s = fs.get("VerbosityMask");
        if (s != null) {
            try {
                this.verbosityMask = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, e.toString(), null, false);
            }
        } else {
            this.verbosityMask = Integer.MAX_VALUE;
        }
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("Enabled", this.enabled);
        fs.put("VerbosityMask", this.verbosityMask);
        return fs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(final FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        if (!handler.getRebootClient().setWatchGlobal(this.enabled, this.verbosityMask, node.clientCore.getFCPServer(), null)) {
            ProtocolErrorMessage err = new ProtocolErrorMessage(33, false, "Persistence disabled", null, true);
            handler.outputHandler.queue(err);
        }
        try {
            handler.server.core.clientContext.jobRunner.queue(new DBJob(){

                @Override
                public boolean run(ObjectContainer container, ClientContext context) {
                    FCPClient client = handler.getForeverClient(container);
                    container.activate((Object)client, 1);
                    client.setWatchGlobal(WatchGlobal.this.enabled, WatchGlobal.this.verbosityMask, handler.server, container);
                    container.deactivate((Object)client, 1);
                    return false;
                }
            }, NativeThread.HIGH_PRIORITY, false);
        }
        catch (DatabaseDisabledException e) {
            ProtocolErrorMessage err = new ProtocolErrorMessage(33, false, "Persistence disabled", null, true);
            handler.outputHandler.queue(err);
        }
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

