/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.client.ClientMetadata;
import freenet.client.FetchException;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertBlock;
import freenet.client.InsertException;
import freenet.crypt.RandomSource;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.NodeStarter;
import freenet.node.Version;
import freenet.node.simulator.LongTermTest;
import freenet.node.simulator.TestUtil;
import freenet.support.Logger;
import freenet.support.PooledExecutor;
import freenet.support.api.Bucket;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class LongTermMHKTest
extends LongTermTest {
    private static final int TEST_SIZE = 65536;
    private static final int EXIT_DIFFERENT_URI = 262;
    private static final int DARKNET_PORT1 = 5010;
    private static final int OPENNET_PORT1 = 5011;
    private static final int DELTA = 7;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        long t2;
        long t1;
        HighLevelSimpleClient client;
        File file;
        FileInputStream fis;
        Node node2;
        Node node;
        int exitCode;
        ArrayList<String> csvLine;
        boolean dumpOnly;
        block81: {
            FreenetURI thisURI;
            int i;
            Bucket[] mhks;
            Bucket single;
            block82: {
                if (args.length < 1 || args.length > 2) {
                    System.err.println("Usage: java freenet.node.simulator.LongTermPushPullTest <unique identifier>");
                    System.exit(1);
                }
                String uid = args[0];
                dumpOnly = args.length == 2 && "--dump".equalsIgnoreCase(args[1]);
                csvLine = new ArrayList<String>();
                System.out.println("DATE:" + dateFormat.format(today.getTime()));
                csvLine.add(dateFormat.format(today.getTime()));
                System.out.println("Version:" + Version.buildNumber());
                csvLine.add(String.valueOf(Version.buildNumber()));
                exitCode = 0;
                node = null;
                node2 = null;
                fis = null;
                file = new File("mhk-test-" + uid + ".csv");
                client = null;
                File dir = new File("longterm-mhk-test-" + uid);
                if (dumpOnly) break block81;
                FileUtil.removeAll(dir);
                RandomSource random = NodeStarter.globalTestInit(dir.getPath(), false, Logger.LogLevel.ERROR, "", false);
                File seednodes = new File("seednodes.fref");
                if (!seednodes.exists() || seednodes.length() == 0L || !seednodes.canRead()) {
                    System.err.println("Unable to read seednodes.fref, it doesn't exist, or is empty");
                    System.exit(257);
                }
                File innerDir = new File(dir, Integer.toString(5010));
                innerDir.mkdir();
                fis = new FileInputStream(seednodes);
                FileUtil.writeTo(fis, new File(innerDir, "seednodes.fref"));
                fis.close();
                node = NodeStarter.createTestNode(5010, 5011, dir.getPath(), false, (short)18, 0, random, new PooledExecutor(), 1000, 0x400000L, true, true, true, true, true, true, true, 12288, true, true, false, false, null);
                Logger.getChain().setThreshold(Logger.LogLevel.ERROR);
                node.start(true);
                t1 = System.currentTimeMillis();
                if (TestUtil.waitForNodes(node)) break block82;
                exitCode = 258;
                try {
                    if (node != null) {
                        node.park();
                    }
                }
                catch (Throwable tt) {
                    // empty catch block
                }
                try {
                    if (node2 != null) {
                        node2.park();
                    }
                }
                catch (Throwable tt) {
                    // empty catch block
                }
                Closer.close(fis);
                if (!dumpOnly) {
                    LongTermMHKTest.writeToStatusLog(file, csvLine);
                }
                System.exit(exitCode);
                return;
            }
            try {
                t2 = System.currentTimeMillis();
                System.out.println("SEED-TIME:" + (t2 - t1));
                csvLine.add(String.valueOf(t2 - t1));
                single = LongTermMHKTest.randomData(node);
                mhks = new Bucket[3];
                for (int i2 = 0; i2 < mhks.length; ++i2) {
                    mhks[i2] = LongTermMHKTest.randomData(node);
                }
            }
            catch (Throwable t) {
                try {
                    t.printStackTrace();
                    exitCode = 261;
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (node != null) {
                            node.park();
                        }
                    }
                    catch (Throwable tt) {}
                    try {
                        if (node2 != null) {
                            node2.park();
                        }
                    }
                    catch (Throwable tt) {}
                    Closer.close(fis);
                    if (!dumpOnly) {
                        LongTermMHKTest.writeToStatusLog(file, csvLine);
                    }
                    System.exit(exitCode);
                }
            }
            client = node.clientCore.makeClient((short)0, false, false);
            System.err.println("Inserting single block 3 times");
            InsertBlock block = new InsertBlock(single, new ClientMetadata(), FreenetURI.EMPTY_CHK_URI);
            FreenetURI uri = null;
            int successes = 0;
            for (i = 0; i < 3; ++i) {
                System.err.println("Inserting single block, try #" + i);
                try {
                    t1 = System.currentTimeMillis();
                    thisURI = client.insert(block, false, null);
                    if (uri != null && !thisURI.equals(uri)) {
                        System.err.println("URI " + i + " is " + thisURI + " but previous is " + uri);
                        System.exit(262);
                    }
                    uri = thisURI;
                    t2 = System.currentTimeMillis();
                    System.out.println("PUSH-TIME-" + i + ":" + (t2 - t1) + " for " + uri + " for single block");
                    csvLine.add(String.valueOf(t2 - t1));
                    csvLine.add(uri.toASCIIString());
                    ++successes;
                    continue;
                }
                catch (InsertException e) {
                    e.printStackTrace();
                    csvLine.add(FetchException.getShortMessage(e.getMode()));
                    csvLine.add("N/A");
                    System.out.println("INSERT FAILED: " + e + " for insert " + i + " for single block");
                }
            }
            if (successes == 3) {
                System.err.println("All inserts succeeded for single block: " + successes);
            } else if (successes != 0) {
                System.err.println("Some inserts succeeded for single block: " + successes);
            } else {
                System.err.println("NO INSERTS SUCCEEDED FOR SINGLE BLOCK: " + successes);
            }
            uri = null;
            for (i = 0; i < 3; ++i) {
                System.err.println("Inserting MHK #" + i);
                uri = null;
                block = new InsertBlock(mhks[i], new ClientMetadata(), FreenetURI.EMPTY_CHK_URI);
                try {
                    t1 = System.currentTimeMillis();
                    uri = thisURI = client.insert(block, false, null);
                    t2 = System.currentTimeMillis();
                    System.out.println("PUSH-TIME-" + i + ":" + (t2 - t1) + " for " + uri + " for MHK #" + i);
                    csvLine.add(String.valueOf(t2 - t1));
                    csvLine.add(uri.toASCIIString());
                    ++successes;
                    continue;
                }
                catch (InsertException e) {
                    e.printStackTrace();
                    csvLine.add(FetchException.getShortMessage(e.getMode()));
                    csvLine.add("N/A");
                    System.out.println("INSERT FAILED: " + e + " for MHK #" + i);
                }
            }
            if (successes == 3) {
                System.err.println("All inserts succeeded for MHK: " + successes);
            } else if (successes != 0) {
                System.err.println("Some inserts succeeded for MHK: " + successes);
            } else {
                System.err.println("NO INSERTS SUCCEEDED FOR MHK: " + successes);
            }
            uri = null;
        }
        boolean match = false;
        FreenetURI singleURI = null;
        FreenetURI[] mhkURIs = new FreenetURI[3];
        fis = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
        String line = null;
        int linesTooShort = 0;
        int linesBroken = 0;
        int linesNoNumber = 0;
        int linesNoURL = 0;
        int linesNoFetch = 0;
        int total = 0;
        int singleKeysSucceeded = 0;
        int mhkSucceeded = 0;
        int totalSingleKeyFetches = 0;
        int totalSingleKeySuccesses = 0;
        while ((line = br.readLine()) != null) {
            boolean singleKeySuccess;
            int singleKeyFetchTime;
            int token;
            singleURI = null;
            for (int i = 0; i < mhkURIs.length; ++i) {
                mhkURIs[i] = null;
            }
            String[] split = line.split("!");
            Date date = dateFormat.parse(split[0]);
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            calendar.setTime(date);
            System.out.println("Date: " + dateFormat.format(calendar.getTime()));
            GregorianCalendar target = (GregorianCalendar)today.clone();
            target.set(11, 0);
            target.set(12, 0);
            target.set(14, 0);
            target.set(13, 0);
            target.add(5, -7);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.getTime();
            target.getTime();
            try {
                int insertTime;
                int i;
                if (split.length < 3) {
                    ++linesTooShort;
                    continue;
                }
                int seedTime = Integer.parseInt(split[2]);
                System.out.println("Seed time: " + seedTime);
                int token2 = 3;
                if (split.length < 4) {
                    ++linesTooShort;
                    continue;
                }
                for (i = 0; i < 3; ++i) {
                    insertTime = Integer.parseInt(split[token2]);
                    System.out.println("Single key insert " + i + " : " + insertTime);
                    FreenetURI thisURI = new FreenetURI(split[++token2]);
                    if (singleURI == null) {
                        singleURI = thisURI;
                    } else if (!singleURI.equals(thisURI)) {
                        System.err.println("URI is not the same for all 3 inserts: was " + singleURI + " but " + i + " is " + thisURI);
                        ++linesBroken;
                        continue;
                    }
                    ++token2;
                }
                System.out.println("Single key URI: " + singleURI);
                for (i = 0; i < 3; ++token2, ++i) {
                    insertTime = Integer.parseInt(split[token2]);
                    mhkURIs[i] = new FreenetURI(split[++token2]);
                    System.out.println("MHK #" + i + " URI: " + mhkURIs[i] + " insert time " + insertTime);
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Failed to parse row: " + e);
                ++linesNoNumber;
                continue;
            }
            catch (MalformedURLException e) {
                System.err.println("Failed to parse row: " + e);
                ++linesNoURL;
                continue;
            }
            if (Math.abs(target.getTimeInMillis() - calendar.getTimeInMillis()) < TimeUnit.HOURS.toMillis(12L)) {
                System.out.println("Found row for target date " + dateFormat.format(target.getTime()) + " : " + dateFormat.format(calendar.getTime()));
                System.out.println("Version: " + split[1]);
                match = true;
                break;
            }
            if (split.length > 15) {
                token = 15;
                singleKeyFetchTime = -1;
                singleKeySuccess = false;
            } else {
                ++linesNoFetch;
                continue;
            }
            for (int i = 0; i < 3; ++token, ++i) {
                if (singleKeySuccess) continue;
                try {
                    singleKeyFetchTime = Integer.parseInt(split[token]);
                    singleKeySuccess = true;
                    System.out.println("Fetched single key on try " + i + " on " + date + " in " + singleKeyFetchTime + "ms");
                    continue;
                }
                catch (NumberFormatException e) {
                    System.out.println("Failed fetch single key on " + date + " try " + i + " : " + split[token]);
                    singleKeyFetchTime = -1;
                }
            }
            boolean mhkSuccess = false;
            for (int i = 0; i < 3; ++token, ++i) {
                ++totalSingleKeyFetches;
                int mhkFetchTime = -1;
                try {
                    mhkFetchTime = Integer.parseInt(split[token]);
                    mhkSuccess = true;
                    ++totalSingleKeySuccesses;
                    System.out.println("Fetched MHK #" + i + " on " + date + " in " + mhkFetchTime + "ms");
                    continue;
                }
                catch (NumberFormatException e) {
                    System.out.println("Failed fetch MHK #" + i + " on " + date + " : " + split[token]);
                }
            }
            ++total;
            if (singleKeySuccess) {
                ++singleKeysSucceeded;
            }
            if (!mhkSuccess) continue;
            ++mhkSucceeded;
        }
        System.out.println("Lines where insert failed or no fetch: too short: " + linesTooShort + " broken: " + linesBroken + " no number: " + linesNoNumber + " no url: " + linesNoURL + " no fetch " + linesNoFetch);
        System.out.println("Total attempts where insert succeeded and fetch executed: " + total);
        System.out.println("Single keys succeeded: " + singleKeysSucceeded);
        System.out.println("MHKs succeeded: " + mhkSucceeded);
        System.out.println("Single key individual fetches: " + totalSingleKeyFetches);
        System.out.println("Single key individual fetches succeeded: " + totalSingleKeySuccesses);
        System.out.println("Success rate for individual keys (from MHK inserts): " + (double)totalSingleKeySuccesses / (double)totalSingleKeyFetches);
        System.out.println("Success rate for the single key triple inserted: " + (double)singleKeysSucceeded / (double)total);
        System.out.println("Success rate for the MHK (success = any of the 3 different keys worked): " + (double)mhkSucceeded / (double)total);
        fis.close();
        fis = null;
        if (!dumpOnly && match) {
            int i;
            boolean fetched = false;
            for (i = 0; i < 3; ++i) {
                if (fetched) {
                    csvLine.add("");
                    continue;
                }
                try {
                    t1 = System.currentTimeMillis();
                    client.fetch(singleURI);
                    t2 = System.currentTimeMillis();
                    System.out.println("PULL-TIME FOR SINGLE URI:" + (t2 - t1));
                    csvLine.add(String.valueOf(t2 - t1));
                    fetched = true;
                    continue;
                }
                catch (FetchException e) {
                    if (e.getMode() != 28 && e.getMode() != 13) {
                        e.printStackTrace();
                    }
                    csvLine.add(FetchException.getShortMessage(e.getMode()));
                    System.err.println("FAILED PULL FOR SINGLE URI: " + e);
                }
            }
            for (i = 0; i < mhkURIs.length; ++i) {
                try {
                    t1 = System.currentTimeMillis();
                    client.fetch(mhkURIs[i]);
                    t2 = System.currentTimeMillis();
                    System.out.println("PULL-TIME FOR MHK #" + i + ":" + (t2 - t1));
                    csvLine.add(String.valueOf(t2 - t1));
                    continue;
                }
                catch (FetchException e) {
                    if (e.getMode() != 28 && e.getMode() != 13) {
                        e.printStackTrace();
                    }
                    csvLine.add(FetchException.getShortMessage(e.getMode()));
                    System.err.println("FAILED PULL FOR MHK #" + i + ": " + e);
                }
            }
        }
        try {
            if (node != null) {
                node.park();
            }
        }
        catch (Throwable tt) {
            // empty catch block
        }
        try {
            if (node2 != null) {
                node2.park();
            }
        }
        catch (Throwable tt) {
            // empty catch block
        }
        Closer.close(fis);
        if (!dumpOnly) {
            LongTermMHKTest.writeToStatusLog(file, csvLine);
        }
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bucket randomData(Node node) throws IOException {
        Bucket data = node.clientCore.tempBucketFactory.makeBucket(65536L);
        OutputStream os = data.getOutputStream();
        try {
            int toWrite;
            byte[] buf = new byte[4096];
            for (long written = 0L; written < 65536L; written += (long)toWrite) {
                node.fastWeakRandom.nextBytes(buf);
                toWrite = (int)Math.min(65536L - written, (long)buf.length);
                os.write(buf, 0, toWrite);
            }
        }
        finally {
            os.close();
        }
        return data;
    }
}

