/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.updater;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.async.BinaryBlobWriter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.USKCallback;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.Version;
import freenet.node.updater.NodeUpdateManager;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.api.Bucket;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import freenet.support.io.FileUtil;
import freenet.support.io.NullOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public abstract class NodeUpdater
implements ClientGetCallback,
USKCallback,
RequestClient {
    private static boolean logMINOR;
    private FetchContext ctx;
    private ClientGetter cg;
    private FreenetURI URI;
    private final Ticker ticker;
    public final NodeClientCore core;
    protected final Node node;
    public final NodeUpdateManager manager;
    private final int currentVersion;
    private int realAvailableVersion;
    private int availableVersion;
    private int fetchingVersion;
    protected int fetchedVersion;
    private int maxDeployVersion;
    private int minDeployVersion;
    private boolean isRunning;
    private boolean isFetching;
    private final String blobFilenamePrefix;
    protected File tempBlobFile;
    static final String DEPENDENCIES_FILE = "dependencies.properties";
    private static final int MAX_MANIFEST_SIZE = 0x100000;

    public abstract String jarName();

    NodeUpdater(NodeUpdateManager manager, FreenetURI URI2, int current, int min, int max, String blobFilenamePrefix) {
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        this.manager = manager;
        this.node = manager.node;
        this.URI = URI2.setSuggestedEdition(Version.buildNumber() + 1);
        this.ticker = this.node.ticker;
        this.core = this.node.clientCore;
        this.currentVersion = current;
        this.availableVersion = -1;
        this.isRunning = true;
        this.cg = null;
        this.isFetching = false;
        this.blobFilenamePrefix = blobFilenamePrefix;
        this.maxDeployVersion = max;
        this.minDeployVersion = min;
        FetchContext tempContext = this.core.makeClient((short)0, true, false).getFetchContext();
        tempContext.allowSplitfiles = true;
        tempContext.dontEnterImplicitArchives = false;
        this.ctx = tempContext;
    }

    void start() {
        try {
            USK myUsk = USK.create(this.URI.setSuggestedEdition(this.currentVersion));
            this.core.uskManager.subscribe(myUsk, this, true, this.getRequestClient());
        }
        catch (MalformedURLException e) {
            Logger.error(this, "The auto-update URI isn't valid and can't be used");
            this.manager.blow("The auto-update URI isn't valid and can't be used", true);
        }
    }

    protected void maybeProcessOldBlob() {
        File oldBlob = this.getBlobFile(this.currentVersion);
        if (oldBlob.exists()) {
            File temp;
            try {
                temp = File.createTempFile(this.blobFilenamePrefix + this.availableVersion + "-", ".fblob.tmp", this.manager.node.clientCore.getPersistentTempDir());
            }
            catch (IOException e) {
                Logger.error(this, "Unable to process old blob: " + e, (Throwable)e);
                return;
            }
            if (oldBlob.renameTo(temp)) {
                FreenetURI uri = this.URI.setSuggestedEdition(this.currentVersion);
                uri = uri.sskForUSK();
                try {
                    this.manager.uom.processMainJarBlob(temp, null, this.currentVersion, uri);
                }
                catch (Throwable t) {
                    Logger.error(this, "Unable to process old blob, caught " + t, t);
                }
                temp.delete();
            } else {
                Logger.error(this, "Unable to rename old blob file " + oldBlob + " to " + temp + " so can't process it.");
            }
        }
    }

    protected RequestClient getRequestClient() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFoundEdition(long l, USK key, ObjectContainer container, ClientContext context, boolean wasMetadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
        int found;
        if (newKnownGood && !newSlotToo) {
            return;
        }
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        if (logMINOR) {
            Logger.minor(this, "Found edition " + l);
        }
        NodeUpdater nodeUpdater = this;
        synchronized (nodeUpdater) {
            if (!this.isRunning) {
                return;
            }
            this.realAvailableVersion = found = (int)key.suggestedEdition;
            if (found > this.maxDeployVersion) {
                System.err.println("Ignoring " + this.jarName() + " update edition " + l + ": version too new (min " + this.minDeployVersion + " max " + this.maxDeployVersion + ")");
                found = this.maxDeployVersion;
            }
            if (found <= this.availableVersion) {
                return;
            }
            System.err.println("Found " + this.jarName() + " update edition " + found);
            Logger.minor(this, "Updating availableVersion from " + this.availableVersion + " to " + found + " and queueing an update");
            this.availableVersion = found;
        }
        this.finishOnFoundEdition(found);
    }

    private void finishOnFoundEdition(int found) {
        this.ticker.queueTimedJob(new Runnable(){

            @Override
            public void run() {
                NodeUpdater.this.maybeUpdate();
            }
        }, TimeUnit.SECONDS.toMillis(60L));
        if (found <= this.currentVersion) {
            System.err.println("Cancelling fetch for " + found + ": not newer than current version " + this.currentVersion);
            return;
        }
        this.onStartFetching();
        Logger.minor(this, "Fetching " + this.jarName() + " update edition " + found);
    }

    protected abstract void onStartFetching();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeUpdate() {
        ClientGetter toStart = null;
        if (!this.manager.isEnabled()) {
            return;
        }
        if (this.manager.isBlown()) {
            return;
        }
        ClientGetter cancelled = null;
        NodeUpdater nodeUpdater = this;
        synchronized (nodeUpdater) {
            if (logMINOR) {
                Logger.minor(this, "maybeUpdate: isFetching=" + this.isFetching + ", isRunning=" + this.isRunning + ", availableVersion=" + this.availableVersion);
            }
            if (!this.isRunning) {
                return;
            }
            if (this.isFetching && this.availableVersion == this.fetchingVersion) {
                return;
            }
            if (this.availableVersion <= this.fetchedVersion) {
                return;
            }
            if (this.fetchingVersion < this.minDeployVersion || this.fetchingVersion == this.currentVersion) {
                Logger.normal(this, "Cancelling previous fetch");
                cancelled = this.cg;
                this.cg = null;
            }
            this.fetchingVersion = this.availableVersion;
            if (this.availableVersion > this.currentVersion) {
                Logger.normal(this, "Starting the update process (" + this.availableVersion + ')');
                System.err.println("Starting the update process: found the update (" + this.availableVersion + "), now fetching it.");
            }
            if (logMINOR) {
                Logger.minor(this, "Starting the update process (" + this.availableVersion + ')');
            }
            try {
                if (this.cg == null || this.cg.isCancelled()) {
                    if (logMINOR) {
                        Logger.minor(this, "Scheduling request for " + this.URI.setSuggestedEdition(this.availableVersion));
                    }
                    if (this.availableVersion > this.currentVersion) {
                        System.err.println("Starting " + this.jarName() + " fetch for " + this.availableVersion);
                    }
                    this.tempBlobFile = File.createTempFile(this.blobFilenamePrefix + this.availableVersion + "-", ".fblob.tmp", this.manager.node.clientCore.getPersistentTempDir());
                    FreenetURI uri = this.URI.setSuggestedEdition(this.availableVersion);
                    uri = uri.sskForUSK();
                    toStart = this.cg = new ClientGetter(this, uri, this.ctx, 2, this, null, new BinaryBlobWriter(new FileBucket(this.tempBlobFile, false, false, false, false, false)), null);
                } else {
                    System.err.println("Already fetching " + this.jarName() + " fetch for " + this.fetchingVersion + " want " + this.availableVersion);
                }
                this.isFetching = true;
            }
            catch (Exception e) {
                Logger.error(this, "Error while starting the fetching: " + e, (Throwable)e);
                this.isFetching = false;
            }
        }
        if (toStart != null) {
            try {
                this.node.clientCore.clientContext.start(toStart);
            }
            catch (FetchException e) {
                Logger.error(this, "Error while starting the fetching: " + e, (Throwable)e);
                NodeUpdater nodeUpdater2 = this;
                synchronized (nodeUpdater2) {
                    this.isFetching = false;
                }
            }
            catch (DatabaseDisabledException databaseDisabledException) {
                // empty catch block
            }
        }
        if (cancelled != null) {
            cancelled.cancel(null, this.core.clientContext);
        }
    }

    final File getBlobFile(int availableVersion) {
        return new File(this.node.clientCore.getPersistentTempDir(), this.blobFilenamePrefix + availableVersion + ".fblob");
    }

    Bucket getBlobBucket(int availableVersion) {
        File f = this.getBlobFile(availableVersion);
        if (f == null) {
            return null;
        }
        return new FileBucket(f, true, false, false, false, false);
    }

    @Override
    public void onSuccess(FetchResult result, ClientGetter state, ObjectContainer container) {
        this.onSuccess(result, state, this.tempBlobFile, this.fetchingVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSuccess(FetchResult result, ClientGetter state, File tempBlobFile, int fetchedVersion) {
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        File blobFile = null;
        NodeUpdater nodeUpdater = this;
        synchronized (nodeUpdater) {
            if (fetchedVersion <= this.fetchedVersion) {
                Bucket toFree;
                tempBlobFile.delete();
                if (result != null && (toFree = result.asBucket()) != null) {
                    toFree.free();
                }
                return;
            }
            if (result == null || result.asBucket() == null || result.asBucket().size() == 0L) {
                tempBlobFile.delete();
                Logger.error(this, "Cannot update: result either null or empty for " + this.availableVersion);
                System.err.println("Cannot update: result either null or empty for " + this.availableVersion);
                if (result == null || result.asBucket() == null || this.availableVersion > fetchedVersion) {
                    this.node.ticker.queueTimedJob(new Runnable(){

                        @Override
                        public void run() {
                            NodeUpdater.this.maybeUpdate();
                        }
                    }, 0L);
                }
                return;
            }
            blobFile = this.getBlobFile(fetchedVersion);
            if (!tempBlobFile.renameTo(blobFile)) {
                blobFile.delete();
                if (!tempBlobFile.renameTo(blobFile)) {
                    if (blobFile.exists() && tempBlobFile.exists() && blobFile.length() == tempBlobFile.length()) {
                        Logger.minor(this, "Can't rename " + tempBlobFile + " over " + blobFile + " for " + fetchedVersion + " - probably not a big deal though as the files are the same size");
                    } else {
                        Logger.error(this, "Not able to rename binary blob for node updater: " + tempBlobFile + " -> " + blobFile + " - may not be able to tell other peers about this build");
                        blobFile = null;
                    }
                }
            }
            this.fetchedVersion = fetchedVersion;
            System.out.println("Found " + this.jarName() + " version " + fetchedVersion);
            if (fetchedVersion > this.currentVersion) {
                Logger.normal(this, "Found version " + fetchedVersion + ", setting up a new UpdatedVersionAvailableUserAlert");
            }
            this.maybeParseManifest(result, fetchedVersion);
            this.cg = null;
        }
        this.processSuccess(fetchedVersion, result, blobFile);
    }

    protected abstract void processSuccess(int var1, FetchResult var2, File var3);

    protected abstract void maybeParseManifest(FetchResult var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseManifest(FetchResult result) {
        InputStream is = null;
        try {
            is = result.asBucket().getInputStream();
            ZipInputStream zis = new ZipInputStream(is);
            try {
                ZipEntry ze;
                block10: while ((ze = zis.getNextEntry()) != null) {
                    if (ze.isDirectory()) continue;
                    String name = ze.getName();
                    if (name.equals("META-INF/MANIFEST.MF")) {
                        if (logMINOR) {
                            Logger.minor(this, "Found manifest");
                        }
                        long size = ze.getSize();
                        if (logMINOR) {
                            Logger.minor(this, "Manifest size: " + size);
                        }
                        if (size > 0x100000L) {
                            Logger.error(this, "Manifest is too big: " + size + " bytes, limit is " + 0x100000);
                            break;
                        }
                        byte[] buf = new byte[(int)size];
                        DataInputStream dis = new DataInputStream(zis);
                        dis.readFully(buf);
                        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
                        InputStreamReader isr = new InputStreamReader((InputStream)bais, "UTF-8");
                        BufferedReader br = new BufferedReader(isr);
                        while (true) {
                            String line;
                            if ((line = br.readLine()) == null) continue block10;
                            this.parseManifestLine(line);
                        }
                    }
                    zis.closeEntry();
                }
            }
            finally {
                Closer.close(zis);
            }
        }
        catch (IOException e) {
            Logger.error(this, "IOException trying to read manifest on update");
        }
        catch (Throwable t) {
            Logger.error(this, "Failed to parse update manifest: " + t, t);
        }
        finally {
            Closer.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties parseProperties(InputStream is, String filename) throws IOException {
        Properties props = new Properties();
        ZipInputStream zis = new ZipInputStream(is);
        try {
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                long size;
                if (ze.isDirectory()) continue;
                String name = ze.getName();
                if (name.equals(filename)) {
                    if (logMINOR) {
                        Logger.minor(NodeUpdater.class, "Found manifest");
                    }
                    size = ze.getSize();
                    if (logMINOR) {
                        Logger.minor(NodeUpdater.class, "Manifest size: " + size);
                    }
                    if (size > 0x100000L) {
                        Logger.error(NodeUpdater.class, "Manifest is too big: " + size + " bytes, limit is " + 0x100000);
                        break;
                    }
                    byte[] buf = new byte[(int)size];
                    DataInputStream dis = new DataInputStream(zis);
                    dis.readFully(buf);
                    ByteArrayInputStream bais = new ByteArrayInputStream(buf);
                    props.load(bais);
                    continue;
                }
                size = ze.getSize();
                FileUtil.copy(zis, new NullOutputStream(), size);
                zis.closeEntry();
            }
        }
        finally {
            Closer.close(zis);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseDependencies(FetchResult result, int build) {
        InputStream is = null;
        try {
            is = result.asBucket().getInputStream();
            this.parseDependencies(NodeUpdater.parseProperties(is, DEPENDENCIES_FILE), build);
        }
        catch (IOException e) {
            Logger.error(this, "IOException trying to read manifest on update");
        }
        catch (Throwable t) {
            Logger.error(this, "Failed to parse update manifest: " + t, t);
        }
        finally {
            Closer.close(is);
        }
    }

    protected void parseDependencies(Properties props, int build) {
    }

    protected void parseManifestLine(String line) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(FetchException e, ClientGetter state, ObjectContainer container) {
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        if (!this.isRunning) {
            return;
        }
        int errorCode = e.getMode();
        this.tempBlobFile.delete();
        if (logMINOR) {
            Logger.minor(this, "onFailure(" + e + ',' + state + ')');
        }
        NodeUpdater nodeUpdater = this;
        synchronized (nodeUpdater) {
            this.cg = null;
            this.isFetching = false;
        }
        if (errorCode == 25 || !e.isFatal()) {
            Logger.normal(this, "Rescheduling new request");
            this.ticker.queueTimedJob(new Runnable(){

                @Override
                public void run() {
                    NodeUpdater.this.maybeUpdate();
                }
            }, 0L);
        } else {
            Logger.error(this, "Canceling fetch : " + e.getMessage());
            System.err.println("Unexpected error fetching update: " + e.getMessage());
            if (!e.isFatal()) {
                this.ticker.queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        NodeUpdater.this.maybeUpdate();
                    }
                }, TimeUnit.HOURS.toMillis(1L));
            }
        }
    }

    public void preKill() {
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void kill() {
        try {
            ClientGetter c;
            NodeUpdater nodeUpdater = this;
            synchronized (nodeUpdater) {
                this.isRunning = false;
                USK myUsk = USK.create(this.URI.setSuggestedEdition(this.currentVersion));
                this.core.uskManager.unsubscribe(myUsk, this);
                c = this.cg;
                this.cg = null;
            }
            c.cancel(null, this.core.clientContext);
        }
        catch (Exception e) {
            Logger.minor(this, "Cannot kill NodeUpdater", (Throwable)e);
        }
    }

    public FreenetURI getUpdateKey() {
        return this.URI;
    }

    @Override
    public void onMajorProgress(ObjectContainer container) {
    }

    public synchronized boolean canUpdateNow() {
        return this.fetchedVersion > this.currentVersion;
    }

    public void onChangeURI(FreenetURI uri) {
        this.kill();
        this.URI = uri;
        this.maybeUpdate();
    }

    public int getFetchedVersion() {
        return this.fetchedVersion;
    }

    public boolean isFetching() {
        return this.availableVersion > this.fetchedVersion && this.availableVersion > this.currentVersion;
    }

    public int fetchingVersion() {
        if (this.fetchingVersion <= this.currentVersion) {
            return this.availableVersion;
        }
        return this.fetchingVersion;
    }

    public long getBlobSize() {
        return this.getBlobFile(this.getFetchedVersion()).length();
    }

    public File getBlobFile() {
        return this.getBlobFile(this.getFetchedVersion());
    }

    @Override
    public short getPollingPriorityNormal() {
        return 2;
    }

    @Override
    public short getPollingPriorityProgress() {
        return 1;
    }

    @Override
    public boolean persistent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinMax(int requiredExt, int recommendedExt) {
        int callFinishedFound = -1;
        NodeUpdater nodeUpdater = this;
        synchronized (nodeUpdater) {
            if (recommendedExt > -1) {
                this.maxDeployVersion = recommendedExt;
            }
            if (requiredExt > -1) {
                this.minDeployVersion = requiredExt;
                if (this.realAvailableVersion != this.availableVersion && this.availableVersion < requiredExt && this.realAvailableVersion >= requiredExt) {
                    System.err.println("Previously out-of-range edition " + this.realAvailableVersion + " is now needed by the new jar; scheduling fetch.");
                    callFinishedFound = this.availableVersion = this.realAvailableVersion;
                } else if (this.availableVersion < requiredExt) {
                    callFinishedFound = this.availableVersion = requiredExt;
                    System.err.println("Need minimum edition " + requiredExt + " for new jar, found " + this.availableVersion + "; scheduling fetch.");
                }
            }
        }
        if (callFinishedFound > -1) {
            this.finishOnFoundEdition(callFinishedFound);
        }
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing NodeUpdater in database", (Throwable)new Exception("error"));
        return false;
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean realTimeFlag() {
        return false;
    }
}

