/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.updater;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.async.BinaryBlobWriter;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.DatabaseDisabledException;
import freenet.l10n.NodeL10n;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.updater.NodeUpdateManager;
import freenet.support.Logger;
import freenet.support.MediaType;
import freenet.support.api.Bucket;
import freenet.support.io.ArrayBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.ByteArrayRandomAccessThing;
import freenet.support.io.FileBucket;
import freenet.support.io.FileUtil;
import freenet.support.io.RandomAccessFileWrapper;
import freenet.support.io.RandomAccessThing;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class RevocationChecker
implements ClientGetCallback,
RequestClient {
    public static final int REVOCATION_DNF_MIN = 3;
    private boolean logMINOR;
    private NodeUpdateManager manager;
    private NodeClientCore core;
    private int revocationDNFCounter;
    private FetchContext ctxRevocation;
    private ClientGetter revocationGetter;
    private boolean wasAggressive;
    private long lastSucceeded;
    private volatile boolean blown;
    private File blobFile;
    private ArrayBucket blobBucket;

    public RevocationChecker(NodeUpdateManager manager, File blobFile) {
        this.manager = manager;
        this.core = manager.node.clientCore;
        this.revocationDNFCounter = 0;
        this.blobFile = blobFile;
        this.logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        this.ctxRevocation = this.core.makeClient((short)0, true, false).getFetchContext();
        this.ctxRevocation.allowSplitfiles = false;
        this.ctxRevocation.maxArchiveLevels = 0;
        this.ctxRevocation.followRedirects = false;
        this.ctxRevocation.maxOutputLength = 32768L;
        this.ctxRevocation.maxTempLength = 65536L;
        this.ctxRevocation.maxSplitfileBlockRetries = -1;
        this.ctxRevocation.maxNonSplitfileRetries = 0;
    }

    public int getRevocationDNFCounter() {
        return this.revocationDNFCounter;
    }

    public void start(boolean aggressive) {
        this.start(aggressive, true);
        if (this.blobFile.exists()) {
            ArrayBucket bucket = new ArrayBucket();
            try {
                BucketTools.copy(new FileBucket(this.blobFile, true, false, false, false, true), bucket);
                this.manager.uom.processRevocationBlob(bucket, "disk", true);
            }
            catch (IOException e) {
                Logger.error(this, "Failed to read old revocation blob: " + e, (Throwable)e);
                System.err.println("We may have downloaded an old revocation blob before restarting but it cannot be read: " + e);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(boolean aggressive, boolean reset) {
        if (this.manager.isBlown()) {
            Logger.error(this, "Not starting revocation checker: key already blown!");
            return false;
        }
        boolean wasRunning = false;
        this.logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        ClientGetter cg = null;
        try {
            ClientGetter toCancel = null;
            RevocationChecker revocationChecker = this;
            synchronized (revocationChecker) {
                if (aggressive && !this.wasAggressive) {
                    toCancel = this.revocationGetter;
                    if (this.logMINOR) {
                        Logger.minor(this, "Ignoring old request, because was low priority");
                    }
                    this.revocationGetter = null;
                    if (toCancel != null) {
                        wasRunning = true;
                    }
                }
                this.wasAggressive = aggressive;
                if (this.revocationGetter != null && !this.revocationGetter.isCancelled() && !this.revocationGetter.isFinished()) {
                    if (this.logMINOR) {
                        Logger.minor(this, "Not queueing another revocation fetcher yet, old one still running");
                    }
                    reset = false;
                    wasRunning = false;
                } else {
                    if (reset) {
                        if (this.logMINOR) {
                            Logger.minor(this, "Resetting DNF count from " + this.revocationDNFCounter, (Throwable)new Exception("debug"));
                        }
                        this.revocationDNFCounter = 0;
                    } else if (this.logMINOR) {
                        Logger.minor(this, "Revocation count " + this.revocationDNFCounter);
                    }
                    if (this.logMINOR) {
                        Logger.minor(this, "fetcher=" + this.revocationGetter);
                    }
                    if (this.revocationGetter != null && this.logMINOR) {
                        Logger.minor(this, "revocation fetcher: cancelled=" + this.revocationGetter.isCancelled() + ", finished=" + this.revocationGetter.isFinished());
                    }
                    this.manager.node.clientCore.getPersistentTempDir().mkdirs();
                    cg = this.revocationGetter = new ClientGetter(this, this.manager.getRevocationURI(), this.ctxRevocation, aggressive ? (short)0 : 2, this, null, new BinaryBlobWriter(new ArrayBucket()), null);
                    if (this.logMINOR) {
                        Logger.minor(this, "Queued another revocation fetcher (count=" + this.revocationDNFCounter + ")");
                    }
                }
            }
            if (toCancel != null) {
                toCancel.cancel(null, this.core.clientContext);
            }
            if (cg != null) {
                this.core.clientContext.start(cg);
                if (this.logMINOR) {
                    Logger.minor(this, "Started revocation fetcher");
                }
            }
            return wasRunning;
        }
        catch (FetchException e) {
            if (e.mode == 30) {
                Logger.error(this, "Cannot start revocation fetcher because recently failed");
            } else {
                Logger.error(this, "Cannot start fetch for the auto-update revocation key: " + e, (Throwable)e);
                this.manager.blow("Cannot start fetch for the auto-update revocation key: " + e, true);
            }
            RevocationChecker revocationChecker = this;
            synchronized (revocationChecker) {
                if (this.revocationGetter == cg) {
                    this.revocationGetter = null;
                }
            }
            return false;
        }
        catch (DatabaseDisabledException e) {
            return false;
        }
    }

    long lastSucceeded() {
        return this.lastSucceeded;
    }

    long lastSucceededDelta() {
        if (this.lastSucceeded <= 0L) {
            return -1L;
        }
        return System.currentTimeMillis() - this.lastSucceeded;
    }

    public void onChangeRevocationURI() {
        this.kill();
        this.start(this.wasAggressive);
    }

    @Override
    public void onSuccess(FetchResult result, ClientGetter state, ObjectContainer container) {
        this.onSuccess(result, state, state.getBlobBucket());
    }

    void onSuccess(FetchResult result, ClientGetter state, Bucket blob) {
        this.blown = true;
        this.moveBlob(blob);
        String msg = null;
        try {
            byte[] buf = result.asByteArray();
            msg = new String(buf, MediaType.getCharsetRobustOrUTF(result.getMimeType()));
        }
        catch (Throwable t) {
            try {
                msg = "Failed to extract result when key blown: " + t;
                Logger.error(this, msg, t);
                System.err.println(msg);
                t.printStackTrace();
            }
            catch (Throwable t1) {
                msg = "Internal error after retreiving revocation key";
            }
        }
        this.manager.blow(msg, false);
    }

    public boolean hasBlown() {
        return this.blown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveBlob(Bucket tmpBlob) {
        RevocationChecker revocationChecker;
        if (tmpBlob == null) {
            Logger.error(this, "No temporary binary blob file moving it: may not be able to propagate revocation, bug???");
            return;
        }
        if (tmpBlob instanceof ArrayBucket) {
            RevocationChecker revocationChecker2 = this;
            synchronized (revocationChecker2) {
                if (tmpBlob == this.blobBucket) {
                    return;
                }
                this.blobBucket = (ArrayBucket)tmpBlob;
            }
        }
        try {
            ArrayBucket buf = new ArrayBucket(BucketTools.toByteArray(tmpBlob));
            revocationChecker = this;
            synchronized (revocationChecker) {
                this.blobBucket = buf;
            }
        }
        catch (IOException e) {
            System.err.println("Unable to copy data from revocation bucket!");
            System.err.println("This should not happen and indicates there may be a problem with the auto-update checker.");
            return;
        }
        if (tmpBlob instanceof FileBucket) {
            File f = ((FileBucket)tmpBlob).getFile();
            revocationChecker = this;
            synchronized (revocationChecker) {
                if (f == this.blobFile) {
                    return;
                }
                if (f.equals(this.blobFile)) {
                    return;
                }
                if (FileUtil.getCanonicalFile(f).equals(FileUtil.getCanonicalFile(this.blobFile))) {
                    return;
                }
            }
        }
        System.out.println("Unexpected blob file in revocation checker: " + tmpBlob);
        FileBucket fb = new FileBucket(this.blobFile, false, false, false, false, false);
        try {
            BucketTools.copy(tmpBlob, fb);
        }
        catch (IOException e) {
            System.err.println("Got revocation but cannot write it to disk: " + e);
            System.err.println("This means the auto-update system is blown but we can't tell other nodes about it!");
            e.printStackTrace();
        }
    }

    @Override
    public void onFailure(FetchException e, ClientGetter state, ObjectContainer container) {
        this.onFailure(e, state, state.getBlobBucket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFailure(FetchException e, ClientGetter state, Bucket blob) {
        this.logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        if (this.logMINOR) {
            Logger.minor(this, "Revocation fetch failed: " + e);
        }
        int errorCode = e.getMode();
        boolean completed = false;
        long now = System.currentTimeMillis();
        if (errorCode == 25) {
            return;
        }
        if (e.isFatal()) {
            if (!e.isDefinitelyFatal()) {
                String message = this.l10n("revocationFetchFailedMaybeInternalError", new String[]{"detail", "key"}, new String[]{e.toUserFriendlyString(), this.manager.getRevocationURI().toASCIIString()});
                System.err.println(message);
                e.printStackTrace();
                this.manager.blow(message, true);
                return;
            }
            String message = this.l10n("revocationFetchFailedFatally", new String[]{"detail", "key"}, new String[]{e.toUserFriendlyString(), this.manager.getRevocationURI().toASCIIString()});
            this.manager.blow(message, false);
            this.moveBlob(blob);
            return;
        }
        if (e.newURI != null) {
            this.manager.blow("Revocation URI redirecting to " + e.newURI + " - maybe you set the revocation URI to the update URI?", false);
        }
        RevocationChecker revocationChecker = this;
        synchronized (revocationChecker) {
            if (errorCode == 13) {
                ++this.revocationDNFCounter;
                if (this.logMINOR) {
                    Logger.minor(this, "Incremented DNF counter to " + this.revocationDNFCounter);
                }
            }
            if (this.revocationDNFCounter >= 3) {
                this.lastSucceeded = now;
                completed = true;
                this.revocationDNFCounter = 0;
            }
            this.revocationGetter = null;
        }
        if (completed) {
            this.manager.noRevocationFound();
        } else if (errorCode == 30) {
            this.manager.node.ticker.queueTimedJob(new Runnable(){

                @Override
                public void run() {
                    RevocationChecker.this.start(RevocationChecker.this.wasAggressive, false);
                }
            }, TimeUnit.SECONDS.toMillis(1L));
        } else {
            this.start(this.wasAggressive, false);
        }
    }

    private String l10n(String key, String[] pattern, String[] value) {
        return NodeL10n.getBase().getString("RevocationChecker." + key, pattern, value);
    }

    @Override
    public void onMajorProgress(ObjectContainer container) {
    }

    public void kill() {
        if (this.revocationGetter != null) {
            this.revocationGetter.cancel(null, this.core.clientContext);
        }
    }

    public long getBlobSize() {
        return this.blobFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket getBlobBucket() {
        if (!this.manager.isBlown()) {
            return null;
        }
        RevocationChecker revocationChecker = this;
        synchronized (revocationChecker) {
            if (this.blobBucket != null) {
                return this.blobBucket;
            }
        }
        File f = this.getBlobFile();
        if (f == null) {
            return null;
        }
        return new FileBucket(f, true, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessThing getBlobThing() {
        if (!this.manager.isBlown()) {
            return null;
        }
        RevocationChecker revocationChecker = this;
        synchronized (revocationChecker) {
            if (this.blobBucket != null) {
                ByteArrayRandomAccessThing t = new ByteArrayRandomAccessThing(this.blobBucket.toByteArray());
                t.setReadOnly();
                return t;
            }
        }
        File f = this.getBlobFile();
        if (f == null) {
            return null;
        }
        try {
            return new RandomAccessFileWrapper(f, "r");
        }
        catch (FileNotFoundException e) {
            Logger.error(this, "We do not have the blob file for the revocation even though we have successfully downloaded it!", (Throwable)e);
            return null;
        }
    }

    private File getBlobFile() {
        if (this.blobFile.exists()) {
            return this.blobFile;
        }
        return null;
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean realTimeFlag() {
        return false;
    }
}

